<?php

/**
 * This is the model class for table "{{fe_factura_recibo}}".
 *
 * The followings are the available columns in table '{{fe_factura_recibo}}':
 * @property string $id_factura_recibo
 * @property string $id_factura
 * @property integer $id_recibo
 * @property double $subtotal
 * @property double $iva
 * @property double $total
 * @property string $ruta_pdf
 * @property string $ruta_xml
 * @property string $estatus
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Recibo $idRecibo
 * @property FeFacturas $idFactura
 */
class FeFacturaRecibo extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FeFacturaRecibo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fe_factura_recibo}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_factura, id_recibo, subtotal, iva, total, log', 'required'),
			array('id_recibo', 'numerical', 'integerOnly'=>true),
			array('subtotal, iva, total', 'numerical'),
			array('id_factura', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>1),
			array('ruta_pdf, ruta_xml', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_factura_recibo, id_factura, id_recibo, subtotal, iva, total, ruta_pdf, ruta_xml, estatus, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idRecibo' => array(self::BELONGS_TO, 'Recibo', 'id_recibo'),
			'idFactura' => array(self::BELONGS_TO, 'FeFacturas', 'id_factura'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_factura_recibo' => 'Id Factura Recibo',
			'id_factura' => 'Id Factura',
			'id_recibo' => 'Id Recibo',
			'subtotal' => 'Subtotal',
			'iva' => 'Iva',
			'total' => 'Total',
			'ruta_pdf' => 'Ruta Pdf',
			'ruta_xml' => 'Ruta Xml',
			'estatus' => 'Estatus',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_factura_recibo',$this->id_factura_recibo,true);
		$criteria->compare('id_factura',$this->id_factura,true);
		$criteria->compare('id_recibo',$this->id_recibo);
		$criteria->compare('subtotal',$this->subtotal);
		$criteria->compare('iva',$this->iva);
		$criteria->compare('total',$this->total);
		$criteria->compare('ruta_pdf',$this->ruta_pdf,true);
		$criteria->compare('ruta_xml',$this->ruta_xml,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}