<?php

/**
 * This is the model class for table "{{facilities}}".
 *
 * The followings are the available columns in table '{{facilities}}':
 * @property integer $id_facilities
 * @property integer $code
 * @property integer $facilityGroupCode
 * @property integer $facilityTypologyCode
 * @property string $serv_def
 *
 * The followings are the available model relations:
 * @property Facilitygroups $facilityGroupCode0
 * @property HotelesFacilities[] $hotelesFacilities
 */
class Facilities extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Facilities the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{facilities}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('code, facilityGroupCode, facilityTypologyCode, serv_def', 'required'),
			array('code, facilityGroupCode, facilityTypologyCode', 'numerical', 'integerOnly'=>true),
			array('serv_def', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_facilities, code, facilityGroupCode, facilityTypologyCode, serv_def', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'facilityGroupCode0' => array(self::BELONGS_TO, 'Facilitygroups', 'facilityGroupCode'),
			'hotelesFacilities' => array(self::HAS_MANY, 'HotelesFacilities', 'id_facilities'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_facilities' => 'Id Facilities',
			'code' => 'Code',
			'facilityGroupCode' => 'Facility Group Code',
			'facilityTypologyCode' => 'Facility Typology Code',
			'serv_def' => 'Serv Def',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_facilities',$this->id_facilities);
		$criteria->compare('code',$this->code);
		$criteria->compare('facilityGroupCode',$this->facilityGroupCode);
		$criteria->compare('facilityTypologyCode',$this->facilityTypologyCode);
		$criteria->compare('serv_def',$this->serv_def,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}