<?php

/**
 * This is the model class for table "{{desglose_menores}}".
 *
 * The followings are the available columns in table '{{desglose_menores}}':
 * @property integer $id_desglose_menor
 * @property integer $id_tarifa
 * @property integer $id_tipo_habitacion
 * @property integer $id_base_habitacion
 * @property double $precio
 * @property integer $edad_max_infante
 * @property integer $edad_min_menor
 * @property integer $edad_max_menor
 * @property integer $num_evaluar
 * @property integer $num_menores_gratis
 * @property integer $es_junior
 * @property string $log
 */
class DesgloseMenores extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DesgloseMenores the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{desglose_menores}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tarifa, id_tipo_habitacion, id_base_habitacion', 'required'),
			array('id_tarifa, id_tipo_habitacion, id_base_habitacion, edad_max_infante, edad_min_menor, edad_max_menor, num_evaluar, num_menores_gratis, es_junior', 'numerical', 'integerOnly'=>true),
			array('precio_neto, precio', 'numerical'),
			array('fecha_inicio_precompra, fecha_final_precompra, fecha_inicio, fecha_final', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_desglose_menor, id_tarifa, id_tipo_habitacion, id_base_habitacion, precio, edad_max_infante, edad_min_menor, edad_max_menor, num_evaluar, num_menores_gratis, es_junior, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTipoHabitacion' => array(self::BELONGS_TO, 'TipoHabitaciones', 'id_tipo_habitacion'),
			'idTarifa' => array(self::BELONGS_TO, 'Tarifa', 'id_tarifa'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_desglose_menor' => 'Id Desglose Menor',
			'id_tarifa' => 'Id Tarifa',
			'id_tipo_habitacion' => 'Id Tipo Habitacion',
			'id_base_habitacion' => 'Id Base Habitacion',
			'precio_neto' => 'Precio Neto',
			'precio' => 'Precio',
			'edad_max_infante' => 'Edad Max Infante',
			'edad_min_menor' => 'Edad Min Menor',
			'edad_max_menor' => 'Edad Max Menor',
			'num_evaluar' => 'Num Evaluar',
			'num_menores_gratis' => 'Num Menores Gratis',
			'es_junior' => 'Es Junior',
			'log' => 'Log',
			'fecha_inicio_precompra' => 'Fecha Inicio Precompra',
			'fecha_final_precompra' => 'Fecha Final Precompra',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_desglose_menor',$this->id_desglose_menor);
		$criteria->compare('id_tarifa',$this->id_tarifa);
		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion);
		$criteria->compare('id_base_habitacion',$this->id_base_habitacion);
		$criteria->compare('precio',$this->precio);
		$criteria->compare('edad_max_infante',$this->edad_max_infante);
		$criteria->compare('edad_min_menor',$this->edad_min_menor);
		$criteria->compare('edad_max_menor',$this->edad_max_menor);
		$criteria->compare('num_evaluar',$this->num_evaluar);
		$criteria->compare('num_menores_gratis',$this->num_menores_gratis);
		$criteria->compare('es_junior',$this->es_junior);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}