<?php

/**
 * This is the model class for table "{{datos_clientes}}".
 *
 * The followings are the available columns in table '{{datos_clientes}}':
 * @property string $id_datos_clientes
 * @property string $id_reservacion
 * @property string $id_agencia
 * @property string $telefono
 * @property string $email
 * @property string $log
 */
class DatosClientes extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DatosClientes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{datos_clientes}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_reservacion, id_agencia', 'required'),
			array('tipo_servicio', 'numerical', 'integerOnly'=>true),
			array('id_reservacion, id_agencia', 'length', 'max'=>10),
			array('telefono', 'length', 'max'=>12),
			array('email', 'length', 'max'=>150),
			array('log', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_datos_clientes, id_reservacion, id_agencia, telefono, email, log, tipo_servicio', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_datos_clientes' => 'Id Datos Clientes',
			'id_reservacion' => 'Id Reservacion',
			'id_agencia' => 'Id Agencia',
			'telefono' => 'Telefono',
			'email' => 'Email',
			'log' => 'Log',
			'tipo_servicio' => 'Tipo Servicio',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_datos_clientes',$this->id_datos_clientes,true);
		$criteria->compare('id_reservacion',$this->id_reservacion,true);
		$criteria->compare('id_agencia',$this->id_agencia,true);
		$criteria->compare('telefono',$this->telefono,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('tipo_servicio',$this->tipo_servicio);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}