<?php

/**
 * This is the model class for table "tbl_ciudadesmex".
 *
 * The followings are the available columns in table 'tbl_ciudadesmex':
 * @property integer $id_ciudad
 * @property integer $id_estadosmex
 * @property string $nombreciudad
 * @property string $registro
 */
class Ciudades extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Ciudades the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_ciudadesmex';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_estadosmex, registro', 'required'),
			array('id_estadosmex', 'numerical', 'integerOnly'=>true),
			array('nombreciudad', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_ciudad, id_estadosmex, nombreciudad, registro', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_ciudad' => 'Id Ciudad',
			'id_estadosmex' => 'Id Estadosmex',
			'nombreciudad' => 'Nombreciudad',
			'registro' => 'Registro',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_ciudad',$this->id_ciudad);
		$criteria->compare('id_estadosmex',$this->id_estadosmex);
		$criteria->compare('nombreciudad',$this->nombreciudad,true);
		$criteria->compare('registro',$this->registro,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}