<?php

/**
 * This is the model class for table "{{chofer}}".
 *
 * The followings are the available columns in table '{{chofer}}':
 * @property integer $id
 * @property string $nombre
 * @property string $apellidos
 * @property string $licencia
 * @property string $vigencia
 *
 * The followings are the available model relations:
 * @property OrdenTransporte[] $ordenTransportes
 */
class Chofer extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Chofer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{chofer}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre, apellidos, vigencia', 'required'),
			array('nombre, apellidos, licencia', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, nombre, apellidos, licencia, vigencia', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'ordenTransportes' => array(self::HAS_MANY, 'OrdenTransporte', 'id_chofer'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'nombre' => 'Nombre',
			'apellidos' => 'Apellidos',
			'licencia' => 'Licencia',
			'vigencia' => 'Vigencia',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('nombre',$this->nombre,true);
		$criteria->compare('apellidos',$this->apellidos,true);
		$criteria->compare('licencia',$this->licencia,true);
		$criteria->compare('vigencia',$this->vigencia,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}