<?php

/**
 * This is the model class for table "{{banners}}".
 *
 * The followings are the available columns in table '{{banners}}':
 * @property string $id
 * @property string $titulo
 * @property string $imagen
 * @property string $url
 * @property string $posicion
 * @property string $fecha_inicial
 * @property string $fecha_final
 * @property integer $estatus
 */
class Banners extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Banners the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{banners}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('titulo, posicion', 'required'),
			array('estatus, posicion', 'numerical', 'integerOnly'=>true),
			array('titulo', 'length', 'max'=>45),
			array('imagen, archivo, url', 'length', 'max'=>100),
			array('fecha_inicial, fecha_final', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, titulo, imagen, url, posicion, fecha_inicial, fecha_final, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'titulo' => 'Titulo',
			'imagen' => 'Imagen',
			'archivo' => 'Archivo',
			'url' => 'Url',
			'posicion' => 'Posicion',
			'fecha_inicial' => 'Fecha Inicial',
			'fecha_final' => 'Fecha Final',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('titulo',$this->titulo,true);
		$criteria->compare('imagen',$this->imagen,true);
		$criteria->compare('url',$this->url,true);
		$criteria->compare('posicion',$this->posicion,true);
		$criteria->compare('fecha_inicial',$this->fecha_inicial,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public static function estatus($x){
		switch($x){
			case 0: $y="Inactivo"; break;
			case 1: $y="Activo"; break;
		}
		return $y;
	}	
}