<?php

/**
 * This is the model class for table "{{agencias}}".
 *
 * The followings are the available columns in table '{{agencias}}':
 * @property integer $id_agencia
 * @property string $nombre_agencia
 * @property string $webslug
 * @property string $fecha_alta
 * @property string $tel_agencia
 * @property string $email_agencia
 * @property string $celular
 * @property string $contacto
 * @property string $skype_agencia
 * @property string $puesto
 * @property double $porcentaje_comision
 * @property string $observaciones
 * @property string $id_pais_agencia
 * @property string $id_estado_agencia
 * @property string $id_ciudad_agencia
 * @property string $id_colonia_agencia
 * @property string $calle_agencia
 * @property string $cruzamientos_agencia
 * @property string $num_interior_agencia
 * @property string $num_exterior_agencia
 * @property string $cp_agencia
 * @property string $rfc
 * @property string $razon_social
 * @property string $id_estado_fiscal
 * @property string $id_ciudad_fiscal
 * @property string $id_colonia_fiscal
 * @property string $calle_fiscal
 * @property string $cruzamientos_fiscal
 * @property string $num_exterior_fiscal
 * @property string $num_interior_fiscal
 * @property string $cp_fiscal
 * @property string $id_pais_fiscal
 * @property string $log
 * @property string $municipio_agencia
 * @property string $municipio_fiscal
 * @property integer $mismadir
 * @property string $logotipo
 * @property string $foto
 * @property string $url_agencia
 * @property string $estatus
 * @property string $activacion
 * @property integer $verificada
 * @property integer $accesows
 * @property string $ubicacion
 * @property string $pie_flyer
 *
 * The followings are the available model relations:
 * @property EventsGuests[] $eventsGuests
 */
class AgenciasRest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AgenciasRest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{agencias}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre_agencia, fecha_alta, tel_agencia, email_agencia, contacto, log, estatus', 'required'),
			array('mismadir, verificada, accesows', 'numerical', 'integerOnly'=>true),
			array('porcentaje_comision', 'numerical'),
			array('nombre_agencia, tel_agencia, contacto, skype_agencia, id_estado_agencia, id_ciudad_agencia, id_colonia_agencia, razon_social, municipio_agencia, municipio_fiscal, logotipo, foto, url_agencia, estatus, activacion', 'length', 'max'=>255),
			array('webslug, ubicacion', 'length', 'max'=>50),
			array('email_agencia, calle_agencia, cruzamientos_agencia, num_interior_agencia, num_exterior_agencia, cp_agencia, rfc, id_estado_fiscal, id_ciudad_fiscal, id_colonia_fiscal, calle_fiscal, cruzamientos_fiscal, num_exterior_fiscal, num_interior_fiscal, cp_fiscal, id_pais_fiscal', 'length', 'max'=>45),
			array('celular, puesto', 'length', 'max'=>30),
			array('id_pais_agencia', 'length', 'max'=>10),
			array('pie_flyer', 'length', 'max'=>100),
			array('observaciones', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_agencia, nombre_agencia, webslug, fecha_alta, tel_agencia, email_agencia, celular, contacto, skype_agencia, puesto, porcentaje_comision, observaciones, id_pais_agencia, id_estado_agencia, id_ciudad_agencia, id_colonia_agencia, calle_agencia, cruzamientos_agencia, num_interior_agencia, num_exterior_agencia, cp_agencia, rfc, razon_social, id_estado_fiscal, id_ciudad_fiscal, id_colonia_fiscal, calle_fiscal, cruzamientos_fiscal, num_exterior_fiscal, num_interior_fiscal, cp_fiscal, id_pais_fiscal, log, municipio_agencia, municipio_fiscal, mismadir, logotipo, foto, url_agencia, estatus, activacion, verificada, accesows, ubicacion, pie_flyer', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventsGuests' => array(self::HAS_MANY, 'EventsGuests', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_agencia' => 'Id Agencia',
			'nombre_agencia' => 'Nombre Agencia',
			'webslug' => 'Webslug',
			'fecha_alta' => 'Fecha Alta',
			'tel_agencia' => 'Tel Agencia',
			'email_agencia' => 'Email Agencia',
			'celular' => 'Celular',
			'contacto' => 'Contacto',
			'skype_agencia' => 'Skype Agencia',
			'puesto' => 'Puesto',
			'porcentaje_comision' => 'Porcentaje Comision',
			'observaciones' => 'Observaciones',
			'id_pais_agencia' => 'Id Pais Agencia',
			'id_estado_agencia' => 'Id Estado Agencia',
			'id_ciudad_agencia' => 'Id Ciudad Agencia',
			'id_colonia_agencia' => 'Id Colonia Agencia',
			'calle_agencia' => 'Calle Agencia',
			'cruzamientos_agencia' => 'Cruzamientos Agencia',
			'num_interior_agencia' => 'Num Interior Agencia',
			'num_exterior_agencia' => 'Num Exterior Agencia',
			'cp_agencia' => 'Cp Agencia',
			'rfc' => 'Rfc',
			'razon_social' => 'Razon Social',
			'id_estado_fiscal' => 'Id Estado Fiscal',
			'id_ciudad_fiscal' => 'Id Ciudad Fiscal',
			'id_colonia_fiscal' => 'Id Colonia Fiscal',
			'calle_fiscal' => 'Calle Fiscal',
			'cruzamientos_fiscal' => 'Cruzamientos Fiscal',
			'num_exterior_fiscal' => 'Num Exterior Fiscal',
			'num_interior_fiscal' => 'Num Interior Fiscal',
			'cp_fiscal' => 'Cp Fiscal',
			'id_pais_fiscal' => 'Id Pais Fiscal',
			'log' => 'Log',
			'municipio_agencia' => 'Municipio Agencia',
			'municipio_fiscal' => 'Municipio Fiscal',
			'mismadir' => 'Mismadir',
			'logotipo' => 'Logotipo',
			'foto' => 'Foto',
			'url_agencia' => 'Url Agencia',
			'estatus' => 'Estatus',
			'activacion' => 'Activacion',
			'verificada' => 'Verificada',
			'accesows' => 'Accesows',
			'ubicacion' => 'Ubicacion',
			'pie_flyer' => 'Pie Flyer',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('nombre_agencia',$this->nombre_agencia,true);
		$criteria->compare('webslug',$this->webslug,true);
		$criteria->compare('fecha_alta',$this->fecha_alta,true);
		$criteria->compare('tel_agencia',$this->tel_agencia,true);
		$criteria->compare('email_agencia',$this->email_agencia,true);
		$criteria->compare('celular',$this->celular,true);
		$criteria->compare('contacto',$this->contacto,true);
		$criteria->compare('skype_agencia',$this->skype_agencia,true);
		$criteria->compare('puesto',$this->puesto,true);
		$criteria->compare('porcentaje_comision',$this->porcentaje_comision);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('id_pais_agencia',$this->id_pais_agencia,true);
		$criteria->compare('id_estado_agencia',$this->id_estado_agencia,true);
		$criteria->compare('id_ciudad_agencia',$this->id_ciudad_agencia,true);
		$criteria->compare('id_colonia_agencia',$this->id_colonia_agencia,true);
		$criteria->compare('calle_agencia',$this->calle_agencia,true);
		$criteria->compare('cruzamientos_agencia',$this->cruzamientos_agencia,true);
		$criteria->compare('num_interior_agencia',$this->num_interior_agencia,true);
		$criteria->compare('num_exterior_agencia',$this->num_exterior_agencia,true);
		$criteria->compare('cp_agencia',$this->cp_agencia,true);
		$criteria->compare('rfc',$this->rfc,true);
		$criteria->compare('razon_social',$this->razon_social,true);
		$criteria->compare('id_estado_fiscal',$this->id_estado_fiscal,true);
		$criteria->compare('id_ciudad_fiscal',$this->id_ciudad_fiscal,true);
		$criteria->compare('id_colonia_fiscal',$this->id_colonia_fiscal,true);
		$criteria->compare('calle_fiscal',$this->calle_fiscal,true);
		$criteria->compare('cruzamientos_fiscal',$this->cruzamientos_fiscal,true);
		$criteria->compare('num_exterior_fiscal',$this->num_exterior_fiscal,true);
		$criteria->compare('num_interior_fiscal',$this->num_interior_fiscal,true);
		$criteria->compare('cp_fiscal',$this->cp_fiscal,true);
		$criteria->compare('id_pais_fiscal',$this->id_pais_fiscal,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('municipio_agencia',$this->municipio_agencia,true);
		$criteria->compare('municipio_fiscal',$this->municipio_fiscal,true);
		$criteria->compare('mismadir',$this->mismadir);
		$criteria->compare('logotipo',$this->logotipo,true);
		$criteria->compare('foto',$this->foto,true);
		$criteria->compare('url_agencia',$this->url_agencia,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('activacion',$this->activacion,true);
		$criteria->compare('verificada',$this->verificada);
		$criteria->compare('accesows',$this->accesows);
		$criteria->compare('ubicacion',$this->ubicacion,true);
		$criteria->compare('pie_flyer',$this->pie_flyer,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}