<?php

/**
 * This is the model class for table "tbl_agencia".
 *
 * The followings are the available columns in table 'tbl_agencia':
 * @property integer $id
 * @property string $nom_agencia
 * @property string $sitio_web
 * @property string $theme_rmt
 * @property string $referenciaRMT
 * @property string $emailPrincipal
 * @property string $telefonoPrincipal
 * @property string $telefonoWhatsapp
 * @property string $nosotros
 * @property string $logo_agencia
 * @property string $fotoBanner
 * @property string $fb_fanpage
 * @property string $agencia_mapa
 * @property string $instagram
 * @property string $twitter
 * @property string $youtube
 * @property string $fb_chat
 * @property string $fb_pixel_code
 * @property string $datos_bancarios
 * @property string $primary_color
 * @property string $secondary_color
 * @property string $log
 * @property integer $id_tipo_plan
 * @property integer $estatus
 * @property integer $updates_estatus
 * @property string $user_ftp
 * @property string $password_ftp
 * @property integer $ssl_status
 *
 * The followings are the available model relations:
 * @property TipoPlan $idTipoPlan
 * @property AvisoAgencia[] $avisoAgencias
 * @property BannerAgencia[] $bannerAgencias
 * @property Categoria[] $categorias
 * @property CategoriaProducto[] $categoriaProductos
 * @property Contacto[] $contactos
 * @property Foto[] $fotos
 * @property Galeria[] $galerias
 * @property Movimientos[] $movimientoses
 * @property NoticiaCategoria[] $noticiaCategorias
 * @property Producto[] $productos
 * @property SeccionMenu[] $seccionMenus
 * @property Subseccion[] $subseccions
 * @property TipoCategoria[] $tipoCategorias
 * @property TipoNoticia[] $tipoNoticias
 * @property UsuarioAgencia[] $usuarioAgencias
 */
class Agencia extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_agencia';
	}
	public function getDbConnection()
	{
		return Yii::app()->db3;
	}
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nom_agencia,theme_rmt, referenciaRMT, emailPrincipal, log, id_tipo_plan', 'required'),
			array('id_tipo_plan, estatus, updates_estatus, ssl_status', 'numerical', 'integerOnly' => true),
			array('nom_agencia, sitio_web, referenciaRMT', 'length', 'max' => 255),
			array('telefonoPrincipal, telefonoWhatsapp', 'length', 'max' => 20),
			array('nosotros, logo_agencia, fotoBanner, fb_fanpage, agencia_mapa, instagram, twitter, youtube, fb_chat, fb_pixel_code, datos_bancarios, primary_color, secondary_color, user_ftp, password_ftp', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, nom_agencia, sitio_web, theme_rmt, referenciaRMT, emailPrincipal, telefonoPrincipal, telefonoWhatsapp, nosotros, logo_agencia, fotoBanner, fb_fanpage, agencia_mapa, instagram, twitter, youtube, fb_chat, fb_pixel_code, datos_bancarios, primary_color, secondary_color, log, id_tipo_plan, estatus, updates_estatus, user_ftp, password_ftp, ssl_status', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTipoPlan' => array(self::BELONGS_TO, 'TipoPlan', 'id_tipo_plan'),
			'avisoAgencias' => array(self::HAS_MANY, 'AvisoAgencia', 'id_agencia'),
			'bannerAgencias' => array(self::HAS_MANY, 'BannerAgencia', 'id_agencia'),
			'categorias' => array(self::HAS_MANY, 'Categoria', 'id_agencia'),
			'categoriaProductos' => array(self::HAS_MANY, 'CategoriaProducto', 'id_agencia'),
			'contactos' => array(self::HAS_MANY, 'Contacto', 'id_agencia'),
			'fotos' => array(self::HAS_MANY, 'Foto', 'id_agencia'),
			'galerias' => array(self::HAS_MANY, 'Galeria', 'id_agencia'),
			'movimientoses' => array(self::HAS_MANY, 'Movimientos', 'id_agencia'),
			'noticiaCategorias' => array(self::HAS_MANY, 'NoticiaCategoria', 'id_agencia'),
			'usuarioAgencias' => array(self::HAS_MANY, 'UsuarioAgencia', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'nom_agencia' => 'Nombre Agencia',
			'sitio_web' => 'Sitio Web',
			'theme_rmt' => 'Tema Agencia',
			'referenciaRMT' => 'Referencia Rmt',
			'emailPrincipal' => 'Correo electrónico',
			'telefonoPrincipal' => 'Teléfono',
			'telefonoWhatsapp' => 'WhatsApp',
			'nosotros' => 'Nosotros',
			'logo_agencia' => 'Logo Agencia',
			'fotoBanner' => 'Foto Banner',
			'fb_fanpage' => 'Fb Fanpage',
			'agencia_mapa' => 'Agencia Mapa',
			'instagram' => 'Instagram',
			'twitter' => 'Twitter',
			'youtube' => 'Youtube',
			'fb_chat' => 'Fb Chat',
			'fb_pixel_code' => 'Fb Pixel Code',
			'datos_bancarios' => 'Datos Bancarios',
			'primary_color' => 'Primary Color',
			'secondary_color' => 'Secondary Color',
			'log' => 'Log',
			'idTipoPlan.plan' => 'Plan Agencia',
			'id_tipo_plan' => 'Id Tipo Plan',
			'estatus' => 'Estatus',
			'updates_estatus' => 'Updates Estatus',
			'user_ftp' => 'User Ftp',
			'password_ftp' => 'Password Ftp',
			'ssl_status' => 'Ssl Status',

		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('nom_agencia', $this->nom_agencia, true);
		$criteria->compare('sitio_web', $this->sitio_web, true);
		$criteria->compare('theme_rmt', $this->theme_rmt, true);
		$criteria->compare('referenciaRMT', $this->referenciaRMT, true);
		$criteria->compare('emailPrincipal', $this->emailPrincipal, true);
		$criteria->compare('telefonoPrincipal', $this->telefonoPrincipal, true);
		$criteria->compare('telefonoWhatsapp', $this->telefonoWhatsapp, true);
		$criteria->compare('nosotros', $this->nosotros, true);
		$criteria->compare('logo_agencia', $this->logo_agencia, true);
		$criteria->compare('fotoBanner', $this->fotoBanner, true);
		$criteria->compare('fb_fanpage', $this->fb_fanpage, true);
		$criteria->compare('agencia_mapa', $this->agencia_mapa, true);
		$criteria->compare('instagram', $this->instagram, true);
		$criteria->compare('twitter', $this->twitter, true);
		$criteria->compare('youtube', $this->youtube, true);
		$criteria->compare('fb_chat', $this->fb_chat, true);
		$criteria->compare('fb_pixel_code', $this->fb_pixel_code, true);
		$criteria->compare('datos_bancarios', $this->datos_bancarios, true);
		$criteria->compare('primary_color', $this->primary_color, true);
		$criteria->compare('secondary_color', $this->secondary_color, true);
		$criteria->compare('log', $this->log, true);
		$criteria->compare('id_tipo_plan', $this->id_tipo_plan);
		$criteria->compare('estatus', $this->estatus);
		$criteria->compare('updates_estatus', $this->updates_estatus);
		$criteria->compare('user_ftp', $this->user_ftp, true);
		$criteria->compare('password_ftp', $this->password_ftp, true);
		$criteria->compare('ssl_status', $this->ssl_status);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Agencia the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}
}
