<?php
class TravelSolutionV2Controller extends Controller

{

	/**

	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning

	 * using two-column layout. See 'protected/views/layouts/column2.php'.

	 */

	public $layout='//layouts/column1';

	/*

	 * @return array action filters

	 */

	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}



	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.

	 * @return array access control rules
	 */

	public function accessRules()
	{

		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions

				'actions'=>array('tarifasAsur3', 'getRatesHD'),

				'users'=>array('*'),

			),

			array('allow',  // allow all users to perform 'index' and 'view' actions

				'actions'=>array('HotelTravelSolution','CancelarBooking','informationReference','TarifasTest'),

				'users'=>array('@'),

			),

			array('deny',  // deny all users
				'users'=>array('*'),
			),

		);

	}



	/**

	 * Displays a particular model.

	 * @param integer $id the ID of the model to be displayed

	 */
	
	public function loadModelTS()
	{
		return Api::model()->findByPk(6);
	}

	public function actionGetRatesHD(){
		if ($_POST["idHotel"] && $_POST["codigoHotel"]) {
			$tc=array();
			if ($_POST['currency_exchange'] && $_POST['currency']!="OR") {
				$tc=array('currency_exchange'=>$_POST['currency_exchange'],'currency'=>$_POST['currency']);				
			}
			$id_hotel = $_POST['idHotel'];
			$session = json_decode($_POST['front_form'],true);
			$api = Api::model()->findByPk(6);
			$markup=$api->markup;
			$tarifaTS = $this->getTarifasHDO($_POST['front_form'],$_POST['idHotel'],$_POST['fecha_inicial'],$_POST['codigoHotel'],false,$_POST['interfaceInfo'],$tc);

			// if (Yii::app()->user->id == 1437) {
				
			// echo "<textarea>".json_encode($tarifaTS)."</textarea>";
			// }
			// exit;
			// echo $tarifaTS['nombre_hotel'];
			$this->renderPartial('/site/_tarifasHotelDo',
				array(
                'tarifaTS'=>$tarifaTS[$id_hotel],
                'tarifa_carrito'=>$tarifaTS,
                'front_form'=>$session,
                'code_hotel'=>$_POST["codigoHotel"],
                'idHotel'=>$id_hotel,
                'nombre_hotel' => $tarifaTS['nombre_hotel'],
                'markup'=>$markup,
                'tc'=>$tc
            	)
			);
			

		}
	}

	public function actionTarifasTest(){
		$front_form = '{"habs":"1","solo_adultos":"","habitacion_1":{"adultos":"3","num_ninios":"0"},"info_search":{"1":{"adultos":"3","no_menores":"0"}},"cuartosParaRatesKeys":{"cuartos":["1~3~0|"],"tipos":["1~3~0|"],"cantidad":{"1~3~0|":1}},"fecha_ini":"09/12/2021","fecha_fin":"15/12/2021","destino":"h_174633","tipoPrecio":"","tipoPlan":null,"id_tipoPlan":null,"categoria":null,"agenciaUsuario":"8","estadoUsuario":"31","tipoUsuario":"Agencia"}';
		$idHotel = 174633;
		$fecha_inicial = '09/12/2021';
		$fecha_inicial = implode('-', array_reverse(explode('/', $fecha_inicial)));
		$codigoHotel = 223;
		$interfaceinfo = 'UEV8MXwyMjN8QkVTVERBWQ==';
		$response = $this->getTarifasHDO($front_form,$idHotel,$fecha_inicial,$codigoHotel,true,$interfaceinfo);
		echo json_encode($response);
	}

	public function actionTarifasAsur3(){
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header('Content-Type: application/json; charset=utf-8');
		$fecha_inicial = implode('-', array_reverse(explode('/', $_POST['fecha_inicial'])));
		$response = $this->getTarifasHDO($_POST['front_form'],$_POST['idHotel'],$fecha_inicial,$_POST['codigoHotel'],true,$_POST['interfaceInfo']);

		echo json_encode($response);
	}

	public function getTarifasHDO($front_form,$idHotel,$fecha_inicial,$codigoHotel,$manual,$interfaceInfo,$tc=null){
		$siteController = Yii::app()->createController('site');
		$siteController = $siteController[0];
		$agenciasMarkup = Yii::app()->createController('AgenciasMarkup')[0];

		$session = json_decode($front_form,true);
		$idhotel = $idHotel;
		$fecha_inicial = $fecha_inicial;

		$hotelTSTest=$siteController->tarifasTravelSolution(array(0=>$codigoHotel),false,$session);

		$hotelRate = json_decode($hotelTSTest)->Hotels->Hotel;

			// echo json_encode($hotelRate);
			// exit;

		$num_habs=$session['habs'];
		$noReembolsableMsg='';
		$noReembolsableMsg="<tr ><td colspan='4' style='border: inset 0pt'><p class='text-muted'>Tarifa No Reembolsable</p></td></tr>";
		$alerta_disponibilidad=1;
		$primeraTarifa="";  
		$menorPrecio=0;
		$tipoCambio=1;
		$api = Api::model()->findByPk(6);
		$markup=$api->markup;
		$mejorHabitacion="";
		$mejorPlan="";
		$num_tarifas=0;
										// $hotelRate = $hotelTS->hotels->hotels[$key];
		$roomTypes=$hotelRate->Rooms->Room;

		$rooms=count($roomTypes);

		$hotelTSInformation = Hoteles::model()->findByPk($idhotel);
		$id_hotel = $hotelTSInformation->id_hotel;

		if($hotelRate->CategoryId!="Array")
		{
			$countCategoria=strlen($hotelRate->CategoryId);
			if($countCategoria==2)
			{
				$estrellas=substr($hotelRate->CategoryId, 1);
			}else
			{
				$estrellas=substr($hotelRate->CategoryId, 1,-1);                                               
			}
		}

		$description = '';

		$description.= strip_tags($hotelRate->Description);

		if(!is_object($hotelRate->AdditionalCharges))
		{
			$hotelRate->AdditionalCharges=strip_tags($hotelRate->AdditionalCharges);
			$description.= "<hr>";
			$description.= "<strong>Nota del Hotel</strong><br>".ucfirst($hotelRate->AdditionalCharges);
		}

		$desgloseHead = "<table border='1' class='table-tooltip'>";
		$desgloseFoot= "</table>";
		$desgloseRooms="<tr><td colspan='2'>Habitaciones</td></tr>";
		$desglose = array();
		for($i=1;$i<=$num_habs;$i++)
		{
			$num_adultos=$session['habitacion_'.$i]['adultos'];
			$num_ninios=$session['habitacion_'.$i]['num_ninios'];
			$conca_adultos=($num_adultos>1)?'s':'';
			$conca_menores=($num_ninios>1)?'es':'';

			$desgloseRooms.="<tr><td>Habitación ".$i."</td>";

			$desgloseRooms.="<td>".$num_adultos." Adulto".$conca_adultos." - ".$num_ninios." Menor".$conca_menores;

			$desglose_ninios="";
			if($session['habitacion_'.$i]['num_ninios'])
			{
				$desglose_ninios=" (";
				for($j=1;$j<=$session['habitacion_'.$i]['num_ninios'];$j++)
				{

					$desglose_ninios.=$session['habitacion_'.$i]['edad_'.$j].",";									

				}

				$desglose_ninios=substr($desglose_ninios,0,-1);
				$desglose_ninios.=")";
			}

			$desgloseRooms.=$desglose_ninios."</td></tr>";
		}

		for ($i=0; $i < $rooms; $i++) { 
			if($rooms>1)
			{
				$room=$roomTypes[$i];
			}else
			{
				$room=$roomTypes;
			}

			$tipohab = TipoHabitaciones::model()->find('codigo="'.$room->Id.'" AND id_hotel='.$id_hotel);
			$tipohabs="";

			if(count($tipohab)>0)
			{
				$imprime=1;
			}else
			{
				$tipohab = new TipoHabitaciones;

				$tipohab->id_hotel=$id_hotel;
				$tipohab->tipo_habitacion=strtoupper($room->Name);
				$tipohab->descripcion=strtoupper($room->Name);
				$tipohab->codigo=$room->Id;
				$tipohab->max_adultos=$room->Adults;
				$tipohab->max_menores=$room->Children;
				$tipohab->paxextra=$room->Extras;
				$tipohab->estatus=1;
				$tipohab->max_juniors=0;
				$tipohab->orden=1;
				$tipohab->activa_validacion=0;

				if($tipohab->save())
				{
					$imprime=1;
				}else
				{
													// echo $tipo->getErrors();
													// print_r($tipohab->getErrors());
				}
			}

			if($imprime==1)
			{
					// $tipoHabs = '';
				for($h=1;$h<=$num_habs;$h++)
				{
					$tipoHabs.=$tipohab->id_tipo_habitacion.",";	
				}

				$roomDescription="";
				if (!is_object($room->Description)) {
					$roomDescription=$room->Description;
				}

				$tarifaTS[$id_hotel]["Habitaciones"][$i]["tipo_hab"] = $room->Name;
				$tarifaTS[$id_hotel]["Habitaciones"][$i]["nombre_hab"] = $tipohab->tipo_habitacion;
				$tarifaTS[$id_hotel]["Habitaciones"][$i]["id_tipo_habitacion"] = $tipohab->id_tipo_habitacion;
				$tarifaTS[$id_hotel]["Habitaciones"][$i]["allotment"] = 1;
				$tarifaTS[$id_hotel]["Habitaciones"][$i]["reservar"] = 1;
				$tarifaTS[$id_hotel]["Habitaciones"][$i]["ratekey"] = 'HotelDo';
				$tarifaTS[$id_hotel]["Habitaciones"][$i]["info_habitacion"] = $roomDescription;
				$tarifaTS[$id_hotel]["Habitaciones"][$i]["habitaciones"] = ""; 

				$ratesTypes=$room->MealPlans->MealPlan;

				$rates=count($ratesTypes);

				for($j=0; $j < $rates ; $j++) 
				{

					if($rates>1)
					{
						$rate=$ratesTypes[$j];
					}else
					{
						$rate=$ratesTypes;
					}

					$promos="";
					$promociones="";

					$tipo_plan=Plan::model()->find('codeTS="'.$rate->Id.'"');

					if(count($tipo_plan)==0)
					{

						$tipo_plan = new Plan;

						$tipo_plan->nombre=$rate->Name;
						$tipo_plan->tipo_validacion=0;
						$tipo_plan->codeTS=$rate->Id;
						$tipo_plan->estatus=1;

						if($tipo_plan->save())
						{
							$imprime=1;
						}else
						{
															// print_r($tipo_plan->getErrors());
						}
					}

					$tarifas_diaria=array();

					$politicasCancelacion=$this->politicasCancelacionTS($rate->RateDetails->RateDetail,$fecha_inicial,$markup,$tipohab->tipo_habitacion,$rate->Currency,$tc);

					$countRate=count($rate->NightsDetail->NightlyRate);
					// if ($manual==true) {
						# code...
						$desglose['habitacion']=$this->desgloseTSManual($rate->NightsDetail->NightlyRate,$fecha_inicial,$markup,$countRate,$rate->Currency,$session,$interfaceInfo,$rate,$room->Id,$api->params,$tc);
						$desgloseCalendario=$desglose;
					// }else{
					// 	$desglose=$this->desgloseTS($rate->NightsDetail->NightlyRate,$fecha_inicial,$markup,$countRate,$rate->Currency,$tc);
					// 	$desgloseCalendario = $desgloseHead.$desgloseRooms.$desgloseFoot.$desgloseHead.$desglose.$desgloseFoot;
					// }

					if(!is_object($hotelRate->AdditionalCharges))
						$cargosAdicionales='<a class="btn btn-xs btn-danger  waves-effect" rel="tooltip" data-toggle="tooltip" data-html="true" data-original-title="'.$hotelRate->AdditionalCharges.'" data-placement="top"><i class="fa fa-info"></i></a>';

					for($h=1;$h<=$num_habs;$h++)
					{
						$tarifadiaria="";             	

						for($d=0; $d<$countRate; $d++)
						{
							if($countRate>1)
							{
								$nightlyRate=$rate->NightsDetail->NightlyRate[$d];
							}else
							{
								$nightlyRate=$rate->NightsDetail->NightlyRate;
							}

							if($h==$num_habs)
								$nightlyRate_MXN=($nightlyRate->Total*$tipoCambio)/$markup;
							else
								$nightlyRate_MXN=0;
							$tarifadiaria.=(float)$nightlyRate_MXN.',';


						}

						array_push($tarifas_diaria, $tarifadiaria);

					}
					
					echo "ok";
					exit;
						##TARIFA DIARIA

					if(!is_object($hotelRate->AdditionalCharges))
					{
						$hotelRate->AdditionalCharges=strip_tags($hotelRate->AdditionalCharges);
						$cargosAdicionales='<a class="btn btn-xs btn-danger  waves-effect" rel="tooltip" data-toggle="tooltip" data-html="true" data-original-title="'.$hotelRate->AdditionalCharges.'" data-placement="top"><i class="fa fa-info"></i></a>';
						$cargos_adicionales = $hotelRate->AdditionalCharges;
					}

					if($rate->Promotions->Promotion)
					{
						$promotions=$rate->Promotions->Promotion;

						$count_promotions=count($promotions);

						for($p=0; $p<$count_promotions; $p++)
						{
							if($count_promotions>1)
							{
								$promocion=$promotions[$p];
							}else
							{
								$promocion=$promotions;
							}

							$promos.=$promocion->Description;
						}


					}

					if($promos!="")
						$promociones = $promos;
							// $promociones="<a class='btn btn-xs btn-success  waves-effect' rel='tooltip' data-toggle='tooltip' data-html='true' data-original-title='<h5>Promociones</h5>".$promos."' data-placement='top'><i class='fa fa-tag'></i></a>";

						### definicion de caracteristicas generales en planes
					$botonReservar=true;
					$tipoBotonTS = 'NORMAL';
					$colorTS = 'green';
					$notaTS = '';
					// 1000000
					if ($rate->Total>=1000000) {
						$botonReservar=false;
						$tipoBotonTS = 'CloseDates';
						$colorTS = 'red';
						$notaTS = 'Fechas Cerradas';
					}

					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["botonReservar"]=$botonReservar;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["tipo_boton"]=$tipoBotonTS;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["btnHtml"]["color"]=$colorTS;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["btnHtml"]["nota"]=$notaTS;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["hasAllotment"]=1;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["num_habs"]=$session["habs"];
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["id_plan"]=$tipo_plan->id_plan;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["id_habitacion"]=$tipohab->id_tipo_habitacion;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["idPrimeraTarifa"]="";
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["ocultarTarifa"]="";
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["Total_planes"]=null;

					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["warning"]["tarifaVacia"]=false;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["warning"]["mensaje"]="";

					if ($primeraTarifa=="") {
						$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["primeraTarifa"] = true;
						$primeraTarifa="Asignado";
					}else{
						$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["primeraTarifa"] = false;
					}

					$currency = '';
					if($rate->Currency == "PE") {
						$currency = "MXN";
					} else {
						$currency = $rate->Currency;
					}

					$rateDo = $rate->Total/$markup;
					$rateAlterada = $agenciasMarkup->aplicaMarkup($session["agenciaUsuario"],$rateDo);

						#### desglose de planes por habitacion
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["tipo_plan"]=$rate->Name;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["id_plan"]=$tipo_plan->id_plan;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["precio"]=number_format($rate->Total/$markup,2);

					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["precio_mod"]=number_format($rateAlterada['total'],2);
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["aplica_markup"]=$rateAlterada['mod'];

					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["precio_neto"]=$rate->Total;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["moneda"]=$currency;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["fecha_limiteH"]=$politicasCancelacion["fecha_limite_h"];
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["fecha_limite"]=$politicasCancelacion["fecha_limite"];
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["ratePlan"]=base64_encode(json_encode($rate));

					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["roomType"]=base64_encode(json_encode($room));
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["politicas_cancelacion"]=$politicasCancelacion["politicasCancelacion"];
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["promociones"]=base64_encode($promos);
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["tarifa"]=$id_tarifa;


					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["hab"]=$tipoHabs;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["tarifadiaria"]=base64_encode(json_encode($tarifas_diaria));
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["rateKey"]=$rate->RateKey;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["allotment"]=$alerta_disponibilidad;

					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["calendario"]=$desgloseCalendario;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["icon_politicas_cancelacion"]=$politicasCancelacion["politicasCancelacion"];
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["cargos_adicionales"]=$cargos_adicionales;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["promociones"]=$promociones;
					$tarifaTS[$id_hotel]["Habitaciones"][$i]["Planes"][$j]["plan"][0]["reembolsable"]="";


					$num_tarifas++;

					} ### fin de for rates


				} #### fin if imprime==1

			} ### fin de for rooms

			$tarifaTS[$id_hotel]["code_hotel"] = $_POST["codigoHotel"];
			$tarifaTS[$id_hotel]["id_hotel"] = $id_hotel;
			$tarifaTS[$id_hotel]["nombre_hotel"] = $hotelTSInformation->nombre_hotel;
			$tarifaTS[$id_hotel]["markup"] = $markup;

			$tarifaTS["code_hotel"] = $_POST["codigoHotel"];
			$tarifaTS["idHotel"] = $id_hotel;
			$tarifaTS["id_hotel"] = $id_hotel;
			$tarifaTS["nombre_hotel"] = $hotelTSInformation->nombre_hotel;
			$tarifaTS["markup"] = $markup;

			return $tarifaTS;
	}

	public function desgloseTS($rateDailyRates,$fecha_inicial,$markup,$countRate,$moneda,$tc=null)
	{
		if($moneda == "PE") {
			$moneda = "MXN";
		}
		$tipoCambio=1;

		$desglose.="<tr>
						<td>Noche</td>
						<td>Fecha</td>
						<td>Importe</td>
					</tr>";


		for($i=0; $i<$countRate; $i++)
		{
			if($countRate>1)
			{
				$nightlyRate=$rateDailyRates[$i];
			}else
			{
				$nightlyRate=$rateDailyRates;
			}
			$monedaChange=$moneda;
			$nightlyRate_MXN=($nightlyRate->Total*$tipoCambio)/$markup;
			$precio=$nightlyRate_MXN;
			if ($tc) {
				$dolarizar=$this->dolarizar($precio,$moneda,$tc);
				$nightlyRate_MXN=$dolarizar['total'];	
				$monedaChange=$dolarizar['moneda'];	
			}
			$desglose .= "<tr>
			<td>".($i+1)."</td>
			<td>".date('d-m-Y',strtotime($fecha_inicial.'+'.($i).' day'))."</td>
			<td>$ ".number_format($nightlyRate_MXN,2)." ".$monedaChange."</td>
			</tr>";

		}

    //$desglose=$desgloseHead.$desglose;

		return $desglose;
	}

	public function desgloseTSManual($rateDailyRates,$fecha_inicial,$markup,$countRate,$moneda,$front_form,$roomRates,$rate,$roomTypeId,$params,$tc=null)
	{
		$resultHotel = explode('|',base64_decode($roomRates));
		$parametrosTS = json_decode($params);
		$clave_afiliado=$parametrosTS->clave_afiliado;
		$ip="MX";
		$currency=$resultHotel[0];
		$destino=$resultHotel[1];
		$lenguage="ESP";
		$fecha_ini=explode("/", $front_form['fecha_ini']);
		$fecha_fin=explode("/", $front_form['fecha_fin']);
		$star_date=$fecha_ini[2].$fecha_ini[1].$fecha_ini[0];
		$end_date=$fecha_fin[2].$fecha_fin[1].$fecha_fin[0];
		$codigo_hotel=$resultHotel[2];
		$id_interfaceType=$resultHotel[3];

		if($moneda == "PE") {
			$moneda = "MXN";
		}

		$tipoCambio=1;

		$desgloseCal = array();
		for ($habs=1; $habs <= $front_form['habs']; $habs++) { 
			$desgloseCal[$habs]['resumen']['adultos'] = $front_form['habitacion_'.$habs]['adultos'];
			$desgloseCal[$habs]['resumen']['num_ninios'] = $front_form['habitacion_'.$habs]['num_ninios'];

			$adultos=$front_form['habitacion_'.$habs]['adultos'];				
			$menores=$front_form['habitacion_'.$habs]['num_ninios'];
			$totalRate = 0;

			$pax.="r1a=".$adultos."&";
			$pax.="r1k=".$menores."&";

			for ($j=1; $j <=$menores; $j++) 
			{
				$pax.="r1k".$j."a=".$front_form["habitacion_".$habs]["edad_".$j]."&";
			}

			$pax = trim($pax, '&');

			$request="a=".$clave_afiliado."&co=".$ip."&c=".$rate->Currency."&d=".$destino."&l=".$lenguage."&rk=".$rate->RateKey."&sd=".$star_date."&ed=".$end_date."&h=".$codigo_hotel."&ci=".$rate->Contract."&mi=".$rate->MarketId."&it=".$id_interfaceType."&ri=".$roomTypeId."&mp=".$rate->Id."&".$pax;

			$responseDesgloseTarifa=json_decode($this->consultarDesgloseTarifa($request),true);	
			$desgloseTarifa=$responseDesgloseTarifa["HotelRate"]["Rooms"]["Room"]["MealPlans"]["MealPlan"]["NightsDetail"]["NightlyRate"];


			if(!$desgloseTarifa[0])
			{
				$responseDesgloseTarifa["HotelRate"]["Rooms"]["Room"]["MealPlans"]["MealPlan"]["NightsDetail"]["NightlyRate"]=array();
				$responseDesgloseTarifa["HotelRate"]["Rooms"]["Room"]["MealPlans"]["MealPlan"]["NightsDetail"]["NightlyRate"][0]=$desgloseTarifa;
			}

			$pax="";

				$monedaChange=$moneda;
			for($i=0; $i<$countRate; $i++)
			{
				$nightlyRate_MXN=($responseDesgloseTarifa["HotelRate"]["Rooms"]["Room"]["MealPlans"]["MealPlan"]["NightsDetail"]["NightlyRate"][$i]["Total"]*$tipoCambio)/$markup;
				$totalRate += $nightlyRate_MXN;
				$desgloseCal[$habs]['Fechas'][$i+1]['Fecha'] = date('d-m-Y',strtotime($fecha_inicial.'+'.($i).' day'));
				$desgloseCal[$habs]['Fechas'][$i+1]['Adultos'] = number_format($nightlyRate_MXN,2);
				$desgloseCal[$habs]['Fechas'][$i+1]['Menores'] = 0.00;
				if ($tc) {
					$dolarizar=$this->dolarizar($nightlyRate_MXN,$moneda,$tc);
					$nightlyRate_MXN=$dolarizar['total'];	
					$monedaChange=$dolarizar['moneda'];	
				}
				$desgloseCal[$habs]['Fechas'][$i+1]['total'] = number_format($nightlyRate_MXN,2);
				$desgloseCal[$habs]['Fechas'][$i+1]['moneda'] = $monedaChange;

			}
			if ($tc) {
				$dolarizar=$this->dolarizar($totalRate,$moneda,$tc);
				$totalRate=$dolarizar['total'];	
				$monedaChange=$dolarizar['moneda'];	
			}
			$desgloseCal[$habs]['Total']['total'] = number_format($totalRate,2);
			$desgloseCal[$habs]['Total']['moneda'] = $monedaChange;

		}

		return $desgloseCal;
	}
	public function dolarizar($precio,$currency,$tc){
		if ($currency!=$tc['currency']){
		
			if ($currency=="USD" && $tc['currency']=="MXN") {
				$precio=($precio*$tc['currency_exchange']);
			}else if($tc['currency']=="USD" && $currency=="MXN"){
				$precio=($precio/$tc['currency_exchange']);
			}
			$currency=$tc['currency'];		
		}	
		return array('total'=>$precio,'moneda'=>$currency);
	}

	public function politicasCancelacionTS($cancellationPolicies,$fecha_inicial,$markup,$descripcionHabitacion,$moneda){
		$reservacionController = Yii::app()->createController('reservacion');
		$reservacionController = $reservacionController[0];
		$politicasCancelacion="<h5>Gastos de cancelación</h5>";

		$politicasCancelacion.="<table border='1' class='table-tooltip tableInfo'>
		<thead>
		<th colspan='3'>".$descripcionHabitacion."</th>
		</thead>
		<tbody>";

		if($moneda == "PE") {
			$moneda = "MXN";
		}

		$count_rateDetail=count($cancellationPolicies);

		for ($c=0; $c < $count_rateDetail; $c++) 
		{ 
			if($count_rateDetail>1)
			{
				$politicaCancelacion=$cancellationPolicies[$c];
			}else
			{
				$politicaCancelacion=$cancellationPolicies;
			}


			$politicaCancelacion->Id=trim($politicaCancelacion->Id,'-');
			$politicaCancelacion->Id=str_replace("C", "M", $politicaCancelacion->Id);

			$importe=$politicaCancelacion->CancellationPolicy->Amount/$markup;
			$daysToApplyCancellation=$politicaCancelacion->CancellationPolicy->DaysToApplyCancellation;

			$datetime_hoy=new DateTime(date("Y-m-d"));

			$datetime_cancelacion=new DateTime(date("Y-m-d",strtotime($fecha_inicial)));

			$diferencia = $datetime_cancelacion->diff($datetime_hoy);

			$resultado_diferencia_dias= $diferencia->format('%a');
			if($resultado_diferencia_dias<=$daysToApplyCancellation)
				$fecha_limite_h = date("d/m/Y 20:00");
			else
				$fecha_limite_h = date("d/m/Y H:i",strtotime($fecha_inicial.' -'.($daysToApplyCancellation+2).' days'));

			$diasLimiteAmount=($daysToApplyCancellation+6);

			$diasLimite=($daysToApplyCancellation+7);

			if($resultado_diferencia_dias<=$diasLimiteAmount)
			{
				$fecha_limite_amount=date("d/m/Y 20:00");
				$fecha_limite=date("d/m/Y 20:00");
			}else
			{											
				$fecha_limite_amount=date("d/m/Y H:i",strtotime($fecha_inicial.' -'.$diasLimiteAmount.' days'));
				$fecha_limite=date("d/m/Y H:i",strtotime($fecha_inicial.' -'.$diasLimite.' days'));

			}
					//$diasConca="<br>Resultado: ".$resultado_diferencia_dias."<br>Días considerables: ".$daysToApplyCancellation."<br> COUNT: ".$count_rateDetail;

			$politicasCancelacion.= "<tr><td>".$politicaCancelacion->Id."</td><td>A partir del ".$fecha_limite_amount."</td><td style='width: 25%;'> $ ".number_format($importe,2)." ".$moneda."</td>".$diasConca;
		}



		$politicasCancelacion.="</tbody></table>"; 

                //if($fecha_inicial==date("Y-m-d"))

                    //$politicasCancelacion="Aplica cargo de cancelación inmediato. $ ".number_format($importe,2)." ".$moneda;

		return array('politicasCancelacion'=>$politicasCancelacion,'fecha_limite'=>$fecha_limite, 'fecha_limite_h'=>$fecha_limite_h);
	}

	public function actionHotelTravelSolution($codigoHotel,$id_hotel,$fecha_inicial)
	{ 


        $response=$this->searchHotelTS($codigoHotel);
        
        $siteController = Yii::app()->createController('site');
        $siteController = $siteController[0];

        $hotelRate=$siteController->tarifasTravelSolution(array(0=>$codigoHotel),false);
        
        //$hotelTSInformation=$siteController->hotelTSInformation($codigoHotel);				

        if(!$_SESSION["informationHotelesTS"][$id_hotel])
        {
            $hotelTSInformation=$siteController->hotelTSInformation($codigoHotel,$id_hotel);
        }

        //echo '<textarea rows="10" cols="50">'.json_encode($_SESSION["informationHotelesTS"][$id_hotel]).'</textarea>';
		//echo '<textarea rows="10" cols="50">'.json_encode($response).'</textarea>';		
		//echo '<textarea rows="10" cols="50">'.$hotelRate.'</textarea>';

		if($id_hotel==184821 || $id_hotel==184822){
			//echo "<textarea>".$_SESSION["tarifasTravelSolution"]."</textarea>";
		}

		
		

        if($response===false){
	        echo 0;
        }
        else{        
			$api = Api::model()->findByPk(6);
            $this->renderPartial('cotizacionrapidaTravelSolution',
            array(
                'id_hotel'=>$id_hotel,
                'fecha_inicial'=>$fecha_inicial,
                'noches'=>$noches,
                'hotelTS'=>json_decode($hotelRate)->Hotel,
                'api'=>$api
            ));

        }
		
	}


	public function hotelTravelSolutionWS($codigoHotel,$id_hotel,$session)
	{ 
        // $response=$this->searchHotelTS($codigoHotel);
        
        $siteController = Yii::app()->createController('site');
        $siteController = $siteController[0];

        $hotelRate=$siteController->tarifasTravelSolution(array(0=>$codigoHotel),false,$session);

        // if(!$_SESSION["informationHotelesTS"][$id_hotel])
        // {
        //     $hotelTSInformation=$siteController->hotelTSInformation($codigoHotel,$id_hotel);
        // }

		if($id_hotel==184821 || $id_hotel==184822){
			//echo "<textarea>".$_SESSION["tarifasTravelSolution"]."</textarea>";
		}
		return json_decode($hotelRate)->Hotel;
	}


	public function hotelTravelSolutionSinInterfaz($codigoHotel,$session)
	{ 

        $siteController = Yii::app()->createController('site');
        $siteController = $siteController[0];

        $hotelRate=$siteController->tarifasTravelSolution(array(0=>$codigoHotel),false,$session);
        		
		$hotelTS=json_decode($hotelRate)->Hotel;

        if($response===false){
	        return 0;
        }
        else{        
            return $hotelTS;
        }
		
	}

	public function searchHotelTS($codigoHotel)
	{
		if (!$_SESSION['mismoHotelDo']) {
			$jsonHotel=$_SESSION["tarifasTravelSolution"];			
        }else{
			$jsonHotel=$_SESSION["mismoHotelDo"];
        }			        
		$ahotelTS=json_decode($jsonHotel,true);         
		$hotelTS=json_decode($jsonHotel);         
		$arrHotel=$ahotelTS["hotels"]["hotels"];
		$key = array_search($codigoHotel, array_column($arrHotel, 'Id'));

        if($key===false){
	        $response=false;
        }
        else{        
        	$response=$hotelTS->hotels->hotels[$key];
        }
       		
        return $response;
	}

	public function searchRoomTS($codigoHotel,$roomID)
	{
        $hotelTS=$this->searchHotelTS($codigoHotel);	
		
        if(count($hotelTS->Rooms->Room)>1)
		{
			$ahotelTS=json_decode(json_encode($hotelTS),true);
			$arrHotel=$ahotelTS["Rooms"]["Room"];
			$key = array_search($roomID, array_column($arrHotel, 'Id'));
		}else
		{
			if($hotelTS->Rooms->Room->Id==$roomID)
			{
				$key=$hotelTS->Rooms->Room;
			}else
			{
				$key=false;
			}
		}
        if($key===false){
	        $response=false;
        }
        else{     
        	if(count($hotelTS->Rooms->Room)>1)
        	{   
        		$response=$hotelTS->Rooms->Room[$key];
        	}else
        	{
        		$response=$key;
        	}
        }
        return $response;
	}

	public function consultarDesgloseTarifa($request)
	{
		$curl = curl_init();
		$rateKey['request'] = base64_encode($request);
		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://www.rutamayatravel.com/sur4/reservacion/recheckHotelDo",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => "rateKey=".json_encode($rateKey)."&check=0",
			CURLOPT_HTTPHEADER => array(
				"Content-Type: application/x-www-form-urlencoded",
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);

		return $response;
	}

	public function menorTarifaTravelSolutionWS($codigo_hotel,$markup,$mealplanArrayDO,$id_hotel)
	{
		$agenciasMarkup = Yii::app()->createController('AgenciasMarkup')[0];
		if ($_SESSION["responseTS"]) {
			$hotelTS = $_SESSION["responseTS"];
		}else{
			$hotelTS = false;
		}
		
		$primeraTarifa="";  
		$menorPrecio=0;
		$roomTypes=$hotelTS->Rooms->Room;
		$rooms=count($roomTypes);

		$planesArray = array();
		$hotelesPlanes = array();
		for($i=0; $i < $rooms ; $i++) 
		{
			if($rooms>1)
			{
				$room=$roomTypes[$i];
			}else
			{
				$room=$roomTypes;
			}

			$tipohab = TipoHabitaciones::model()->find('codigo="'.$room->Id.'" AND id_hotel='.$id_hotel);
			$tipohabs="";

			if(count($tipohab)>0)
			{
				$imprime=1;
			}else
			{
				$tipohab = new TipoHabitaciones;

				$tipohab->id_hotel=$id_hotel;
				$tipohab->tipo_habitacion=strtoupper($room->Name);
//		                $tipohab->descripcion=strtoupper($room->Name.' '.(empty($room->RoomView))?'':$room->RoomView);
				$tipohab->descripcion=strtoupper($room->Name);
				$tipohab->codigo=$room->Id;
				$tipohab->max_adultos=$room->Adults;
				$tipohab->max_menores=$room->Children;
				$tipohab->paxextra=$room->Extras;
				$tipohab->estatus=1;
				$tipohab->max_juniors=0;
				$tipohab->orden=1;
				$tipohab->activa_validacion=0;

				if($tipohab->save())
				{
					$imprime=1;
				}else
				{
					echo $tipohab->getErrors();
						// print_r($tipohab->getErrors());
				}
			}


			$ratesTypes=$room->MealPlans->MealPlan;

			$rates=count($ratesTypes); 

			for($j=0; $j < $rates ; $j++) 
			{

				if($rates>1)
				{
					$rate=$ratesTypes[$j];
				}else
				{
					$rate=$ratesTypes;
				}

				if($rate->Currency == "PE") {
					$currency = "MXN";
				} else {
					$currency = $rate->Currency;
				}	

				$planHDO = array_search($rate->Id,$mealplanArrayDO);
				if (!in_array((int) $planHDO,$planesArray)) {
					array_push($planesArray,(int) $planHDO);
					$hotelesPlanes[] =  $rate->Name;
				}

				if($primeraTarifa=="")
				{
					$precioPrimeraTarifa = $rate->Total/$markup;
					// $precioPrimeraAlterada = $agenciasMarkup->aplicaMarkup($agenciaUsuario,$precioPrimeraTarifa);
					// $precioPrimeraTarifa = $precioPrimeraAlterada['total'];
					$primeraTarifa="asignado";
					$desgloseTS["tarifas"] = $rooms;
					$desgloseTS["mejorHabitacion"] = $tipohab->tipo_habitacion;
					$desgloseTS["mejorPlan"] = $rate->Name;
					$desgloseTS["menorPrecio"]=number_format($precioPrimeraTarifa,2);
					$desgloseTS["moneda"] = $currency;
					$desgloseTS["banderaBootom"] = false;
					$menorTarifa=$rate->Total/$markup;

					if($currency=="USD") {
						$desgloseTS["menorPrecio"] = number_format($precioPrimeraTarifa,2);
						$menorTarifaMXN = 19.5000*$precioPrimeraTarifa;
						$desgloseTS["menorPrecio_mxn"] = number_format($menorTarifaMXN,2);
					}

				}
			}
		}

        return array('menorTarifa' => $menorTarifa, 'planHDO' => $planesArray, 'nombrePlanes' => $hotelesPlanes, "desgloseTS" => $desgloseTS);
	}


	public function menorTarifaTravelSolution($codigo_hotel)
	{
		$hotelTS=$this->searchHotelTS($codigo_hotel);
		
        if($hotelTS===false){
	        $menorTarifa=0;
        }
        else
        {        
			$api = Api::model()->findByPk(6);
            
			$primeraTarifa="";  
			$menorPrecio=0;
			$markup=$api->markup;
			$roomTypes=$hotelTS->Rooms->Room;
			$rooms=count($roomTypes);

	    	for($i=0; $i < $rooms ; $i++) 
			{
			    if($rooms>1)
			    {
			        $room=$roomTypes[$i];
			    }else
			    {
			        $room=$roomTypes;
			    }	           

			    $ratesTypes=$room->MealPlans->MealPlan;

			    $rates=count($ratesTypes); 

			    for($j=0; $j < $rates ; $j++) 
			    {

			        if($rates>1)
			        {
			            $rate=$ratesTypes[$j];
			        }else
			        {
			            $rate=$ratesTypes;
			        }
                    
                    if($primeraTarifa=="")
                    {
                    	$primeraTarifa="asignado";
                    	$menorTarifa=$rate->Total/$markup;

                    }
			    }
			}
        }



        return $menorTarifa;
	}


	public function actionInformationReference()
	{
		$reference=substr($_POST["code"],2);
		$markup = Api::model()->findByPk(6)->markup;
		$resultado="";
		$error=0;
		$travelSolution= new TravelSolution();
		$start=explode("/",$_SESSION["booking"]["start"]);
	 	$end=explode("/",$_SESSION["booking"]["end"]);

	 	$from=$start[2].$start[1].$start[0];
	 	$to=$end[2].$end[1].$end[0];

		$params = 'asoc='.$travelSolution->affiliateId.'&from='.$from.'&to='.$to.'&bookId='.$reference.'&destId=0&lang=ESP&bychangedate=N&hash=';
		$travel = $travelSolution->getBookinbyDate($params);

		$travel=json_decode($travel);
		if ($travel->Error) {
			echo '<div class=" alert alert-warning text-center">
				<strong>'.$travel->Error->Description.'</strong>
			</div>';
			exit;
		}

		if (count($travel->Booking)>1) {
			foreach ($travel->Booking as $i => $information) 	
			{
					//echo "<textarea>".json_encode($information)."</textarea>";
				//$response=$this->searchBookingTS($reference."-".$i);
					$reference=explode('-',$information->BookingId);
					
								
					if($i==0)
					{
						$fechac= $information->BookingDate;
						$fechao= $information->LeavingDate;
						$fecha= $information->ReturnDate;
						$resultado.='
						<table class="table table-striped table-condensed">
							<thead>
								<tr>
									<td colspan="4" rowspan="3"><h4><strong>Cliente: </strong>'.$information->CustomerFirstName.' '.$information->CustomerLastName.'</h4></td>
									<td ><strong>Creación: </strong></td><td>'.$fechac.'</td>
								<tr>
									<td><strong>Check in: </strong></td><td>'.$fecha.'</td>
								<tr>
									<td><strong>Check Out: </strong></td><td>'.$fechao.'</td>
								</tr>
								<tr>
									<th>Habitación</th>
									<th>Booking Id</th>
									<th>Estatus</th>
									<th>Servicio</th>
									<th>Total</th>
								</tr>
								</thead>
							<tbody>
								';
									//<th>Estado</th>
					}
					
					$resultado.='
							<tr>
								<th>'.$reference[1].'</th>
								<td>'.$reference[0].'</td>
								<td>'.$this->statusBooking($information->BookingState).'</td>
								<td>'.$information->ServiceName.'</td>
								<td>$ '.number_format($information->BookingAmmount,2).' '.$information->Currency.'</td>
							</tr>
							';
								//<td>'.$this->statusBooking($information->PaymentState).'</td>
			}
				
		}else{

			$information=$travel->Booking;
			$reference=explode('-',$information->BookingId);
			$fechac= $information->BookingDate;
						$fechao= $information->LeavingDate;
						$fecha= $information->ReturnDate;
						$resultado.='
						<table class="table table-striped table-condensed">
							<thead>
								<tr>
									<td colspan="4" rowspan="3"><h4><strong>Cliente: </strong>'.$information->CustomerFirstName.' '.$information->CustomerLastName.'</h4></td>
									<td ><strong>Creación: </strong></td><td>'.$fechac.'</td>
								<tr>
									<td><strong>Check in: </strong></td><td>'.$fecha.'</td>
								<tr>
									<td><strong>Check Out: </strong></td><td>'.$fechao.'</td>
								</tr>
								<tr>
									<th>Habitación</th>
									<th>Booking Id</th>
									<th>Estatus</th>
									<th>Servicio</th>
									<th>Total</th>
								</tr>
								</thead>
							<tbody>
								';
									//<th>Estado</th>
					
					
					$resultado.='
							<tr>
								<th>'.$reference[1].'</th>
								<td>'.$reference[0].'</td>
								<td>'.$this->statusBooking($information->BookingState).'</td>
								<td>'.$information->ServiceName.'</td>
								<td>$ '.number_format($information->BookingAmmount,2).' '.$information->Currency.'</td>
							</tr>
							';

		}
	

		$resultado.='</tbody></table>';

		if($error==1)
			$resultado="<br>Ocurrió un error, el código de información no se encontró registrado con el Socio On-Line<br>";
		

		echo $resultado;


	}

	public function searchBookingTS($reference)
	{
		//echo $reference;

		$aBookingsTravelSolution=json_decode($_SESSION["bookingsTravelSolution"],true);
		$bookingsTravelSolution=json_decode($_SESSION["bookingsTravelSolution"]);

		$numeroReservas=count($aBookingsTravelSolution);
		$arrBooking=$aBookingsTravelSolution["Booking"];
		if($numeroReservas>1){
			$key = array_search($reference, array_column($arrBooking, 'BookingId'));
	        if($key===false){
		        $response=false;
	        }
	        else{        
	        	$response=$bookingsTravelSolution->Booking[$key];
	    	}        
		}else{
			$response=$bookingsTravelSolution->Booking;
		}
		return json_encode($response);

	}
	
	public function bookingBeforeCancel($reference)
	{
		$travelSolution = new TravelSolution;	

		$request="a=".$travelSolution->affiliateId."&bn=".$reference;
		$response = $travelSolution->getItinerary($request);
		return $response;
	}

	public function counsultaCancelarBooking($reference,$consecutivo)
	{
		
		$lenguage="ESP";
		$currency="MX";

		$travelSolution = new TravelSolution;	
		
		//bn=47121828&bc=9&ch=111635&rc=

		$request="a=".$travelSolution->affiliateId."&ip=".$_SERVER["REMOTE_ADDR"]."&l=".$lenguage."&c=".$currency."&bn=".$reference."&bc=".$consecutivo;   

		//echo $request."<hr>";
		$response = $travelSolution->cancelItineraryHotel($request);
	
		return $response;
	}

	public function bookingList($request)
	{
		$travelSolution = new TravelSolution;		
		$response = $travelSolution->getBookinbyDate($request);

		return $response;
	}

	public function actionCancelarBooking()
	{

		$cancelar=$_POST["cancelar"];

		$code=explode("/", $_POST["code"]);
		$reference=substr($code[0], 2);
		$num_service=$code[1]-1;
		$cancelacion=array();
		//echo $cancelar." ".$reference;

		
		if($cancelar=='SIMULATION')
		{
			//echo $num_service;
			
		
			$response=$this->bookingBeforeCancel($reference);
		
			$booking=json_decode($response,true);

			//echo '<textarea rows="10" cols="50">'.$response.'</textarea>';
			
			$booking["Itinerary"]["@attributes"]["ReservationId"];

			
			if($booking["Itinerary"]["@attributes"]["ReservationId"])
			{

				
				$aKeys=array_keys($booking["Itinerary"]["Services"]["HotelServices"]["Hotel"]);
					if (!is_numeric($keys[0])) {
						$serviciosHotel[0]=$booking["Itinerary"]["Services"]["HotelServices"]["Hotel"];
					}else{
						$serviciosHotel=$booking["Itinerary"]["Services"]["HotelServices"]["Hotel"];
					}

				/*if(!$serviciosHotel[0])
				{
					$booking["Itinerary"]["Services"]["HotelServices"]["Hotel"]=array();
					$booking["Itinerary"]["Services"]["HotelServices"]["Hotel"][0]=$serviciosHotel;
				}

				

				$politicasCancelacion=$booking["Itinerary"]["Services"]["HotelServices"]["Hotel"]["Cancellation"];
			
			    if(!$politicasCancelacion[0])
				{
					$booking["Itinerary"]["Services"]["HotelServices"]["Hotel"]["Cancellation"]=array();
					$booking["Itinerary"]["Services"]["HotelServices"]["Hotel"]["Cancellation"][0]=$politicasCancelacion;	
				}*/

				//$fechaSC=implode("/", array_reverse(explode("-",  substr($booking["Itinerary"]["Services"]["HotelServices"]["Hotel"]["Cancellation"][0]["PenaltyStartDate"],0,10))));

				/*$fechaSC=$booking["Itinerary"]["Services"]["HotelServices"]["Hotel"]["Cancellation"]["PenaltyStartDate"];*/
							
				foreach ($serviciosHotel as  $key=>$fechas) 
				{
				
						
					
						$cancelacionInmediata="0";
						$fecha=$fechas["Cancellation"];
						
						$fechaSC=date("d/m/Y",strtotime($fecha["PenaltyStartDate"]." -1 days"));
						if (date("Y-m-d") < date("Y-m-d",strtotime($fecha["PenaltyStartDate"]." -2 days"))) {
							$cancelacionInmediata="1";
						}
						$noches = $fecha["PenaltyNights"]>1?" Noches":" Noche";
						$cancelacion[$key]=array('habitacion'=>($key+1),'fecha'=>$fechaSC, 'importe'=>$fecha["PenaltyNights"].$noches);
						$cancelacion["btnCancelacion"][$key]=$cancelacionInmediata;	
					
				}
				
					echo json_encode($cancelacion);
			}else
			{
				echo "<br>Ocurrió un error, no se puede cancelar la reserva";
			}	



			/*$this->archivoLog($reference,"CancelsimRQ ".$reference.".xml");

			$this->archivoLog($response,"CancelsimRS ".$reference.".xml");*/

		}

		else if($_POST["idDesglose"] && $cancelar=="CANCELLATION")
		{
			

			//$response = $this->counsultaCancelarBooking($reference,$code[1]);

			
			/*
						$this->archivoLog($reference.$code[1],"CancelRQ ".$reference.".xml");

						$this->archivoLog($response,"CancelRS ".$reference.".xml");
					*/

			/*echo '<textarea rows="10" cols="50">'.$logHotelbeds->request.'</textarea>';
			echo '<textarea rows="10" cols="50">'.$logHotelbeds->response.'</textarea>';*/


			
				$response=json_decode($this->xml_to_json($response));
				
				if($response->status=="CA")
				{
					$habitacion = ReservacionDesglose::model()->findByPk($_POST["idDesglose"]);					
					if($habitacion->id_desglose==$_POST["idDesglose"])
					{
						$habitacion->estatus=0; 
						if($habitacion->save())
							echo "<p>La habitación ha sido cancelada.</p><p>Costo: ".number_format($response->amount,2)." ".$response->currency."</p>";					
						
					}
				}else if($response->code=="221")
				{
					$habitacion = ReservacionDesglose::model()->findByPk($_POST["idDesglose"]);					
					if($habitacion->id_desglose==$_POST["idDesglose"])
					{
						$habitacion->estatus=0; 
						if($habitacion->save())
							echo "<p>La habitación ha sido cancelada anteriormente.</p>";					
						
					}
				}else
				{
					echo "<br>Ocurrió un error al intentar cancelar la reserva.";
				}
			


		}
		$response=json_encode($response);
		$logHotelbeds['header'] = $cancelar;
		$logHotelbeds['request'] = json_encode(array('reference'=>$reference,'consecutivo'=>$code[1]));
		$logHotelbeds['response'] = $response;
		$logHotelbeds['reference'] = $reference;
		$this->logWs($logHotelbeds);
		
	}


	public function statusBooking($status)
	{
		switch ($status) 
		{
			##Bookings
		    case 'None':
		        $response="Ninguna";
		    break;
		    case "CO":
		        $response="Confirmada";
		    break;
		    case "NC":
	    	    $response="No Confirmada";
	        break;
	        case "CA":
	        	$response="Cancelada";	        
	        break;
	        ##Payment
	        case "NA":
	        	$response="Pagado no aplicado";	        
	        break;
	        case "NP":
	        	$response="No pagado";	        
	        break;
	        case "PP":
	        	$response="Parcialmente pagado";	        
	        break;
	        case "PA":
	        	$response="Pagado";	        
	        break;
	        case "OP":
	        	$response="Pagado en exceso";	        
	        break;
		}

		return $response;
	}


	public 	function createBookTravelSolution($reservacion)
	{
		$carrito = $_POST['carrito'];
		$ratePlan=json_decode(base64_decode($_SESSION["Datos"][0]["ratePlan"]));
		$roomType=json_decode(base64_decode($_SESSION["Datos"][0]["roomType"]));

	    $xml = new DomDocument('1.0', 'UTF-8');
	 
	    $request = $xml->createElement('Request');
	    $request = $xml->appendChild($request);
	    $request->setAttribute('Type', 'Reservation');
	    $request->setAttribute('Version', '1.0');

	    	$travelSolution = new TravelSolution;	


		    $affiliateid = $xml->createElement('affiliateid',$travelSolution->affiliateId);
		    $affiliateid = $request->appendChild($affiliateid);

		    $language = $xml->createElement('language','ESP');
		    $language = $request->appendChild($language);

			//$company = $xml->createElement('company','BEDA');
		    //$company = $request->appendChild($company);

		    $currency = $xml->createElement('currency',$ratePlan->Currency);
		    $currency = $request->appendChild($currency);

		    $uid = $xml->createElement('uid','tgvwbagq0fn2bd3kn1w4xvba');
		    $uid = $request->appendChild($uid);

		    $machineid = $xml->createElement('machineid','989a49a7-bfdd-44a5-ef01-a6f5fa075f8d');
		    $machineid = $request->appendChild($machineid);

		    $ip = $xml->createElement('ip','187.155.151.75');
		    $ip = $request->appendChild($ip);

		    $firstname = $xml->createElement('firstname',$reservacion->nombre_cliente);
		    $firstname = $request->appendChild($firstname);

		    $lastname = $xml->createElement('lastname',$reservacion->apellido_cliente);
		    $lastname = $request->appendChild($lastname);

		    $emailaddress = $xml->createElement('emailaddress','fernandoeuan@rutamayatravel.com');
		    $emailaddress = $request->appendChild($emailaddress);

		    ##PREGUNTAR QUE VA LLEVAR EN ESTA SECCIÓN 

			    $clientcountry = $xml->createElement('clientcountry','MX');
			    $clientcountry = $request->appendChild($clientcountry);

			    $country = $xml->createElement('country','MX');
			    $country = $request->appendChild($country);
			 
			 	$address = $xml->createElement('address','Conocido');
			    $address = $request->appendChild($address);

			    $city = $xml->createElement('city','Mérida');
			    $city = $request->appendChild($city);

			    $state = $xml->createElement('state','YUCA');
			    $state = $request->appendChild($state);

			    $zip = $xml->createElement('zip','97120');
			    $zip = $request->appendChild($zip);
		    
		    ##PREGUNTAR QUE VA LLEVAR EN ESTA SECCIÓN 


		    $total = $xml->createElement('total',$ratePlan->Total);
		    $total = $request->appendChild($total);

		    $phones = $xml->createElement('phones');
		    $phones = $request->appendChild($phones);

			    $phone = $xml->createElement('phone');
			    $phone = $phones->appendChild($phone);

				    $phon = $xml->createElement('type','2');
				    $phon = $phone->appendChild($phon);

				    $phon = $xml->createElement('number','9991224716');
				    $phon = $phone->appendChild($phon);

		    $hotels = $xml->createElement('hotels');
		    $hotels = $request->appendChild($hotels);

			    $hotel = $xml->createElement('hotel');
			    $hotel = $hotels->appendChild($hotel);

				    $hotelid = $xml->createElement('hotelid',explode('/',$reservacion->idHotel->codigo)[0]);
				    $hotelid = $hotel->appendChild($hotelid);

				    $roomtypeId = $xml->createElement('roomtype',$roomType->Id);
				    $roomtypeId = $hotel->appendChild($roomtypeId);

				    $mealplan = $xml->createElement('mealplan',$ratePlan->Id);
				    $mealplan = $hotel->appendChild($mealplan);

				    $datearrival = $xml->createElement('datearrival',date("Ymd",strtotime($reservacion->fecha_inicial)));
				    $datearrival = $hotel->appendChild($datearrival);

				    $datedeparture = $xml->createElement('datedeparture',date("Ymd",strtotime($reservacion->fecha_final)));
				    $datedeparture = $hotel->appendChild($datedeparture);

				    $marketid = $xml->createElement('marketid',$ratePlan->MarketId);
				    $marketid = $hotel->appendChild($marketid);

				    $contractid = $xml->createElement('contractid',$ratePlan->Contract);
				    $contractid = $hotel->appendChild($contractid);

				    $dutypercent = $xml->createElement('dutypercent','0');
				    $dutypercent = $hotel->appendChild($dutypercent);

				    $rooms = $xml->createElement('rooms');
				    $rooms = $hotel->appendChild($rooms);


						for($hab=1;$hab<=$reservacion->num_habitaciones;$hab++)
						{
							$roomRate=json_decode($_SESSION['Datos'][0]['roomRates'][$hab]);
							
							$adults=$_SESSION['front_form']['habitacion_'.$hab]['adultos'];
							$kids = 0;
							$infants = 0;
							$ageKids=array();
							$ageInfants=array();					

							$num_ninios_aux=$_SESSION['front_form']['habitacion_'.$hab]['num_ninios'];							
							
							if($num_ninios_aux)
							{
								for($n=1;$n<=$num_ninios_aux;$n++)
								{				
									$edad_ninio_aux=$_SESSION['front_form']['habitacion_'.$hab]['edad_'.$n];	

					    			if($roomType->CapacityChildAgeFrom>$edad_ninio_aux)
					    			{
					    				$infants++;
					    				array_push($ageInfants,$edad_ninio_aux);
					    			}

					    			if($roomType->CapacityChildAgeFrom<=$edad_ninio_aux && $edad_ninio_aux<=$roomType->CapacityChildAgeTo)
					    			{
					    				$kids++;
					    				array_push($ageKids,$edad_ninio_aux);
					    			}

					    			if($roomType->CapacityJuniorAgeFrom!=0 && $roomType->CapacityJuniorAgeTo!=0)
					    			{
					    				if($roomType->CapacityJuniorAgeFrom<=$edad_ninio_aux && $edad_ninio_aux<=$roomType->CapacityJuniorAgeTo)
					    				{
					    					$kids++;
					    					array_push($ageKids,$edad_ninio_aux);

					    				}

						    			if($roomType->CapacityJuniorAgeTo<$edad_ninio_aux)
						    				$adults++;
					    			}else
					    			{
					    				if($roomType->CapacityChildAgeTo<$edad_ninio_aux)
						    				$adults++;
					    			}	    			
									
								}

						  	}


							$room = $xml->createElement('room');
						    $room = $rooms->appendChild($room);
						    
						    	for ($a=1; $a<=$adults; $a++) { 

							    	$name= $xml->createElement('name', $_SESSION['Datos'][$carrito]['front_form']['habitacion_'.$hab]['adulto_'.$a]);
							    	$name = $room->appendChild($name);
							    	$lastname = $xml->createElement('lastname', $_SESSION['Datos'][$carrito]['front_form']['habitacion_'.$hab]['adulto_apellido_'.$a]);
							    	$lastname = $room->appendChild($lastname);
						    		
						    	}

						    	
							    $amount = $xml->createElement('amount',$roomRate->Total);
							    $amount = $room->appendChild($amount);

							    $status = $xml->createElement('status',$roomRate->Available->Status);
							    $status = $room->appendChild($status);

							    $ratekey = $xml->createElement('ratekey',$roomRate->RateDetails->RateDetail->RateKey);
							    $ratekey = $room->appendChild($ratekey);

							    $adults = $xml->createElement('adults',$adults);
							    $adults = $room->appendChild($adults);

							    $kids = $xml->createElement('kids',$kids);
							    $kids = $room->appendChild($kids);						    

							    foreach ($ageKids as $keyK => $ageK) 
							    {
							    	$ageK = $xml->createElement('k'.($keyK+1).'a',$ageK);
							    	$ageK = $room->appendChild($ageK);
							    }

							    $infants = $xml->createElement('infants',$infants);
							    $infants = $room->appendChild($infants);

							    foreach ($ageInfants as $keyI => $ageI) 
							    {
							    	$ageI = $xml->createElement('i'.($keyI+1).'a',$ageI);
							    	$ageI = $room->appendChild($ageI);
							    }

						}

					    $payments = $xml->createElement('payments');
					    $payments = $request->appendChild($payments);

					    $agencycreditpayment = $xml->createElement('agencycreditpayment');
					    $agencycreditpayment = $payments->appendChild($agencycreditpayment);

					    $type=$xml->createElement('type','CREPMX');
					    $type=$agencycreditpayment->appendChild($type);
					    

					    $currency=$xml->createElement('currency','PE');
					    $currency=$agencycreditpayment->appendChild($currency);

					    $amount=$xml->createElement('amount',$ratePlan->Total);
					    $amount=$agencycreditpayment->appendChild($amount);
/*
<agencycreditpayment> 
	<type>CREPMX</type> 
	<currency>PE</currency> 
	<amount>12346.51</amount> 
</agencycreditpayment>

*/


	 
	    $xml->formatOutput = true;
	    $request_xml = $xml->saveXML();

	    $response=$this->bookTravelSolution($request_xml);
		//$response=$this->xml_to_json($response_xml);
		//echo '<textarea rows="10" cols="50">'.$request_xml.'</textarea>';
		//echo '<textarea rows="10" cols="50">'.$response.'</textarea>';
		//echo '<textarea rows="10" cols="50">'.json_encode($ratePlan).'</textarea>';
		//
		
		
		$responsJson=$this->xml_to_json($response);
		$responseObj=json_decode($responseJson);
		$logHotelbeds['header'] = "Booking";
		$logHotelbeds['request'] = $request_xml;
		$logHotelbeds['response'] = $response;
		$logHotelbeds['reference'] = $responseObj->confirmationid;
		$this->logWs($logHotelbeds);

		
		$this->archivoLog($request_xml,"BookRQ ".$responseObj->confirmationid.".xml");
		
		$this->archivoLog($logHotelbeds['response'],"BookRS ".$responseObj->confirmationid.".xml");
		
	
			return $responsJson;

      	//return $request_xml;
  	}

  	public function bookTravelSolution($request)
	{
		$travelSolution = new TravelSolution;		
		$response = $travelSolution->book($request);
		return $response;		
	}

	public function logWsRequest($data, $ws)
	{
		$logWsControl=Yii::app()->createController('logWs');
		$logWsControl=$logWsControl[0];
		return $logWsControl->logCreate($data, $ws);
	}
	public function logWsResponse($id, $data)
	{
		$logWsControl=Yii::app()->createController('logWs');
		$logWsControl=$logWsControl[0];
		return $logWsControl->Update($id, $data);
	}

	
	public function xml_to_json($url)
		{
			$simpleXml = simplexml_load_string($url);

			$json = json_encode($simpleXml);

			return $json;
		}


	public function archivoLog($cadena,$file){
		if($archivo = fopen($file, "a"))
	    {

	        fwrite($archivo,$cadena);
	        
	        fclose($archivo);
	    }
	}

	private function logWs($data)
	{
		$logWsControl=Yii::app()->createController('logWs');
		$logWsControl=$logWsControl[0];
		return $logWsControl->Create($data, 'HotelDo');
	}


}


