<?php
// require_once('../api/tourstores/apiTours.php');
class TransportacionController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
				'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
			),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow', 'actions' => array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users' => array('@'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('view', 'indexV2', 'simularHoras'),
				'users' => array('@'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'SearchDestinations', 'Avail'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actions()
	{
		return array('REST.' => 'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model' => $this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$session = new CHttpSession;
		$session->open();
		$model = new TransportacionReservacion;
		$this->layout = "//layouts/ansonika_site";

		// aeropuerto-hotel viaje redondo
		// aeropuerto-hotel viaje sencillo
		// hotel-aeropuerto viaje sencillo

		// echo "<textarea>".json_encode($_POST)."</textarea>"; exit;


		if (isset($_POST['direccion'])) {
			$datos = array();
			$_POST['city'] = 'CUN';
			$tourstores = $this->getRateTransfers($_POST);
			$_SESSION['DatosTransportacion'] = $_POST;
			// echo "<textarea>".json_encode($tourstores)."</textarea>";

			$cambio_tarifa = 0;
			$cambio_tarifa = $tourstores->publicRate;

			$agencia = Agencias::model()->findByPk($_SESSION['agenciaUsuario']);
			$hotel = Hoteles::model()->findByPk($_POST['id_hotel']);
			$model->id_usuario = Yii::app()->user->id;
			$model->id_hotel = $hotel->id_hotel;
			$model->comision = 0;
			$model->saldo = 0;
			$model->saldo_api = 0;
			$model->total = $_POST['total'];
			$model->tarifa_neta = $_POST['tarifa_neta'];
			if (round($cambio_tarifa, 2) > round($model->total, 2)) {
				$model->total = $cambio_tarifa;
				$model->tarifa_neta = $tourstores->nateRate;
			}
			$model->total_tc = $model->total;
			$model->tarifa_agencia = 0;
			$model->moneda = $_POST['moneda'];
			$model->servicio = $_POST['servicio'] == 'sencillo' ? 0 : 1;
			$model->deluxe = $_POST['deluxe'];
			$model->pasajeros = $_POST['adultos'];
			$model->direccion = $_POST['direccion'] == 'desdeAeropuerto' ? 0 : 1;

			$mostrarFechas = $this->mostrarFechas($model);
			$fecha = "";
			$mostrarFechaLlegada = $mostrarFechas['mostrarFechaLlegada'];
			$mostrarFechaSalida = $mostrarFechas['mostrarFechaSalida'];

			if ($mostrarFechaLlegada == true) {
				$model->fecha_llegada = implode('-', array_reverse(explode('/', $_POST['fecha_llegada'])));
			}
			if ($mostrarFechaSalida == true) {
				$model->fecha_salida = implode('-', array_reverse(explode('/', $_POST['fecha_salida'])));
			}

			if ($model->direccion == 0) {
				$fecha = $model->fecha_llegada;
			} else if ($model->direccion == 1) {
				$fecha = $model->fecha_salida;
			}

			$politicas = $this->politicasCancelacion($fecha);
			$model->fecha_limite = $politicas['fecha_limite'];
			$model->fecha_limite_api = $politicas['fecha_limite_api'];
			$model->politicas_cancelacion = $politicas['politicas_cancelacion'];

			$hora_restringida = false;
			$fechaMas1dia = date('Y-m-d', strtotime(date('Y-m-d') . '+ 1 days'));
			if (strtotime($fecha) == strtotime($fechaMas1dia)) {
				$hora_restringida = true;
			}

			if (isset($_SESSION['DatosTraslados'][0]['nombre_cliente'])) {

				$model->id_agente = $_SESSION['DatosTraslados'][0]['id_agente'];
				$model->id_agencia = $_SESSION['DatosTraslados'][0]['id_agencia'];
				$model->nombre_cliente = $_SESSION['DatosTraslados'][0]['nombre_cliente'];
				$model->apellido_cliente = $_SESSION['DatosTraslados'][0]['apellido_cliente'];
				$model->tel_cliente = $_SESSION['DatosTraslados'][0]['tel_cliente'];
				$model->hora_vuelo_llegada = $_SESSION['DatosTraslados'][0]['hora_vuelo_llegada'];
				$model->hora_pick_up = $_SESSION['DatosTraslados'][0]['hora_pick_up'];
				$model->hora_vuelo_salida = $_SESSION['DatosTraslados'][0]['hora_vuelo_salida'];
				$model->ciudad = $_SESSION['DatosTraslados'][0]['ciudad'];
				$model->id_estado = $_SESSION['DatosTraslados'][0]['id_estado'];
			}

			$descripcion = $this->descripcionServicio($model);
			$_SESSION['pagoInmediatoTraslados'] = date("Y-m-d", strtotime($model->fecha_limite)) == date("Y-m-d") ? 1 : 0;
			$_SESSION['ResultadoBusquedaTrasporte'] = $tourstores;
			// echo "<textarea>".CJSON::encode($mostrarFechas)."</textarea>";
			// echo "<textarea>".CJSON::encode($_POST)."</textarea>";
			// echo "<textarea>".CJSON::encode($model)."</textarea>";
			$this->render('create', array(
				'model_transporte' => $model,
				'datos' => $_POST,
				'hotel' => $hotel,
				'agencia' => $agencia,
				'descripcionServicio' => $descripcion,
				'mostrarFechaLlegada' => $mostrarFechaLlegada,
				'mostrarFechaSalida' => $mostrarFechaSalida,
				'rateKey' => $tourstores->ratekey,
				'hora_restringida' => $hora_restringida,
				'resultadoBusqueda' => $tourstores
				// 'datos' => $datos
			));
		} else {
			if (isset($_GET['ref'])) {
				$log = LogBanco::model()->find('reference="' . $_GET['ref'] . '" AND tipo="TRANSPORTACION"');
				$logs = json_decode($log->reserva);
				$modelo = json_decode(json_encode($logs->TransportacionReservacion->TransportacionReservacion), true);
				$model = new TransportacionReservacion;
				$model->attributes = $modelo;
				$model->fecha_llegada = $modelo['fecha_llegada'];
				$model->fecha_salida = $modelo['fecha_salida'];
				$model->fecha_limite = $logs->pagoInmediato ? date("Y-m-d") : $model->fecha_limite;
				$datos = json_decode(json_encode($logs->Datos), true);
				$hotel = Hoteles::model()->findByPk($model->id_hotel);
				$agencia = Agencias::model()->findByPk($model->id_agencia);
				$descripcion = $this->descripcionServicio($model);

				$mostrarFechas = $this->mostrarFechas($model);
				$fecha = "";
				$mostrarFechaLlegada = $mostrarFechas['mostrarFechaLlegada'];
				$mostrarFechaSalida = $mostrarFechas['mostrarFechaSalida'];
				if ($model->direccion == 0) {
					$fecha = $model->fecha_llegada;
				} else if ($model->direccion == 1) {
					$fecha = $model->fecha_salida;
				}

				$tourstores = $logs->ResultadoBusqueda;
				$hora_restringida = false;
				$fechaMas1dia = date('Y-m-d', strtotime(date('Y-m-d') . '+ 1 days'));
				if (strtotime($fecha) == strtotime($fechaMas1dia)) {
					$hora_restringida = true;
				}

				$this->render('create', array(
					'model_transporte' => $model,
					'datos' => $datos,
					'hotel' => $hotel,
					'agencia' => $agencia,
					'descripcionServicio' => $descripcion,
					'mostrarFechaLlegada' => $mostrarFechaLlegada,
					'mostrarFechaSalida' => $mostrarFechaSalida,
					'rateKey' => $tourstores->ratekey,
					'hora_restringida' => $hora_restringida,
					'resultadoBusqueda' => $tourstores
					// 'datos' => $datos
				));
			}
		}
	}

	public function descripcionServicio($model)
	{
		$descripcion = "";
		$destino = $model->idHotel->nombre_hotel;
		$servicio = $model->servicio == 0 ? 'Sencillo' : 'Redondo';
		$deluxe = $model->deluxe == 0 ? 'Regular' : 'Deluxe';
		if ($model->direccion == 0) {
			$descripcion = "Viaje " . $servicio . " " . $deluxe . " desde el aeropuerto de Cancun hacia " . $destino;
		} else if ($model->direccion == 1) {
			$descripcion = "Transportación desde " . $destino . " hacia el aeropuerto de Cancun con viaje " . $servicio . " " . $deluxe;
		}

		return $descripcion;
	}

	public function mostrarFechas($model)
	{
		$fecha = "";
		$mostrarFechaSalida = false;
		$mostrarFechaLlegada = true;

		if ($model->direccion == 0) {
			$fecha = $model->fecha_llegada;
			if ($model->servicio == 1) {
				$mostrarFechaSalida = true;
			}
		} else if ($model->direccion == 1) {
			$fecha = $model->fecha_salida;
			$mostrarFechaLlegada = false;
			$mostrarFechaSalida = true;
		}

		return array('mostrarFechaLlegada' => $mostrarFechaLlegada, 'mostrarFechaSalida' => $mostrarFechaSalida, 'fecha' => $fecha);
	}

	public function politicasCancelacion($fecha_llegada)
	{

		// Fechas limites
		// Validar con las fechas limite
		$hoy = date("Y-m-d");
		$datetime_fecha_llegada = new DateTime($fecha_llegada);
		$datetime_hoy = new DateTime($hoy);
		$diferencia = $datetime_fecha_llegada->diff($datetime_hoy);
		$resultado_diferencia_dias = $diferencia->format('%a'); ##DIFERENCIA DE DIAS ENTRE LA FECHA ACTUAL Y LA FECHA DE ENTRADA

		if ($resultado_diferencia_dias <= 7) {
			$fecha_limite = date("Y-m-d", strtotime($hoy));
			$politicas_cancelacion = "Pago inmediato. A partir del " . date('d/m/Y', strtotime($fecha_limite)) . " tiene penalización de toda la estancia. ";
			if ($resultado_diferencia_dias <= 2) {
				$fecha_limite_api = date("Y-m-d", strtotime($hoy));
			} else {
				$fecha_limite_api = date("Y-m-d", strtotime($fecha_llegada . ' -2 days'));
			}
		} else if ($resultado_diferencia_dias > 7) {

			$fecha_limite = date("Y-m-d", strtotime($fecha_llegada . ' -7 days'));
			$fecha_limite_api = date("Y-m-d", strtotime($fecha_llegada . ' -2 days'));

			$politicas_cancelacion .= "A partir del " . date('d/m/Y', strtotime($fecha_limite)) . " tiene penalización de toda la estancia. ";
		}

		return array('fecha_limite' => $fecha_limite, 'fecha_limite_api' => $fecha_limite_api, 'politicas_cancelacion' => $politicas_cancelacion);
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['DestinoTourStores'])) {
			$model->attributes = $_POST['DestinoTourStores'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_destino));
		}

		$this->render('update', array(
			'model' => $model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if (Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if (!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		} else
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
	}

	public function actionIndexV2()
	{
		$this->layout = "//layouts/layout_widgets";

		// $politicas = $this->politicasFechas();

	}
	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header("Allow: GET, POST, OPTIONS, PUT, DELETE");
		unset($_SESSION['DatosTraslados']);
		$politicas = $this->politicasFechas();

		$this->renderPartial('index', array('politicas' => $politicas));
	}

	public function politicasFechas()
	{
		$zona_gmt = new DateTime("now", new DateTimeZone('America/Cancun'));
		$datetime_cancun = $zona_gmt->format('d-m-Y H:i:s');
		$hora_cancun = date('H:i:s', strtotime($datetime_cancun));

		$availability = true; // bajo disponibilidad

		$fechaActual = date('d-m-Y H:i:s'); // fecha actual del servidor
		$horaLimiteInicialPermitido = date('10:00:00');
		$horaLimiteFinalPermitido = date('20:00:00'); // hora limite final de servicio hora cancun

		$fecha = date('d/m/Y');
		$hora = $horaLimiteInicialPermitido;

		if ($_SESSION['tipoUsuario'] == 'Agencia') {
			$fecha = date('d/m/Y', strtotime($fechaActual . '+ 1 days'));
		}

		if (strtotime($hora_cancun) > strtotime($horaLimiteFinalPermitido) && (strtotime($datetime_cancun) == strtotime($fechaActual) || strtotime($datetime_cancun) > strtotime($fechaActual)) && $_SESSION['tipoUsuario'] == 'Agencia') {
			// ¿la hora de cancun es mayor a la hora permitida?
			$availability = false;
			$fecha = date('d/m/Y', strtotime($fechaActual . '+ 2 days'));
		}

		return array('fecha' => $fecha, 'hora' => $hora, 'disponibilidad' => $availability);
	}

	public function actionSimularHoras()
	{

		$zona_gmt = new DateTime("now", new DateTimeZone('America/Cancun'));
		$dia_cancun = $zona_gmt->format('Y-m-d H:i:s');
		$hora_cancun = date('H:i:s', strtotime($dia_cancun));

		$availability = true; // bajo disponibilidad
		$bajo_disponibilidad = false;

		$fechaActual = date('d-m-Y'); // fecha actual del servidor
		$horaActual = date('H:i:s'); // hora actual del servidor

		$fechaBusqueda = date('27-12-2020'); // fecha de llegada/salida solicitida
		$horaLimiteInicial = date('10:00:00'); // hora limite inicial de servicio
		$horaLimiteFinal = date('20:00:00'); // hora limite final de servicio

		$datetime_fecha_llegada = new DateTime($fechaBusqueda);
		$datetime_hoy = new DateTime($fechaActual);
		$diferencia = $datetime_fecha_llegada->diff($datetime_hoy);
		$resultado_diferencia_dias = $diferencia->format('%a'); ##DIFERENCIA DE DIAS ENTRE LA FECHA ACTUAL Y LA FECHA DE ENTRADA

		$error = array();

		// si la solicitud se hace para viajes del dia siguiente antes de las 8 pm el horario por default sera de 10:00am - 8:00 pm eso no cambia
		// si la solicitud se hace para viajes del dia siguiente despues de las 8 pm, debe hacerse via telefonica o no permitir fechas de mañana (la fecha inicia 2 dias despues), eso se deja en duda
		// si la solicitud se hace para viajes posteriores al dia siguiente despues de las 7 pm, es via telefonica con proveedor y con departamento de reservas para revisar disponibilidad
		// mismo dia los servicios es entre las 10:00 am y 8:00 pm

		// el mismo dia
		if ($resultado_diferencia_dias == 0) {
			// bajo disponibilidad
			$availability = false;
			$bajo_disponibilidad = true;

			// 4hrs de anticipacion, toma hora actual se le suma 5hrs
			$horaMasHrsSumadas = date('H:i:s', strtotime($horaActual . '+3 hour'));

			$error[0] = 'Bajo disponibilidad.';
			$error[1] = 'Hora de servicio disponible el mismo dia con 5hrs de anticipación para servicios entre las 10:00 am y las 08:00 pm';
			// mismo dia solicitando despues de las 10am y antes de las 8pm pero las hrs permitidas es menor a 5hrs
			if (strtotime($horaMasHrsSumadas) >= strtotime($horaLimiteInicial) && strtotime($horaMasHrsSumadas) <= strtotime($horaLimiteFinal)) {
				$fecha = $fechaActual;
				$hora_inicial = $horaMasHrsSumadas;
				$hora_final = $horaLimiteFinal;
				// hora inicial sera la hora + 5hrs y hora final sera las 8pm
			} else if (strtotime($horaMasHrsSumadas) < strtotime($horaLimiteInicial)) {
				// mismo dia solicitando antes de las 10am
				$fecha = $fechaActual;
				$hora_inicial = $horaLimiteInicial;
				$hora_final = $horaLimiteFinal;
			} else if (strtotime($horaMasHrsSumadas) > strtotime($horaLimiteFinal)) {
				// mismo dia solicitando despues de las 8pm
				$fecha = date('d/m/Y', strtotime($fechaActual . '+ 1 days'));
				$hora_inicial = $horaLimiteInicial;
				$hora_final = $horaLimiteFinal;
			}
		}

		// dia siguiente
		if ($resultado_diferencia_dias == 1) {

			// si escoge el dia siguiente antes de las 8:00pm -> abrir opciones de hora con el horario permitido 10:00 am - 8:00 pm
			$hora_inicial = $horaLimiteInicial;
			$hora_final = $horaLimiteFinal;
			$fecha = $fechaBusqueda;

			// antes de las 8
			if (strtotime($horaActual) <= strtotime($horaLimiteFinal)) {
				$error[0] = "Las horas disponibles para el dia de mañana son de 10:00 am - 8:00 pm";
				$fecha = date('d/m/Y', strtotime($fechaActual . '+ 1 days'));
			}

			// despues de las 8
			if (strtotime($horaActual) > strtotime($horaLimiteFinal)) {
				$availability = false;
				$error[0] = "No hay disponibilidad para servicios del dia de mañana";
				$fecha = date('d/m/Y', strtotime($fechaActual . '+ 2 days'));
				$hora_inicial = "";
				$hora_final = "";
			}
		}

		// dias siguientes
		if ($resultado_diferencia_dias > 1) {
			$hora_final = "";
			$hora_final = "";
			$fecha = $fechaBusqueda;

			// despues de las 8
			if (strtotime($horaActual) > strtotime($horaLimiteFinal)) {
				$error[0] = "Sujeto a disponibilidad. Nuestros ejecutivos se pondran en contacto con usted para confirmar su reserva.";
			}
		}

		echo '<br>';
		echo 'Hora Cancun: ' . $hora_cancun;
		echo '<br>Fecha Solicitud: ' . $fechaActual;
		echo '<br>Fecha Viaje: ' . $fechaBusqueda;
		echo '<br>Diferencia de dias: ' . $resultado_diferencia_dias;
		echo '<br>Fecha permitido: ' . $fecha;
		echo '<br>Hora Inicial: ' . $hora_inicial;
		echo '<br>Hora Final: ' . $hora_final;
		echo '<br>';
		echo '<br>';
		echo "<textarea cols='50' rows='10'>" . json_encode($error) . "</textarea>";
	}

	public function actionSearchDestinations()
	{

		$arSearch = explode(" ", $_POST["search"]);
		$buscarNombreHotel = "";
		foreach ($arSearch as $search) {
			$buscarNombreHotel .= 'and H.nombre_hotel like "%' . $search . '%" ';
		}
		$pais = '';
		$condition = " AND Z.destinationsCode IN ('CUN','PCM') ";
		$sql = "SELECT H.id_hotel as 'Codigo', CONCAT(H.nombre_hotel,  ', ', D.name) AS 'Nombre', 'Hotel' AS 'Tipo',  Z.destinationsCode as 'City', Z.idZona as 'Zona', Ts.id_tour_store as 'codeStore'
		FROM tbl_hoteles H 
		INNER JOIN zonasbeds Z ON Z.idZona = H.id_destino 
		INNER JOIN destinations D ON D.code = Z.destinationsCode 
		INNER JOIN tbl_destino_tour_stores Ts ON H.id_hotel = Ts.id_hotel 
		WHERE H.estatus = 1 AND H.busqueda = 1 " . $buscarNombreHotel . "" . $pais . $condition . " LIMIT 20";

		$model_destinos = Yii::app()->db->createCommand($sql)->queryAll();

		echo json_encode($model_destinos);
	}

	public function actionAvail()
	{
		if ($_POST) {

			// echo "<textarea>".json_encode($_POST)."</textarea>";
			if (!empty($_POST['code'])) {

				$post = $_POST;
				$post['servicio'] = $_POST['tipo_servicio'];
				$disponibilidad = $this->availTourStore($post);

				echo json_encode($disponibilidad);
			}
		}
	}

	public function availTourStore($data)
	{

		$avail = new apiTours;
		$request = 'cur=' . $data['moneda'] . '&idl=' . $data['code'];
		$response = $avail->getPickupTransfers($request);

		$transporte = json_decode($response);
		$transporte = $transporte[0];
		$disponible = array();
		$error = false;
		$mensaje = '';
		if (!empty($transporte)) {
			// echo $transporte->idl;
			$data['moneda'] = $transporte->currency;
			$precios_netos = $transporte->net_rates_airport;
			$precios_publicos = $transporte->public_rates_airport;
			$adultos = $data['adultos'];

			// $logTourStore['header'] = "avail";
			// $logTourStore['request'] = $request;
			// $logTourStore['response'] = $response;
			// $logTourStore['reference'] = $data['code'];
			// $this->guardarLogTourStore($logTourStore,'TourStores');

			if ($data['direccion'] == 'desdeAeropuerto') {
				if ($data['servicio'] == 'sencillo') {
					// viaje sencillo
					switch ($data['deluxe']) {
						case 0:
							// sencillo - servicio regular
							if ($adultos > 7) {
								$precio_neto = $precios_netos->sprinter_van_single;
								$precio_publico = $precios_publicos->sprinter_van_single;
							} else {
								$precio_neto = $precios_netos->regular_van_single;
								$precio_publico = $precios_publicos->regular_van_single;
							}
							break;
						case 1:
							// sencillo - servicio deluxe
							$precio_neto = $precios_netos->deluxe_van_single;
							$precio_publico = $precios_publicos->deluxe_van_single;
							$adultos = $adultos > 5 ? 5 : $adultos;
							break;
					}
				} else if ($data['servicio'] == 'redondo') {
					// Viaje redondo
					switch ($data['deluxe']) {
						case 0:
							// reondo - servicio regular
							if ($adultos > 7) {
								$precio_neto = $precios_netos->sprinter_van_round;
								$precio_publico = $precios_publicos->sprinter_van_round;
							} else {
								$precio_neto = $precios_netos->regular_van_round;
								$precio_publico = $precios_publicos->regular_van_round;
							}
							break;
						case 1:
							// reondo - servicio deluxe
							$precio_neto = $precios_netos->deluxe_van_round;
							$precio_publico = $precios_publicos->deluxe_van_round;
							$adultos = $adultos > 5 ? 5 : $adultos;
							break;
					}
				}
			} else if ($data['direccion'] == 'alAeropuerto') {
				switch ($data['deluxe']) {
					case 0:
						// sencillo - regular
						if ($adultos > 7) {
							$precio_neto = $precios_netos->sprinter_van_single;
							$precio_publico = $precios_publicos->sprinter_van_single;
						} else {
							$precio_neto = $precios_netos->regular_van_single;
							$precio_publico = $precios_publicos->regular_van_single;
						}
						break;
					case 1:
						// sencillo - redondo
						$precio_neto = $precios_netos->deluxe_van_single;
						$precio_publico = $precios_publicos->deluxe_van_single;
						$adultos = $adultos > 5 ? 5 : $adultos;
						break;
				}
			}

			$disponible['precio'] = $precio_neto;
			$disponible['publica'] = $precio_publico;
			$disponible['adultos'] = $adultos;
		} else {
			$error = true;
			$mensaje = 'Ocurrió un problema con la conexión de servidor.';
		}
		// echo "<textarea>".json_encode($data)."</textarea>";
		return array('avail' => $disponible, 'error' => $error, 'mensaje' => $mensaje);
	}

	public function getRateTransfers($data)
	{
		$avail = new apiTours;
		$request['des'] = $data['city'];
		$request['idl'] = $data['code'];
		$request['pax'] = $data['adultos'];

		$request['cur'] = $data['moneda'];

		$rt = "";
		if ($data['direccion'] == 'desdeAeropuerto' && $data['servicio'] == 'sencillo') {
			$request['date1'] = implode('-', array_reverse(explode('/', $data['fecha_llegada'])));
			$rt = "AHS";
		} else if ($data['direccion'] == 'desdeAeropuerto' && $data['servicio'] == 'redondo') {
			$request['date1'] = implode('-', array_reverse(explode('/', $data['fecha_llegada'])));
			$request['date2'] = implode('-', array_reverse(explode('/', $data['fecha_salida'])));
			$rt = "AHR";
		}

		// echo "<textarea>".json_encode($data)."</textarea>";

		if ($data['direccion'] == 'alAeropuerto' && $data['servicio'] == 'sencillo') {
			// echo 'string';
			$request['date1'] = implode('-', array_reverse(explode('/', $data['fecha_salida'])));
			$rt = 'HAS';
		}

		$request['rt'] = $rt;

		$cat = $data['deluxe'] == 0 ? 'REG' : 'DLX';
		$request['cat'] = $cat;

		$req = 'des=' . $request['des'] . '&idl=' . $request['idl'] . '&pax=' . $request['pax'] . '&rt=' . $request['rt'] . '&cat=' . $request['cat'] . '&date1=' . $request['date1'];
		// if ($request['date2']) {
		$req .= '&date2=' . $request['date2'];
		// }
		$req .= '&cur=' . $request['cur'] . '&lan=ESP';

		// echo '<br>';
		// echo '<br>';
		// echo '<br>';
		// echo '<br>';
		// echo '<br>';
		// echo $req;
		$response = $avail->getRateTransfers($req);

		$logTourStore = array();
		$logTourStore['header'] = "avail";
		$logTourStore['request'] = $req;
		$idLogWs = $this->logWsRequest($logTourStore, 'TourStores');

		$response_json = json_decode($response);
		$response = json_decode($response_json);

		$logTourStore['response'] = json_encode($response);
		$logTourStore['reference'] = $request['idl'];
		$this->logWsResponse($idLogWs, $logTourStore);

		return $response;
	}
	public function logWsRequest($data, $ws)
	{
		$logWsControl = Yii::app()->createController('logWs');
		$logWsControl = $logWsControl[0];
		return $logWsControl->logCreate($data, $ws);
	}
	public function logWsResponse($id, $data)
	{
		$logWsControl = Yii::app()->createController('logWs');
		$logWsControl = $logWsControl[0];
		return $logWsControl->Update($id, $data);
	}
	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new DestinoTourStores('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['DestinoTourStores']))
			$model->attributes = $_GET['DestinoTourStores'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = DestinoTourStores::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'destino-tour-stores-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['DestinoTourStores_records'])) {
			$model = $session['DestinoTourStores_records'];
		} else
			$model = DestinoTourStores::model()->findAll();


		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}
	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['DestinoTourStores_records'])) {
			$model = $session['DestinoTourStores_records'];
		} else
			$model = DestinoTourStores::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('DestinoTourStores Report');
		$pdf->SetSubject('DestinoTourStores Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("DestinoTourStores_002.pdf", "I");
	}
}
