<?php
Yii::import('application.extensions.phpmailer.JPhpMailer');
require_once dirname(__FILE__) . '/../vendors/openpay/Openpay.php';
require_once dirname(__FILE__) . '/../vendors/stripe/vendor/autoload.php';

use Openpay\Data\Openpay;
use Openpay\Resources\OpenpayErrors;

class TourReservacionController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/ansonika_site';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
				'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
			),
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{

		$rules = AuthFuncion::model()->findAll('controlador="' . Yii::app()->controller->id . '"');
		$array = array();
		foreach ($rules as $row) {
			$rule = array(
				'allow',
				'actions' => array($row->funcion),
				'roles' => array($row->operacion),
			);
			array_push($array, $rule);
		}
		array_push(
			$array,
			array(
				'allow', 'actions' => array('create', 'view', 'paynet', 'reciboPayNet', 'correoPrueba'),
				'users' => array('*'),
			),
			array(
				'allow', 'actions' => array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users' => array('@'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'detallesReserva', 'agregarinformacion', 'update', 'GeneratePdf', 'GenerateExcel', 'liberar', 'Pagoscupon', 'reinstalarReservacion', 'updateFechaTour'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			)
		);
		return $array;
	}

	public function actions()
	{
		return array('REST.' => 'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}
	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		// $this->layout = "//layouts/ansonika";
		$model = $this->loadModel($id);
		$datos_cliente = new CDbCriteria;
		$datos_cliente->addCondition("id_reservacion='" . $id . "'");
		$datos_cliente->addCondition("tipo_servicio='5'");
		// $datos_cliente = BannerAgencia::model()->findAll($c_banners);
		$datos_cliente = DatosClientes::model()->find($datos_cliente);
		$reservacionController = Yii::app()->createController('reservacion');
		$reservacionController = $reservacionController[0];
		$agencia = $reservacionController->loadModelAgencia($model->id_agencia);
		$direccion = $reservacionController->direccionAgencia($agencia);
		$dias = $this->dias($model->fecha_inicio, $model->fecha_fin);
		$modelRecibo = new Recibo;
		$modelRecibo->id_agencia = $model->id_agencia;
		$modelComision = new Reservacion;
		$this->render('view', array(
			'model' => $model,
			'agencia' => $agencia,
			'direccion' => $direccion,
			'dias' => $dias,
			'datos_cliente' => $datos_cliente,
			'modelRecibo' => $modelRecibo,
			'modelComision' => $modelComision,
		));
	}
	public function actionDetallesReserva($id)
	{
		$model = $this->loadModel($id);
		$this->render('detallesReserva', array(
			'model' => $model
		));
	}
	private function dias($fecha_inicio, $fecha_final)
	{
		$datetime1 = new DateTime($fecha_inicio);
		$datetime2 = new DateTime($fecha_final);
		$interval = $datetime1->diff($datetime2);
		$dias = $interval->format('%a');
		return $dias;
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreateBackup()
	{
		$model = new TourReservacion;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		$outlet = Outlet::model()->find('estatus=1');
		$_SESSION['tour_form']['importe'] = $_POST["importe"];
		$_SESSION['tour_form']['id_tarifa'] = $_POST["id_tarifa"];
		if (isset($_POST['TourReservacion'])) {
			$model->attributes = $_POST['TourReservacion'];
			$model->fecha_reserva = date("Y-m-d");
			$model->id_usuario = Yii::app()->user->id;
			$model->fecha_inicio = implode("-", array_reverse(explode("/", $_SESSION['searchAct']['from'])));
			$model->fecha_fin = implode("-", array_reverse(explode("/", $_SESSION['searchAct']['to'])));
			$comision = Agencias::model()->findByPk($model->id_agencia);
			$fechaLimite_dias = 10;
			if ($this->eventoOutlet($outlet)) {
				$model->fecha_limite = date('Y-m-d');
				$model->comision = $outlet->comision_agencia;
			} else {

				$model->comision = $comision->porcentaje_comision;
				$dates_1 = $model->fecha_reserva;
				$dates_2 = $model->fecha_inicio;
				$interval = $this->dias($dates_1, $dates_2);
				if ($interval <= 2) {
					$model->fecha_limite = $model->fecha_reserva;
				} else if ($interval > 2 && $interval <= 6) {
					$model->fecha_limite = date('Y-m-d', strtotime('+1 day', strtotime($model->fecha_reserva)));
				} else if ($interval > 6 && $interval <= 10) {
					$model->fecha_limite = date('Y-m-d', strtotime('+3 day', strtotime($model->fecha_reserva)));
				} else if ($interval > 10 && $interval <= 15) {
					$model->fecha_limite = date('Y-m-d', strtotime('+7 day', strtotime($model->fecha_reserva)));
				} else if ($interval > 15 && $interval <= 30) {
					$model->fecha_limite = date('Y-m-d', strtotime('+15 day', strtotime($model->fecha_reserva)));
				} else if ($interval > 30) {
					$model->fecha_limite = date('Y-m-d', strtotime($model->fecha_inicio . ' - ' . ($fechaLimite_dias) . ' days'));
				}
			}
			if ($model->comision != 0)
				$model->saldo = $model->importe * ($model->comision / 100);
			else
				$model->saldo = $model->importe;

			$comision_proveedor = TourTarifa::model()->findByPk($model->id_tarifa);
			$comisionProveedor = (100 - $comision_proveedor->comision_proveedor);

			$model->saldo_h = ($model->importe * $comisionProveedor) / 100;

			if (!empty($_SESSION['promocion']))
				$model->descuento = $_SESSION['promocion'];


			if ($model->save()) {
				$id_reservacion = $model->id_tourReservacion;
				$this->guardarReservacionDesglosePersona($id_reservacion);
				$this->enviaEmail($model);
				$this->redirect(array('view', 'id' => $model->id_tourReservacion));
			} else {
				print_r($model->getErrors());
			}
		}
		$this->render('create', array(
			'model' => $model,
		));
	}

	public function actionCreate()
	{
		//header('Content-Type: application/json;');
		/* $aux = json_decode($_POST["tour"], true);
		print_r($aux);
		exit; */
		$model = new TourReservacion;
		$outlet = Outlet::model()->find('estatus=1');
		$_SESSION['tour_form']['importe'] = $_POST["importe"];
		$_SESSION['tour_form']['id_tarifa'] = $_POST["id_tarifa"];
		if (isset($_POST['TourReservacion'])) {
			$contacto_cliente = $_POST['contactoCliente'];

			$model->attributes = $_POST['TourReservacion'];
			$model->fecha_reserva = date("Y-m-d");
			$model->id_usuario = $_POST['TourReservacion']['id_usuario'];
			$model->fecha_inicio = implode("-", array_reverse(explode("/", $model->fecha_inicio)));
			$comision = Agencias::model()->findByPk($model->id_agencia);
			$fechaLimite_dias = 10;
			if ($this->eventoOutlet($outlet)) {
				$model->fecha_limite = date('Y-m-d');
				$model->comision = $outlet->comision_agencia;
			} else {
				$model->comision = $comision->porcentaje_comision;
				$dates_1 = $model->fecha_reserva;
				$dates_2 = $model->fecha_inicio;
				$interval = $this->dias($dates_1, $dates_2);
				if ($interval <= 2) {
					$model->fecha_limite = $model->fecha_reserva;
				} else if ($interval > 2 && $interval <= 6) {
					$model->fecha_limite = date('Y-m-d', strtotime('+1 day', strtotime($model->fecha_reserva)));
				} else if ($interval > 6 && $interval <= 10) {
					$model->fecha_limite = date('Y-m-d', strtotime('+3 day', strtotime($model->fecha_reserva)));
				} else if ($interval > 10 && $interval <= 15) {
					$model->fecha_limite = date('Y-m-d', strtotime('+7 day', strtotime($model->fecha_reserva)));
				} else if ($interval > 15 && $interval <= 30) {
					$model->fecha_limite = date('Y-m-d', strtotime('+15 day', strtotime($model->fecha_reserva)));
				} else if ($interval > 30) {
					$model->fecha_limite = date('Y-m-d', strtotime($model->fecha_inicio . ' - ' . ($fechaLimite_dias) . ' days'));
				}
			}
			if ($model->comision != 0)
				$model->saldo = $model->importe * ($model->comision / 100);
			else
				$model->saldo = $model->importe;

			$comision_proveedor = TourTarifa::model()->findByPk($model->id_tarifa);
			$comisionProveedor = (100 - $comision_proveedor->comision_proveedor);

			$model->saldo_h = ($model->importe * $comisionProveedor) / 100;

			if (!empty($_SESSION['promocion']))
				$model->descuento = $_SESSION['promocion'];

			if ($model->save()) {
				$this->guardarReservacionDesglosePersona($model);
				$this->guardarDatosPersonas($model, $contacto_cliente);
				$this->enviaEmail($model, $contacto_cliente['correo_cliente']);
				$this->redirect(array('view', 'id' => $model->id_tourReservacion));
			} else {
				print_r($model->getErrors());
			}
		}
		$this->layout = "//layouts/ansonika_site";
		$this->render('create', array(
			'model' => $model,
		));
	}
	private function guardarReservacionDesglosePersona($model)
	{
		$num_menores = intval($model->menores);
		$num_adultos = intval($model->adultos);
		for ($i = 1; $i <= $num_menores; $i++) {
			$reservacionDesglosePersona = new TourReservacionDesglosePersona;
			$reservacionDesglosePersona->id_reservacion = $model->id_tourReservacion;
			$reservacionDesglosePersona->nombre = $_POST["Ninio"][$i]["nombre"];
			$reservacionDesglosePersona->apellido = $_POST["Ninio"][$i]["apellido"];
			$reservacionDesglosePersona->tipo = 'N';
			$reservacionDesglosePersona->edad = $_POST["Ninio"][$i]["edad"];
			if (!$reservacionDesglosePersona->save()) {
				echo CJSON::encode($reservacionDesglosePersona->getErrors());
			}
		}
		for ($i = 1; $i <= $num_adultos; $i++) {
			$reservacionDesglosePersona = new TourReservacionDesglosePersona;
			$reservacionDesglosePersona->id_reservacion = $model->id_tourReservacion;
			$reservacionDesglosePersona->nombre = $_POST['Adulto'][$i]['nombre'];
			$reservacionDesglosePersona->apellido = $_POST['Adulto'][$i]['apellido'];
			$reservacionDesglosePersona->tipo = 'A';
			$reservacionDesglosePersona->edad = 30;
			if (!$reservacionDesglosePersona->save()) {
				echo CJSON::encode($reservacionDesglosePersona->getErrors());
			}
		}
	}

	public function guardarDatosPersonas($tour_reservacion, $contacto_cliente)
	{
		$datos_clientes = new DatosClientes;
		$datos_clientes->id_reservacion = $tour_reservacion->id_tourReservacion;
		$datos_clientes->id_agencia = $tour_reservacion->id_agencia;
		$datos_clientes->telefono = $contacto_cliente['telefono_cliente'];
		$datos_clientes->email = $contacto_cliente['correo_cliente'];
		$datos_clientes->tipo_servicio = 5;
		if (!$datos_clientes->save()) {
			echo CJSON::encode($datos_clientes->getErrors());
		}
	}

	private function guardarReservacionDesglosePersonaBackup($id_reservacion)
	{
		for ($i = 1; $i <= $_SESSION['searchAct']['num_ninios']; $i++) {
			$reservacionDesglosePersona = new TourReservacionDesglosePersona;
			$reservacionDesglosePersona->id_reservacion = $id_reservacion;
			$reservacionDesglosePersona->nombre = $_POST['Ninio_' . $i]['nombre'];
			$reservacionDesglosePersona->apellido = $_POST['Ninio_' . $i]['apellido'];
			$reservacionDesglosePersona->tipo = 'N';
			$reservacionDesglosePersona->edad = $_SESSION['searchAct']['num_edad']['edad_' . $i];
			$reservacionDesglosePersona->save();
		}
		for ($i = 1; $i <= $_SESSION['searchAct']['num_adultos']; $i++) {
			$reservacionDesglosePersona = new TourReservacionDesglosePersona;
			$reservacionDesglosePersona->id_reservacion = $id_reservacion;
			$reservacionDesglosePersona->nombre = $_POST['Adulto_' . $i]['nombre'];
			$reservacionDesglosePersona->apellido = $_POST['Adulto_' . $i]['apellido'];
			$reservacionDesglosePersona->tipo = 'A';
			$reservacionDesglosePersona->edad = 30;
			$reservacionDesglosePersona->save();
		}
	}
	public function personas_tours($id_reservacion)
	{
		$sql = "SELECT * 
		FROM tbl_tour_reservacion_desglose_persona  
		WHERE id_reservacion='" . $id_reservacion . "'";
		$row = Yii::app()->db->createCommand($sql)->queryAll();
		foreach ($row as $data) {
			$arreglo[] = $data;
		}
		return $arreglo;
	}
	public function actionAgregarinformacion()
	{
		$model = $this->loadModel($_POST['idCupon']);
		if (isset($_POST['observacion'])) {
			$model->observaciones = $_POST['observacion'];
			$return = $model->observaciones;
		}
		$model->save();
		echo $return;
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		if (isset($_POST['TourReservacion'])) {
			$model->attributes = $_POST['TourReservacion'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_tourReservacion));
		}
		$this->render('update', array(
			'model' => $model,
		));
	}
	public function actionPagoscupon()
	{
		$model = TourReservacion::model()->findByPk($_POST["idCupon"]);
		$pagos = ReciboDetalles::model()->findAll('tipo="Tour" and id_reservacion=' . $_POST["idCupon"]);
		$this->renderPartial('pagoscupon', array('model' => $model, 'pagos' => $pagos));
	}
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if (Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();
			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if (!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		} else
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
	}
	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$session = new CHttpSession;
		$session->open();
		$criteria = new CDbCriteria();
		$model = new TourReservacion('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['TourReservacion'])) {
			$model->attributes = $_GET['TourReservacion'];
			if (!empty($model->id_tourReservacion)) $criteria->addCondition("id_tourReservacion = '" . $model->id_tourReservacion . "'");
			if (!empty($model->id_tour)) $criteria->addCondition("id_tour = '" . $model->id_tour . "'");
			if (!empty($model->fecha_inicio)) $criteria->addCondition("fecha_inicio = '" . $model->fecha_inicio . "'");
			if (!empty($model->fecha_fin)) $criteria->addCondition("fecha_fin = '" . $model->fecha_fin . "'");
			if (!empty($model->importe)) $criteria->addCondition("importe = '" . $model->importe . "'");
			if (!empty($model->estatus)) $criteria->addCondition("estatus = '" . $model->estatus . "'");
			if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '" . $model->id_agencia . "'");
			if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '" . $model->id_usuario . "'");
			if (!empty($model->fecha_reserva)) $criteria->addCondition("fecha_reserva = '" . $model->fecha_reserva . "'");
			if (!empty($model->log)) $criteria->addCondition("log = '" . $model->log . "'");
			if (!empty($model->comision)) $criteria->addCondition("comision = '" . $model->comision . "'");
			if (!empty($model->fecha_limite)) $criteria->addCondition("fecha_limite = '" . $model->fecha_limite . "'");
			if (!empty($model->libera_cupon)) $criteria->addCondition("libera_cupon = '" . $model->libera_cupon . "'");
			if (!empty($model->cliente_nombre)) $criteria->addCondition("cliente_nombre = '" . $model->cliente_nombre . "'");
			if (!empty($model->cliente_tel)) $criteria->addCondition("cliente_tel = '" . $model->cliente_tel . "'");
			if (!empty($model->adultos)) $criteria->addCondition("adultos = '" . $model->adultos . "'");
			if (!empty($model->menores)) $criteria->addCondition("menores = '" . $model->menores . "'");
			if (!empty($model->id_tarifa)) $criteria->addCondition("id_tarifa = '" . $model->id_tarifa . "'");
			if (!empty($model->cancelacion_fecha)) $criteria->addCondition("cancelacion_fecha = '" . $model->cancelacion_fecha . "'");
			if (!empty($model->cancelacion_motivo)) $criteria->addCondition("cancelacion_motivo = '" . $model->cancelacion_motivo . "'");
			if (!empty($model->observaciones)) $criteria->addCondition("observaciones = '" . $model->observaciones . "'");
			$session['TourReservacion_records'] = TourReservacion::model()->findAll($criteria);
		}
		$this->render('index', array(
			'model' => $model,
		));
	}
	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new TourReservacion('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['TourReservacion']))
			$model->attributes = $_GET['TourReservacion'];
		$this->render('admin', array(
			'model' => $model,
		));
	}
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = TourReservacion::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}
	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'tour-reservacion-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();
		if (isset($session['TourReservacion_records'])) {
			$model = $session['TourReservacion_records'];
		} else
			$model = TourReservacion::model()->findAll();
		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}
	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');
		if (isset($session['TourReservacion_records'])) {
			$model = $session['TourReservacion_records'];
		} else
			$model = TourReservacion::model()->findAll();
		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);
		//die($html);
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('TourReservacion Report');
		$pdf->SetSubject('TourReservacion Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("TourReservacion_002.pdf", "I");
	}
	public function actionLiberar($id)
	{
		$model = $this->loadModel($id);
		$model->libera_cupon = 1;
		$model->fecha_liberacion = date('Y-m-d');
		$model->usuario_liberacion = Yii::app()->user->id;
		$model->code = $_POST['TourReservacion']['code'];
		if ($model->save()) {
			$operacion = Yii::app()->createController('operacionesLog');
			$operacion = $operacion[0];
			$operacion->Create($model->id_tourReservacion, 20);
			$this->redirect(array('view', 'id' => $model->id_tourReservacion));
		} else {
			print_r($model->getErrors());
		}
	}


	public function actionCorreoPrueba()
	{
		$email = "programador@2businesstravel.com";
		$model = TourReservacion::model()->findByPk(1120);
		$this->enviaEmail($model, $email);
	}

	private function enviaEmail($model, $email)
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://2businesstravel.com/panel/agencia/getDatosAgencia2business/?referencia=U".$model->id_usuario."A".$model->id_agencia,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'Cookie: PHPSESSID=f0f713606a09d30811ee686517baf2d1'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$agencia = json_decode($response);

		$subject = "Felicidades, su reservación ha sido creada con éxito";
		$message = "<div align='center' style='font-family:helvetica'>
						<img height='100' src='https://www.2businesstravel.com/images/agencia_$agencia->id/$agencia->logo_agencia' border='1'>
						<div style='background:#2196f3;color:#fff;padding:24px;font-size:24px;font-weight:bold'>
							Estimado " . $model->cliente_nombre . " " . $model->cliente_apellido . "<br>
							su reservación ha sido creada con éxito.
						</div>
						<h4>Los datos de su reservación son:</h4>
						<p>No. de Cupón: <strong>" . $model->id_tourReservacion . "</strong><br>
						Agencia: <strong>" . $model->idAgencia->nombre_agencia . "</strong><br>
						Tour: <strong>" . $model->idTour->nombre . "</strong><br>
						Fecha de Visita: <strong>" . date('d/m/Y', strtotime($model->fecha_inicio)) . "</strong><br>
						Categoria: <strong>" . $model->idTour->idTipoCategoria0->nombre . "</strong><br>
						<p>Para ver más detalles del cupón haga clic en el link: <a href='https://" . $_SERVER['SERVER_NAME'] . "" . Yii::app()->baseUrl . "/tourReservacion/view/id/" . $model->id_tourReservacion . "'>Ver Cupón</a></p>
						" . ($model->libera_cupon == 0 && !empty($model->fecha_limite) ? "<p>Su Fecha Límite de pago es: <strong>" . date('d/m/Y', strtotime($model->fecha_limite)) . "</strong><br>Para descargar su orden de pago de clic en el siguiente link. Agradecemos su pronto pago.<br>
						<a href='https://" . $_SERVER['SERVER_NAME'] . "/reservaciones/yii_rutamaya/index.php/site/proforma/" . $model->id_tourReservacion . "'>Descargar Orden de Pago</a></p>" : "") . "
						<hr>
						<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
						<h4>Tels: (999) 925-54-43</h4>
						<h4>Atentamente el equipo de Ruta Maya Travel</h4>
					</div>";
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com';
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com';
		$mail->Port = '26';
		$mail->Password = 'Intelred76';
		$mail->SMTPKeepAlive = true;
		$mail->Mailer = "smtp";
		$mail->IsSMTP();
		$mail->SMTPAuth = true;
		$mail->CharSet = 'utf-8';
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel');
		$mail->Subject = $subject;
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!';
		$mail->MsgHTML($message);
		// $mail->AddAddress($model->idUsuario->email_usuario, $model->idUsuario->nombre_usuario);
		// $mail->AddAddress('programador@2businesstravel.com');
		$mail->AddAddress($model->idAgencia->email_agencia, $model->idAgencia->nombre_agencia);
		$mail->AddAddress($model->idAgente->email_usuario, $model->idAgente->nombre_usuario);
		if($mail->Send()){
			$this->emailCliente($model, $email, $agencia);
		}
		//envio de correo al hotel
		//si es modificacion no se envia el correo al hotel
	}

	public function emailCliente($model, $email, $agencia)
	{


		$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  " . $agencia->nom_agencia . " <" . $agencia->emailPrincipal . ">\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		$subject = "Felicidades, su reservación ha sido creada con éxito";
		//$cancelaciones = $this->cancelaciones($model,$model->fecha_inicial,$model->id_tarifa);

		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com';
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com';
		$mail->Port = '26';
		$mail->Password = 'Intelred76';
		$mail->SMTPKeepAlive = true;
		$mail->Mailer = "smtp";
		$mail->IsSMTP();
		$mail->SMTPAuth = true;
		$mail->CharSet = 'utf-8';
		$mail->SMTPDebug  = 0;
		$mail->SetFrom($agencia->emailPrincipal, $agencia->nom_agencia);
		$mail->Subject = $subject;
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!';
		$mail->IsHTML(true);
		//$mail->Body($this->renderPartial('email',true));
		$mail->MsgHTML($this->renderPartial('email', array('model' => $model, 'email' => $email, 'agencia' => $agencia), true));
		$mail->AddAddress($email);
		// $mail->AddAddress($model->idUser->email_usuario, $model->idUser->nombre_usuario);
		// $mail->AddBcc($agencia->emailPrincipal, $agencia->nom_agencia);
		// $mail->AddBcc('programador2@rutamayatravel.com', 'programador2');
		// $mail->AddBcc('soporte@rutamayatravel.com', 'Soporte');
		//$mail->AddAddress($model->idAgente->email_usuario, $model->idAgente->nombre_usuario);
		// $mail->AddBcc('reservaciones@rutamayatravel.com');
		if ($mail->Send()) {
			echo "enviado";
		} else {
			echo 'Message could not be sent.';
			echo 'Mailer Error: <textarea>' . $mail->ErrorInfo . "";
		}
	}

	public function actionCancelar($id)
	{
		$model = $this->loadModel($id);
		$usuarioCancela = $this->verificaClave($_POST['clave_confirmacion']);
		if ($usuarioCancela) {
			$penalizar = isset($_POST['penalizar']) ? TRUE : FALSE;
			$penalizacion = isset($_POST['penalizacion']) ? $_POST['penalizacion'] : 0;
			$recibos = ReciboDetalles::model()->with('idRecibo')->findAll('id_reservacion=' . $model->id_tourReservacion . ' and estado!="C" and tipo="Tour"');
			$importe = 0;
			$cancelados = "";
			foreach ($recibos as $row) {
				if ($penalizar == TRUE && $row->importe == $penalizacion) {
					$penalizado = TRUE;
					continue;
				}
				$importe += $row->importe;
				$cancelarecibo = Recibo::model()->findByPk($row->id_recibo);
				$cancelarecibo->estado = 'C';
				$cancelarecibo->motivo = "Cancelación de Reservación #" . $model->id_tourReservacion;
				$cancelarecibo->save();
				$cancelados .= "#" . $row->id_recibo . " ";
				$otrasreservas = ReciboDetalles::model()->findAll('tipo="Tour" and id_recibo=' . $row->id_recibo . ' and id_reservacion!=' . $model->id_tourReservacion);
				if (count($otrasreservas) > 0) {
					$importeotras = 0;
					$reservas = "";
					foreach ($otrasreservas as $otras) {
						$importeotras += $otras->importe;
						$reservacion = TourReservacion::model()->findByPk($otras->id_reservacion);
						$reservacion->saldo += $otras->importe;
						try {
							$reservacion->save();
						} catch (Exception $e) {
							$reservacion->getErros();
						}
						$reservacion->save();
						$reservas .= "#" . $otras->id_reservacion . " ";
					}
					$this->Crearnota($importeotras, $model, "Cancelación de Reservación #" . $model->id_tourReservacion . " - Importe de Reservas: " . $reservas);
				}
			}
			if ($importe > 0) {
				if ($penalizar == TRUE && $penalizado == FALSE && $importe > $penalizacion) {
					$importe = $importe - $penalizacion;
					$recibo = new Recibo;
					$recibo->id_tipo = 11;
					$recibo->tipo = "Tour";
					$recibo->importe = $penalizacion;
					$recibo->id_agencia = $model->id_agencia;
					$recibo->id_user = Yii::app()->user->id;
					if ($recibo->save()) {
						$detalle = new ReciboDetalles;
						$detalle->id_recibo = $recibo->id_recibo;
						$detalle->id_reservacion = $model->id_tourReservacion;
						$detalle->importe = $penalizacion;
						$detalle->tipo = 'Tour';
						$detalle->concepto = 'Pago de Penalización Reserva #' . $model->id_tourReservacion . ' Pax: ' . $model->nombre_cliente . ' ' . $model->cliente_apellido . ' - Tour: ' . $model->idTour->nombre;
						$detalle->save();
					}
				}
				$this->Crearnota($importe, $model, "Cancelación de Reservación #" . $model->id_tourReservacion . " Recibos Cancelados: " . $cancelados);
			}
			$model->saldo += $importe;
			$model->cancelacion_motivo = $_POST['motivo'] . "<br />Fecha: " . date('d/m/Y H:i:s') . " Autorizó: " . $usuarioCancela->idUsuario->nombre_usuario;
			$model->cancelacion_fecha = date('Y-m-d H:i:s');
			$model->estatus = 'C';

			if ($model->save()) {
				$operacion = Yii::app()->createController('operacionesLog');
				$operacion = $operacion[0];
				$operacion->Create($model->id_tourReservacion, 5);
				$this->redirect(array('view', 'id' => $model->id_tourReservacion));
			}
		} else if (isset($_POST['clave_confirmacion'])) {
			$this->redirect(array('view', 'id' => $model->id_tourReservacion, 'error_clave' => 1));
		} else {
			$model->cancelacion_motivo = $_POST['motivo'];
			$model->estatus = 'PC';
			if ($model->save()) {
				$this->redirect(array('view', 'id' => $model->id_tourReservacion));
			} else {
				print_r($model->getErrors());
			}
		}
	}


	public function actionReinstalarReservacion($id)
	{
		$model = $this->loadModel($id);
		$usuarioCancela = $this->verificaClave($_POST['clave_confirmacion']);
		if (isset($_POST['clave_confirmacion']) && !empty($usuarioCancela)) {
			$model->estatus = "RE";
			$model->cancelacion_motivo .= "<br />Se reinstaló: " . date('d/m/Y H:i:s') . " Autorizó: " . $usuarioCancela->idUsuario->nombre_usuario;
			if ($model->save()) {
				$operacion = Yii::app()->createController('operacionesLog');
				$operacion = $operacion[0];
				$operacion->Create($model->id_tourReservacion, 31);
				$this->redirect(array('view', 'id' => $model->id_tourReservacion));
			} else {
				print_r($model->getErrors());
			}
		} else {
			$this->redirect(array('view', 'id' => $model->id_tourReservacion, 'error_clave' => 1));
		}
	}

	public function verificaClave($clave)
	{
		$clave = Claves::model()->find('clave="' . $clave . '"');

		if (!empty($clave)) {
			return $clave;
		} else {
			return NULL;
		}
	}
	public function eventoOutlet($outlet)
	{

		$activo = ($outlet->fecha_inicio <= date("Y-m-d") && $outlet->fecha_final > date("Y-m-d")) ? true : false;
		//$activo=('2018-04-25'<=date("Y-m-d") && '2018-04-26'>date("Y-m-d"))? 'SI':'NO';
		return $activo;
	}

	private function Crearnota($importe, $model, $concepto)
	{
		$notacredito = new NotaCredito;
		$notacredito->importe = $importe;
		$notacredito->id_tipo = 11;
		$notacredito->id_agencia = $model->id_agencia;
		$notacredito->id_ref = $model->id_tourReservacion;
		$notacredito->tipo_ref = "TOUR";
		$notacredito->concepto = $concepto;
		$notacredito->estatus = "A";
		$notacredito->id_user = Yii::app()->user->id;
		$notacredito->save();
	}

	public function actionUpdateFechaTour()
	{
		$fecha_limite = DateTime::createFromFormat('d/m/Y', $_POST["fecha_limite"])->format('Y-m-d');
		$fecha_limite_t = DateTime::createFromFormat('d/m/Y', $_POST["fecha_limite_tour"])->format('Y-m-d');
		$model_reserva = TourReservacion::model()->findByPk($_POST["id_reserva"]);
		$model_reserva->fecha_limite = $fecha_limite;
		$model_reserva->fecha_limite_t = $fecha_limite_t;
		if ($model_reserva->save()) {
			if ($model_reserva->fecha_limite != $_POST["fecha_limite"]) {
				$tipo_cambio = "FL";
				$cambio = "Cambio " . $tipo_cambio . " de " . $model_reserva->fecha_limite . " a " . $fecha_limite;
			} else if ($model_reserva->fecha_limite_t != $_POST["fecha_limite_tour"]) {
				$tipo_cambio = "FLT";
				$cambio = "Cambio " . $cambio . " de " . $model_reserva->fecha_limite_t . " a " . $fecha_limite_t;
			}
			$log_model = new OperacionesLog;
			$log_model->id_referencia = "T-" . $_POST["id_reserva"];
			$log_model->id_operacion_tipo = 40;
			$log_model->descripcion = $cambio;
			$log_model->id_usuario = $_POST["id_usuario"];
			$log_model->save();
			$this->redirect(array("view", "id" => $_POST["id_reserva"]));
		}
	}

	function printPrecio($precio, $model)
	{
		$general = Yii::app()->createController('general')[0];
		return $general->printPrice($precio, $model, "tour");
	}

	// --------------------PAYNET----------------------- //
	public function actionPaynet($id)
	{


		$production    = false;
		$clientId      = ($production) ? '' : 'mt2dpexmii5tvdsof9oo';
		$secretKey     = ($production) ? '' : 'sk_80c1c067a5d342de9c5f39fca65c1e08';
		$publicKey     = ($production) ? '' : 'pk_c23be88946224dcca0028af6d4539fac';

		$reservacion = TourReservacion::model()->findByPK($id);
		$nombre_tour = Tour::model()->findByPk($reservacion->id_tour)->nombre;
		$datos_cliente = new CDbCriteria;
		$datos_cliente->addCondition("id_reservacion='" . $id . "'");
		$datos_cliente->addCondition("tipo_servicio='5'");
		$datos_cliente = DatosClientes::model()->find($datos_cliente);

		$model_paynet = ReservacionesPaynet::model()->find("id_reservacion = " . $id);
		if (is_null($model_paynet)) {
			$model_paynet = $this->DatosPaynet($reservacion);
		}
		/* echo CJSON::encode($reservacion);
		exit();*/
		$dash        = Yii::app()->createController('dashboard');
		$dash        = $dash[0];
		$tasa_cambio = $dash->tasaCambioActual();

		if (!isset($model_paynet->url_pdf)) {

			$currency    = (isset($tasa_cambio['importe'])) ? floatval($tasa_cambio['importe']) : 25.5;

			$today = date('Y-m-d');
			$daylimit = date('Y-m-d', strtotime($today . '+ ' . 2 . ' days'));

			$monto = "";
			$total_reserva = $reservacion["importe"];
			$modeda = $reservacion['moneda'];
			if ($modeda == 'USD') {
				$monto = ($total_reserva * $currency);
			} else {
				$monto = $total_reserva;
			}

			$customer = array(
				'name'         => $reservacion["cliente_nombre"],
				'phone_number' => $datos_cliente["telefono"],
				'email'        => $datos_cliente["email"],
			);

			$chargeData = array(
				'method'      => 'store',
				'amount'      => number_format($monto, 2, '.', ''),
				'description' => 'Reservación #' . $reservacion["id_tourReservacion"] . ' Hotel: ' . $nombre_tour . ', Fecha: ' . $reservacion['fecha_inicio'],
				'due_date' => $daylimit,
				'customer'    => $customer,
			);

			try {
				$openpay = Openpay::getInstance($clientId, $secretKey, 'MX');
				$charge = $openpay->charges->create($chargeData);

				$ref =  $charge->payment_method->reference;

				/* var_dump($charge);
				exit; */
				$model_paynet->url_pdf = "https://sandbox-dashboard.openpay.mx/paynet-pdf/$clientId/$ref";
				$model_paynet->transaction_id = $charge->id;
				if ($model_paynet->save()) {

					$this->render('ReciboPayNet', array("charge" => $charge, "reservacion" => $reservacion));
					/* header("Location: https://sandbox-dashboard.openpay.mx/paynet-pdf/$clientId/$ref"); */
				} else {
					echo CJSON::encode($model_paynet->getErrors());
				}
			} catch (\Throwable $th) {
				$message = OpenpayErrors::getErrors()[$th->getCode()];
				die(var_dump($message));
			}
		} else {
			$openpay = Openpay::getInstance($clientId, $secretKey, 'MX');
			$charge = $openpay->charges->get("$model_paynet[transaction_id]");

			$this->render('ReciboPayNet', array("charge" => $charge, "reservacion" => $reservacion));

			/* 		var_dump($charge);
			exit; */
			// header("Location: $model_paynet[url_pdf]");
			// $this->render('ReciboPayNet', array("ref" => $ref
			// ));
		}
	}

	public function DatosPaynet($reserva)
	{
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://www.2businesstravel.com/panel/agencia/getDatosAgencia2business/?referencia=U' . $reserva->id_usuario . 'A' . $reserva->id_agencia . '',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'Cookie: PHPSESSID=0e547b6cba728a2c6d0a7382cd94691a'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$respuesta =  json_decode($response, true);

		$id_reserva = $reserva->id_tourReservacion;
		$id_agencia = $respuesta['id'];
		$model_paynet = new ReservacionesPaynet;
		$model_paynet->id_agencia = $id_agencia;
		$model_paynet->id_reservacion = $id_reserva;

		if ($model_paynet->save()) {
			return $model_paynet;
		} else {
			echo CJSON::encode($model_paynet->getErrors());
		}
	}

	public function actionReciboPayNet()
	{
		$this->render('ReciboPayNet', array(
			'model' => $model,
		));
	}

	// ---------------------PAYNET----------------- //






}
