<?php
 // error_reporting(E_ALL);
 Yii::import('application.extensions.phpmailer.JPhpMailer');
class SolicitudReservacionController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $palaceResorts = array('BP'=>1,'CZ'=>1,'IM'=>1,'LBC'=>1,'MPS'=>1,'PL'=>1,'SP'=>1,'MPG'=>1,'ZPLB'=>1);
	public $layout='//layouts/ansonika_site';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','guardarBooking','sendEmailTest','ecomercePaypal'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel'),
				'users'=>array('*'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->layout='//layouts/ansonika_site';
		$desglose=SolicitudReservacionDesglose::model()->findAll('id_reservacion='.$id);
		$model_markup = SolicitudReservacionMarkup::model()->find('id_reservacion='.$id);
		$model=$this->loadModel($id);
		
		$this->render('view',array(
			'model'=>$model,'desglose'=>$desglose, 'model_markup'=>$model_markup
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new SolicitudReservacion;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['SolicitudReservacion']))
		{
			$model->attributes=$_POST['SolicitudReservacion'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_reservacion));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	public function actionGuardarBooking()
	{
		// $model, $reserva, $datos, $cotizacion, $TotalCotiz, $ecomerce
		/*$outlet=Outlet::model()->find('estatus=1');
		$outletEstatus=$this->eventoOutlet($outlet);
		$outletControl=Yii::app()->createController('outlet');
		$tarifasOutlet=$outletControl[0]->validacionTarifas($outlet);*/
		$session=new CHttpSession;
		$session->open();
		$model = new SolicitudReservacion;

		if (isset($_POST["Reservacion"])) 
		{
			$solicitud["SolicitudReservacion"]=$_POST['Reservacion'];
			/*unset($_SESSION['ecomerce']);
			echo json_encode($solicitud);
			exit;*/
			if($_POST['Reservacion']['manual'] == 1 && !empty($_POST['Reservacion']['id_bloqueo'])){
				$clave = $this->verificaClave($_POST['clave']);
				if(empty($clave)){
					$this->redirect(array('bloqueo','id'=>$_POST['Reservacion']['id_bloqueo'],'hab'=>$_POST['roomlist'],'error_clave'=>1));
				}
			}
			//$reservaApis = Yii::app()->createController('reservaBanco');
			//$reservaApis = $reservaApis[0];
			//$this->outlet = Outlet::model()->find('estatus=1');
			
			$model->attributes=$solicitud["SolicitudReservacion"];
			$model->email=$_POST['Reservacion']['email'];
			$model->moneda=$_POST['Reservacion']['moneda'];
			$model->id_usuario=$_POST['Reservacion']['id_usuario'];
			$model->tel_cliente=$_POST['Reservacion']['tel_cliente'];
			$Reservacion = $_POST;
			$datos = json_decode($_POST["datos"],true);
			$cotizacion = $_GET["cotizacion"];
			$totalCotiz = $_GET["totalCotiz"];

			$datos['id_agencia'] = $model->id_agencia;
			$datos['id_agente'] = $model->id_agente;
			$datos['nombre_cliente'] = $model->nombre_cliente;
			$datos['apellido_cliente'] = $model->apellido_cliente;
			$datos['tel_cliente'] = $model->tel_cliente;


			for($i=1;$i<=$model->num_habitaciones;$i++):
				$adultos = $datos['front_form']['habitacion_'.$i]['adultos'];
				for($a=1;$a<=$adultos;$a++){
					//agregar nombres de adultos al front_form
					$datos['front_form']['habitacion_'.$i]['adulto_'.$a] = $Reservacion['Adulto_'.$a.'_'.$i]['nombre'];
					$datos['front_form']['habitacion_'.$i]['adulto_apellido_'.$a] = $Reservacion['Adulto_'.$a.'_'.$i]['apellido'];
				}
				$num_ninios = $datos['front_form']['habitacion_'.$i]['num_ninios'];
				for($m=1;$m<=$num_ninios;$m++){
					//agregar nombres de menores al front_form
					$datos['front_form']['habitacion_'.$i]['ninio_'.$m] = $Reservacion['Ninio_'.$m.'_'.$i]['nombre'];
					$datos['front_form']['habitacion_'.$i]['ninio_apellido_'.$m] = $Reservacion['Ninio_'.$m.'_'.$i]['apellido'];
				}
			endfor;
			
			### para separar datos de $Reservacion y tener menos peso la variable
			unset($Reservacion['datos']);

			// echo json_encode($Reservacion);
			// exit;
			if (empty($model->id_bloqueo)) {
				$model->fecha_inicial = implode("-", array_reverse(explode("-", $model->fecha_inicial)));
				$model->fecha_final = implode("-", array_reverse(explode("-", $model->fecha_final)));
			}

			$model->num_noches = $this->noches($model->fecha_inicial,$model->fecha_final);		
			//$outletEstatus=$this->eventoOutlet($this->outlet);
			/*$comision = Agencias::model()->findByPk($model->id_agencia)->porcentaje_comision;
			if ($_POST['Reservacion']['id_bloqueo']) {
				$porcentaje = Bloqueos::model()->findByPk($_POST['Reservacion']['id_bloqueo'])->comision;
				if ($porcentaje>0) {
					$comision=$porcentaje;
				}
			}

			$model->comision = $comision;*/
			$comision = Agencias::model()->findByPk($model->id_agencia);
			if(empty($datos['rateKey']))
			{
				$comision_hotel = Tarifa::model()->findByPk($model->id_tarifa);

			}
			else
			{
				//pasar a variables de configuracion, tarea pendiente 14 nov 2017
				$comision_hotel=20; 
				// $model->id_tarifa=0;
				//$model->comision = 14; 
				if($model->idHotel->proveedor==1){
					$markup = Api::model()->findByPk(1)->markup;
				}else if($model->idHotel->proveedor==2){
					$markup = Api::model()->findByPk(4)->markup;
				}else if($model->idHotel->proveedor==3){
					$markup = Api::model()->findByPk(6)->markup;
				}
			}

			//$model->libera_cupon=1;

			//if($model->manual == 1)$model->total_tc = $model->total;

			$model->tarifa_agencia = $model->total - ($model->total*($comision/100));

			$model->tarifa_neta = $model->total - ($model->total*($comision_hotel->comision/100));	

			$model->estatus = 'R';

			if($model->idTarifa->tipo_cambio != 0){
				if($model->idTarifa->tipo_cambio == 1){
					$model->tipo_cambio = $model->idHotel->tipo_cambio;
				}else if($model->idTarifa->tipo_cambio == 2){
					$model->tipo_cambio = $model->idTarifa->tasa_cambio;
				}
				$model->saldo = round($model->total_tc * $model->tipo_cambio,2);
				$model->saldo = $model->saldo - ($model->saldo*($model->comision/100));
				// $model->saldo = 0;
			}


			if (empty($datos["rateKey"])) {
				$fechaLimite = FechaLimite::model()->find('id_hotel='.$model->id_hotel.' and "'.$model->fecha_inicial.'" between fecha_inicio and fecha_final');

				if(!empty($model->idTarifa->fecha_limite) && strtotime($model->fecha_inicial) > strtotime($model->idTarifa->fecha_limite))
				{
					$model->fecha_limite = $model->idTarifa->fecha_limite;
				}
				else if(!empty($model->idTarifa->fecha_limite_dias)){
					$model->fecha_limite = date('Y-m-d',strtotime($model->fecha_inicial.' -'.($model->idTarifa->fecha_limite_dias + 2).' days'));
				}
				else{
				// $fechaLimite = FechaLimite::model()->find('id_hotel='.$model->id_hotel.' and "'.$model->fecha_inicial.'" between fecha_inicio and fecha_final');
					if(!empty($fechaLimite)){
						$model->fecha_limite = date('Y-m-d',strtotime($model->fecha_inicial.' -'.($fechaLimite->dias + 2).' days'));
					}
				}

				if (!empty($fechaLimite) && $model->idHotel->Destino->destinationsCode0->code!="HUA") {
				// echo "HUA";
					$model->fecha_limite_h = date('Y-m-d',strtotime($model->fecha_inicial.' -'.$fechaLimite->dias.' days')); 
				}


				if( ( !empty($model->fecha_limite) && strtotime($model->fecha_limite) < strtotime(date('Y-m-d')) ) || empty($model->fecha_limite) ){
					$hoy=date("Y-m-d");

					$datetime_fecha_inicial=new DateTime($model->fecha_inicial);
					$datetime_hoy=new DateTime($hoy);

					$diferencia = $datetime_fecha_inicial->diff($datetime_hoy);

					$resultado_diferencia_dias= $diferencia->format('%a');

					if($resultado_diferencia_dias<=7 && empty($fechaLimite))
					{
						$fecha_limite=date("Y-m-d",strtotime($hoy));

					}else if($resultado_diferencia_dias>7 && $resultado_diferencia_dias<=15 && empty($fechaLimite))
					{
						$fecha_limite=date("Y-m-d",strtotime($hoy.' +1 days'));							

					}else if($resultado_diferencia_dias>15 && $resultado_diferencia_dias<=32 && empty($fechaLimite))
					{
						$fecha_limite=date("Y-m-d",strtotime($hoy.' +2 days'));

					}else if($resultado_diferencia_dias>32 && empty($fechaLimite))
					{
						$fecha_limite=date("Y-m-d",strtotime($model->fecha_inicial.' -31 days'));

					}elseif ( !empty($fechaLimite) && strtotime($model->fecha_inicial.' -'.$fechaLimite->dias.' days') < strtotime(date('Y-m-d')) ) {

						$fecha_limite=date("Y-m-d",strtotime($hoy));	
						$model->fecha_limite_h=date("Y-m-d",strtotime($hoy));
					}

					if($fecha_limite<=$hoy)
						$fecha_limite=$hoy;


					if (empty($fechaLimite)) {
						$model->fecha_limite_h = null;
					}

					$model->fecha_limite = $fecha_limite;
				}

			}else{

				switch ($model->idHotel->proveedor) {
					case 1:
						$avisoCancelacion="";
						$busquedaController = Yii::app()->createController('busqueda');
						$busquedaController = $busquedaController[0];
						$markup = Api::model()->findByPk(1)->markup;

						foreach (json_decode(base64_decode($datos['rateKey'])) as $rK => $rateKey) 
						{
							$requestCheckrate=array();
							$requestCheckrate["rateKey"]= $rateKey;	
							$responseCheckrate=$this->consultarCheckrates(json_encode($requestCheckrate));

							$arrayCheckrate=json_decode($responseCheckrate);

							$tipohab = TipoHabitaciones::model()->find('codigo="'.$arrayCheckrate->hotel->rooms[0]->code.'" AND id_hotel='.$model->id_hotel);

							$descripcionHabitacion=(strlen($tipohab->descripcion)>0)?$tipohab->descripcion:$tipohab->tipo_habitacion;

							$responsePoliticas=$busquedaController->politicasCancelacion($arrayCheckrate->hotel->rooms[0]->rates[0]->cancellationPolicies,$model->fecha_inicial,$markup,$descripcionHabitacion,$rK,$moneda,false);

							$avisoCancelacion.=$responsePoliticas["politicasCancelacion"];

							if($arrayCheckrate->hotel->rooms[0]->rates[0]->cancellationPolicies)
							{

								$fecha_limite=substr($responsePoliticas["fecha_limite"],0,10);

								$fecha_limite_h=date('Y/m/d H:i:s',strtotime($arrayCheckrate->hotel->rooms[0]->rates[0]->cancellationPolicies[0]->from));

								$model->fecha_limite=implode('-',array_reverse(explode('/',$fecha_limite)));
								$model->fecha_limite_h=$fecha_limite_h;

							}else
							{
								// echo $model->fecha_limite=date("Y-m-d");
								$model->fecha_limite=date("Y-m-d");
							}

							if($arrayCheckrate->hotel->rooms[0]->rates[0]->rateComments)
								$rateComments[$rK]=$arrayCheckrate->hotel->rooms[0]->rates[0]->rateComments;
							if($arrayCheckrate->hotel->rooms[0]->rates[0]->offers)
								$offers[$rK]=$arrayCheckrate->hotel->rooms[0]->rates[0]->offers;
							$TotalN+=$arrayCheckrate->hotel->totalNet/$markup;

						}
						$model->fecha_limite;
						$datos['politicas_cancelacion']=$avisoCancelacion;
						break;
					case 2:
						$ratePlan_data=json_decode(base64_decode($datos["ratePlan"]));

						$datetime_hoy=new DateTime(date("Y-m-d"));
						$dias_fecha_limite=$ratePlan_data->CancelPenalties->CancelPenalty->DeadLine->OffsetUnitMultiplier;
						$datetime_fecha_inicial=new DateTime(date("Y-m-d",strtotime($model->fecha_inicial)));
						$datetime_fecha_limite=new DateTime(date("Y-m-d",strtotime($model->fecha_inicial.' - '.$dias_fecha_limite)));

						$diferencia = $datetime_fecha_inicial->diff($datetime_hoy);

						$resultado_diferencia_dias=$diferencia->format('%a');

						if($dias_fecha_limite<=$resultado_diferencia_dias)
						{
							$model->fecha_limite_h=date("Y-m-d H:i:s",strtotime($model->fecha_inicial.' -'.($dias_fecha_limite).' days'));                    	
						}else
						{							
							$model->fecha_limite_h=date("Y-m-d H:i:s");
						}
						$model->fecha_limite=$reservaApis->fechaLimite($resultado_diferencia_dias, $model->fecha_limite_h );
						break;
					case 3:
						$model->fecha_limite=implode('-',array_reverse(explode('/',$datos['fecha_limite'])));
						$model->fecha_limite_h=implode('-',array_reverse(explode('/',$datos['fecha_limite_h'])));
						break;
					case 4:
						//$model->fecha_limite=date('Y-m-d H:i:s', strtotime($datos['fecha_limite']));
						$model->fecha_limite=implode('-',array_reverse(explode('/',$datos['fecha_limite'])));
						$model->fecha_limite_h=$datos['fecha_limite_h'];
						$avisoCancelacion= $datos['politicas_cancelacion'];
						break;
					case 5:
						$fechaH= $datos['fecha_limite_h'];
						$model->fecha_limite_h = $fechaH; 
						$model->fecha_limite=$datos["fecha_limite"];
						// $model->fecha_limite=implode('-',array_reverse(explode('/',$datos['fecha_limite'])));
						break;
					case 6:
						$fechaLimite =implode('-',array_reverse(explode('/',$datos['ratePlan'])));
						$fechaH = $datos['fecha_limite_h'];
						$model->fecha_limite = $fechaLimite;
						$model->fecha_limite_h = $fechaH;
						break;
					default:
						$model->fecha_limite_h=$datos['fecha_limite_h'];
						break;
				}

			}
			
			
			if (empty($model->id_bloqueo)) {
				if(empty($datos['rateKey']))
				{
					$model->politicas_cancelacion = $this->cancelaciones($model,$model->fecha_inicial,$model->id_tarifa);
				}
				else
				{
					$model->politicas_cancelacion=$datos['politicas_cancelacion'];
				}

				if(empty($datos['rateKey']))
				{
				//Checa si tiene allotment, poner codigo
					$fechaInicio = new DateTime($model->fecha_inicial);
					$fechaFinal = new DateTime($model->fecha_final);
					do{
						$allotment = Allotment::model()->find('id_hotel='.$model->id_hotel.' and "'.$fechaInicio->format('Y-m-d').'" between fecha_inicio and fecha_final');
						$fechaInicio->modify('+1 days');
						if(!empty($allotment)){
							$model->code = "W".date('YmdHis');
							break;
						}
					}
					while($fechaInicio < $fechaFinal);
				//Fin chequeo
				}else{
					
					$tipoReservacion = 'Normal';
					//CONEXIONES AL WS SOCIOS ONLINE
					if($datos['rateKey']!="OB")
					{
						switch ($model->idHotel->proveedor) {
							case 1:

							/*foreach (json_decode(base64_decode($datos['rateKey'])) as $i_room => $value_rateKey) 
							{
								$bookingResponse=$reservaApis->bookingBedsBanco($value_rateKey,$i_room+1 ,$Reservacion,$tipoReservacion);
								$booking=json_decode($bookingResponse);
								$bookingReference=$booking->booking->reference;
								if(empty($bookingReference)){ echo "Ocurrió un error al intentar hacer la reservacion con el Socio Online"; exit; }
								$bookingReferences.="BR".$bookingReference.",";
							}

							$supplier=$booking->booking->hotel->supplier;
							
							$bookingReferences=trim($bookingReferences, ',');
							$model->code=$bookingReferences;
							$model->manual=2;
							//DESGLOSE COMENTARIOS Y PROMOCIONES DE LA TARIFA
							
							$desglose_rate=array();
							$desglose_rate['currency']=$datos['currency'];
							$desglose_rate['rateClass']=$datos['rate_class'];
							$desglose_rate["supplier"]=array('name'=>$supplier->name, 'vatNumber'=>$supplier->vatNumber);
							
							if($datos['promociones'])
								$desglose_rate['promociones']=base64_decode($datos['promociones']);				
							
							$model->desglose_rate=json_encode($desglose_rate);*/
								$comisionProveedor = Api::model()->findByPk(1)->markup;
								$comisionTipo="Api";
								
							break;
							case 3:
							
							/*
							$travelSolutionController = Yii::app()->createController('travelSolution');
							$travelSolutionController = $travelSolutionController[0];
							$bookingResponse=$reservaApis->createBookTravelSolution($model,$datos,$Reservacion,$tipoReservacion);
							//echo '<textarea rows="10" cols="50">'.$bookingResponse.'</textarea>';
							$booking=json_decode($bookingResponse);
							$bookingReference=$booking->confirmationid;//validar el estatus internet
							$rooms=$booking->Rooms->Room;
							if (count($rooms)>1) {
								foreach ($rooms as $keyroom => $room) {
									$model->fecha_limite_h = $room->CancellationPolicy->PaymentLimitDay;
								}
								
							}else{

								$model->fecha_limite_h = $rooms->CancellationPolicy->PaymentLimitDay;
								
							}
							if (empty($model->fecha_limite_h) || strtotime($model->fecha_limite_h) <=strtotime(date('Y-m-d'))) {
								$model->fecha_limite_h=date('Y-m-d');
								$model->fecha_limite=date('Y-m-d');
							}
							if ($bookingReference==0 || empty($bookingReference)) {
								echo $booking->Error->Id.": ".$booking->Error->Description; exit; 
							}

							
							$model->code="TS".$bookingReference;
							$model->manual=2;

							$codigo_hotel=explode("/",$model->idHotel->codigo)[0];
							$hotelSocioOnline=$travelSolutionController->searchHotelTS($codigo_hotel);

							$desglose_rate=array();
							$desglose_rate['currency']=$booking->currency;
							$desglose_rate['operatorname']=$booking->operatorname;
							$desglose_rate['operatoremail']=$booking->operatoremail;
							
							if(!is_object($hotelSocioOnline->AdditionalCharges))
							{
								$hotelSocioOnline->AdditionalCharges=strip_tags($hotelSocioOnline->AdditionalCharges);
								$desglose_rate['additionalCharges']=ucfirst($hotelSocioOnline->AdditionalCharges);
							}	        	
							
							if($_POST['promociones'])
								$desglose_rate['promociones']=base64_decode($_POST['promociones']);				
							
							$model->desglose_rate=json_encode($desglose_rate);

							$fotos = HotelesFotos::model()->findAll('id_hotel='.$model->id_hotel.' and logotipo=1 and foto LIKE "'.$hotelSocioOnline->Image.'"');
							if(count($fotos)==0)
							{			
								$foto = new HotelesFotos;
								$foto->id_hotel=$model->id_hotel;
								$foto->foto=$hotelSocioOnline->Image;
								$foto->logotipo=1;

								if(!$foto->save())
									print_r($foto->getErrors());

							}*/

							$comisionProveedor = Api::model()->findByPk(6)->markup;
							$comisionTipo="Api";
							//$model->tarifa_neta = $this->saldoHotel($model->total,$comision_hotel,"Api");
							
							break;
							case 4:
							/*$riuController=Yii::app()->createController('riu');
							$riuReservacion=$reservaApis->bookingRiuBanco($datos,$Reservacion,$tipoReservacion);
						//$riuReservacion=json_decode($riuReservacion);
							
							$reservacion=json_decode($riuReservacion)[0];
							if (empty($reservacion->HotelResResponse->out->customerReservationCode) && empty($reservacion->HotelResResponse->out->hotelReservationCode) && $reservacion->HotelResResponse->out->state!="OK") {
								echo "Hubo un Error al crear la reserva, la reserva no fue efectuada";
								exit;
							}

							$comision_hotel = Api::model()->findByPk(7)->markup;*/
							/*$model->code="RI".$reservacion->HotelResResponse->out->customerReservationCode."-".$reservacion->HotelResResponse->out->hotelReservationCode."-".$reservacion->HotelResResponse->out->hotelReservationID;*/
							$comisionProveedor=20;
							$comisionTipo="comision";
							
							break;
							case 5:
							/*$dingusReservacion=$reservaApis->bookingDingusBanco($model->idHotel->Cadena->url_dingus, $datos, $Reservacion,$tipoReservacion);
							$reservacion=$dingusReservacion;
							$hotelResID=$reservacion['OTA_HotelResRS']['HotelReservations']['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'];
							if (empty($hotelResID)) {
								echo "Hubo un Error al crear la reserva, la reserva no fue efectuada";
								exit;
							}*/

						
							$comisionProveedor = $model->idHotel->comision;
							$comisionTipo="comision";
							
							
							//$model->code="DI";
							
							$model->politicas_cancelacion=$datos['politicas_cancelacion'];
							break;
							case 6:
								$comisionProveedor = Api::model()->findByPk(9)->markup;
								$comisionTipo="Api";
								
								
							break;
							default:
							# code...
							break;
						}
					}else{

						$comisionProveedor=$model->idHotel->comision;
						$comisionTipo="comision";
						/*$codeHotel=  explode("/",Hoteles::model()->findByPk($model->id_hotel)->codigo);				
						$return=$reservaApis->bookingOmniBeesBanco($codeHotel[0],$datos,$Reservacion,$tipoReservacion);
						$array=json_decode($return);
						$bookingReference=$array->SendHotelResResult->HotelReservationsType->HotelReservations->HotelReservation->UniqueID->ID;
						if(empty($bookingReference)){ echo $return; exit; }
						$model->code="OB".$bookingReference;
						$model->manual=2;*/
					}

				$model->tarifa_neta=$this->saldoHotel($model->total, $comisionProveedor, $comisionTipo);
				}

			}
			/*echo $datos["rateKey"];
			exit;*/
			$model->code="RMTS".Hoteles::model()->findByPk($model->id_hotel)->proveedor.date('sHd');
			
			/*if($outletEstatus && $model->idTarifa->precio=='OUTLET')
			{
				$model->fecha_limite=date('Y-m-d');
				if($model->code=="")
				{
					$model->code="RMT-OUTLET".date('Y-m-d');
				}
			}*/

			// echo "<textarea>".CJSON::encode($model)."</textarea>";
			// exit;
			if($model->save())
			{
				
				

				$broker=explode('-', $model->code);
				$BR=$broker[0];
				$beds=$BR[1].$BR[0];
				$m=0;
				for($i=1;$i<=$model->num_habitaciones;$i++)
				{
					if($_POST['Habitacion_'.$i] != NULL)
					{
						if ($model->idHotel->proveedor==4||$model->idHotel->proveedor==5) {
							$Reservacion['habitacion_'.$i]['id_tipo_habitacion']=$Reservacion['habitacion_1']['id_tipo_habitacion'];
						}
						$habitacion=new SolicitudReservacionDesglose;
						$habitacion->attributes=$Reservacion['Habitacion_'.$i];
						$habitacion->id_reservacion = $model->id_reservacion;
						$desgloseB["desglose"]=array();
						for($d=0;$d<$model->num_noches;$d++)
						{
							array_push($desgloseB["desglose"], array("noche"=>$cotizacion[$m][$d][0][$i]['fecha'], "precio_adulto"=>$cotizacion[$m][$d][0][$i]['adultos'],"precio_menor"=>$cotizacion[$m][$d][0][$i]['menores']));
							$desgloseB["desglose"][$d]["precioPorMenor"]=array();
							for ($p=0; $p < $datos['front_form']['habitacion_'.$i]['num_ninios']; $p++) 
							{
								array_push($desgloseB["desglose"][$d]["precioPorMenor"],$cotizacion[$m][$d][0][$i][$p]);
							} 
						}

						$reference=explode(",", $model->code);
						$desgloseB["desglose"]["reference"]=$reference[$i-1];
						$desgloseB["desglose"]["planHotel"]=$datos['boardName'];

						if($_POST['rateComments_'.$i])
							$desgloseB["desglose"]['rateComments']=$_POST['rateComments_'.$i];

						if($_POST['offers_'.$i])
						{
							$desgloseB["desglose"]['offers']=array();
							foreach(json_decode($_POST['offers_'.$i]) as $offer)
							{
								$importeOferta=$offer->amount/$markup;
								array_push($desgloseB["desglose"]['offers'], array("code"=>$offer->name, "name"=>$offer->name,"amount"=>$importeOferta));		            		
							}
						}
						$tipoReservacion = "Normal";
						if(!empty($_POST['rateKey']))                  	
							$desgloseBeds=json_encode($desgloseB);
						else
						$desgloseBeds="";
						$habitacion->desgloseBeds=$desgloseBeds;
						if(empty($model->id_bloqueo) && !empty($this->palaceResorts[$model->idHotel->codigo]))
						{
							if (!$outletEstatus) {
								//$wsResponse = $reservaApis->palaceWsBanco($model,$habitacion,$i,$Reservacion,$tipoReservacion);
							}
							$comisionProveedor=20;
							if(empty($wsResponse['error'])){
								$comision_hotel = Api::model()->findByPk(9)->markup;
								$saldo_hotel = $this->saldoHotel($model->total,$comision_hotel,"Api");
								//$model->saldo_h = $saldo_hotel;

								// $model->saldo_h=$this->saldoHotel($model->total, $comisionProveedor);
								//$model->code .= "WS".$wsResponse['folio'];
								$model->save();
							}
							else{
								$model->delete();
								throw new CHttpException(500,$wsResponse['error']);
							}
						}

						if($habitacion->save())
						{
							for($a=1;$a<=$habitacion->num_adultos;$a++)
							{
								$adulto=new SolicitudReservacionDesglosePersona;
								$adulto->nombre=$_POST['Adulto_'.$a.'_'.$i]["nombre"]." ".$_POST['Adulto_'.$a.'_'.$i]["apellido"];
								$adulto->tipo = 'A';
								$adulto->edad = 30;
								$adulto->id_desglose = $habitacion->id_desglose;
								$adulto->id_reservacion = $model->id_reservacion;
								$adulto->save();
							}
							for($n=1;$n<=$habitacion->num_ninios;$n++){ //Ordenar edades menores mayor a menor
								if($_POST["Ninio_".$n."_".$i.""]["edad"] < $_POST["Ninio_".($n+1)."_".$i.""]["edad"]){
									$aux = $_POST["Ninio_".$n."_".$i.""]["edad"];
									$aux2 = $_POST["Ninio_".$n."_".$i.""]["nombre"];
									$_POST["Ninio_".$n."_".$i.""]["edad"] = $_POST["Ninio_".($n+1)."_".$i.""]["edad"];
									$_POST["Ninio_".$n."_".$i.""]["nombre"] = $_POST["Ninio_".($n+1)."_".$i.""]["nombre"];
									$_POST["Ninio_".($n+1)."_".$i.""]["edad"] = $aux;
									$_POST["Ninio_".($n+1)."_".$i.""]["nombre"] = $aux2; 
									$n=0;
								}
							}
							for($n=1;$n<=$habitacion->num_ninios;$n++)
							{
								$ninio=new SolicitudReservacionDesglosePersona;
								$ninio->attributes=$_POST['Ninio_'.$n.'_'.$i];
								$ninio->tipo = 'N';
								$ninio->id_desglose = $habitacion->id_desglose;
								$ninio->id_reservacion = $model->id_reservacion;
								$ninio->save();
							}
						}else
						{
							print_r($habitacion->getErrors());
						}

					}	
				}

				// $notificar = Usuarios::model()->findAll('aviso LIKE "%r%"');
				// foreach($notificar as $user){
				// 	$notificacion = new Notificacion;
				// 	$notificacion->id_item = $model->id_reservacion;
				// 	$notificacion->tipo = 2;
				// 	$notificacion->id_users = $user->id_usuario;
				// 	$notificacion->visto = 0;
				// 	$notificacion->save();
				// }
				

				// echo "<textarea>".CJSON::encode($model)."</textarea>";
				// echo "<textarea>".CJSON::encode($habitacion)."</textarea>";
				// echo "<textarea>".CJSON::encode($adulto)."</textarea>";
				// echo "<textarea>".CJSON::encode($ninio)."</textarea>";
				
				
				$mail = $this->enviaEmail($model);
				$operacion = Yii::app()->createController('operacionesLog');
				$operacion = $operacion[0];
				$operacion->Create($model->id_reservacion,3,$model->id_usuario);
				
				echo CJSON::encode(array('cupon'=>'A'.$model->id_agencia.'R'.$model->id_reservacion));
				
				/*if(isset($_POST['carrito'])){
					if(empty($_SESSION['pagado'])){
					}else{
						unset($_SESSION['itemcarrito'],$_SESSION['pagado']);
						$this->redirect(array('view','id'=>$model->id_reservacion));
					}
				}else if(isset($_POST['roomlist'])){
					$roomlistHabs = explode(',',$_POST['roomlist']);
					for($i=0;$i<count($roomlistHabs);$i++)
					{
						$roomlistRow = Roominglist::model()->find('id_bloqueo='.$model->id_bloqueo.' and habitacion='.$roomlistHabs[$i]);
						$roomlistRow->id_reservacion = $model->id_reservacion;
						$roomlistRow->id_agencia = $model->id_agencia;
						$roomlistRow->save();
					}
					$this->redirect(array('bloqueos/view','id'=>$model->id_bloqueo));
				}else{}*/
					//$this->redirect(array('view','id'=>$model->id_reservacion));
				
			

			} ### fin de model->save
			else
			{
				print_r($model->getErrors());
			}

		} #### fin de if $_post["reservacion"]
		
	}
	public function noches($fecha_inicio,$fecha_final)
	{
		$datetime1 = new DateTime($fecha_inicio);
		$datetime2 = new DateTime($fecha_final);
		$interval = $datetime1->diff($datetime2);
		$noches= $interval->format('%a');
		return $noches;
	}
	public function saldoHotel($importe,$comision,$tipo){
		
		if ($tipo == "Api") {
		
		$obtener_saldo_h = $importe * $comision;
		
		}else{
		
		$obtener_saldo_h = $importe - ($importe*($comision/100));
		
		}

		return $obtener_saldo_h;
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionEcomercePaypal(){
		header("Content-Type: text/html;charset=utf-8");
		$ch = curl_init();
		$urlWS = "https://rutamayatravel.com/sur4demo/logPaypal/pagarPaypal";
		curl_setopt($ch, CURLOPT_URL, "https://rutamayatravel.com/sur4demo/logPaypal/pagarPaypal");
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE);
		curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "content=".$content);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($ch);

		curl_close($ch);
		echo $response;
		exit;

		if ($err) {
		  echo "cURL Error #:" . $err;
		} else {
		}
	}

	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['SolicitudReservacion']))
		{
			$model->attributes=$_POST['SolicitudReservacion'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_reservacion));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function dateFormat($date, $format=null){
		if ($format) {
			$fecha=date($format, strtotime($date));
		}else{
			$date=explode(' ', $date);
			$fecha=implode('-',array_reverse(explode('/',$date[0])));
		}
		return $fecha;

	}
	public function base($base){
		switch ($base) {
			case 2:
				$code='DOBLE';
				break; 
			case 3:
				$code='TRIPLE';
				break; 
			case 4:
				$code='CUADRUPLE';
				break; 
			case 5:
				$code='QUINTUPLE';
				break; 
			
			default:
				$code='SENCILLA';
				break;
		}
		return $code;

	}
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new SolicitudReservacion('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['SolicitudReservacion']))
		{
                        $model->attributes=$_GET['SolicitudReservacion'];
			
			
                   	
                       if (!empty($model->id_reservacion)) $criteria->addCondition("id_reservacion = '".$model->id_reservacion."'");
                     
                    	
                       if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '".$model->id_agencia."'");
                     
                    	
                       if (!empty($model->id_hotel)) $criteria->addCondition("id_hotel = '".$model->id_hotel."'");
                     
                    	
                       if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '".$model->id_usuario."'");
                     
                    	
                       if (!empty($model->id_agente)) $criteria->addCondition("id_agente = '".$model->id_agente."'");
                     
                    	
                       if (!empty($model->id_bloqueo)) $criteria->addCondition("id_bloqueo = '".$model->id_bloqueo."'");
                     
                    	
                       if (!empty($model->fecha_inicial)) $criteria->addCondition("fecha_inicial = '".$model->fecha_inicial."'");
                     
                    	
                       if (!empty($model->fecha_final)) $criteria->addCondition("fecha_final = '".$model->fecha_final."'");
                     
                    	
                       if (!empty($model->fecha_limite)) $criteria->addCondition("fecha_limite = '".$model->fecha_limite."'");
                     
                    	
                       if (!empty($model->fecha_limite_old)) $criteria->addCondition("fecha_limite_old = '".$model->fecha_limite_old."'");
                     
                    	
                       if (!empty($model->fecha_limite_h)) $criteria->addCondition("fecha_limite_h = '".$model->fecha_limite_h."'");
                     
                    	
                       if (!empty($model->fecha_liberacion)) $criteria->addCondition("fecha_liberacion = '".$model->fecha_liberacion."'");
                     
                    	
                       if (!empty($model->usuario_liberacion)) $criteria->addCondition("usuario_liberacion = '".$model->usuario_liberacion."'");
                     
                    	
                       if (!empty($model->num_noches)) $criteria->addCondition("num_noches = '".$model->num_noches."'");
                     
                    	
                       if (!empty($model->observaciones)) $criteria->addCondition("observaciones = '".$model->observaciones."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    	
                       if (!empty($model->tipo_cambio)) $criteria->addCondition("tipo_cambio = '".$model->tipo_cambio."'");
                     
                    	
                       if (!empty($model->total)) $criteria->addCondition("total = '".$model->total."'");
                     
                    	
                       if (!empty($model->total_tc)) $criteria->addCondition("total_tc = '".$model->total_tc."'");
                     
                    	
                       if (!empty($model->tarifa_neta)) $criteria->addCondition("tarifa_neta = '".$model->tarifa_neta."'");
                     
                    	
                       if (!empty($model->tarifa_agencia)) $criteria->addCondition("tarifa_agencia = '".$model->tarifa_agencia."'");
                     
                    	
                       if (!empty($model->num_habitaciones)) $criteria->addCondition("num_habitaciones = '".$model->num_habitaciones."'");
                     
                    	
                       if (!empty($model->nombre_cliente)) $criteria->addCondition("nombre_cliente = '".$model->nombre_cliente."'");
                     
                    	
                       if (!empty($model->apellido_cliente)) $criteria->addCondition("apellido_cliente = '".$model->apellido_cliente."'");
                     
                    	
                       if (!empty($model->tel_cliente)) $criteria->addCondition("tel_cliente = '".$model->tel_cliente."'");
                     
                    	
                       if (!empty($model->id_tarifa)) $criteria->addCondition("id_tarifa = '".$model->id_tarifa."'");
                     
                    	
                       if (!empty($model->code)) $criteria->addCondition("code = '".$model->code."'");
                     
                    	
                       if (!empty($model->id_tipo_plan)) $criteria->addCondition("id_tipo_plan = '".$model->id_tipo_plan."'");
                     
                    	
                       if (!empty($model->motivo)) $criteria->addCondition("motivo = '".$model->motivo."'");
                     
                    	
                       if (!empty($model->politicas_cancelacion)) $criteria->addCondition("politicas_cancelacion = '".$model->politicas_cancelacion."'");
                     
                    	
                       if (!empty($model->desglose_rate)) $criteria->addCondition("desglose_rate = '".$model->desglose_rate."'");
                     
                    	
                       if (!empty($model->enviado)) $criteria->addCondition("enviado = '".$model->enviado."'");
                     
                    			
                    $session['SolicitudReservacion_records']=SolicitudReservacion::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new SolicitudReservacion('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['SolicitudReservacion']))
			$model->attributes=$_GET['SolicitudReservacion'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=SolicitudReservacion::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='solicitud-reservacion-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['SolicitudReservacion_records']))
               {
                $model=$session['SolicitudReservacion_records'];
               }
               else
                 $model = SolicitudReservacion::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['SolicitudReservacion_records']))
               {
                $model=$session['SolicitudReservacion_records'];
               }
               else
                 $model = SolicitudReservacion::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('SolicitudReservacion Report');
		$pdf->SetSubject('SolicitudReservacion Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("SolicitudReservacion_002.pdf", "I");
	}

	public function actionSendEmailTest($id){
		$model = SolicitudReservacion::model()->findByPk($id);
		$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  VIAJES MAIRMA sid <reservas@viajesmairma.com.mx>\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		$subject = "SOLICITUD DE RESERVA RMTS#".$model->id_reservacion." ".strtoupper($model->nombre_cliente)." ".strtoupper($model->apellido_cliente);
		$message = "<div align='center' style='width:400px;font-family:helvetica'>
		<img src='http://".$_SERVER['SERVER_NAME']."/imagenes/".$model->idAgencia->foto."' style='width:100px'>
		<div style='background:#2196f3;color:#fff;padding:24px;font-size:24px;font-weight:bold'>
		Estimado ".$model->nombre_cliente." ".$model->apellido_cliente."<br>
		Has solicitado una reserva y estos son los datos.
		</div>
		<h4>Solicitud de reservación:</h4>
		<p>No. de solicitud: <strong>".$model->code."</strong><br>

		Hotel: <strong>".$model->idHotel->nombre_hotel."</strong><br>
		Fecha Entrada: <strong>".date('d/m/Y',strtotime($model->fecha_inicial))."</strong><br>
		Fecha Final: <strong>".date('d/m/Y',strtotime($model->fecha_final))."</strong><br>
		Plan: <strong>".$model->idTipoPlan->nombre."</strong><br>
		Noches: <strong>".$model->num_noches."</strong><br>
		No. de Habitaciones: <strong>".$model->num_habitaciones."</strong><br>



		<hr>

		<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
		<h4>Tels: ".$model->idAgencia->tel_agencia."</h4>
		<h4>Atentamente: ".$model->idAgencia->nombre_agencia."</h4>
		</div>";
		$subject2 = "Solicitud de reservación solicitud #".$model->id_reservacion;
		$desglose = SolicitudReservacionDesglose::model()->findAll('id_reservacion='.$model->id_reservacion);
		$num_adultos = 0;
		$num_menores = 0;
		$i = 1;
		$message2 = '<div style="font-family:Helvetica">
		<img src="http://'.$_SERVER['SERVER_NAME'].''.Yii::app()->baseUrl.'/images/logo_rutamaya.jpg" style="width:30px" style="width:30px"><br>
		<table border="1" bordercolor="#000000">
		<tbody>
		<tr>
		<td align="center" colspan="4" style="background:#CCC; font-size:22px">SOLICITUD DE RESERVACION</td>    
		</tr>
		<tr>
		<td>MERIDA, YUC.</td>
		<td>FECHA:</td>
		<td colspan="2">'.date('d/m/Y').'</td>
		</tr>
		<tr>
		<td colspan="3">DEPARTAMENTO DE RESERVACIONES:</td>
		<td align="center">(999) 925 24 43</td>
		</tr>
		<tr>
		<td style="font-size:16px">HOTEL:</td>
		<td colspan="3" style="font-size:16px"><strong>'.strtoupper($model->idHotel->nombre_hotel).'</strong></td>
		</tr>

		<tr>
		<td>FAVOR DE:</td>
		<td align="center" colspan="3" style="font-size:16px"><strong>Confirmar con el cliente</strong></td>
		</tr>
		<tr>
		<td>CUPÓN RMT:</td>
		<td colspan="3">'.$model->id_reservacion.'</td>
		</tr>';
		foreach($desglose as $hab)
		{	
			$pax = SolicitudReservacionDesglosePersona::model()->find('id_desglose='.$hab->id_desglose.' and id_reservacion='.$hab->id_reservacion);
			$menores = SolicitudReservacionDesglosePersona::model()->findAll('id_desglose='.$hab->id_desglose.' and id_reservacion='.$hab->id_reservacion.' and tipo="N"');
			$num_adultos += $hab->num_adultos;
			$num_menores += $hab->num_ninios;
			$message2 .= '<tr>
			<td><strong>PAX '.$i.'</strong></td>
			<td colspan="2"><strong>'.$pax->nombre.' </td><td>HAB '.$hab->idbasehabitacion->base_habitacion;
			if(!empty($menores))
			{
				$message2 .= ' + '.$hab->num_ninios.' MNRS / ';
				foreach($menores as $mnr){
					$message2 .= $mnr->edad.',';
				}
				$message2 = substr($message2, 0, -1);						
				$message2 .= ' AÑOS</strong></td>
				</tr>
				<tr>
				<td colspan="4">&nbsp;</td>
				</tr>';
			}
			else{
				$message2 .= '</strong></td></tr>
				<tr>
				<td colspan="4">&nbsp;</td>
				</tr>';
			}
			$i++;
		}
		$message2 .= '<tr>
		<td>IN:</td>
		<td colspan="3" style="background:#CCC;"><strong>'.date('d/m/Y',strtotime($model->fecha_inicial)).'</strong></td>
		</tr>
		<tr>
		<td>OUT:</td>
		<td colspan="3" style="background:#CCC;"><strong>'.date('d/m/Y',strtotime($model->fecha_final)).'</strong></td>
		</tr>
		<tr>
		<td colspan="4">&nbsp;</td>
		</tr>
		<tr>
		<td>NUM. NOCHES:</td>
		<td colspan="3"><strong>'.$model->num_noches.' NOCHES</strong></td>
		</tr>
		<tr>
		<td>No. HAB:</td>
		<td colspan="3"><strong>'.$model->num_habitaciones.'</strong></td>
		</tr>
		<tr>
		<td>TIPO:</td>
		<td colspan="3"><strong>'.$desglose[0]->idHabitacion->tipo_habitacion.'</strong></td>
		</tr>
		<tr>
		<td>No. ADTS</td>
		<td align="center">'.$num_adultos.'</td>
		<td>No. MNRS</td>
		<td align="center">'.$num_menores.'</td>
		</tr>
		<tr>
		<td>PLAN</td>
		<td colspan="3"><strong>'.$model->idTipoPlan->nombre.'</strong></td>
		</tr>
		<tr>
		<td>COD. TARIFA</td>
		<td colspan="3"><strong>'.$model->idTarifa->nombre_tarifa.' ('.$model->idTarifa->codigo.')</strong></td>
		</tr>
		<tr>
		<td align="center" colspan="4"><strong>OBSERVACIONES:</strong></td>
		</tr>
		<tr>
		<td colspan="4" rowspan="4" style="background:#CCC;"><strong>'.$model->observaciones.'</strong></td>
		</tr>';
		$message2 .= '</tbody></table><br>';
		$message2 .= "Enviado por: <strong>".$model->nombre_cliente." ".$model->apellido_cliente."</strong><br>
		Responder a: <strong>".$model->email."</strong><br>";
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'agencia.viajesmairma.com.mx'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'reservas@agencia.viajesmairma.com.mx'; 
		$mail->Port = '465'; 
		$mail->Password = 'mairma1+.'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 2;
		$mail->SetFrom('reservas@agencia.viajesmairma.com.mx', 'VIAJES MAIRMA'); 
		$mail->Subject = $subject; 
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->MsgHTML($message);
		
		$mail->AddBcc('programador2@rutamayatravel.com', 'programador2');
		$mail->AddAddress('josecanutl21@gmail.com', 'programador3');
		$mail->AddAddress('jorgevadillo@rutamayatravel.com', 'Jorge');

		$mail->Send();

	}

	public function enviaEmail($model)
	{
		$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  VIAJES MAIRMA <reservas@viajesmairma.com.mx>\n";
		// $encabezados .= "X-Sender: <contacto web>\n";
		// $encabezados .= "X-Mailer: PHP\n";
		// $encabezados .= "X-Priority: 3\n";
		// $encabezados .= "Return-Path: <web page>\n";
		$subject = "SOLICITUD DE RESERVA RMTS#".$model->id_reservacion." ".strtoupper($model->nombre_cliente)." ".strtoupper($model->apellido_cliente);
		//$cancelaciones = $this->cancelaciones($model,$model->fecha_inicial,$model->id_tarifa);
		$message = "<div align='center' style='width:400px;font-family:helvetica'>
						<img src='http://".$_SERVER['SERVER_NAME']."/imagenes/".$model->idAgencia->foto."' style='width:100px'>
						<div style='background:#2196f3;color:#fff;padding:24px;font-size:24px;font-weight:bold'>
							Estimado ".$model->nombre_cliente." ".$model->apellido_cliente."<br>
							Has solicitado una reserva y estos son los datos.
						</div>
						<h4>Solicitud de reservación:</h4>
						<p>No. de solicitud: <strong>".$model->code."</strong><br>
						
						Hotel: <strong>".$model->idHotel->nombre_hotel."</strong><br>
						Fecha Entrada: <strong>".date('d/m/Y',strtotime($model->fecha_inicial))."</strong><br>
						Fecha Final: <strong>".date('d/m/Y',strtotime($model->fecha_final))."</strong><br>
						Plan: <strong>".$model->idTipoPlan->nombre."</strong><br>
						Noches: <strong>".$model->num_noches."</strong><br>
						No. de Habitaciones: <strong>".$model->num_habitaciones."</strong><br>
						
						
						
						<hr>

						<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
						<h4>Tels: ".$model->idAgencia->tel_agencia."</h4>
						<h4>Atentamente: ".$model->idAgencia->nombre_agencia."</h4>
					</div>";
		$subject2 = "Solicitud de reservación solicitud #".$model->id_reservacion;
		$desglose = SolicitudReservacionDesglose::model()->findAll('id_reservacion='.$model->id_reservacion);
		$num_adultos = 0;
		$num_menores = 0;
		$i = 1;

		/*<tr>
								<td style="font-size:16px">CLIENTE:</td>
								<td colspan="3" style="font-size:16px"><strong>'.strtoupper($model->nombre_cliente).' '.strtoupper($model->apellido_cliente).'</strong></td>
							</tr>*/
		$message2 = '<div style="font-family:Helvetica">
					<img src="http://'.$_SERVER['SERVER_NAME'].''.Yii::app()->baseUrl.'/images/logo_rutamaya.jpg" style="width:30px" style="width:30px"><br>
					<table border="1" bordercolor="#000000">
						<tbody>
							<tr>
								<td align="center" colspan="4" style="background:#CCC; font-size:22px">SOLICITUD DE RESERVACION</td>    
							</tr>
							<tr>
								<td>MERIDA, YUC.</td>
								<td>FECHA:</td>
								<td colspan="2">'.date('d/m/Y').'</td>
							</tr>
							// <tr>
							// 	<td colspan="3">DEPARTAMENTO DE RESERVACIONES:</td>
							// 	<td align="center">(999) 925 24 43</td>
							// </tr>
							<tr>
								<td style="font-size:16px">HOTEL:</td>
								<td colspan="3" style="font-size:16px"><strong>'.strtoupper($model->idHotel->nombre_hotel).'</strong></td>
							</tr>
							
							<tr>
								<td>FAVOR DE:</td>
								<td align="center" colspan="3" style="font-size:16px"><strong>Confirmar con el cliente</strong></td>
							</tr>
							<tr>
								<td>CUPÓN RMT:</td>
								<td colspan="3">'.$model->id_reservacion.'</td>
							</tr>';
		foreach($desglose as $hab)
		{	
			$pax = SolicitudReservacionDesglosePersona::model()->find('id_desglose='.$hab->id_desglose.' and id_reservacion='.$hab->id_reservacion);
			$menores = SolicitudReservacionDesglosePersona::model()->findAll('id_desglose='.$hab->id_desglose.' and id_reservacion='.$hab->id_reservacion.' and tipo="N"');
			$num_adultos += $hab->num_adultos;
			$num_menores += $hab->num_ninios;
			$message2 .= '<tr>
							<td><strong>PAX '.$i.'</strong></td>
							<td colspan="2"><strong>'.$pax->nombre.' </td><td>HAB '.$hab->idbasehabitacion->base_habitacion;
				if(!empty($menores))
				{
					$message2 .= ' + '.$hab->num_ninios.' MNRS / ';
					foreach($menores as $mnr){
						$message2 .= $mnr->edad.',';
					}
					$message2 = substr($message2, 0, -1);						
					$message2 .= ' AÑOS</strong></td>
								</tr>
								<tr>
									<td colspan="4">&nbsp;</td>
								</tr>';
				}
				else{
					$message2 .= '</strong></td></tr>
								<tr>
									<td colspan="4">&nbsp;</td>
								</tr>';
				}
			$i++;
		}
		$message2 .= '<tr>
						<td>IN:</td>
						<td colspan="3" style="background:#CCC;"><strong>'.date('d/m/Y',strtotime($model->fecha_inicial)).'</strong></td>
					</tr>
					<tr>
						<td>OUT:</td>
						<td colspan="3" style="background:#CCC;"><strong>'.date('d/m/Y',strtotime($model->fecha_final)).'</strong></td>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
					<tr>
						<td>NUM. NOCHES:</td>
						<td colspan="3"><strong>'.$model->num_noches.' NOCHES</strong></td>
					</tr>
					<tr>
						<td>No. HAB:</td>
						<td colspan="3"><strong>'.$model->num_habitaciones.'</strong></td>
					</tr>
					<tr>
						<td>TIPO:</td>
						<td colspan="3"><strong>'.$desglose[0]->idHabitacion->tipo_habitacion.'</strong></td>
					</tr>
					<tr>
						<td>No. ADTS</td>
						<td align="center">'.$num_adultos.'</td>
						<td>No. MNRS</td>
						<td align="center">'.$num_menores.'</td>
					</tr>
					<tr>
						<td>PLAN</td>
						<td colspan="3"><strong>'.$model->idTipoPlan->nombre.'</strong></td>
					</tr>
					<tr>
						<td>COD. TARIFA</td>
						<td colspan="3"><strong>'.$model->idTarifa->nombre_tarifa.' ('.$model->idTarifa->codigo.')</strong></td>
					</tr>
					<tr>
						<td align="center" colspan="4"><strong>OBSERVACIONES:</strong></td>
					</tr>
					<tr>
						<td colspan="4" rowspan="4" style="background:#CCC;"><strong>'.$model->observaciones.'</strong></td>
					</tr>';
		$message2 .= '</tbody></table><br>';
		$message2 .= "Enviado por: <strong>".$model->nombre_cliente." ".$model->apellido_cliente."</strong><br>
					Responder a: <strong>".$model->email."</strong><br>";

		// $mail = new JPhpMailer;
		// $mail->IsSMTP();
		// $mail->Host = 'agencia.viajesmairma.com.mx'; 
		// $mail->SMTPAuth = true;
		// $mail->Username = 'reservas@agencia.viajesmairma.com.mx'; 
		// $mail->Port = '26'; 
		// $mail->Password = 'mairma1+.'; 
		// $mail->SMTPKeepAlive = true;  
		// $mail->Mailer = "smtp"; 
		// $mail->IsSMTP();  
		// $mail->SMTPAuth = true;  
		// $mail->CharSet = 'utf-8';  
		// $mail->SMTPDebug  = 0;
		// $mail->SetFrom('reservas@agencia.viajesmairma.com.mx', 'VIAJES MAIRMA'); 
		// $mail->Subject = $subject; 
		// $mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		// $mail->MsgHTML($message);
		//$mail->AddAddress($model->email, $model->nombre_cliente);
		// $mail->AddBcc('programador2@rutamayatravel.com', 'programador2');
		// $mail->AddAddress('jorgevadillo@rutamayatravel.com', 'Jorge');
		//$mail->AddBcc('reservaciones@rutamayatravel.com');
		
		// $mail->Send();

		// $mail->ClearAddresses();
		// $mail->Subject = $subject2;
		// $mail->MsgHTML($message2);

		 //$mail->AddBcc('programador2@rutamayatravel.com', 'programador2');
		// $mail->AddBcc('programador3@rutamayatravel.com', 'programador3');
		// $mail->AddAddress('jorgevadillo@rutamayatravel.com', 'Jorge');

		//mail('programador3@rutamayatravel.com',$subject2,$message2,$encabezados);
		// $mail->Send();
		
	
	}

	public function cancelaciones($model,$fecha_inicio,$id_tarifa=null)
	{
		$avisoCancelacion = "";
		$cancelacion = Cancelacion::model()->findAll('id_hotel='.$model->id_hotel.' and "'.$fecha_inicio.'" between fecha_inicio and fecha_final ORDER BY dias DESC');
		if(empty($cancelacion))
			$cancelacion = Cancelacion::model()->findAll('id_hotel is null and "'.$fecha_inicio.'" between fecha_inicio and fecha_final ORDER BY dias DESC');
		foreach($cancelacion as $row){
			$fecha = strtotime($fecha_inicio." -".$row->dias." days");
			if(strtotime(date('Y-m-d')) <= $fecha){
				$avisoCancelacion .= "<p>Si cancela hasta el ".date('d/m/Y',$fecha)." tiene penalidad de ".$row->penalizacion." noches</p>";
			}
		}
		if(!empty($cancelacion)){
			$fecha = strtotime($fecha_inicio." -".($row->dias - 1)." days");
			if($fecha < strtotime('now')){
				$fecha = strtotime('now');
			}
			$avisoCancelacion .= "<p>A partir del ".date('d/m/Y',$fecha)." tiene penalización de toda la estancia.</p>";
		}

		if($avisoCancelacion=="")
		{
	        $siteController = Yii::app()->createController('site');
            $siteController = $siteController[0];

            $fecha_limite=$siteController->getFechaLimitePago($model->id_tarifa,$fecha_inicio,$model->id_hotel);

			$avisoCancelacion="<p>Si cancela hasta el ".date("d/m/Y",strtotime($fecha_limite))." tiene penalidad de 0 noches.</p>";
			$avisoCancelacion .= "<p>A partir del ".date('d/m/Y',strtotime($fecha_limite.' +1 days'))." tiene penalización de toda la estancia.</p>";
		}
		return $avisoCancelacion;
	}
}
