<?php
//antes del cambio en el tiempo de carga
Yii::import('application.extensions.bootstrap.gii.*');
$_SESSION["timeTS"] = date("Y-m-d his");
// require_once('bootstrap/tcpdf/tcpdf.php');
// require_once('bootstrap/tcpdf/config/lang/eng.php');
// require_once('../api/travelsolution/TravelSolution.php');
// require_once('../api/beds/HotelApi.php');
class SiteController extends Controller
{
	/**
	 * Declares the behaviors.
	 * @return array the behaviors 
	 */
	public function behaviors()
	{
		return array(
			'seo' => 'ext.seo.components.SeoControllerBehavior',
		);
	}
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	public function accessRules()
	{
		return array(
			array(
				'allow',
				'actions' => array('cotizador', 'promocion', 'error', 'Tarifas', 'TarifasTest', 'getTarifas', 'getHotelTarifas', 'getSamesHotels', 'getSamesDestinations', 'dragMaps', 'index', 'activities', 'tours', 'HotelServDef', 'bloqueo', 'tarifasV2', 'activitiesV2', 'toursV2', 'contactRecaptcha', 'test'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('indexV2', 'ReporteReservaciones', 'Perfil', 'Ventas', 'Corte', 'Cobrar', 'Pagar', 'Recibos', 'Facturas', 'Porpagar', 'Banners', 'Tarifashotel', 'Usuariosagencias', 'BuscarHoteles', 'Sumardias', 'Tarifas2', 'Consultarfechas', 'Cargarfotos', 'Cargarhabitaciones', 'Cotizarapida', 'Tarifasbase', 'Agregarcarrito', 'Vercarrito', 'Eliminarcarrito', 'Vaciarcarrito', 'Imprimircotizacion', 'Checacarrito', 'Validaestados', 'ConsultarBeds', 'AgregarcarritoBeds', 'hotelesBusqueda', 'Estrellas', 'HotelesSugerencias', 'HotelesSugerenciasMismoHotel', 'linkWS', 'miAgencia', 'bloqueos', 'promociones', 'grupos'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('ConsultarTarifas'),
				'roles' => array('verTarifa'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	/**
	 * Declares class-based actions.
	 * @return array the actions
	 */
	public function actions()
	{
		return array(
			'captcha' => array(
				'class' => 'CCaptchaAction',
				'backColor' => 0xFFFFFF,
			),
		);
	}

	public function actionTest() {
		$model_log = LogAvail::model()->findByPk(664);

		// $tbl = "tbl_log_avail";
		$tbl = "tbl_log_book";
		$id = 255;
		$getLogs=$this->getLogs($id,$tbl);
		if ($getLogs) {
			$log=$getLogs;
		}else if(empty($log)){
			$log= LogHotelbeds::model()->findByPk($id);
			$log= json_decode(CJSON::encode($log),true);	
		}else {
			$log= LogHotelbeds0::model()->findByPk($id);
			$log= json_decode(CJSON::encode($log),true);
		}

		echo $log['request'];
	}

	public function getLogs($id,$tbl)
	{
		$sql="SELECT CONVERT( UNCOMPRESS( response ) USING utf8 )  as res,  CONVERT( UNCOMPRESS( request ) USING 'utf8' )  as req FROM ".$tbl." WHERE id= ".$id;
			$res=Yii::app()->db->createCommand($sql)->queryRow();
			
			$request=base64_decode($res['req']);
			$response=base64_decode($res['res']);
		if ($res) {
			return array('request'=>$request,'response'=>$response);
		}else{
			return false;
		}

	}
	
	
	

	public function actionActivities()
	{
		$this->layout = "//layouts/ansonika_site";
		$this->render('/activities/activities');
	}

	public function actionActivitiesV2() {
		$this->layout = "//layouts/general_layout";
		$this->render("general", array(
			"render" => "activities"
		));
	}

	public function actionTours()
	{
		$this->inicioSesion($_GET);
		$this->layout = "//layouts/ansonika_site";
		$this->render('/tour/tours');
	}

	public function actionToursV2() {
		$this->render("tarifasV2/tours");
	}

	public function actionCotizador($idApi)
	{

		header('Access-Control-Allow-Origin: *');
		$agencia = Agencias::model()->findByPk($idApi);
		// $user = Usuarios::model()->find('id_agencia='.$idApi);
		$this->layout = "//layouts/cotiz_layout";
		$this->renderPartial('cotizador', array('agencia' => $agencia));
	}
	public function actionBloqueo()
	{

		header('Access-Control-Allow-Origin: *');
		$this->layout = "//layouts/cotiz_layout";
		$this->renderPartial('bloqueowidget');
	}
	public function actionPromocion()
	{

		header('Access-Control-Allow-Origin: *');
		$this->layout = "//layouts/cotiz_layout";
		$this->renderPartial('promocioneswidget');
	}


	public function inicioSesion($agencia)
	{
		if (isset($_SESSION['agenciaUsuario'])) {
			$_SESSION["tipoUsuario"] = 'Agencia';
			$_SESSION["agenciaUsuario"] = $agencia['id_agencia'];
			$agencia = Agencias::model()->findByPk($agencia['id_agencia']);
			$_SESSION["agencia"] = $agencia;
		}
	}

	public function actionMiAgencia()
	{
		$this->layout = "//layouts/ansonika_site";
		$this->render('miAgencia');
	}

	public function actionBloqueos()
	{
		$this->layout = "//layouts/ansonika_site";
		$this->render('bloqueos');
	}

	public function actionPromociones()
	{
		$this->layout = "//layouts/ansonika_site";
		$this->render('promociones');
	}

	public function actionGrupos()
	{
		$this->layout = "//layouts/ansonika_site";
		$this->render('grupos');
	}

	public function actionValidaestados()
	{
		$tarifas = Tarifa::model()->findAll('estatus=1 and current_date <= fecha_promo');
		foreach ($tarifas as $row) {
			$estados = TarifaEstados::model()->findAll('id_tarifa=' . $row->id_tarifa);
			if (empty($estados)) {
				for ($i = 1; $i <= 32; $i++) {
					$estado = new TarifaEstados;
					$estado->id_tarifa = $row->id_tarifa;
					$estado->id_estado = $i;
					$estado->save();
				}
				echo $row->id_tarifa . "<br>";
			}
		}
		echo "OK";
	}

	public function actionHotelServDef()
	{

		$this->renderPartial('_servicios', array('id_hotel' => $_POST['id_hotel'], 'broker' => $_POST['proveedor']));
	}
	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionLinkWs()
	{
		echo 'https://' . $_SERVER["SERVER_NAME"] . Yii::app()->request->baseUrl . '/getTarifas/ObtenerTarifas';
	}


	public function actionIndex()
	{
		session_start();
		$criteria_anuncios =new CDbCriteria;
		$criteria_anuncios->addCondition("estado = 'activo'");
		$criteria_anuncios->limit = 6;
		$criteria_anuncios->order = 'RAND()';
		$model_anuncios = RentasvAnuncios::model()->findAll($criteria_anuncios);
		$this->layout = "//layouts/homezV6";
	    $this->render('index', array("model_anuncios" => $model_anuncios));
	}

	public function actionContactRecaptcha(){
		define('CLAVE', '6Lcs7jgpAAAAAMrjduO03t7qFPtjNTTqmgCZuRWW');

		$token 	= $_POST['token'];
		$action = $_POST['action'];

		$curl = curl_init();
		curl_setopt_array($curl, array(
		CURLOPT_URL            => 'https://www.google.com/recaptcha/api/siteverify',
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING       => '',
		CURLOPT_MAXREDIRS      => 10,
		CURLOPT_TIMEOUT        => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST  => 'POST',
		CURLOPT_POSTFIELDS     => http_build_query(array('secret' => CLAVE, 'response' => $token)),
		CURLOPT_HTTPHEADER     => array(),
		));
		$responseRecaptcha = curl_exec($curl); 
		curl_close($curl);

		$dataRecaptcha = json_decode($responseRecaptcha, true);

		if ($dataRecaptcha['score'] > 0.5) {
			echo "Se manda correo";
		}else{
			echo "Es un robot";
		}
	}

	public function actionIndexV2()
	{
		$this->layout = "//layouts/ansonika_site";
		if (Yii::app()->user->isGuest) {
			$this->redirect(Yii::app()->user->loginUrl);
		} else {
			$usuario = Usuarios::model()->findByPk(Yii::app()->user->id);
			$reservaciones = $this->cuentaxpagar($usuario->id_agencia);
			$banners = Banners::model()->findAll(array('condition' => 'estatus=1 and current_date() between fecha_inicial and fecha_final', 'order' => 'posicion'));
			$countries = Countries::model()->findAll();

			$this->render('indexV2', array(
				'porPagar' => $reservaciones[0]["apagar"],
				'num_reservaciones' => $reservaciones[0]["num_reservaciones"], 'banners' => $banners, 'countries' => $countries
			));
		}
	}

	public function cuentaxpagar($idAgencia)
	{
		$sql = "select SUM(total) apagar, COUNT(*) as num_reservaciones
					from tbl_reservacion r
					where libera_cupon=1 and saldo>0 and estatus!='C' ";
		if ($idAgencia > 1)
			$sql .= " and r.id_agencia=" . $idAgencia;
		$row = Yii::app()->db->createCommand($sql)->queryAll();
		foreach ($row as $data) {
			$row[] = $data;
		}
		return $row;
	}

	public function actionBuscarHoteles()
	{
		if (isset($_POST['id_destino'])) {
			if ($_POST['id_destino'] != "") {
				$destino = 'and id_destinoLocal=' . $_POST['id_destino'];
			}
			$hoteles = Hoteles::model()->with('tarifas')->findAll(array('order' => 'nombre_hotel', 'condition' => 't.proveedor=0 and t.estatus=1 ' . $destino));
			$this->renderPartial('listahoteles', array('hoteles' => $hoteles));
		}
	}

	public function actionConsultarTarifas()
	{
		if (isset($_POST['id_destino'])) {
			$fechas = 'and(fecha_inicial between "' . date('Y-m-d') . '" and "' . date('Y-m-d', strtotime('today +90 days')) . '" or fecha_final between "' . date('Y-m-d') . '" and "' . date('Y-m-d', strtotime('today +90 days')) . '")';
			$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
			$precios = 'and t.precio="PROMO"';
			if ($_POST['fecha_inicio'] != "" && $_POST['fecha_final'] != "") {
				$fecha_inicio = implode("-", array_reverse(explode("/", $_POST['fecha_inicio'])));
				$fecha_final = implode("-", array_reverse(explode("/", $_POST['fecha_final'])));
				$fechas = 'and(fecha_inicial between "' . $fecha_inicio . '" and "' . $fecha_final . '" or fecha_final between "' . $fecha_inicio . '" and "' . $fecha_final . '")';
			}
			if (!empty($_POST['precios'])) {
				$precios = 'and(';
				$i = 0;
				foreach ($_POST['precios'] as $row) {
					if ($i != 0) {
						$precios .= ' or ';
					} else {
						$i = 1;
					}
					$precios .= 't.precio="' . $row . '"';
				}
				$precios .= ')';
			}
			$model = Tarifa::model()->with('tarifaDestino', 'tarifaDesgloses')->findAll(array('condition' => 'tarifaDestino.id_destinoLocal=' . $_POST['id_destino'] . ' ' . $precios . ' ' . $fecha_promo . ' and precio_normal between ' . $_POST['preciomin'] . ' and ' . $_POST['preciomax'] . ' ' . $fechas . ' and t.estatus=1', 'order' => 'nombre_hotel'));
			$this->renderPartial('tablatarifas', array('model' => $model));
		} else {
			$this->render('tarifasgrid', array());
		}
	}

	public function actionSumardias()
	{
		if ($_POST['fecha_inicial'] != "" && $_POST['noches'] > 0) {
			$fecha = array_reverse(explode("/", $_POST['fecha_inicial']));
			$nuevafecha = date('Y-m-d', mktime(0, 0, 0, $fecha[1], $fecha[2] + $_POST['noches'], $fecha[0]));
			$nuevafecha = implode("/", array_reverse(explode("-", $nuevafecha)));
			echo CJSON::encode(array(
				'fecha_final' => $nuevafecha
			));
		}
		if ($_POST['fecha_inicial'] != "" && $_POST['fecha_final'] != "") {
			$fecha_inicial = implode("-", array_reverse(explode("/", $_POST["fecha_inicial"])));
			$fecha_final = implode("-", array_reverse(explode("/", $_POST["fecha_final"])));
			$datetime1 = new DateTime($fecha_inicial);
			$datetime2 = new DateTime($fecha_final);
			$interval = $datetime1->diff($datetime2);
			$noches = $interval->format('%a');
			echo CJSON::encode(array(
				'noches' => $noches
			));
		}
	}
	public function actionTarifasTest()
	{
		unset($_SESSION['Formulario_reservar']);
		$this->layout = "//layouts/bootstrap_layout";

		$this->render('index_prueba', array());
	}

	public function actionTarifas()
	{
		unset($_SESSION['Formulario_reservar']);
		$this->layout = "//layouts/bootstrap_layout";
		$destino = explode('_', $_GET['destino']);

		if ($destino[0] == "h") {
			$this->layout = "//layouts/ansonika_site";
			$fotos = HotelesFotos::model()->findAll('id_hotel=' . $destino[1] . ' and logotipo!=1');
			$hotel = Hoteles::model()->findByPk($destino[1]);

			$this->render('detalle_promo', array('fotos' => $fotos, 'hotel' => $hotel));
		} else if ($_GET['dev'] == 1) {
			$this->render('tarifas_hotelesV2', array());
		} else {
			$this->render('tarifas_hoteles', array());
		}
	}

	public function actionTarifasV2() {
		unset(Yii::app()->session['epayco']);
		unset(Yii::app()->session['datos_generales']);		
		$this->layout = "//layouts/tarifas_layout";
		$this->render("tarifasV2/hotels-rates");
	}

	/* CONSULTA DE TARIFAS
	Metodo para consultar las tarifas de los hoteles del sistema local
	*/
	public function actionTarifasold()
	{
		$this->layout = "//layouts/bootstrap_layout";
		//$this->layout = "//layouts/ansonika_site";
		if (isset($_GET)) {
			// echo "<textarea>".json_encode($_POST)."</textarea>";
			$tarifa = new Tarifa;
			$cadena = new CadenaHotel;
			$zonas = new Zonasbeds;
			$hotel = new Hoteles;
			$session = new CHttpSession;
			$session->open();
			$fecha_inicial = implode("-", array_reverse(explode("/", $_GET["fecha_entrada"])));
			$fecha_final = implode("-", array_reverse(explode("/", $_GET["fecha_salida"])));
			$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
			$hora = "and curtime() between hora_inicio and hora_final";
			$early_booking = "and (early_booking is null or DATEDIFF('" . $fecha_inicial . "',current_date) <= early_booking)";
			$tipo_precio = "";
			$tipo_plan = "";
			$proveedor = "";
			$categoria = "";
			$solo_adultos = "";
			$datetime1 = new DateTime($fecha_inicial);
			$datetime2 = new DateTime($fecha_final);
			$interval = $datetime1->diff($datetime2);
			$noches = $interval->format('%a');
			unset($_SESSION['data']);

			$busquedaController = Yii::app()->createController('busqueda');
			$busquedaController = $busquedaController[0];
			$riuController = Yii::app()->createController('riu');
			$riuController = $riuController[0];
			$palaceController = Yii::app()->createController('palace');
			$palaceController = $palaceController[0];
			$habitacionesRQ = array();

			if (empty($_SESSION['loginRiu'])) {
				$_SESSION['loginRiu'] = $riuController->login();
			}

			//ALMACENA VARIABLES DE BUSQUEDA EN SESSION FRONT_FORM PAX
			$cuartos = array();
			if (!empty($_GET['habs'])) {
				if (!empty($_SESSION['front_form'])) {
					unset($_SESSION['front_form']);
					unset($_SESSION['cuartosParaRatesKeys']);
					$_SESSION['info_search'] = array();
				}

				$habs = $_GET['habs'];
				$_SESSION['front_form']['habs'] = $habs;
				$_SESSION['front_form']['solo_adultos'] = "";

				for ($i = 1; $i <= $habs; $i++) {
					if (!empty($_GET['habitacion_' . $i]['adultos'])) {
						$adultos = $_GET['habitacion_' . $i]['adultos'];
						$_SESSION['front_form']['habitacion_' . $i]['adultos'] = $adultos;
						$_SESSION['info_search']['habitaciones'][$i]['adultos'] = $adultos;
						$cuarto = "1~" . $_SESSION['front_form']['habitacion_' . $i]['adultos'] . "~"; //PARA RATEKEYS
					}
					$num_ninios = $_GET['habitacion_' . $i]['num_ninios'];
					$_SESSION['front_form']['habitacion_' . $i]['num_ninios'] = $num_ninios;
					$_SESSION['info_search']['habitaciones'][$i]['no_menores'] = $num_ninios;
					$cuarto .= $_SESSION['front_form']['habitacion_' . $i]['num_ninios'] . "|"; //PARA RATEKEYS
					if (!empty($num_ninios)) {
						$edadesArray = array();
						for ($j = 1; $j <= $num_ninios; $j++) {
							if (isset($_GET['habitacion_' . $i]['edad_' . $j])) {
								$edad = $_GET['habitacion_' . $i]['edad_' . $j];
								$_SESSION['front_form']['habitacion_' . $i]['edad_' . $j] = $edad;
								if ($num_ninios > 0) {
									array_push($edadesArray, $edad);
								}

								$cuarto .= $_SESSION['front_form']['habitacion_' . $i]['edad_' . $j] . "~"; //PARA RATEKEYS
								$_SESSION['front_form']['solo_adultos'] = "SOLOADULTOS";
								// echo $_SESSION['front_form']['habitacion_'.$i]['edad_'.$j];						
							}
						}
						rsort($edadesArray);
						$_SESSION['info_search']['habitaciones'][$i]['menores'] = $edadesArray;
					}
					$_SESSION['front_form']['info_search'] = $_SESSION['info_search']['habitaciones'];

					if ($_SESSION['front_form']['habitacion_' . $i]['num_ninios'])
						$cuarto = substr($cuarto, 0, -1); //PARA RATKEYS

					array_push($cuartos, $cuarto); //PARA RATEKEYS

				}

				$_SESSION['cuartosParaRatesKeys'] = $busquedaController->agrupaCantidad($cuartos); //PARA RATES KEYS
				$_SESSION['front_form']['cuartosParaRatesKeys'] = $busquedaController->agrupaCantidad($cuartos);
			}

			$_SESSION['front_form']['fecha_ini'] = $_GET['fecha_entrada'];
			$_SESSION['front_form']['fecha_fin'] = $_GET['fecha_salida'];

			$_SESSION['info_search']['entrada'] = $_GET['fecha_entrada'];
			$_SESSION['info_search']['salida'] = $_GET['fecha_salida'];

			$habitaciones = $_SESSION['front_form']['habs'];

			//cuando recibas el destino identificar el tipo de destino.
			if (!empty($_GET["destino"])) {
				$_SESSION['front_form']['destino'] = $_GET["destino"];
				$destino = explode('_', $_GET["destino"]);
				if ($destino[0] == 'd') {
					$id_destino = $destino[1];
				} else if ($destino[0] == 'c') {
					$id_cadena = $destino[1];
				} else if ($destino[0] == 'h') {
					$id_hotel = $destino[1];
				} else if ($destino[0] == 'z') {
					$id_zona = $destino[1];
				}

				$cadena->id = $id_cadena;
				$hotel->id_hotel = $id_hotel;
			}

			if ($_SESSION['front_form']['solo_adultos'] != "") {
				$solo_adultos = 'AND solo_adultos=0';
			}

			if (isset($_GET['nombre_hotel']) && !empty($_GET['nombre_hotel'])) {
				$nombreHotel = " AND nombre_hotel LIKE '%" . $_GET['nombre_hotel'] . "%' ";
			} else {
				$nombreHotel = "";
			}

			// $proveedor='and proveedor NOT IN (2)';
			// $proveedor='and proveedor IN (0,1,2,4,5,6)';
			// $proveedor='and proveedor IN (2)';
			if (count($_GET["Hoteles"]["proveedor"]) == 1) {
				foreach ($_GET["Hoteles"]["proveedor"] as $key => $value) {
					if ($value == 0) {
						$proveedor = 'and proveedor IN (0,2,4,5,6)';
					} else if ($value == 1) {
						$proveedor = 'and proveedor IN (1,3)';
					}
				}
			}

			if ($_GET['tipoPrecio']) {
				$_SESSION['front_form']['tipoPrecio'] = $_GET['tipoPrecio'];
				$tipoPrecio = array('OUTLET');
				//$tipoPrecio = array('OUTLETGRUPOS');
				$fecha_promo = "and (current_date between fecha_promo_inicio and fecha_promo or fecha_promo>='" . date('Y-m-d') . "')";
				$proveedor = 'and proveedor=0';
			} else {
				$_SESSION['front_form']['tipoPrecio'] = "";
				//$tipoPrecio = array('OUTLET','PROMO','NORMAL','VIP','OUTLETGRUPOS');
				$tipoPrecio = array('OUTLET', 'PROMO', 'NORMAL', 'VIP');
			}

			if (!empty($_GET['Tarifa']['id_tipo_plan'])) {
				$planHotel = Plan::model()->findByPk($_GET['Tarifa']['id_tipo_plan']);
				$_SESSION['front_form']['tipoPlan'] = $planHotel;
				$_SESSION['front_form']['id_tipoPlan'] = $_SESSION['front_form']['tipoPlan']->id_plan;
				$tipo_plan = 'and t.id_tipo_plan="' . $_SESSION['front_form']['tipoPlan']->id_plan . '"';
				$tarifa->id_tipo_plan = $_GET['Tarifa']['id_tipo_plan'];
			} else {
				$_SESSION['front_form']['tipoPlan'] = null;
				$_SESSION['front_form']['id_tipoPlan'] = null;
			}

			$estrellas = array();
			if (!empty($_GET["Hoteles"]["id_categoria"])) {
				$hotel->id_categoria = $_GET["Hoteles"]["id_categoria"];
				$_SESSION['front_form']['categoria'] = $_GET["Hoteles"]["id_categoria"];
				foreach ($_GET["Hoteles"]["id_categoria"] as $star) {
					$estrellas[] = $star;
				}
				$categoria = " and tarifaHotel.id_categoria IN (" . implode(", ", $estrellas) . ")";
			} else {
				$_SESSION['front_form']['categoria'] = null;
			}

			if (isset($_GET['ORDER_PRECIO'])) {
				$ORDER_PRECIO = $_GET['ORDER_PRECIO'];
			} else {
				$ORDER_PRECIO = "ASC";
			}
			$agencia = Agencias::model()->findByPk($_GET['id_agencia']);
			$_SESSION['front_form']['agenciaUsuario'] = $_GET['id_agencia'];
			$_SESSION['front_form']['estadoUsuario'] = $agencia->id_estado_agencia;

			$_SESSION['front_form']['agencia'] = $agencia;
			$_SESSION['front_form']['tipoUsuario'] = 'Agencia';

			if (!empty($id_hotel)) {
				$noresults = 0;
				$hoteles = Hoteles::model()->findAll('id_hotel=' . $id_hotel . ' and estatus=1 and no_listar = 1');
				/*$hotel=Hoteles::model()->find('id_hotel='.$id_hotel.' and estatus=1');
				$hoteles=Hoteles::model()->findAll('nombre_hotel="'.$hotel->nombre_hotel.'" and estatus=1');*/
				$rowscount = count($hoteles);
			} else if (!empty($id_destino)) {
				$noresults = 0;
				$zonas = Zonasbeds::model()->findAll('destinationsCode="' . $id_destino . '"');
				foreach ($zonas as $zona) {
					$listazonas .= $zona->idZona . ',';
				}
				$listazonas = substr($listazonas, 0, -1);
				$hoteles = Hoteles::model()->findAll(array('condition' => 'id_destino IN(' . $listazonas . ') and estatus=1 and no_listar = 1 ' . $proveedor . ' ' . $solo_adultos . $nombreHotel));
				$rowscount = count($hoteles);
			} else if (!empty($id_cadena)) {
				$noresults = 0;
				$hoteles = Hoteles::model()->findAll(array('condition' => 'id_cadena=' . $id_cadena . ' and estatus=1 and no_listar = 1 ' . $proveedor . ' ' . $solo_adultos . $nombreHotel));
				$rowscount = count($hoteles);
			} else if (!empty($id_zona)) {
				$noresults = 0;
				$hoteles = Hoteles::model()->findAll(array('condition' => 'id_destino=' . $id_zona . ' and estatus=1 and no_listar = 1 ' . $proveedor . ' ' . $solo_adultos . $nombreHotel));
				$rowscount = count($hoteles);
			}

			$i = 0;
			$countHotels = count($hoteles);
			foreach ($hoteles as $killing => $row) {
				switch ($row->proveedor) {
					case '0':
						$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
						//$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["proveedor"]=$row->proveedor;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"] = $row->codigo;
						if ($countHotels == 1) {
							$hotelesRQ = (object) $hotelesRQ;
						}
						break;
					case '1':
						$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
						//$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["proveedor"]=$row->proveedor;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"] = $row->codigo;
						break;
					case '2':
						$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
						//$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["proveedor"]=$row->proveedor;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"] = $row->codigo;
						break;
					case '3':
						$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
						//$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["proveedor"]=$row->proveedor;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"] = $row->codigo;
						break;
					case '4':
						$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
						//$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["proveedor"]=$row->proveedor;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"] = $row->codigo;
						break;
					case '5':
						$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
						//$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["proveedor"]=$row->proveedor;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"] = $row->codigo;
						break;
					case '6':
						$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
						//$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["proveedor"]=$row->proveedor;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"] = $row->codigo;
						break;
					default:
						break;
				}
				$i++;
			}

			//sirve para mostrar el error en el return, 0 es via sistema e ignora los errores del try catch, 1 es via postman y muestra el error en el return
			$_SESSION['front_form']['request_url'] = 0;

			$habitacionesRQ = array(
				'fecha_inicial' => $fecha_inicial,
				'fecha_final' => $fecha_final,
				'fecha_promo' => $fecha_promo,
				'hora' => $hora,
				'early_booking' => $early_booking,
				'noches' => $noches,
				'habitaciones' => $habitaciones,
				'proveedor' => $proveedor,
				'categoria' => $categoria,
				'tipo_precio' => $tipo_precio,
				'tipo_plan' => $tipo_plan,
				'ORDER_PRECIO' => $ORDER_PRECIO,
				'rowscount' => $rowscount,
				'noresults' => $noresults,
				'filtro_disponibilidad' => $_GET['filtro_disponibilidad'],
				'hotel' => $hotel,
				'tarifa' => $tarifa,
				'totalHoteles' => count($hoteles),
			);

			$_SESSION["resultadoBusquedaHoteles"] = array(
				'fecha_inicial' => $fecha_inicial,
				'fecha_final' => $fecha_final,
				'fecha_promo' => $fecha_promo,
				'hora' => $hora,
				'early_booking' => $early_booking,
				'noches' => $noches,
				'habitaciones' => $habitaciones,
				'proveedor' => $proveedor,
				'categoria' => $categoria,
				'tipo_precio' => $tipo_precio,
				'tipo_plan' => $tipo_plan,
				'ORDER_PRECIO' => $ORDER_PRECIO,
				'rowscount' => $rowscount,
				'noresults' => $noresults,
				'filtro_disponibilidad' => $_GET['filtro_disponibilidad'],
				'hotel' => $hotel,
				'tarifa' => $tarifa,
				'totalHoteles' => count($hoteles),
			);

			if (is_array($hotelesRQ)) {
				$hotelesRQ = (object) $hotelesRQ;
			}

			// echo json_encode($hotelesRQ);
			$this->render('index_prueba', array("hotelesRQ" => $hotelesRQ, "habitacionesRQ" => $habitacionesRQ, "front_form" => $_SESSION['front_form']));

			//$this->render('index_prueba', $_SESSION["resultadoBusquedaHoteles"]);

		} else if ($_SESSION['data']) {
			$this->render('index_prueba', $_SESSION["resultadoBusquedaHoteles"]);
		} else {
			$this->redirect('index');
		}
	}


    public function actionGetTarifas()
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header("Allow: GET, POST, OPTIONS, PUT, DELETE");
		header('Content-Type: application/json; charset=utf-8');
		if (isset($_GET)) {
			$tarifa  = new Tarifa();
			$cadena  = new CadenaHotel();
			$zonas   = new Zonasbeds();
			$hotel   = new Hoteles();
			$session = new CHttpSession();
			$session->open();
			$fecha_inicial = implode("-", array_reverse(explode("/", $_GET["fecha_entrada"])));
			$fecha_final   = implode("-", array_reverse(explode("/", $_GET["fecha_salida"])));
			$fecha_promo   = "and current_date between fecha_promo_inicio and fecha_promo";
			$hora          = "and curtime() between hora_inicio and hora_final";
			$early_booking = "and (early_booking is null or DATEDIFF('" . $fecha_inicial . "',current_date) <= early_booking)";
			$tipo_precio   = "";
			$tipo_plan     = "";
			$proveedor     = "";
			$categoria     = "";
			$solo_adultos  = "";
			$datetime1     = new DateTime($fecha_inicial);
			$datetime2     = new DateTime($fecha_final);
			$interval      = $datetime1->diff($datetime2);
			$noches        = $interval->format('%a');
			unset($_SESSION['data']);
			// $outlet             = Outlet::model()->find('estatus=1 and current_date between fecha_inicio and fecha_final');
			$busquedaController = Yii::app()->createController('busqueda')[0];
			// $riuController      = Yii::app()->createController('riu')[0];
			//$palaceController   = Yii::app()->createController('palace')[0];
			$habitacionesRQ     = array();
			// $outletController   = Yii::app()->createController('outlet')[0];
			// if (empty($_SESSION['loginRiu'])) {
			// 	$_SESSION['loginRiu'] = $riuController->login();
			// }
			$cuartos = array();
			if (!empty($_GET['habs'])) {
				if (!empty($_SESSION['front_form'])) {
					unset($_SESSION['front_form']);
					unset($_SESSION['cuartosParaRatesKeys']);
					$_SESSION['info_search'] = array();
				}
				$habs                                   = $_GET['habs'];
				$_SESSION['front_form']['habs']         = $habs;
				$_SESSION['front_form']['solo_adultos'] = "";
				for ($i = 1; $i <= $habs; $i++) {
					if (!empty($_GET['habitacion_' . $i]['adultos'])) {
						$adultos                                                = $_GET['habitacion_' . $i]['adultos'];
						$_SESSION['front_form']['habitacion_' . $i]['adultos']  = $adultos;
						$_SESSION['info_search']['habitaciones'][$i]['adultos'] = $adultos;
						$cuarto                                                 = "1~" . $_SESSION['front_form']['habitacion_' . $i]['adultos'] . "~"; //PARA RATEKEYS
					}
					$num_ninios                                                = $_GET['habitacion_' . $i]['num_ninios'];
					$_SESSION['front_form']['habitacion_' . $i]['num_ninios']  = $num_ninios;
					$_SESSION['info_search']['habitaciones'][$i]['no_menores'] = $num_ninios;
					$cuarto .= $_SESSION['front_form']['habitacion_' . $i]['num_ninios'] . "|";
					if (!empty($num_ninios)) {
						$edadesArray = array();
						for ($j = 1; $j <= $num_ninios; $j++) {
							if (isset($_GET['habitacion_' . $i]['edad_' . $j])) {
								$edad                                                     = $_GET['habitacion_' . $i]['edad_' . $j];
								$_SESSION['front_form']['habitacion_' . $i]['edad_' . $j] = $edad;
								if ($num_ninios > 0) {
									array_push($edadesArray, $edad);
								}
								$cuarto .= $_SESSION['front_form']['habitacion_' . $i]['edad_' . $j] . "~";
								$_SESSION['front_form']['solo_adultos'] = "SOLOADULTOS";
							}
						}
						rsort($edadesArray);
						$_SESSION['info_search']['habitaciones'][$i]['menores'] = $edadesArray;
					}
					$_SESSION['front_form']['info_search'] = $_SESSION['info_search']['habitaciones'];
					if ($_SESSION['front_form']['habitacion_' . $i]['num_ninios']) {
						$cuarto = substr($cuarto, 0, -1);
					}
					array_push($cuartos, $cuarto);
				}
				$_SESSION['cuartosParaRatesKeys']               = $busquedaController->agrupaCantidad($cuartos); //PARA RATES KEYS
				$_SESSION['front_form']['cuartosParaRatesKeys'] = $busquedaController->agrupaCantidad($cuartos);
			}
			$_SESSION['front_form']['fecha_ini'] = $_GET['fecha_entrada'];
			$_SESSION['front_form']['fecha_fin'] = $_GET['fecha_salida'];
			$_SESSION['info_search']['entrada']  = $_GET['fecha_entrada'];
			$_SESSION['info_search']['salida']   = $_GET['fecha_salida'];
			if ($_GET['outlet']) {
				$_SESSION['front_form']['outlet'] = $_GET['outlet'];
			}
			if ($_GET['tarifa']) {
				$_SESSION['front_form']['tarifa'] = $_GET['tarifa'];
			}
			$habitaciones = $_SESSION['front_form']['habs'];
			if (!empty($_GET["destino"])) {
				$_SESSION['front_form']['destino'] = $_GET["destino"];
				$destino                           = explode('_', $_GET["destino"]);
				if ($destino[0] == 'd') {
					$id_destino = $destino[1];
				} else if ($destino[0] == 'c') {
					$id_cadena  = $destino[1];
					$cadena->id = $id_cadena;
				} else if ($destino[0] == 'h') {
					$id_hotel        = $destino[1];
					$hotel->id_hotel = $id_hotel;
					if ($id_hotel != 395 && $id_hotel != 394) {
						unset($_GET['tarifa']);
					}
				} else if ($destino[0] == 'z') {
					$id_zona = $destino[1];
				} else if ($destino[0] == 'e') {
					$id_usuario_extranet = $destino[1];
				}
			}
			if ($_SESSION['front_form']['solo_adultos'] != "") {
				$solo_adultos = 'AND solo_adultos=0';
			}
			if (isset($_GET['nombre_hotel']) && !empty($_GET['nombre_hotel'])) {
				$nombreHotel = " AND nombre_hotel LIKE '%" . $_GET['nombre_hotel'] . "%' ";
			} else {
				$nombreHotel = "";
			}
			if ($_GET['proveedores']) {
				$proveedor = 'and proveedor IN (' . $_GET["proveedores"] . ')';
			} else {
				$proveedor = 'and proveedor NOT IN (6,3,1)';
			}
			if ($_GET['proveedores'] === '0') {
				$proveedor = 'and proveedor = 0';
			}
			if ($_GET['movil'] == 1 && $_GET['proveedores']) {
				$proveedor = 'and proveedor IN (0,2)';
			}
			if ($_GET['tipoPrecio']) {
				$_SESSION['front_form']['tipoPrecio'] = $_GET['tipoPrecio'];
				$fecha_promo = "and (current_date between fecha_promo_inicio and fecha_promo or fecha_promo>='" . date('Y-m-d') . "')";
				$proveedor   = 'and proveedor=0';
			} else {
				$_SESSION['front_form']['tipoPrecio'] = "";
			}
			if (!empty($_GET['plan'])) {
				$planHotel                             = Plan::model()->findByPk($_GET['plan']);
				$_SESSION['front_form']['tipoPlan']    = $planHotel;
				$_SESSION['front_form']['id_tipoPlan'] = $_SESSION['front_form']['tipoPlan']->id_plan;
				$tipo_plan                             = 'and t.id_tipo_plan="' . $_SESSION['front_form']['tipoPlan']->id_plan . '"';
				$tarifa->id_tipo_plan                  = $_GET['plan'];
			} else {
				$_SESSION['front_form']['tipoPlan']    = null;
				$_SESSION['front_form']['id_tipoPlan'] = null;
			}
			$estrellas = array();
			if (!empty($_GET["Hoteles"]["id_categoria"])) {
				$hotel->id_categoria                 = $_GET["Hoteles"]["id_categoria"];
				$_SESSION['front_form']['categoria'] = $_GET["Hoteles"]["id_categoria"];
				foreach ($_GET["Hoteles"]["id_categoria"] as $star) {
					$estrellas[] = $star;
				}
				$categoria = " and tarifaHotel.id_categoria IN (" . implode(", ", $estrellas) . ")";
			} else {
				$_SESSION['front_form']['categoria'] = null;
			}
			if (isset($_GET['ORDER_PRECIO'])) {
				$ORDER_PRECIO = $_GET['ORDER_PRECIO'];
			} else {
				$ORDER_PRECIO = "ASC";
			}
			$_SESSION['front_form']['agenciaUsuario'] = $_SESSION["agenciaUsuario"];
			$_SESSION['front_form']['estadoUsuario']  = $_SESSION["estadoUsuario"];
			// if ($_GET['keyU']) {
			// 	$usuario     = Profiles::model()->findByPk($_GET['keyU']);
			// 	$tipoUsuario = $usuario->tipo;
			// 	$uss         = Usuarios::model()->findByPk($_GET['keyU']);
			// 	$agencia     = Agencias::model()->findByPk($uss->id_agencia);
			// 	$idUser      = $uss->id_usuario;
			// } else {
			// 	$idUser      = Yii::app()->user->id;
			// 	$usuario     = Profiles::model()->findByPk($idUser);
			// 	$tipoUsuario = $usuario->tipo;
			// 	$uss         = Usuarios::model()->findByPk($idUser);
			// 	$agencia     = Agencias::model()->findByPk($uss->id_agencia);
			// }
            $usuario     = Profiles::model()->findByPk(1);
            $tipoUsuario = $usuario->tipo;
            $uss         = Usuarios::model()->findByPk(1);
            $agencia     = Agencias::model()->findByPk($uss->id_agencia);
            $idUser      = $uss->id_usuario;


			$_SESSION['front_form']['agenciaUsuario'] = $uss->id_agencia;
			if ($agencia->id_agencia != 9) {
				$_SESSION['front_form']['estadoUsuario'] = $agencia->id_estado_agencia;
			}
			if ($_GET['nacionalidad']) {
				$_SESSION['front_form']['nacionalidad'] = $_GET['nacionalidad'];
			}else{
				$_SESSION['front_form']['nacionalidad'] = ($agencia->id_estado_agencia=='31') ? 'MX/MEX' : 'CO/COL';
			}
			$_SESSION['front_form']['agencia']     = $agencia;
			$_SESSION['front_form']['tipoUsuario'] = $tipoUsuario;
			$_SESSION['front_form']['user_id']     = $idUser;
			if ($_SESSION['tipoUsuario'] == "Hotel") {
				$_SESSION['front_form']['agenciaUsuario'] = 9;
				$_SESSION['front_form']['estadoUsuario']  = 31;
			}
			if (!empty($id_hotel)) {
				$noresults = 0;
				$hoteles   = Hoteles::model()->findAll('id_hotel=' . $id_hotel . ' and estatus=1 and no_listar = 1 ');
				$rowscount = count($hoteles);
			} else if (!empty($id_destino)) {
				$hoteles_no_colombia = array();
				if ($_SESSION["agencia"]["id_estado_agencia"] == 33) {
					$hoteles_no_colombia     = array(169502, 169539, 178011, 169556, 276, 169565, 169507, 169500, 137, 169505, 177938, 169566, 169561, 169508, 169504, 169567, 169538, 169553, 169554, 169557, 169558, 177954, 169506, 178929, 178904, 169509, 169559, 169562, 169564, 169503, 169555, 169540, 179298, 179662, 179344, 179345, 179178, 169560, 169576, 169577, 169525, 179212, 179328, 177992, 169535, 169531, 177994, 177993, 169536, 169534, 169516, 169542, 169517, 169571, 169563, 169545, 179290, 169474, 169480, 177785, 169481, 178035, 169482, 179320, 177990, 18, 281, 321, 179717, 179716, 179718, 179719, 178881, 177890);
					$str_hoteles_no_colombia = implode(",", $hoteles_no_colombia);
					$sql_colombia            = ' AND id_hotel NOT IN (' . $str_hoteles_no_colombia . ')';
				}
				$noresults = 0;
				$zonas     = Zonasbeds::model()->findAll('destinationsCode="' . $id_destino . '"');
				foreach ($zonas as $zona) {
					$listazonas .= $zona->idZona . ',';
				}
				$listazonas = substr($listazonas, 0, -1);
				if ($_GET['outlet'] == 'grupos' && $_GET['proveedores'] == 2) {
					$hotelesEspeciales = ' OR id_hotel IN(178186,178185) ';
				}
				$hoteles   = Hoteles::model()->findAll(array('condition' => 'id_destino IN(' . $listazonas . ') and estatus=1 and no_listar = 1 ' . $proveedor . $hotelesEspeciales . ' ' . $solo_adultos . $nombreHotel . $sql_colombia));
				$rowscount = count($hoteles);
				if ($rowscount == 1) {
					$rowscount += 1;
				}
			} else if (!empty($id_cadena)) {
				$noresults = 0;
				$hoteles   = Hoteles::model()->findAll(array('condition' => 'id_cadena=' . $id_cadena . ' and estatus=1 and no_listar = 1 ' . $proveedor . ' ' . $solo_adultos));
				$rowscount = count($hoteles);
				if ($rowscount == 1) {
					$rowscount += 1;
				}
			} else if (!empty($id_zona)) {
				$noresults = 0;
				$hoteles   = Hoteles::model()->findAll(array('condition' => 'id_destino=' . $id_zona . ' and estatus=1 and no_listar = 1 ' . $proveedor . ' ' . $solo_adultos . $nombreHotel));
				$rowscount = count($hoteles);
				if ($rowscount == 1) {
					$rowscount += 1;
				}
			} else if ($id_usuario_extranet) {
				$noresults = 0;
				$hExtranet = HotelesExtranet::model()->findAll('idUsuario=' . $id_usuario_extranet);
				$idsExtra  = array();
				foreach ($hExtranet as $extra) {
					array_push($idsExtra, $extra->idHotel);
				}
				$hoteles   = Hoteles::model()->findAll('id_hotel in(' . implode(",", $idsExtra) . ')');
				$rowscount = count($hoteles);
			}
			$i                = 0;
			$truncate_hoteles = 1;
			$countHotels      = count($hoteles);
			foreach ($hoteles as $row) {
				switch ($row->proveedor) {
					// case '0':
					// 	$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
					// 	$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
					// 	$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
					// 	if ($countHotels == 1) {
					// 		$hotelesRQ = (object) $hotelesRQ;
					// 	}
					// 	break;
					// case '1':
					// 	if ($truncate_hoteles <= 450) {
					// 		$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
					// 		$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
					// 		$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
					// 	}
					// 	$truncate_hoteles++;
					// 	break;
					// case '2':
					// 	if ($_GET['outlet'] != "" && $_GET['outlet'] != "outlet" && $outlet) {
	
					// 		if ($outletController->hotelesOutlet($row->id_hotel, 2, $_GET['outlet'])) {
					// 			$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
					// 			$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
					// 			$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
					// 		}
					// 	} else {
					// 		$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
					// 		$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
					// 		$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
					// 	}
					// 	break;
					// case '3':
					// 	$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
					// 	$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
					// 	$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
					// 	break;
					// case '4':
					// 	$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
					// 	$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
					// 	$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
					// 	break;
					// case '5':
					// 	if ($_GET['outlet'] == "grupos" && $outlet) {
					// 		if ($outletController->hotelesOutlet($row->id_hotel, $row->proveedor, $_GET['outlet'])) {
					// 			$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
					// 			$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
					// 			$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
					// 		}
					// 	} else {
	
					// 		$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
					// 		$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
					// 		$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
					// 	}
					// 	break;
					// case '6':
					// 	$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
					// 	$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
					// 	$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
					// 	break;
					// case '7':
					// 	$hotelesRQ[$row->proveedor]["proveedor"] = $row->proveedor;
					// 	$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
					// 	$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
					// 	break;
					case '10':
						$hotelesRQ[$row->proveedor]["proveedor"] 						   = $row->proveedor;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"] = $row->id_hotel;
						$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]   = $row->codigo;
						break;
					default:
						break;
				}
				$i++;
			}
	
// 			if (Yii::app()->user->id == 1437) {
// 				$_SESSION['front_form']['request_url'] = 1;
// 			}
	
			$habitacionesRQ = array(
				'fecha_inicial'         => $fecha_inicial,
				'fecha_final'           => $fecha_final,
				'fecha_promo'           => $fecha_promo,
				'hora'                  => $hora,
				'early_booking'         => $early_booking,
				'noches'                => $noches,
				'habitaciones'          => $habitaciones,
				'proveedor'             => $proveedor,
				'categoria'             => $categoria,
				'tipo_precio'           => $tipo_precio,
				'tipo_plan'             => $tipo_plan,
				'ORDER_PRECIO'          => $ORDER_PRECIO,
				'rowscount'             => $rowscount,
				'noresults'             => $noresults,
				'filtro_disponibilidad' => $_GET['filtro_disponibilidad'],
				'hotel'                 => $hotel,
				'tarifa'                => $tarifa,
				'totalHoteles'          => $rowscount
			);
			$_SESSION["resultadoBusquedaHoteles"]    = $habitacionesRQ;
			$habitacionesRQ['filtro_disponibilidad'] = 0;
	
			if (is_array($hotelesRQ)) {
				$hotelesRQ = (object) $hotelesRQ;
			}
			$front_form = $_SESSION['front_form'];
			if ($_GET['tarifa'] == "especial" && $destino[0] == 'h') {
				$getTarifas = Yii::app()->createController('getTarifaEspecial')[0];
				try {
					$hotelesArray      = (array) $hotelesRQ;
					$resultTarifasJSON = $getTarifas->ObtenerTarifas($hotelesArray[0]['hoteles'], $habitacionesRQ, $front_form, 0);
					$resultTarifas     = $resultTarifasJSON;
				} catch (Exception $e) {
					var_dump($e);
				}
			} else {
				$resultTarifasJSON   = $this->TarifasWs(json_encode($hotelesRQ), json_encode($habitacionesRQ), json_encode($front_form));
				$resultTarifasJSONWs = iconv("Windows-1252", "UTF-8", $resultTarifasJSON);
				$resultTarifas       = json_decode($resultTarifasJSONWs, true);
			}
			unset($habitacionesRQ['fecha_promo']);
			unset($habitacionesRQ['hora']);
			unset($habitacionesRQ['early_booking']);
			unset($habitacionesRQ['proveedor']);
			unset($habitacionesRQ['hotel']);
			unset($habitacionesRQ['tarifa']);
			unset($front_form['agencia']);
	
			$json_response .= '{"front_form":' . json_encode($front_form) . ',"habitacionesRQ":' . json_encode($habitacionesRQ) . ',';
			if ($resultTarifas != null) {
				$this->clearSesion();
				$json_response .= '"row":' . json_encode($resultTarifas) . ', "count": ' . count($resultTarifas) . '}';
			} else {
				$json_response .= '"row":[], "count": 0}';
			}
	
			echo $json_response;
		
		}
	}

	public function actionGetSamesHotels()
	{
		header('Content-Type: application/json; charset=utf-8');
		$tarifas = array();

		$id_hotel = explode('_', $_POST['destinoRQ']);
		$resultadoBusquedaHoteles = json_decode($_POST['habitacionesRQ']);
		$resultadoBusquedaHoteles->filtro_disponibilidad = $_POST['disponibilidad'];
		$front_form = json_decode($_POST['front_form']);

		$es_outlet_grupos = '';
		if ($front_form->outlet == 'grupos') {
			$es_outlet_grupos = ' AND proveedor IN(0) ';
		}

		$notProveedor = '';
		// if (Yii::app()->user->id != 1437) {
			$notProveedor = ' AND proveedor NOT IN(7) ';
		// }

		$hoteles = 'select id_hotel, nombre_hotel, codigo, proveedor FROM tbl_hoteles WHERE nombre_hotel LIKE (SELECT h.nombre_hotel FROM tbl_hoteles h WHERE id_hotel = ' . $id_hotel[1] . ') AND id_hotel!=' . $id_hotel[1] . $es_outlet_grupos . ' AND estatus=1 AND no_listar=1 ' .$notProveedor. $resultadoBusquedaHoteles->solo_adultos;

		$row = Yii::app()->db->createCommand($hoteles)->queryAll();
		$resultadoBusquedaHoteles->totalHoteles = count($row) + 1;

		$front_form->hotelesIguales = true;
		$hotelesRQ = $this->formarHoteles($row);

		if (count($hotelesRQ) > 0) {
			$resultMismoHoteles = $this->TarifasWs(json_encode($hotelesRQ), json_encode($resultadoBusquedaHoteles), json_encode($front_form));
			$resultMismoHotelesWs = iconv("Windows-1252", "UTF-8", $resultMismoHoteles);
			$resultTarifas = json_decode($resultMismoHotelesWs, true);
		} else {
			$resultTarifas = null;
		}

		$this->clearSesion();
		echo json_encode($resultTarifas);
	}

	public function actionGetSamesDestinations()
	{
		header('Content-Type: application/json; charset=utf-8');
		$tarifas = array();
		$id_hotel = explode('_', $_POST['destinoRQ']);
		$resultadoBusquedaHoteles = json_decode($_POST['habitacionesRQ']);
		$front_form = json_decode($_POST['front_form']);
		if (is_numeric($id_hotel[1])) {
			$hoteles = 'select id_hotel, nombre_hotel, codigo, proveedor FROM tbl_hoteles WHERE id_destino=(SELECT h.id_destino FROM tbl_hoteles h WHERE id_hotel = ' . $id_hotel[1] . ') AND id_hotel!=' . $id_hotel[1] . ' AND estatus=1 AND proveedor=0 AND no_listar!=0 ' . $resultadoBusquedaHoteles->solo_adultos;

			$row = Yii::app()->db->createCommand($hoteles)->queryAll();

			$hotelesRQ = $this->formarHoteles($row);
			$resultadoBusquedaHoteles->totalHoteles = count($row) + 1;

			if (count($hotelesRQ) > 0) {
				$resultMismoDestino = $this->TarifasWs(json_encode($hotelesRQ), json_encode($resultadoBusquedaHoteles), $_POST['front_form']);
				$resultMismoDestinoWs = iconv("Windows-1252", "UTF-8", $resultMismoDestino);
				$resultTarifas = json_decode($resultMismoDestinoWs, true);
			} else {
				$resultTarifas = null;
			}

			if ($resultTarifas == null || count($resultTarifas) == 0) {
				$hoteles = 'select id_hotel, nombre_hotel, codigo, proveedor FROM tbl_hoteles WHERE id_destino=(SELECT h.id_destino FROM tbl_hoteles h WHERE id_hotel = ' . $id_hotel[1] . ') AND nombre_hotel NOT LIKE "%(SELECT h.nombre_hotel FROM tbl_hoteles h WHERE id_hotel = ' . $id_hotel[1] . ')%" AND id_hotel!=' . $id_hotel[1] . ' AND estatus=1 AND proveedor NOT IN(0)';

				$hotelesRQ = $this->formarHoteles($row);

				if (count($hotelesRQ) > 0) {
					$resultMismoDestino = $this->TarifasWs(json_encode($hotelesRQ), json_encode($resultadoBusquedaHoteles), $_POST['front_form']);
					$resultMismoDestinoWs = iconv("Windows-1252", "UTF-8", $resultMismoDestino);
					$resultTarifas = json_decode($resultMismoDestinoWs, true);
				}
			}
			$this->clearSesion();
			echo json_encode($resultTarifas);
		} else {
			echo "[]";
		}
	}

	public function actionDragMaps()
	{
		header('Content-Type: application/json; charset=utf-8');

		$habitacionesRQ = $_POST['habitacionesRQ'];
		$front_form = $_POST['front_form'];


		if (!empty($_POST['ubicacion'])) {
			$position = array();
			$ubicacion = explode('/', $_POST['ubicacion']);

			$position['lat'] = (float) $ubicacion[0];
			$position['lng'] = (float) $ubicacion[1];

			$norte = $position['lat'] + 0.01;
			$sur = $position['lat'] - 0.01;

			$este = $position['lng'] + 0.01;
			$oeste = $position['lng'] - 0.01;

			$sql_ubicacion = "SELECT * FROM `tbl_hoteles` WHERE (latitud BETWEEN " . $sur . " and " . $norte . ") and (longitud BETWEEN " . $oeste . " and " . $este . ") AND estatus=1";

			$rows = Yii::app()->db->createCommand($sql_ubicacion)->queryAll();

			$hotelesRQ = $this->formarHoteles($rows);

			if (!empty($hotelesRQ)) {
				echo '{"row":' . json_encode($hotelesRQ) . ', "count": ' . count($rows) . '}';
			} else {
				echo '{"row":[], "count": 0}';
			}
		} else {
			echo '{"row":[], "count": 0}';
		}
	}

	public function TarifasWs($hoteles, $habitaciones, $front_form){
		header("Content-Type: text/html;charset=utf-8");
		$tarifas=[];
		$getTarifas = Yii::app()->createController('getTarifas')[0];
		$decode_hoteles = json_decode($hoteles, true);
        if (is_null($decode_hoteles)) {
            $decode_hoteles = [];
        }
		foreach ($decode_hoteles as $key => $value) {
			$response = $getTarifas->ObtenerTarifas(json_encode($decode_hoteles[$key]['hoteles']), $habitaciones, $front_form, $key);
			$decodi   = json_decode($response,true);
			if(count($decodi)>0){
				foreach ($decodi as $hotelKey => $hotelValue) {
					if(is_int($hotelKey)){
						$tarifas[$hotelKey] = $decodi[$hotelKey];
					}
				}
			}
		}
		return json_encode($tarifas);
	}

	public function formarHoteles($hoteles)
	{


		// echo "<textarea>".CJSON::encode($hoteles)."</textarea>";

		foreach ($hoteles as $killing => $row) {
			
			
			//if (in_array($row["id_hotel"], array(394, 395, 177912, 177911))) {
			if (in_array($row["id_hotel"], array(177912, 177911))) {
				continue;
			}
			
			switch ($row["proveedor"]) {
				case '0':
					$hotelesRQ[$row["proveedor"]]["proveedor"] = $row["proveedor"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["id_hotel"] = $row["id_hotel"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["codigo"] = $row["codigo"];
					if ($countHotels == 1) {
						$hotelesRQ = (object) $hotelesRQ;
					}
					break;
				case '1':
					$hotelesRQ[$row["proveedor"]]["proveedor"] = $row["proveedor"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["id_hotel"] = $row["id_hotel"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["codigo"] = $row["codigo"];
					break;
				case '2':
					$hotelesRQ[$row["proveedor"]]["proveedor"] = $row["proveedor"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["id_hotel"] = $row["id_hotel"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["codigo"] = $row["codigo"];
					break;
				case '3':
					$hotelesRQ[$row["proveedor"]]["proveedor"] = $row["proveedor"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["id_hotel"] = $row["id_hotel"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["codigo"] = $row["codigo"];
					break;
				case '4':
					$hotelesRQ[$row["proveedor"]]["proveedor"] = $row["proveedor"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["id_hotel"] = $row["id_hotel"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["codigo"] = $row["codigo"];
					break;
				case '5':
					$hotelesRQ[$row["proveedor"]]["proveedor"] = $row["proveedor"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["id_hotel"] = $row["id_hotel"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["codigo"] = $row["codigo"];
					break;
				case '6':
					$hotelesRQ[$row["proveedor"]]["proveedor"] = $row["proveedor"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["id_hotel"] = $row["id_hotel"];
					$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["codigo"] = $row["codigo"];
					break;
				case '7':
				$hotelesRQ[$row["proveedor"]]["proveedor"]=$row["proveedor"];
				$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["id_hotel"]=$row["id_hotel"];
				$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["codigo"]=$row["codigo"];
				break;
				// case '10':
				// 	$hotelesRQ[$row["proveedor"]]["proveedor"]=$row["proveedor"];
				// 	$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["id_hotel"]=$row["id_hotel"];
				// 	$hotelesRQ[$row["proveedor"]]["hoteles"][$row["id_hotel"]]["codigo"]=$row["codigo"];
				// break;
				default:
					break;
			}
			$i++;
		}



		if (is_array($hotelesRQ)) {
			$hotelesRQ = (object) $hotelesRQ;
		}
		// echo "<textarea>".json_encode($hotelesRQ)."</textarea>";
		return $hotelesRQ;
	}

	public function getNameProveedor($id_hotel, $proveedor)
	{

		$logo = HotelesFotos::model()->find('id_hotel=' . $id_hotel . ' and logotipo=0');
		if (empty($logo)) $logo = HotelesFotos::model()->find('id_hotel=' . $id_hotel . ' and logotipo=1');

		$prov = "Socio Online";

		if ($proveedor == 1) {

			if ($_SESSION["tipoUsuario"] != "Agencia")
				$prov .= " Hotel Beds";
		} else if ($proveedor == 3) {

			if ($_SESSION["tipoUsuario"] != "Agencia")
				$prov .= " Hotel Do";
		} else {

			$prov = "Ruta Maya Travel";

			if ($_SESSION["tipoUsuario"] != "Agencia" && $proveedor == 2) {
				$prov .= "  - OmniBees";
			} else if ($proveedor == 4 && $_SESSION["tipoUsuario"] != "Agencia") {
				$prov .= " - Riu";
			} else if ($proveedor == 5 && $_SESSION["tipoUsuario"] != "Agencia") {
				$prov .= " - Dingus";
			} else if ($proveedor == 6 && $_SESSION["tipoUsuario"] != "Agencia") {
				$prov .= " - Palace";
			}
		}


		$urlfoto = $_SERVER['DOCUMENT_MAIN'] . '/imagenes/';
		switch ($proveedor) {
			case '2':
				$rutaImage = $logo->foto;
				break;
			case '5':
				$rutaImage = $logo->foto;
				break;
			case '1':
				$rutaImage = 'https://photos.hotelbeds.com/giata/' . $logo->foto;
				break;
			case '3':
				$rutaImage = "";
				break;
			default:
				$rutaImage = $urlfoto . $logo->foto;
				break;
		}

		$fotoHotel = [
			"prov" => $prov,
			"rutaImage" => $rutaImage
		];

		return $fotoHotel;
	}

	public function itemCotizacionRapida($tipohab, $id_tarifa, $id_hotel, $fecha_inicial, $fecha_final, $noches, $i_cotiza, $primeraTarifa, $disponibilidadPalace, $session_api, $i_room)
	{
		if ($_SESSION["front_form"]) {
			# code...	
			$front_form = $_SESSION["front_form"];
		} else {

			$front_form = $session_api;
		}

		$desglosePersonas = array();

		$tarifa = Tarifa::model()->findByPk($id_tarifa);
		$hotel = Hoteles::model()->findByPk($id_hotel);
		$id_estado_agencia = Agencias::model()->findByPk($front_form["agenciaUsuario"])->id_estado_agencia;

		if ($tarifa->precio == "OUTLET") {
			$in = '"OUTLET","NORMAL"';
		} else if ($tarifa->precio == "PROMO") {
			$in = '"PROMO","NORMAL"';
		} else if ($tarifa->precio == "NORMAL") {
			$in = '"NORMAL","PROMO","OUTLET"';
		}

		$tarifaAux = $tarifa;
		$id_tipo_plan = $tarifa->id_tipo_plan;
		$moneda = $tarifa->moneda;
		$msgError = array();

		$hora = "and curtime() between hora_inicio and hora_final";
		$fecha_promo = "and (current_date between fecha_promo_inicio and fecha_promo or fecha_promo>='" . date('Y-m-d') . "')";
		$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";

		$precompraMenor = "fecha_inicio_precompra is null or current_date between fecha_inicio_precompra and fecha_final_precompra";
		$early_booking = "and (early_booking is null or DATEDIFF('" . $fecha_inicial . "',current_date) <= early_booking)";

		/*
	    $vip=TarifaAgencia::model()->find("id_agencia=".$_SESSION["agenciaUsuario"]);
		
	    if($_SESSION["agenciaUsuario"] != 9 && !$vip ){		
	    

	    	$tarifaAgencias = 'and not exists(select NULL from tbl_tarifa_agencia tarifaAgencias where tarifaAgencias.id_tarifa=t.id_tarifa and tarifaAgencias.id_agencia!='.$_SESSION["agenciaUsuario"].')';
			//$agenciaUsuario = Agencias::model()->findByPk($_SESSION["agenciaUsuario"]);
			$agenciaUsuario = $_SESSION["agencia"]; //$_SESSION["agenciaUsuario"];
			$tarifaEstados = 'and exists(select NULL from tbl_tarifa_estados tarifaEstados where tarifaEstados.id_tarifa=t.id_tarifa and tarifaEstados.id_estado='.$agenciaUsuario->id_estado_agencia.')';
		}*/

		$releaseDays = 0;
		$sup = Yii::app()->createController('reservacion');
		$sup = $sup[0];
		$costoHabitacion = array();
		$costoTotal = 0;

		for ($dia = 0; $dia < $noches; $dia++) {
			$fecha = date("Y-m-d", strtotime($fecha_inicial . " +" . $dia . " days"));
			$fechadia = strtotime($fecha_inicial . " +" . $dia . " days");
			$tarifaVacia = false;
			if (empty($combinar))
				$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition' => 't.id_tarifa=' . $id_tarifa . ' and id_tipo_plan=' . $id_tipo_plan . ' ' . $fecha_promo . ' ' . $hora . ' ' . $early_booking . ' and dia=' . date("N", $fechadia) . ' and "' . $fecha . '" between t.fecha_inicial and t.fecha_final ' . $tarifaAgencias . ' ' . $tarifaEstados . '', 'limit' => 1));
			if (empty($tarifa) || !empty($combinar)) {
				$tarifa = Tarifa::model()->with('tarifaDiasvalidos', 'tarifaDesgloses')->findAll(array('condition' => 't.id_hotel=' . $id_hotel . ' and t.id_tipo_plan=' . $id_tipo_plan . ' ' . $fecha_promo . ' ' . $hora . ' ' . $early_booking . ' and ( t.id_tarifa=' . $id_tarifa . ' || ( t.precio IN(' . $in . ') and (t.id_combina=' . $id_tarifa . ' || t.id_combina is null) and promocontigua=1 ) ) and t.estatus=1 and id_base_habitacion=2 and dia=' . date("N", $fechadia) . ' and "' . $fecha . '" between t.fecha_inicial and t.fecha_final ' . $tarifaAgencias . ' ' . $tarifaEstados . '', 'order' => ' t.id_tipo_plan ASC, precio_normal ASC ', 'limit' => 1));
				if (empty($tarifa))
					$tarifaVacia = true;
			}
			$t = 0;
			foreach ($tarifa as $row) {
				$nocheGratis = NochesGratis::model()->find('id_tarifa=' . $row->id_tarifa . ' and (id_tipo_habitacion is null or id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ')');
				$NGratis = false;
				if (empty($row->release)) {
					$modelRelease = Release::model()->find('id_hotel=' . $id_hotel . ' AND current_date BETWEEN fecha_inicio AND fecha_final');
					$row->release = $modelRelease->dias;
				}
				if ($row->release > $releaseDays) $releaseDays = $row->release;
				if ($dia == 0) $id_tarifa = $row->id_tarifa;
				if (!empty($nocheGratis) && (($dia + 1) % $nocheGratis->noche == 0)) {
					if (($dia + 1) > $nocheGratis->noche && $nocheGratis->acumulable != 1) {
						$NGratis = false;
					} else {
						$NGratis = true;
					}
				}
				if (!empty($front_form)) {
					for ($i = 1; $i <= $front_form['habs']; $i++) :
						$adultos = $front_form['habitacion_' . $i]['adultos'];
						$num_ninios = $front_form['habitacion_' . $i]['num_ninios'];
						$costoHabitacion[$i]['num_adultos'] = $adultos;
						$costoHabitacion[$i]['num_ninios'] = $num_ninios;
						if ($combinar == true) {
							$desglose = TarifaDesglose::model()->with('idTipoHabitacion')->find(array('condition' => 't.id_tarifa=' . $row->id_tarifa . ' and id_base_habitacion=' . $adultos . ' and max_adultos >= ' . $adultos . ' and t.max_menores >= ' . $num_ninios . ' and idTipoHabitacion.estatus=1', 'order' => 'precio_normal ' . $ORDER_PRECIO . ''));
						} else {
							$desglose = TarifaDesglose::model()->find('t.id_tarifa=' . $row->id_tarifa . ' and t.id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ' and id_base_habitacion=' . $adultos . ' and ' . $tipohab->max_adultos . ' >= ' . $adultos . ' and ' . $tipohab->max_menores . ' >= ' . $num_ninios);
							$desglose = TarifaDesglose::model()->find('id_tarifa=' . $row->id_tarifa . ' and id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ' and id_base_habitacion=' . $adultos . ' and ' . $num_ninios . ' <= max_menores and estatus=1');
						}

						// echo "<br>_________???".$desglose->id_tarifa_desglose;

						if (empty($desglose)) {
							$costoHabitacion[$i]['N/A'] = true;
							$noDisponible = true;
							if ($tipohab->max_adultos < $adultos) {
								$max_adultos = TipoHabitaciones::model()->find('id_hotel=' . $row->id_hotel . ' ORDER BY max_adultos DESC');
								$msgError = "Este Hotel no permite más de " . $max_adultos->max_adultos . " adultos. Favor de redefinir su búsqueda.";
							} else if ($tipohab->max_menores < $num_ninios) {
								$max_menores = TipoHabitaciones::model()->find('id_hotel=' . $row->id_hotel . ' ORDER BY max_menores DESC');
								$msgError = "Este Hotel no permite más de " . $max_menores->max_menores . " menores. Favor de redefinir su búsqueda.";
							}
							$_SESSION["msgError"] = "No hay tarifa para " . $adultos . " adultos que acepte " . $num_ninios . " menores para la habitación " . $i . ".";
						} else {
							if ($NGratis == true) $desglose->precio_normal = 0;
							$costoHabitacion[$i][$dia]['adultos'] = $row->tipoCambio($desglose->precio_normal) + $row->tipoCambio($sup->Sumarsuplemento($row->id_tarifa, $fecha, $adultos, 'A', NULL));
							$costoHabitacion[$i][$dia]['total'] = $costoHabitacion[$i][$dia]['adultos'];
							$costoHabitacion[$i]['precio'] += $costoHabitacion[$i][$dia]['total'];
							$tipohab = TipoHabitaciones::model()->findByPk($desglose->id_tipo_habitacion);
						}
						$tarifasDia[$dia] = $row->id_tarifa;
						if (!empty($front_form['habitacion_' . $i]['num_ninios']) && $tipohab->max_menores >= $front_form['habitacion_' . $i]['num_ninios']) {
							$num_ninios = $front_form['habitacion_' . $i]['num_ninios'];
							for ($j = 1; $j <= $num_ninios; $j++) { //Ordenar edades menores mayor a menor
								if ($front_form['habitacion_' . $i]['edad_' . $j] < $front_form['habitacion_' . $i]['edad_' . ($j + 1)]) {
									$aux = $front_form['habitacion_' . $i]['edad_' . $j];
									$front_form['habitacion_' . $i]['edad_' . $j] = $front_form['habitacion_' . $i]['edad_' . ($j + 1)];
									$front_form['habitacion_' . $i]['edad_' . ($j + 1)] = $aux;
									$j = 0;
								}
							}
							$existeM = DesgloseMenores::model()->findAll('id_tarifa=' . $row->id_tarifa . ' and id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ' and es_junior=0');
							if (!empty($existeM) && count($existeM) >= $desglose->max_menores) {
								$convertir = 0;
								$juniors = 0;
								for ($j = 1; $j <= $num_ninios; $j++) {
									$edad = $front_form['habitacion_' . $i]['edad_' . $j];
									$desgloseM = DesgloseMenores::model()->find('id_tarifa=' . $row->id_tarifa . ' and id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ' and ' . $edad . ' <= edad_max_menor and num_evaluar=' . ($j - $convertir - $juniors) . ' and es_junior=0 and(' . $precompraMenor . ') and(fecha_inicio is null or "' . $fecha . '" between fecha_inicio and fecha_final) ORDER BY precio ASC');
									if (empty($desgloseM)) $desgloseM = DesgloseMenores::model()->with('idTipoHabitacion')->find(array('condition' => 'id_tarifa=' . $row->id_tarifa . ' and t.id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ' and ' . $edad . ' >= edad_min_menor and ' . $edad . ' <= edad_max_menor and es_junior=1 and max_juniors > ' . $juniors . ' and(' . $precompraMenor . ') and(fecha_inicio is null or "' . $fecha . '" between fecha_inicio and fecha_final)', 'order' => 'precio ASC'));
									if (!empty($desgloseM)) {
										if ($edad < $desgloseM->edad_min_menor || $NGratis == true) $desgloseM->precio = 0;
										$precioMenor = $row->tipoCambio($desgloseM->precio) + $row->tipoCambio($sup->Sumarsuplemento($row->id_tarifa, $fecha, 0, 'N', $edad));
										$costoHabitacion[$i][$dia]['menores'] += $precioMenor;
										$costoHabitacion[$i][$dia]['total'] += $precioMenor;
										$costoHabitacion[$i]['precio'] += $precioMenor;

										if ($desgloseM->es_junior == 1) $juniors++;
									} else {
										$adultos += 1;
										$convertir++;
										$aux_ninios = $num_ninios - $convertir;
										if ($combinar == true) {
											$desglose = TarifaDesglose::model()->with('idTipoHabitacion')->find(array('condition' => 't.id_tarifa=' . $row->id_tarifa . ' and id_base_habitacion=' . $adultos . ' and max_adultos >= ' . $adultos . ' and t.max_menores >= ' . $aux_ninios . ' and idTipoHabitacion.estatus=1', 'order' => 'precio_normal ' . $ORDER_PRECIO . ''));
										} else {
											$desglose = TarifaDesglose::model()->find('t.id_tarifa=' . $row->id_tarifa . ' and t.id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ' and id_base_habitacion=' . $adultos . ' and ' . $tipohab->max_adultos . ' >= ' . $adultos . ' and ' . $tipohab->max_menores . ' >= ' . $aux_ninios);
											$desglose = TarifaDesglose::model()->find('id_tarifa=' . $row->id_tarifa . ' and id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ' and id_base_habitacion=' . $adultos . ' and ' . $aux_ninios . ' <= max_menores and estatus=1');
										}
										$costoHabitacion[$i]['num_adultos'] = $adultos;
										$costoHabitacion[$i]['num_ninios'] = $aux_ninios;
										$msgConversion = "Se convirtieron " . $convertir . " menor(es) en adulto(s).";
										if (empty($desglose)) {
											$costoHabitacion[$i]['N/A'] = true;
											$noDisponible = true;
											$msgError = "Este Hotel no permite " . $adultos . " adultos y " . $aux_ninios . " menores. Favor de redefinir su búsqueda.";
										} else {
											if ($NGratis == true) $desglose->precio_normal = 0;
											$costoHabitacion[$i]['precio'] -= $costoHabitacion[$i][$dia]['total'];
											$costoHabitacion[$i][$dia]['adultos'] = $row->tipoCambio($desglose->precio_normal) + $row->tipoCambio($sup->Sumarsuplemento($row->id_tarifa, $fecha, $adultos, 'A', NULL));
											$costoHabitacion[$i][$dia]['total'] = $costoHabitacion[$i][$dia]['adultos'];
											$costoHabitacion[$i]['precio'] += $costoHabitacion[$i][$dia]['total'];
										}
									}
								}
							} else {
								$costoHabitacion[$i]['N/A'] = true;
								$noDisponible = true;
								$msgError = "Error en la tarifa! Se le sugiere notificar a su agente de ventas.";
								break;
							}
						}

						//Mínimo de noches
						$minNoches = MinNoches::model()->find('id_tarifa=' . $row->id_tarifa . ' and id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ' and "' . $fecha . '" between fecha_inicio and fecha_final');
						if (!empty($minNoches) && $minNoches->minimo > $costoHabitacion[$t]['min_noches']) {
							$costoHabitacion[$t]['min_noches'] = $minNoches->minimo;
						} else if ($row->min_noches > $costoHabitacion[$t]['min_noches']) {
							$costoHabitacion[$t]['min_noches'] = $row->min_noches;
						}

					endfor;
				}

				$t++;
			}
		}

		$tarifa = Tarifa::model()->findByPk($id_tarifa);
		$tarifaAux = $tarifa;
		$moneda = ($tarifa->tipo_cambio != 0 && $tarifa->mostrar_conversion == 1) ? 'MXN' : $tarifa->moneda;

		$busquedaController = Yii::app()->createController('busqueda');
		$busquedaController = $busquedaController[0];

		$politicasDeCancelacion = '';
		$cancelaciones = $busquedaController->cancelaciones($id_hotel, $fecha_inicial, $id_tarifa);

		if ($tarifa->precio == "OUTLET")
			$cancelaciones = "Pago inmediato. No transferible, no reembolsable, no se aceptan modificaciones, cancelaciones, ni devoluciones.";
		if (!empty($cancelaciones))
			$politicasDeCancelacion = $cancelaciones;
		if ($tarifa->restricciones != "")
			$restricciones = $tarifa->restricciones;

		## fechas disponibles ##

		$hora = "and curtime() between hora_inicio and hora_final";
		$fecha_promo = "and (current_date between fecha_promo_inicio and fecha_promo or fecha_promo>='" . date('Y-m-d') . "')";
		$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
		$early_booking = "and(early_booking is null or DATEDIFF('" . $fecha_inicial . "',current_date) <= early_booking)";

		if (empty($tarifa->release)) {
			$modelRelease = Release::model()->find('id_hotel=' . $id_hotel . ' AND current_date BETWEEN fecha_inicio AND fecha_final');
			$tarifa->release = $modelRelease->dias;
		}
		if ($hotel->alerta_disponibilidad == 1) {
			$hasAllotment = 0;
		} else {
			$hasAllotment = 1;
		}
		if ($tarifa->release > $releaseDays) $releaseDays = $tarifa->release;

		$now = strtotime(date('Y-m-d'));
		$checkin_date = strtotime($fecha_inicial);
		$datediff = abs($now - $checkin_date);
		$diffdays = floor($datediff / (60 * 60 * 24));

		$desgloseFechas = array();

		if ($diffdays < $releaseDays) {
			$tieneRelease = 1;
			$desgloseFechas["error"] = 'Esta tarifa tiene un mínimo de ' . $releaseDays . ' días de anticipación para poder reservar';
			$desgloseFechas["status"] = 'danger';
		} else {
			$palaceResorts = array('BP', 'CZ', 'IM', 'LBC', 'MPS', 'PL', 'SP', 'MPG');

			for ($dia = 0; $dia < $noches; $dia++) {
				$fecha = date("Y-m-d", strtotime($fecha_inicial . " +" . $dia . " days"));
				$desgloseFechas['Fechas'][$dia]['fecha'] = date('d/m/Y', strtotime($fecha));
			}

			$ok = 0;

			if (in_array($hotel->codigo, $palaceResorts) && $disponibilidadPalace == false) {
				for ($dia = 0; $dia < $noches; $dia++) {
					$mensaje = 1;
					$desgloseFechas['Fechas'][$dia]['estatus'] = 'danger';
					$desgloseFechas['Fechas'][$dia]['disponible'] = false;
				}

				$desgloseFechas["error"] = 'No existen fechas disponibles para esta habitación';
				$desgloseFechas["status"] = 'warning';
			} else {
				for ($dia = 0; $dia < $noches; $dia++) {
					$fecha = date("Y-m-d", strtotime($fecha_inicial	. " +" . $dia . " days"));
					$fechadia = strtotime($fecha_inicial . " +" . $dia . " days");
					if (strtotime($fecha) > strtotime($tarifa->fecha_final)) {
						$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->find(array('condition' => 't.id_hotel=' . $id_hotel . ' and id_tipo_plan=' . $id_tipo_plan . ' ' . $fecha_promo . ' ' . $hora . ' ' . $early_booking . ' and precio IN(' . $in . ') and promocontigua=1 and estatus=1 and dia=' . date("N", $fechadia) . ' and "' . $fecha . '" between t.fecha_inicial and t.fecha_final', 'order' => 'precio desc'));
					}


					$bloqueada = FechasBloqueadas::model()->find('id_tarifa=' . $tarifasDia[$dia] . ' and ((id_tipo_habitacion is null and "' . $fecha . '" between fecha_inicio and fecha_final) or (id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ' and "' . $fecha . '" between fecha_inicio and fecha_final))');


					$allotment = AllotmentDesglose::model()->with('idAllotment')->find('id_hotel=' . $hotel->id_hotel . ' and "' . $fecha . '" between fecha_inicio and fecha_final and id_tipo_habitacion=' . $tipohab->id_tipo_habitacion);

					$reservadas = ReservacionDesglose::model()->with('idReservacion')->findAll('id_tipo_habitacion=' . $tipohab->id_tipo_habitacion . ' and "' . $fecha . '" between fecha_inicial and fecha_final and idReservacion.estatus!="C" and libera_cupon=1');

					if ($tarifa->release > $releaseDays) $releaseDays = $tarifa->release;

					if (!empty($bloqueada)) {
						$mensaje = 1;
						$desgloseFechas['Fechas'][$dia]['estatus'] = 'danger';
						$desgloseFechas['Fechas'][$dia]['disponible'] = false;
					} else if (($hasAllotment == 0) || !empty($allotment) && ($allotment->maximo - count($reservadas)) <= 0) {
						$mensaje = 1;
						$desgloseFechas['Fechas'][$dia]['estatus'] = 'warning';
						$desgloseFechas['Fechas'][$dia]['disponible'] = false;
					} else {
						$ok++;
						$desgloseFechas['Fechas'][$dia]['estatus'] = 'success';
						$desgloseFechas['Fechas'][$dia]['disponible'] = true;
					}
				}

				if ($hasAllotment == 0) {
					$desgloseFechas["error"] = 'Es necesario verificar y confirmar disponibilidad por medio de los agentes de venta de Ruta Maya Travel antes de realizar la reserva.';
					$desgloseFechas["status"] = 'warning';
				} else {
					$desgloseFechas["error"] = 'La disponibilidad ha sido verificada y confirmada, puede realizar la reserva si no existe fecha cerrada en el calendario que se presenta a continuación.';
					$desgloseFechas["status"] = 'success';
				}
			}
		}


		$tarifa = Tarifa::model()->findByPk($id_tarifa);

		if ($ok == $noches) $btnColor = "green";
		else $btnColor = "red";
		if (($hasAllotment == 0)  || ($ok == $noches && $hasAllotment == 0)) $btnColor = "orange";
		if ($tieneRelease == 1 || $noches < $costoHabitacion[0]['min_noches']) $btnColor = "red";

		$ocultarTarifa = false;
		if ($btnColor == "green") {
			if ($tarifa->fecha_promo_inicio <= date("Y-m-d") && $tarifa->fecha_promo >= date("Y-m-d")) {
				if ($tarifa->precio == "OUTLET") {
					if (count($outlet) != 0 && date("Y-m-d") >= $outlet->fecha_inicio && date("Y-m-d") <= $outlet->fecha_final) {
						if ($front_form["tipoUsuario"] == "Agencia") {
							$outletAgencia = OutletAgencia::model()->find('id_agencia=' . $front_form["agenciaUsuario"] . ' AND id_evento=' . $outlet->id_outlet);
							if (count($outletAgencia) != 0) {
								$imprimeBootom = true;
							}
						} else {
							$imprimeBootom = true;
						}
					} else {
						$imprimeBootom = true;
					}
				} else {
					$imprimeBootom = true;
				}

				if ($imprimeBootom == true) {
					if ($tarifa->precio == "OUTLETGRUPOS") {
						$tarifaRmt["botonReservar"] = false;
						$tarifaRmt["tipo_boton"] = "OUTLETGRUPOS";
						$tarifaRmt["hasAllotment"] = $hasAllotment;
						$tarifaRmt["btnHtml"]["color"] = "blue";
						$tarifaRmt["btnHtml"]["link"] = Yii::app()->createUrl("gruposCotizaciones/create/idTarifa/" . $id_tarifa . "/idHotel/" . $id_hotel . "/idHabitacion/" . $tipohab->id_tipo_habitacion);
					} else {
						$tarifaRmt["botonReservar"] = true;
						$tarifaRmt["tipo_boton"] = "NORMAL";
						$tarifaRmt["hasAllotment"] = $hasAllotment;
						$tarifaRmt["btnHtml"]["color"] = $btnColor;
					}
				}
			}

			if (($tarifa->precio == "OUTLET" || $tarifa->precio == "OUTLETGRUPOS")  && $bootom == "") {
				$tarifaRmt["botonReservar"] = false;
				$tarifaRmt["tipo_boton"] = "OUTLET";
				$tarifaRmt["hasAllotment"] = $hasAllotment;
				$tarifaRmt["btnHtml"]["color"] = "";
				$tarifaRmt["btnHtml"]["link"] = Yii::app()->baseUrl . '/images/banners/' . $tarifa->tarifaLogo->logo;
				$tarifaRmt["btnHtml"]["nota"] = 'La tarifa estará disponible únicamente para agencias participantes durante las fechas del evento.';
			}
		} else {
			$calendario = ($diffdays < $releaseDays && $front_form["tipoUsuario"] == "Agencia") ? '' : 'calendario';
			$datas = ($diffdays > $releaseDays || $front_form["tipoUsuario"] == "Admon") ? '#modal-calendario' : '';
			$data_original_title = ($releaseDays > 0) ? 'Esta tarifa tiene un mínimo de ' . $releaseDays . ' días de anticipación para poder reservar' : '';

			if ($tarifa->fecha_promo_inicio <= date("Y-m-d") && $tarifa->fecha_promo >= date("Y-m-d")) {
				if ($tarifa->precio == "OUTLET") {
					if (count($outlet) != 0 && date("Y-m-d") >= $outlet->fecha_inicio && date("Y-m-d") <= $outlet->fecha_final) {
						if ($front_form["tipoUsuario"] == "Agencia") {
							$outletAgencia = OutletAgencia::model()->find('id_agencia=' . $front_form["agenciaUsuario"] . ' AND id_evento=' . $outlet->id_outlet);
							if (count($outletAgencia) != 0) {
								$imprimeBootom = true;
							}
						} else {
							$imprimeBootom = true;
						}
					} else {
						$imprimeBootom = true;
					}
				} else {
					$imprimeBootom = true;
				}

				if ($imprimeBootom == true) {
					if ($tarifa->precio == "OUTLETGRUPOS") {
						$tarifaRmt["botonReservar"] = false;
						$tarifaRmt["tipo_boton"] = "OUTLETGRUPOS";
						$tarifaRmt["hasAllotment"] = $hasAllotment;
						$tarifaRmt["btnHtml"]["color"] = "blue";
						$tarifaRmt["btnHtml"]["link"] = Yii::app()->createUrl("gruposCotizaciones/create/idTarifa/" . $id_tarifa . "/idHotel/" . $id_hotel . "/idHabitacion/" . $tipohab->id_tipo_habitacion);
					} else {
						$tipo_boton = "RESTRICCIONES";
						if ($btnColor == "red") {
							$carrito = null;
							$tipo_boton = "SINFECHAS";
						}

						$tarifaRmt["botonReservar"] = false;
						$tarifaRmt["tipo_boton"] = $tipo_boton;
						$tarifaRmt["hasAllotment"] = $hasAllotment;
						$tarifaRmt["btnHtml"]["color"] = $btnColor;
						$tarifaRmt["btnHtml"]["calendario"] = $calendario;
						$tarifaRmt["btnHtml"]["nota_1"] = $data_original_title;
						$tarifaRmt["btnHtml"]["modal"] = $datas;

						// $bootom='<a class="btn btn-fw '.$btnColor.' m-b-xs m-r-xs '.$calendario.'" data-id="'.$id_hotel.'" data-tarifa="'.$id_tarifa.'" data-rate="'.$i_cotiza.'" data-hab="'.$tipohab->id_tipo_habitacion.'" data-allotment="'.$hasAllotment.'" '.$datas.' rel="tooltip" data-original-title="'.$data_original_title.'"><i class="fa fa-calendar"></i> Disponibilidad</a>'.$carrito;
					}
				}
			}

			if ($tarifa->precio == "OUTLET" && $bootom == "") {
				$tarifaRmt["botonReservar"] = false;
				$tarifaRmt["tipo_boton"] = "OUTLET";
				$tarifaRmt["hasAllotment"] = $hasAllotment;
				$tarifaRmt["btnHtml"]["color"] = "";
				$tarifaRmt["btnHtml"]["link"] = Yii::app()->baseUrl . '/images/banners/' . $tarifa->tarifaLogo->logo;
			}

			$ocultarTarifa = true;
		}


		$tarifaRmt["num_habs"] = $front_form["habs"];
		$tarifaRmt["id_plan"] = $id_tipo_plan;
		$tarifaRmt["id_habitacion"] = $tipohab->id_tipo_habitacion;
		$tarifaRmt["Total_planes"] = null;

		if ($primeraTarifa == "OK") {
			$idPrimeraTarifa = 'id="primeraTarifa_' . $id_hotel . '"';
			$ocultarTarifa = false;
			$tarifaRmt["primeraTarifa"] = true;
		} else {
			$idPrimeraTarifa = "";
			$tarifaRmt["primeraTarifa"] = false;
		}

		if ($noDisponible != true) {

			for ($i = 1; $i <= $front_form['habs']; $i++) {
				$desglosePersona['habitacion'][$i]['resumen']['adultos'] = $costoHabitacion[$i]['num_adultos'];
				$desglosePersona['habitacion'][$i]['resumen']['menores'] = $costoHabitacion[$i]['num_ninios'];

				if ($costoHabitacion[$i]['N/A'] == true) {
					$desglosePersona['habitacion'][$i]['Fechas']['error'] = true;
				} else {
					$costoTotal += $costoHabitacion[$i]['precio'];
					for ($n = 0; $n < $noches; $n++) {
						if (empty($costoHabitacion[$i][$n])) continue;

						$desglosePersona['habitacion'][$i]['Fechas'][($n + 1)]['Fecha'] = date('d-m-Y', strtotime($fecha_inicial . '+' . $n . ' day'));
						$desglosePersona['habitacion'][$i]['Fechas'][($n + 1)]['Adultos'] = number_format($costoHabitacion[$i][$n]['adultos'], 2);
						$desglosePersona['habitacion'][$i]['Fechas'][($n + 1)]['Menores'] = number_format($costoHabitacion[$i][$n]['menores'], 2);
						$desglosePersona['habitacion'][$i]['Fechas'][($n + 1)]['total'] = number_format($costoHabitacion[$i][$n]['total'], 2);
						$desglosePersona['habitacion'][$i]['Fechas'][($n + 1)]['moneda'] = $moneda;
					}

					$desglosePersona['habitacion'][$i]['Total']['total'] = number_format($costoHabitacion[$i]['precio'], 2);
					$desglosePersona['habitacion'][$i]['Total']['moneda'] = $moneda;
				}
			}

			$tooltipmsgConversion = (!empty($msgConversion)) ? $msgConversion : "";
			if (!empty($tooltipmsgConversion)) {
				$desglosePersona['habitacion']['mensaje'] = $tooltipmsgConversion;
			}

			$tarifaRmt["plan"][0]["id_plan"] = $id_tipo_plan;
			$tarifaRmt["plan"][0]["tipo_plan"] = $tarifa->tarifaPlan->nombre;
			$tarifaRmt["plan"][0]["nombrePlan"] = $tarifa->nombre_tarifa;
			$tarifaRmt["plan"][0]["alerta_disponibilidad"] = $hasAllotment;
			$tarifaRmt["plan"][0]["ratePlanDescription"] = "";
			$tarifaRmt["plan"][0]["icon_politicas_cancelacion"] = $politicasDeCancelacion;
			$tarifaRmt["plan"][0]["fecha_limite"] = "";
			$tarifaRmt["plan"][0]["politicas_cancelacion"] = $politicasDeCancelacion;
			$tarifaRmt["plan"][0]["tarifadiaria"] = "";
			$tarifaRmt["plan"][0]["calendario"] = $desglosePersona;
			$tarifaRmt["plan"][0]["tarifa"] = $id_tarifa;
			$tarifaRmt["plan"][0]["moneda"] = $moneda;
			$tarifaRmt["plan"][0]["reembolsable"] = "";
			$tarifaRmt["plan"][0]["restricciones"] = $restricciones;
			$tarifaRmt["plan"][0]["precio"] = number_format($costoTotal, 2);
			$tarifaRmt["plan"][0]["fechas_disponibles"] = $desgloseFechas;
			$tarifaRmt["plan"][0]["roomrates"] = base64_encode(json_encode($costoHabitacion));
			$tarifaRmt["plan"][0]["i_cotiza"] = $i_cotiza;
			$tarifaRmt["plan"][0]["ocultarTarifa"] = $ocultarTarifa;

			if ($tarifaVacia == true) {
				$tarifaRmt["warning"]["tarifaVacia"] = true;
				$tarifaRmt["warning"]["mensaje"] = "No se encontraron tarifas para uno o más días.";
			} else {
				$tarifaRmt["warning"]["tarifaVacia"] = false;
				$tarifaRmt["warning"]["mensaje"] = null;
			}
		} else {
			if (!empty($msgConversion)) {
				$tarifaRmt["warning"]["error"] = true;
				$tarifaRmt["warning"]["mensaje"] = $msgConversion;
			} else {
				$tarifaRmt["warning"]["error"] = true;
				$tarifaRmt["warning"]["mensaje"] = $msgError;
				// if (!empty($msgError["msgError"]["msgError"]) || $msgError["msgError"]["msgError"]!=null) {
				// 	# code...
				// 	$tarifaRmt["warning"]["mensaje"] = $msgError["msgError"]["msgError"];
				// }else{
				// 	$tarifaRmt["warning"]["mensaje"] = $msgError["msgError"];
				// }
			}
		}
		return $tarifaRmt;
	}

	public function clearSesion()
	{
		unset($_SESSION["Formulario_reservar"]);
		// unset($_SESSION["tarifasbeds"]);
		// unset($_SESSION["tarifaspropias"]);
		// unset($_SESSION["tarifasOmniBees"]);
		// unset($_SESSION["msgError"]);
		// unset($_SESSION["dataSuggestions"]);
		// unset($_SESSION["dataSuggestionsSames"]);
		// unset($_SESSION["tarifasTravelSolution"]);//Trae la disponibilidad
		// unset($_SESSION["informationHotelesTS"]);//Trae la información del hotel
		// unset($_SESSION["tarifasPalace"]);
		// unset($_SESSION["mismoHotelDo"]);
	}

	public function actionHotelesSugerenciasMismoHotel($id_hotel, $nombre_hotel)
	{
		if (!$_SESSION["dataSuggestionsSames"]) {
			$hoteles = Hoteles::model()->findAll('nombre_hotel LIKE "' . $nombre_hotel . '" AND id_hotel!=' . $id_hotel . ' AND estatus=1 AND no_listar=1');

			$result = $this->getTarifas($hoteles, false);

			$_SESSION["dataSuggestionsSames"] = $result;

			$this->renderPartial('hoteles', array('hoteles' => $_SESSION["dataSuggestionsSames"], 'listView' => 'listViewSugerenciasMismoHotel'));
		} else {
			$_SESSION['data'] = $_SESSION["dataSuggestionsSames"];
			$_SESSION['mismoHotelDo'] = $_SESSION['tarifasTravelSolution'];

			$this->render('tarifasxhotel', $_SESSION["resultadoBusquedaHoteles"]);
		}
	}

	public function actionHotelesSugerencias($id_hotel, $id_zona, $id_categoria)
	{
		if (!$_SESSION["dataSuggestions"]) {
			$_SESSION["resultadoBusquedaHoteles"]["categoria"] = " and tarifaHotel.id_categoria=" . $id_categoria;

			extract($_SESSION["resultadoBusquedaHoteles"]); //extrae las variables de la sesion

			$hoteles = Hoteles::model()->findAll(array('condition' => 'id_destino=' . $id_zona . ' AND id_hotel!=' . $id_hotel . ' AND estatus=1 AND proveedor=0 AND no_listar!=0 ' . $solo_adultos));

			$result_zonas = $this->getTarifas($hoteles, false);
			//echo "<textarea>".CJSON::encode($result)."</textarea>";

			if (count($result_zonas) == 0) {
				$_SESSION['front_form']['categoria'] = array($id_categoria);

				$hoteles = Hoteles::model()->findAll(array('condition' => 'id_destino=' . $id_zona . ' AND nombre_hotel NOT LIKE "%' . $nombre_hotel . '%" AND id_hotel!=' . $id_hotel . ' AND estatus=1 AND proveedor!=0 ' . $solo_adultos));

				$result_zonas = $this->getTarifas($hoteles, false);
			}

			$_SESSION["dataSuggestions"] = $result_zonas;
			// echo "<textarea>".CJSON::encode($_SESSION["dataSuggestions"])."</textarea>";
			$this->renderPartial('hoteles', array('hoteles' => $_SESSION["dataSuggestions"], 'listView' => 'listViewSugerencias', 'id_zona' => $id_zona));
		} else {
			$_SESSION['data'] = $_SESSION["dataSuggestions"];

			$this->render('tarifasxhotel', $_SESSION["resultadoBusquedaHoteles"]);
		}
	}

	public function getTarifas($hoteles, $bandera)
	{
		extract($_SESSION["resultadoBusquedaHoteles"]);

		if ($bandera == true) {
			$this->clearSesion();
		} else {
			$filtro_disponibilidad = true;
		}



		$busquedaController = Yii::app()->createController('busqueda');
		$busquedaController = $busquedaController[0];
		$omniBeesController = Yii::app()->createController('omniBees');
		$omniBeesController = $omniBeesController[0];
		$travelSolutionController = Yii::app()->createController('travelSolution');
		$travelSolutionController = $travelSolutionController[0];
		$palaceController = Yii::app()->createController('palace');
		$palaceController = $palaceController[0];
		$riuController = Yii::app()->createController('riu');
		$riuController = $riuController[0];
		$dingusController = Yii::app()->createController('dingus');
		$dingusController = $dingusController[0];

		$contarHotel = count($hoteles);
		$i_tarifas = 0;
		$cuartospalace = 0;
		$tipohab = "";
		$codigosHoteles = array();
		$palaceResorts = array('BP', 'CZ', 'IM', 'LBC', 'MPS', 'PL', 'SP', 'MPG');
		//$tipoPrecio = array('OUTLET','PROMO','NORMAL','VIP');


		if ($_POST['tipoPrecio']) {
			$tipoPrecio = array('OUTLET');
			//$tipoPrecio = array('OUTLETGRUPOS');
		} else {

			//$tipoPrecio = array('OUTLET','PROMO','NORMAL','VIP','OUTLETGRUPOS');
			$tipoPrecio = array('OUTLET', 'PROMO', 'NORMAL', 'VIP');
		}
		$propios["hotels"]["hotels"] = array();
		$mapaDestinos = array();
		$hotelesOcultar = array();


		foreach ($hoteles as $killing => $row) {
			$code = explode("/", $row->codigo);
			if ($row->proveedor == 0) {
				//echo  $row->id_hotel."<br>";
				$tarifasArray = array();
				$importesArray = array();
				$menorTarifa = 0;
				$num_tarifas = 0;
				$roomsPalace = array();
				$disponibilidadPalace = null;
				$banderaBootom = false;
				foreach ($tipoPrecio as  $precio) {




					/*if($precio =="VIP")
        		     $vip=TarifaAgencia::model()->find("id_agencia=".$_SESSION["agenciaUsuario"]);

				    if($_SESSION["agenciaUsuario"] != 9 || !$vip){

        		
						$tarifaAgencias = 'and not exists(select NULL from tbl_tarifa_agencia tarifaAgencias where tarifaAgencias.id_tarifa=t.id_tarifa and tarifaAgencias.id_agencia!='.$_SESSION["agenciaUsuario"].')';
					

						$agenciaUsuario = $_SESSION["agencia"]; 
						$tarifaEstados = 'and exists(select tarifaEstados.id_tarifa from tbl_tarifa_estados tarifaEstados where tarifaEstados.id_tarifa=t.id_tarifa and tarifaEstados.id_estado='.$agenciaUsuario->id_estado_agencia.')';
					}
					*/

					$todas = Tarifa::model()->with('tarifaHotel', 'tarifaDesgloses', 'tarifaDiasvalidos')->findAll(array('condition' => 't.id_hotel=' . $row->id_hotel . ' ' . $categoria . ' ' . $tipo_precio . ' ' . $tipo_plan . ' ' . $fecha_promo . ' ' . $hora . ' ' . $early_booking . ' and "' . $fecha_inicial . '" >= current_date and dia=' . date("N", strtotime($fecha_inicial)) . ' and "' . $fecha_inicial . '" between t.fecha_inicial and t.fecha_final and t.precio IN("' . $precio . '") and t.estatus=1 and id_base_habitacion=2 ' . $tarifaAgencias . ' ' . $tarifaEstados . '', 'order' => 't.id_tipo_plan ASC, precio_normal ' . $ORDER_PRECIO . ''));

					foreach ($todas as $subrow) {

						$tipohabs = TipoHabitaciones::model()->with('tarifaDesgloses')->findAll(array('condition' => 'id_hotel=' . $row->id_hotel . ' and id_tarifa=' . $subrow->id_tarifa . ' and id_base_habitacion=2 and t.estatus=1', 'order' => 'precio_normal ' . $ORDER_PRECIO . ''));


						foreach ($tipohabs as $habs) {
							if (!empty($habs->id_tipo_habitacion)) {
								if (in_array($row->codigo, $palaceResorts)) {
									if (!array_key_exists($habs->codigo, $roomsPalace)) {


										$responseDisponibilidadPalace = json_decode($busquedaController->disponibilidadPalace($fecha_inicial, $noches, $row->codigo, $habs->codigo));
										//echo "<textarea>".json_encode($responseDisponibilidadPalace).$habs->codigo."</textarea>";
										$disponibilidadPalace = $responseDisponibilidadPalace->Data->Availability_Exists;

										//echo $disponibilidadPalace."<br>";
										//if($responseDisponibilidadPalace->ExceptionInfo->Message)
										//{
										//echo $responseDisponibilidadPalace->ExceptionInfo->Message;						                        
										//}
										$roomsPalace[$habs->codigo] = $disponibilidadPalace;
										$cuartospalace++;
									}
									$disponibilidadPalace = $roomsPalace[$habs->codigo];
								}

								//echo "<b>".$habs->id_tipo_habitacion."</b>".$disponibilidadPalace."<br>";

								//$tipohab = TipoHabitaciones::model()->findByPk($habs->id_tipo_habitacion);
								$data = json_decode($busquedaController->getPrecio($habs, $subrow->id_tarifa, $row->id_hotel, $fecha_inicial, $noches, false, $fecha_final, $disponibilidadPalace));
								if ($data->menorTarifa != 0) {
									if (!$tarifasArray[$habs->id_tipo_habitacion]) {
										$tarifasArray[$habs->id_tipo_habitacion] = array();
										$tarifasArray[$habs->id_tipo_habitacion]["menorTarifa"] = 0;
										$tarifasArray[$habs->id_tipo_habitacion]["disponibilidad"] = $data->disponibilidad;
									}


									array_push($tarifasArray[$habs->id_tipo_habitacion], array('id_tarifa' => $subrow->id_tarifa, 'menorTarifa' => $data->menorTarifa, 'disponibilidad' => $data->disponibilidad, 'btnColor' => $data->btnColor));

									if ($tarifasArray[$habs->id_tipo_habitacion]["disponibilidad"] != true && $data->disponibilidad == true)
										$tarifasArray[$habs->id_tipo_habitacion]["disponibilidad"] = true;

									//echo $data->menorTarifa."<br>";
									$importesArray[$data->disponibilidad][] = $data->menorTarifa;
									$num_tarifas++;
									$i_tarifas++;
								}
							}
						}
					}
				}

				//echo "<textarea>".json_encode($importesArray)."</textarea>";

				if ($importesArray[true]) {
					$menorTarifa = min($importesArray[true]);
					//$noDisponible=true;
					$disponibilidadHotel = true;
				} else {
					$menorTarifa = min($importesArray[false]);
					//$noDisponible=false;
					$disponibilidadHotel = false;
					$hotelesOcultar[] = $row->id_hotel;
				}

				if ($importesArray[false])
					$banderaBootom = true;


				//echo "<b>".$menorTarifa."</b>";

				if ($num_tarifas > 0) {
					$row->precio = $menorTarifa;

					if ($filtro_disponibilidad == true) {
						if ($disponibilidadHotel != true)
							$row->precio = 0;
					}

					if ($row->precio == 0 && $contarHotel > 1) {
						unset($hoteles[$killing]);
					} else {
						array_push($propios["hotels"]["hotels"], array('id_hotel' => $row->id_hotel, 'menorTarifa' => $menorTarifa, 'banderaBootom' => $banderaBootom, 'num_tarifas' => $num_tarifas, 'disponibilidadHotel' => $disponibilidadHotel, 'rooms' => $tarifasArray));
						$mapaDestinos[] = $this->addMapDestination($row);
					}
				} else {
					if ($contarHotel > 1) {
						unset($hoteles[$killing]);
					} else {
						array_push($propios["hotels"]["hotels"], array('id_hotel' => $row->id_hotel, 'menorTarifa' => $menorTarifa, 'banderaBootom' => $banderaBootom, 'num_tarifas' => $num_tarifas, 'disponibilidadHotel' => $disponibilidadHotel, 'rooms' => $tarifasArray));
						$mapaDestinos[] = $this->addMapDestination($row);
					}
				}
			} else if ($row->proveedor == 1) {
				$codigosHoteles[] = $code[0];
			} else if ($row->proveedor == 2) {
				$codigoHotel = $code[0];
				$countryCode = $row->Destino->destinationsCode0->countryCode;
				$result = $omniBeesController->hotelOmnibees($codigoHotel, true, $row->id_hotel, $countryCode);
				$_SESSION["tarifasOmniBees"][$row->id_hotel] = json_decode($result);

				$result = json_decode($result);
				$PlanOmnibees = $result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RatePlans->RatePlanType->MealsIncluded->MealPlanCode;

				$omniBeesController->tarifasOmniBees($codigoHotel, $row->id_hotel, $fecha_inicial, 0, $countryCode);
				if ($_SESSION['menorPrecioOmniBees'][$row->id_hotel] > 0) {
					$row->precio = $_SESSION['menorPrecioOmniBees'][$row->id_hotel];
				} else {
					if ($contarHotel > 1 || (!empty($_POST['Tarifa']['id_tipo_plan']) && $_POST['Tarifa']['id_tipo_plan'] != 1))
						unset($hoteles[$killing]);
				}
				if (empty($PlanOmnibees) &&  $_POST['Tarifa']['id_tipo_plan'] == 1) {
					unset($hoteles[$killing]);
				}
			} else if ($row->proveedor == 3) {
				$codigosHotelTravelSolution[] = $code[0];
			} else if ($row->proveedor == 4) {

				$avail = $riuController->hotelAvail($code[0]);
				$hotelAvail = json_decode($avail, true);

				$AvailabilityGroup = $hotelAvail[0]['HotelAvailResponse']['HotelAvailResponse']['availabilityList']['AvailabilityGroup'];
				$_SESSION['riuAvail'][$row->id_hotel] = $avail;
				$bookingRule = $riuController->sortBookingRule($AvailabilityGroup);
				$_SESSION['riuBookingRule'][$row->id_hotel] = $bookingRule;
				$keys = array_keys($bookingRule);

				$row->precio = ($keys[0]);
				//echo $row->precio;
				if ($contarHotel > 1) {
					if (empty($hotelAvail[0]['HotelAvailResponse']['HotelAvailResponse']['availabilityList'])) {
						unset($hoteles[$killing]);
					}

					if ($hotelAvails[0]['soapFault']['detail']['ExcepcionesNegocio']['errores']['ErroresDto'][0]['codigoError'] == "EX005") {
						unset($hoteles[$killing]);
					}
				}
			} else if ($row->proveedor == 5) {
				$hotelAvail = $dingusController->hotelAvail($code[0], $row->Cadena->url_dingus, $row->id_hotel);
				$hotelAvails = json_decode($hotelAvail, true);
				$roomRates = $dingusController->roomsrates($hotelAvails);
				$tarifa = array();
				$imp = true;
				$impr = true;
				$roomsRates = "";
				foreach ($roomRates as $keys => $value) {

					foreach ($value as $meal => $room) {
						foreach ($room as $rph => $cuartos) {
							foreach ($cuartos as $cuarto) {

								if ($cuarto['@attributes']['RoomTypeCode'] == $keys) {
									if ($_SESSION['front_form']['habs'] == 1) {
										$amountKey[$rph] = $cuarto['Total']['@attributes']['AmountAfterTax'];
									} else {
										if ($rph == $cuarto['@attributes']['RatePlanCode']) {
											$amountKey[$rph] += $cuarto['Total']['@attributes']['AmountAfterTax'];
										}
									}
									$roomsRates[$keys][$meal][$rph] += $cuarto['Total']['@attributes']['AmountAfterTax'];
								}
							}
						}
					}
				}

				foreach ($roomsRates as $roomTypes => $meal) {
					ksort($roomTypes);
					$imp = true;
					foreach ($meal as $mealcode => $ratecode) {
						foreach ($ratecode as $rate => $value) {
							if ($imp == true) {
								$row->precio = $value;
							}
							$imp = false;
						}
					}
				}

				//echo "<textarea>".json_encode($roomsRated)."</textarea>";
				/*	if ($_SESSION['tipoUsuario'] == 'Agencia') {
        			unset($hoteles[$killing]);
        		}*/

				$_SESSION['dingusAvail' . $code[0]] = $hotelAvail;
				if ($contarHotel > 1) {
					if (empty(json_decode($hotelAvail))) {
						unset($hoteles[$killing]);
					}
				}
			} else if ($row->proveedor == 6) {
				$codigoHotelPalace = $code[0];
				$AvailabilityPalace = $palaceController->ObtenerDisponibilidad($fecha_inicial, $noches, $code[0]);
				$_SESSION["tarifasPalace"][$row->id_hotel] = json_decode($AvailabilityPalace);
				$avail = json_decode($AvailabilityPalace, true);
				$keyHab = array_keys($avail[0]['Habitaciones']);
				$habcount = count($keyHab);
				$habnull = 0;
				foreach ($avail[0]['Habitaciones'] as $key => $value) {
					if ($value['Ws'][0]["TotalAmout"] == null) {
						$habnull++;
					}
				}
				if ($contarHotel > 1) {
					if ($habnull == $habcount) {
						unset($hoteles[$killing]);
					}
				}

				##planes
				#
				if ($_SESSION['front_form']['tipoPlan']) {
					# code...
					if ($_SESSION['front_form']['tipoPlan']->id_plan != 1) {
						unset($hoteles[$killing]);
					}
				}
				####
				#
				$row->precio = $avail[0]['Habitaciones'][$keyHab[0]]['Ws'][0]['TotalAmount'];
			}
		}


		if ($i_tarifas > 0) {
			$_SESSION["tarifaspropias"] = json_encode($propios);

			/*if(!$_SESSION["tarifaspropias"]){
				$_SESSION["tarifaspropias"]=json_encode($propios);
			}else
			{
				
				
				//UNIR LA ANTERIOR CON LAS NUEVAS	
				$tarifaspropias_session=json_decode($_SESSION["tarifaspropias"]);	
				$tarifaspropias=json_decode(json_encode($propios));
				$resultHoteles = array_merge($tarifaspropias_session->hotels->hotels, $tarifaspropias->hotels->hotels);
				$tarifaspropias_session->hotels->hotels=$resultHoteles;
				$_SESSION["tarifaspropias"]=json_encode($tarifaspropias_session);
				
			}*/
		} else {
			if ($_POST["tipoPrecio"]) {
				$_SESSION["tarifaspropias"] = "tarifaOutlet";
			} else {
				$_SESSION["tarifaspropias"] = null;
			}
		}


		##STAR HOTEL BEDS
		$resultado["hotels"]["hotels"] = array();
		$resultado = json_encode($resultado);
		$resultado = json_decode($resultado);
		if (count($codigosHoteles) > 0) {
			$codigosHotelAgrupados = array_chunk($codigosHoteles, 500);
			foreach ($codigosHotelAgrupados as $key => $value) {
				$response = json_decode($this->tarifasBeds($value));

				$resultHoteles = array_merge($resultado->hotels->hotels, $response->hotels->hotels);

				$resultado->hotels->hotels = $resultHoteles;
			}
		}


		$jsonHotel = json_encode($resultado);

		//echo '<textarea rows="10" cols="50">'.$jsonHotel.'</textarea>';
		//echo '<textarea rows="10" cols="50">'.$_SESSION["tarifaspropias"].'</textarea>';



		$_SESSION["tarifasbeds"] = $jsonHotel;
		$ahotelHB = json_decode($jsonHotel, true);
		$arrHotel = $ahotelHB["hotels"]["hotels"];

		//echo '<textarea rows="10" cols="50">'.json_encode($codigosHoteles).'</textarea>';

		foreach ($codigosHoteles as $codigoHotel) {
			$keyHotel = false;
			$menorTarifaBeds = 0;
			if ($arrHotel != NULL) {
				$keyHotel = array_search($codigoHotel, array_column($arrHotel, 'code'));
			}
			$hotelHB = Hoteles::model()->find('codigo LIKE "' . $codigoHotel . '/%" and proveedor=1');
			if ($keyHotel === false) {
				$hotelesOcultar[] = $hotelHB->id_hotel;
			} else {
				$menorTarifaBeds = $busquedaController->menorTarifaBeds(json_encode($arrHotel[$keyHotel]));
			}



			foreach ($hoteles as $kill => $hotelAll) {
				if ($hotelAll->id_hotel == $hotelHB->id_hotel) {

					if ($menorTarifaBeds > 0) {
						$hotelAll->precio = $menorTarifaBeds;
						$mapaDestinos[] = $this->addMapDestination($hotelAll);
					} else {
						if ($contarHotel > 1) {
							unset($hoteles[$kill]);
						} else {
							$hotelesOcultar[] = $hotelHB->id_hotel;
						}
					}
				}
			}
		}

		##END HOTEL BEDS
		#
		#
		###START TRAVELSOLUTION

		$resultadoTS["hotels"]["hotels"] = array();
		$resultadoTS = json_encode($resultadoTS);
		$resultadoTS = json_decode($resultadoTS);

		//echo "<textarea>".json_encode($codigosHotelTravelSolution)."</textarea>";

		if (count($codigosHotelTravelSolution) > 0) {
			$codigosHotelAgrupados = array_chunk($codigosHotelTravelSolution, 500);
			foreach ($codigosHotelAgrupados as $key => $value) {
				//print_r($value);
				$response = $this->tarifasTravelSolution($value, true);
				//echo '<textarea rows="10" cols="50">'.$response.'</textarea>';
				$response = json_decode($response);


				if (count($response->Hotels->Hotel) == 1) {
					$jsonHotel = json_encode($resultadoTS);
					$resultadoTS = json_decode($jsonHotel, true);
					//var_dump($response->Hotels->Hotel);			

					$h = (array)$response->Hotels->Hotel;
					//print_r($h);
					$resultadoTS["hotels"]["hotels"][] = $h;
					//array_push($resultadoTS["hotels"]["hotels"],$h);	
					//var_dump($resultadoTS);
					//print_r($resultadoTS);

				} else {

					$resultHotelesTS = array_merge($resultadoTS->hotels->hotels, $response->Hotels->Hotel);
					$resultadoTS->hotels->hotels = $resultHotelesTS;
				}
			}
		}

		$jsonHotelTS = json_encode($resultadoTS);

		$_SESSION["tarifasTravelSolution"] = $jsonHotelTS;


		//echo "<textarea>".$_SESSION["tarifasTravelSolution"]."</textarea>";

		foreach ($codigosHotelTravelSolution as $codigoHotelTS) {
			$hotelTS = Hoteles::model()->find('codigo LIKE "' . $codigoHotelTS . '/%" AND proveedor=3');

			$menorTarifaTS = $travelSolutionController->menorTarifaTravelSolution($codigoHotelTS);

			foreach ($hoteles as $kill => $hotelAll) {
				if ($hotelAll->id_hotel == $hotelTS->id_hotel) {
					if ($menorTarifaTS == 0) {
						//echo $hotelAll->id_hotel."--".$hotelTS->id_hotel." -- ".$menorTarifaTS."<br>";	 				
						if ($contarHotel > 1) {
							unset($hoteles[$kill]);
						} else {
							$hotelesOcultar[] = $hotelTS->id_hotel;
						}
					} else {
						$hotelAll->precio = $menorTarifaTS;
						$mapaDestinos[] = $this->addMapDestination($hotelAll);
					}
				}
			}
		}
		##END TRAVELSOLUTION

		if (count($mapaDestinos) > 0)
			$_SESSION["resultadoBusquedaHoteles"]["mapaDestinos"] = json_encode($mapaDestinos);
		else
			$_SESSION["resultadoBusquedaHoteles"]["mapaDestinos"] = null;

		$_SESSION["resultadoBusquedaHoteles"]["hotelesOcultar"] = $hotelesOcultar;

		return $hoteles;
	}

	public function dataProvider($hoteles)
	{
		return new CArrayDataProvider($hoteles, array(
			'keyField' => 'id_hotel',
			'sort' => array(
				'attributes' => array(
					'precio'
				),
				'defaultOrder' => 'precio'
			),
			'pagination' => array(
				'pageSize' => 10
			),
		));
	}

	public function addMapDestination($hotel)
	{
		$map = explode("/", $hotel->ubicacion);
		$htmlMark = "<p style='font-size: 1.2em;'>" . $hotel->nombre_hotel . "<p> 
					<p><b> Desde: </b>$ " . number_format($hotel->precio, 2) . "</p>
					<p class='text-right'><button class='cotizarHotel btn btn-info btn-xs' data-nombrehotel='" . $hotel->nombre_hotel . "' data-id='" . $hotel->id_hotel . "'>Ver más</button></p>";

		return array($htmlMark, $map[1], $map[0], number_format($hotel->precio, 2));
	}

	public function actionEstrellas()
	{
		$session = new CHttpSession;
		$session->open();
		if ($_POST['category']) {
			$_SESSION["ajaxCategoria"] = $_POST['category'];
		} else {
			unset($_SESSION["ajaxCategoria"]);
		}
	}

	public function consultarBeds($request)
	{
		$hotelApi = new HotelApi();
		$estatus = $hotelApi->estatus();
		//return $estatus;
		if ($estatus == "OK") {
			$response = $hotelApi->hotelAvailableWithFilters($request);

			return $response;
		} else {
			return "No hubo conexión";
		}
	}

	public function tarifasBeds($codigoHotel, $session_api)
	{

		if ($_SESSION["front_form"]) {
			# code...	
			$front_form = $_SESSION["front_form"];
		} else {

			$front_form = $session_api;
		}

		// $front_form = $session_api;
		//echo json_encode($front_form);
		$fe = $front_form["fecha_ini"]; //$_POST["fecha_entrada"];
		$fs = $front_form["fecha_fin"]; //$_POST["fecha_salida"];
		$rooms = $front_form["habs"]; //$_POST["habs"];
		$front_form['info_search'];
		$fecha_inicial = implode("-", array_reverse(explode("/", $fe)));
		$fecha_final = implode("-", array_reverse(explode("/", $fs)));
		$request = array();
		$request["stay"]["checkIn"] = $fe;
		$request["stay"]["checkOut"] = $fs;
		$request["dailyRate"] = true;
		$request["stay"]["allowOnlyShift"] = false;
		$datetime1 = new DateTime($fecha_inicial);
		$datetime2 = new DateTime($fecha_final);
		$interval = $datetime1->diff($datetime2);
		$noches = $interval->format('%a');
		$request["stay"]["shiftDays"] = 2;
		for ($i = 1; $i <= $rooms; $i++) {
			$var_habs = "habitacion_" . $i;
			$request["occupancies"][$i - 1]["rooms"] = 1;
			$request["occupancies"][$i - 1]["paxes"] = array();
			// $request["occupancies"][$i-1]["adults"]=$front_form['info_search'][$i]["adultos"];
			$request["occupancies"][$i - 1]["adults"] = $front_form["habitacion_" . $i]["adultos"];
			// for ($j=1; $j <= $front_form['info_search'][$i]["adultos"]; $j++) {
			// 		$pax=array('type'=>'AD','age'=>30);
			// 	//array_push($request["occupancies"][0]["paxes"],$pax);
			// 	array_push($request["occupancies"][$i-1]["paxes"],$pax);
			// }
			for ($j = 1; $j <= $front_form["habitacion_" . $i]["adultos"]; $j++) {
				$pax = array('type' => 'AD', 'age' => 30);
				//array_push($request["occupancies"][0]["paxes"],$pax);
				array_push($request["occupancies"][$i - 1]["paxes"], $pax);
			}
		}
		for ($i = 1; $i <= $rooms; $i++) {
			$var_habs = "habitacion_" . $i;
			// $request["occupancies"][$i-1]["children"]=$front_form['info_search'][$i]["no_menores"];
			$request["occupancies"][$i - 1]["children"] = $front_form["habitacion_" . $i]["num_ninios"];

			// for ($j=1; $j <=$front_form['info_search'][$i]["no_menores"]; $j++) {
			// 	$pax=array('type'=>'CH','age'=>$front_form['info_search'][$i]["menores"][$j-1]);
			// 	//array_push($request["occupancies"][$i-1]["paxes"],$pax);
			// 	array_push($request["occupancies"][$i-1]["paxes"],$pax);
			// }
			for ($j = 1; $j <= $front_form["habitacion_" . $i]["num_ninios"]; $j++) {
				$var_edad = "edad_" . $j;
				$pax = array('type' => 'CH', 'age' => $front_form["habitacion_" . $i]["edad_" . $j]);
				//array_push($request["occupancies"][$i-1]["paxes"],$pax);
				array_push($request["occupancies"][$i - 1]["paxes"], $pax);
			}
		}
		if ($front_form["tipoPlan"] != null) {
			$request["boards"]["included"] = true;
			$request["boards"]["board"][0] = $front_form["tipoPlan"]->code;
		}
		$request["hotels"]["hotel"] = $codigoHotel;
		$request["filter"]["packaging"] = false;

		if ($front_form["categoria"] != null) {

			$request["filter"]["minCategory"] = min($front_form["categoria"]);
			$request["filter"]["maxCategory"] = max($front_form["categoria"]);
		}
		$e = $this->consultarBeds(json_encode($request));
		// echo json_encode($request);exit;

		$response = json_decode($e);
		$logHotelbeds = array();
		$logHotelbeds['header'] = "Avail";
		$logHotelbeds['request'] = json_encode($request);
		$logHotelbeds['response'] = $e;
		$logHotelbeds['reference'] = json_encode($codigoHotel);
		$this->logWs($logHotelbeds, 'Beds');
		return $e;
	}

	public function Arrayorder()
	{
	}
	//public function actionConsultarBeds()

	public function tarifasTravelSolution($array_codigosHoteles, $bandera, $session_api)
	{
		if ($_SESSION["front_form"]) {
			$front_form = $_SESSION["front_form"];
		} else {
			$front_form = $session_api;
		}

		$recheck['array_codigosHoteles'] = $array_codigosHoteles;
		$recheck['bandera'] = $bandera;
		$recheck['session_api'] = $session_api;

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://www.rutamayatravel.com/sur4/reservacion/recheckHotelDo",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => "rateKey=" . json_encode($recheck) . "&check=1",
			CURLOPT_HTTPHEADER => array(
				"Content-Type: application/x-www-form-urlencoded",
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		return $response;

		// $travelSolution = new TravelSolution;	 

		// $fecha_ini=explode("/", $front_form["fecha_ini"]);
		// $fecha_fin=explode("/", $front_form["fecha_fin"]);
		// $rooms=$front_form["habs"];
		// $clave_afiliado=$travelSolution->affiliateId;
		// $ip="MX";
		// $currency="PE";
		// $lenguage="esp";
		// $star_date=$fecha_ini[2].$fecha_ini[1].$fecha_ini[0];
		// $end_date=$fecha_fin[2].$fecha_fin[1].$fecha_fin[0];

		// $codigosHoteles="";
		// foreach ($array_codigosHoteles as $codigo ) 
		// {
		// 	$codigosHoteles.=$codigo.",";
		// }

		// $codigosHoteles = trim($codigosHoteles, ',');

		// for ($i=1; $i <= $rooms; $i++) 
		// {	
		// 	$var_habs = "habitacion_".$i;
		// 	$pax.="r".$i."a=".$front_form["habitacion_".$i]["adultos"]."&";
		// 	$pax.="r".$i."k=".$front_form["habitacion_".$i]["num_ninios"]."&";
		// 	for ($j=1; $j <=$front_form["habitacion_".$i]["num_ninios"]; $j++) 
		// 	{
		// 		$var_edad = "edad_".$j;
		// 		$pax.="r".$i."k".$j."a=".$front_form["habitacion_".$i]["edad_".$j]."&";
		// 	}	
		// }

		// $pax = trim($pax, '&');


		// ######  POSIBLE ERROR EN $FRONT_FORM AL REFERENCIAR A codeTS
		// $request = "a=".$clave_afiliado."&co=".$ip."&c=".$currency."&sd=".$star_date."&ed=".$end_date."&mp=".$front_form['tipoPlan']->codeTS."&h=".$codigosHoteles."&r=".$rooms."&".$pax."&l=".$lenguage;

		// //echo $request."<br>";


		// $response=$this->consultarTravelSolution($request,$bandera);
		// //$response=$this->xml_to_json($response_xml);
		// //echo '<textarea rows="10" cols="50">'.$request.'</textarea>';
		// //echo '<textarea rows="10" cols="50">'.$response.'</textarea>';

		// 	$logHotelbeds = array();
		// 	$logHotelbeds['header'] = "Avail";
		// 	$logHotelbeds['request'] = $request;
		// 	$logHotelbeds['response'] = $response;
		// 	$logHotelbeds['reference'] = $codigosHoteles;
		// 	$this->logWs($logHotelbeds,'HotelDo');
		return $response;
	}

	public function consultarTravelSolution($request, $bandera)
	{
		$travelSolution = new TravelSolution;

		if ($bandera == true) {
			$response = $travelSolution->getQuoteHotels($request);
			//$this->archivoLog($request,"getQuoteHotelsRQ ".$_SESSION["timeTS"].".txt");
		} else {
			$response = $travelSolution->getQuoteHotelRate($request);
		}

		return $response;
	}

	public function archivoLog($cadena, $file)
	{
		if ($archivo = fopen($file, "a")) {

			fwrite($archivo, $cadena);

			fclose($archivo);
		}
	}

	public function hotelTSInformation($codigoHotel, $id_hotel)
	{
		if (!$_SESSION["informationHotelesTS"])
			$_SESSION["informationHotelesTS"] = array();

		$travelSolution = new TravelSolution;
		//$modelTS=json_decode(Api::model()->findByPk(6)->params);
		$clave_afiliado = $travelSolution->affiliateId; //$modelTS->clave_afiliado;
		$ip = $_SERVER["REMOTE_ADDR"];
		$currency = "PE";
		$lenguage = "ESP";

		$request = "a=" . $clave_afiliado . "&ip=" . $ip . "&c=" . $currency . "&h=" . $codigoHotel . "&l=" . $lenguage;
		//echo $request."<br>";
		$response = $travelSolution->getHotelInformation($request);
		//echo $response;
		$_SESSION["informationHotelesTS"][$id_hotel] = json_decode($response, true)["Hotel"];

		//return $response;
	}

	public function actionCargarfotos()
	{
		$id_hotel = $_POST['id_hotel'];
		$proveedor = $_POST['proveedor'];

		if ($proveedor == 3) {
			$galleriesHotel = json_decode(json_encode($_SESSION["informationHotelesTS"][$id_hotel]["Galleries"]));
			$image = $galleriesHotel->Image;
			$count_Image = count($image);

			$fotos = array();

			for ($i = 0; $i < $count_Image; $i++) {
				if ($count_Image > 1) {
					$img = $image[$i];
				} else {
					$img = $image;
				}

				$foto = array('id_hotel' => $id_hotel, 'foto' => $img->URL, 'piedefoto' => $img->Description);

				array_push($fotos, $foto);
			}
		} else {
			$fotos = HotelesFotos::model()->findAll('id_hotel=' . $id_hotel . ' and logotipo!=1');
		}

		echo CJSON::encode($fotos);
	}

	public function actionCargarhabitaciones()
	{
		$id_hotel = $_POST['id_hotel'];
		$id_tarifa = $_POST['id_tarifa'];
		$id_plan = $_POST['id_plan'];
		$tipohabs = TipoHabitaciones::model()->with('tarifaDesgloses')->findAll(array('condition' => 'id_hotel=' . $id_hotel . ' and id_tarifa=' . $id_tarifa . ' and t.estatus=1', 'order' => 'precio_normal ' . $_POST['ORDER_PRECIO'] . ''));
		$this->renderPartial('desglosetarifa', array('tipohabs' => $tipohabs, 'id_tarifa' => $id_tarifa, 'id_plan' => $id_plan, 'id_hotel' => $id_hotel));
	}

	public function actionCotizarapida()
	{
		$palaceResorts = array('BP', 'CZ', 'IM', 'LBC', 'MPS', 'PL', 'SP', 'MPG');
		$disponibilidadPalace = null;
		$id_hotel = $_POST['id_hotel'];
		$id_tarifa = $_POST['id_tarifa'];
		if (!empty($_POST['id_hab'])) {
			$tipohab = TipoHabitaciones::model()->findByPk($_POST['id_hab']);
		} else {
			$tipohabs = TipoHabitaciones::model()->with('tarifaDesgloses')->findAll(array('condition' => 'id_hotel=' . $id_hotel . ' and id_tarifa=' . $id_tarifa . ' and t.estatus=1', 'order' => 'precio_normal ' . $_POST['ORDER_PRECIO'] . ''));
			$tipohab = $tipohabs[0];
		}
		$fecha_inicio = $_POST['fecha_inicio'];
		$noches = $_POST['noches'];

		$hotel = Hoteles::model()->findByPk($id_hotel);

		if (in_array($hotel->codigo, $palaceResorts)) {
			$jsonHotel = $_SESSION["tarifaspropias"];
			$ahotel = json_decode($jsonHotel, true);

			$arrHotel = $ahotel["hotels"]["hotels"];
			$key = array_search($id_hotel, array_column($arrHotel, 'id_hotel'));

			$rates = $arrHotel[$key]["rooms"][$tipohab->id_tipo_habitacion];
			$keyrate = array_search($id_tarifa, array_column($rates, 'id_tarifa'));

			$disponibilidadPalace = $rates[$keyrate]["disponibilidad"];
		}



		$this->renderPartial("/busqueda/_itemCotizacionrapida", array('tipohab' => $tipohab, 'id_tarifa' => $id_tarifa, 'id_hotel' => $id_hotel, 'fecha_inicial' => $fecha_inicio, 'noches' => $noches, 'disponibilidadPalace' => $disponibilidadPalace, 'contenidoAjax' => true));
	}

	public function actionTarifasbase()
	{
		$id_hotel = $_POST['id_hotel'];
		$id_tarifa = $_POST['id_tarifa'];
		$tipohab = TipoHabitaciones::model()->findByPk($_POST['id_hab']);
		$fecha_inicio = $_POST['fecha_inicio'];
		$noches = $_POST['noches'];
		$combinar = $_POST['combinar'];
		$ORDER_PRECIO = $_POST['ORDER_PRECIO'];
		$this->renderPartial('tarifasbase', array('tipohab' => $tipohab, 'id_tarifa' => $id_tarifa, 'id_hotel' => $id_hotel, 'fecha_inicial' => $fecha_inicio, 'noches' => $noches, 'ORDER_PRECIO' => $ORDER_PRECIO, 'combinar' => $combinar));
	}

	public function actionConsultarfechas()
	{
		session_start();
		$tarifaWs = json_decode(base64_decode($_POST['habitacion']));
		$hotel = Hoteles::model()->findByPk($_POST['id_hotel']);
		$id_tarifa = $_POST['id_tarifa'];
		$tarifa = Tarifa::model()->findByPk($id_tarifa);
		$tipohab = TipoHabitaciones::model()->findByPk($_POST['id_tipohab']);
		$palaceResorts = array('BP' => 1, 'CZ' => 1, 'IM' => 1, 'LBC' => 1, 'MPS' => 1, 'PL' => 1, 'SP' => 1, 'MPG' => 1);
		$realResorts = array('GPR' => 1);
		//if($_SESSION['tipoUsuario'] != 'Agencia')
		{
			$fecha_inicio = $_POST['fecha_inicio'];
			$fecha_final = date('Y-m-d', strtotime($_POST['fecha_inicio'] . " +" . $_POST['noches'] . " days"));
			/*$startTimeStamp = strtotime("now");
			$endTimeStamp = strtotime($fecha_inicio);
			$noches = ceil(abs($endTimeStamp - $startTimeStamp) / 86400);*/
			$datetime1 = new DateTime(date("Y-m-d"));
			$datetime2 = new DateTime($fecha_inicio);
			$interval = $datetime1->diff($datetime2);
			$noches = $interval->format('%a');
			if (!empty($palaceResorts[$hotel->codigo])) {
				$wsResponse = $this->palaceWs($hotel->codigo, $tarifa->codigo, $tipohab->codigo, $fecha_inicio, $fecha_final);
			} else if (!empty($realResorts[$hotel->codigo])) {
			}
		}

		if ($_POST['rate'] != "") {
			$contenedor = "collapseTarifas_" . $hotel->id_hotel;
		} else {
			$contenedor = "contenidoAjax" . $hotel->id_hotel;
		}
		$this->renderPartial('tablafechas', array('hotel' => $hotel, 'id_tarifa' => $id_tarifa, 'tipohab' => $tipohab, 'fecha_inicio' => $_POST['fecha_inicio'], 'noches' => $_POST['noches'], 'wsResponse' => $wsResponse, 'rate' => $_POST['rate'], 'contenedor' => $contenedor, 'disponibilidad' => $_POST['btnColor'], 'tarifaHabitacion' => $tarifaWs));
	}

	public function palaceWs($hotel, $tarifa, $tipo_hab, $fecha_inicio, $fecha_final)
	{
		session_start();
		$ini = ini_set("soap.wsdl_cache_enabled", "0");
		//$client = new SoapClient("https://api.palaceresorts.com/EnterpriseServiceInterface/ServiceInterface.asmx?wsdl");
		$wsResponse = array();
		for ($i = 1; $i <= $_SESSION['front_form']['habs']; $i++) {
			$adultos = $_SESSION['front_form']['habitacion_' . $i]['adultos'];
			$menores = $_SESSION['front_form']['habitacion_' . $i]['num_ninios'];
			$personas = $adultos + $menores;
			$bebes = 0;
			$ninios = 0;
			$juniors = 0;
			//Validando tipo de cama
			if ($personas > 2) {
				$tipo_cama = "D";
			} else {
				$tipo_cama = "K";
			}
			if ($tipo_hab == "FL") {
				if ($tipo_cama == "K") {
					$tipo_hab = "FL1";
				} else if ($tipo_cama == "D") {
					$tipo_hab = "FL2";
				}
			}
			//Validando tipo de menores
			for ($j = 1; $j <= $menores; $j++) {
				$edad = $_SESSION['front_form']['habitacion_' . $i]['edad_' . $j];
				if ($edad <= 3) {
					$bebes++;
				} else if ($edad > 3 && $edad <= 12) {
					$ninios++;
				} else if ($edad > 12 && $edad <= 17) {
					$juniors++;
				}
			}
			$parametros = array(
				"availabilityRequest" => array(
					"data" => array(
						"hotel" => $hotel, //"MPS",
						"room_type" => $tipo_hab, //"OV",
						"bed_type" => $tipo_cama, //"K",	
						"adultos" => $adultos, //2,
						"menores" => $menores, //0,
						"baby" => $bebes,
						"child" => $ninios,
						"kid" => $juniors,
						"rate_plan" => $tarifa, //"TOCSAI",
						"arrival_date" => $fecha_inicio . "T00:00:00.0000000-05:00", //"2015-12-22T00:00:00.0000000-05:00",
						"departure_date" => $fecha_final . "T00:00:00.0000000-05:00", //"2015-12-23T00:00:00.0000000-05:00",
						"agency_cd" => "RMAYA"
					),
					"AuthInfo" => array(
						"Recnum" => 0,
						"Ent_User" => "RMY",
						"Ent_Pass" => "QMrq8UzEru",
						"Ent_Term" => "RMY"
					)
				)
			);
			//$result = $client->GetAvailability($parametros);
			//$tarifa="TX175PV1925";
			$fecha_inicioWS = date('Y-m-d', strtotime(str_replace('/', '-', $fecha_inicio)));
			$fecha_finalWS = date('Y-m-d', strtotime(str_replace('/', '-', $fecha_final)));
			/*$xml = '<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema"><soap:Body><GetAvailability><availabilityRequest xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availabilityRequest.xsd"><data><hotel  xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$hotel.'</hotel><room_type xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$tipo_hab.'</room_type><bed_type xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$tipo_cama.'</bed_type><arrival_date xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$fecha_inicioWS.'T00:00:00.0000000-05:00</arrival_date><departure_date xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$fecha_final.'T00:00:00.0000000-05:00</departure_date><adultos xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$adultos.'</adultos><menores xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$menores.'</menores><baby xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$bebes.'</baby><child xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$ninios.'</child><kid xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$juniors.'</kid><rate_plan xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">'.$tarifa.'</rate_plan><agency_cd xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">RMAYA</agency_cd></data><Tag></Tag><AuthInfo><Recnum>0</Recnum><Ent_User>RMY</Ent_User><Ent_Pass>QMrq8UzEru</Ent_Pass><Ent_Term>RMY</Ent_Term></AuthInfo></availabilityRequest></GetAvailability></soap:Body></soap:Envelope>';*/

			$xml = '<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema"><soap:Body><GetAvailability><availabilityRequest xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availabilityRequest.xsd"><data><hotel  xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">' . $hotel . '</hotel><room_type xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">' . $tipo_hab . '</room_type><bed_type xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">' . $tipo_cama . '</bed_type><arrival_date xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">' . $fecha_inicioWS . 'T00:00:00.0000000-05:00</arrival_date><departure_date xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">' . $fecha_final . 'T00:00:00.0000000-05:00</departure_date><adultos xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">' . $adultos . '</adultos><menores xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">0</menores><baby xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">' . $bebes . '</baby><child xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">' . $ninios . '</child><kid xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">' . $juniors . '</kid><rate_plan xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">' . $tarifa . '</rate_plan><agency_cd xmlns="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd">RMAYA</agency_cd></data><Tag></Tag><AuthInfo><Recnum>0</Recnum><Ent_User>RMY</Ent_User><Ent_Pass>QMrq8UzEru</Ent_Pass><Ent_Term>RMY</Ent_Term></AuthInfo></availabilityRequest></GetAvailability></soap:Body></soap:Envelope>';

			//echo $xml;





			$url = 'https://api.palaceresorts.com/EnterpriseServiceInterface/ServiceInterface.asmx?wsdl';
			$action = 'http://localhost/xmlschemas/enterpriseservice/16-07-2009/GetAvailability';
			$client = new SoapClient(null, array(
				'location' => $url,
				'uri'      => "",
				'trace'    => 1,
			));
			try {
				$result = $client->__doRequest($xml, $url, $action, 1);
				$xml = simplexml_load_string($result, NULL, NULL, "http://schemas.xmlsoap.org/soap/envelope/");
				$ns = $xml->getNamespaces(true);
				$soap = $xml->children($ns['soap']);
				$body = $soap->Body->children($ns['GetAvailabilityResponse']);
				$result = $body->GetAvailabilityResponse;
				//print_r($result->roomAvailabilityResponse);
				//echo "<script> console.log('".print_r($result)."');</script>";
			} catch (SoapFault $exception) {
				//print_r($exception);
				$ex = $exception;
			}
			$error = "";
			$info = "";
			if ($result->roomAvailabilityResponse->HasErrors != "false") {
				$error = $result->roomAvailabilityResponse->ExceptionInfo->Type . " " . $result->roomAvailabilityResponse->ExceptionInfo->Message;
				$info = "error";
				//print_r($result->roomAvailabilityResponse->TotalAmount);
			} else {
				if ($_SESSION["tipoUsuario"] == "Agencia")
					$info = "";
				else {
					$info = "<strong>El total de la reserva es : $ " . number_format((float) $result->roomAvailabilityResponse->TotalAmount, 2) . " " . $result->roomAvailabilityResponse->Moneda . "</strong></br>";
				}
				$dias = $result->roomAvailabilityResponse->Data->Availability->dayAvailable;
				//print_r($dias);
				if ($dias) {
					foreach ($dias as $dia) {
						$info .= "- La fecha " . date('d/m/Y', strtotime($dia->Day)) . " esta " . ($dia->Available ? 'disponible' : 'ocupada') . "<br/>";
						if ($dia->Available == 'disponible')
							$info .= '<td align="center"><i class="fa fa-check text-success"></i></td>';
						else
							$info .= '<td align="center"><i class="fa fa-ban text-danger"></i></td>';
					}
				}
			}
			$wsResponse[$i] = array('error' => $error, 'result' => $info);
		}
		return $wsResponse;
	}

	##EL METODO EXISTE TAL CUÁL EN ReservacionController y BusquedaController
	public function cancelaciones($id_hotel, $fecha_inicio, $id_tarifa = null)
	{
		$avisoCancelacion = "";
		$cancelacion = Cancelacion::model()->findAll('id_hotel=' . $id_hotel . ' and "' . $fecha_inicio . '" between fecha_inicio and fecha_final ORDER BY dias DESC');
		if (empty($cancelacion))
			$cancelacion = Cancelacion::model()->findAll('id_hotel is null and "' . $fecha_inicio . '" between fecha_inicio and fecha_final ORDER BY dias DESC');
		foreach ($cancelacion as $row) {
			$fecha = strtotime($fecha_inicio . " -" . $row->dias . " days");
			if (strtotime(date('Y-m-d')) <= $fecha) {
				$avisoCancelacion .= "Si cancela hasta el " . date('d/m/Y', $fecha) . " tiene penalidad de " . $row->penalizacion . " noches. ";
			}
		}
		if (!empty($cancelacion)) {
			$fecha = strtotime($fecha_inicio . " -" . ($row->dias - 1) . " days");
			if ($fecha < strtotime('now')) {
				$fecha = strtotime('now');
			}
			$avisoCancelacion .= "A partir del " . date('d/m/Y', $fecha) . " tiene penalización de toda la estancia. ";
		}

		if ($avisoCancelacion == "") {

			$fecha_limite = $this->getFechaLimitePago($id_tarifa, $fecha_inicio, $id_hotel);

			$avisoCancelacion = "Si cancela hasta el " . date("d/m/Y", strtotime($fecha_limite)) . " tiene penalidad de 0 noches. ";
			$avisoCancelacion .= "A partir del " . date('d/m/Y', strtotime($fecha_limite . ' +1 days')) . " tiene penalización de toda la estancia. ";
		}

		return $avisoCancelacion;
	}

	public function getFechaLimitePago($id_tarifa, $fecha_inicio, $id_hotel)
	{
		$tarifa = Tarifa::model()->findByPk($id_tarifa);
		$fecha_limite = "";
		if (!empty($tarifa->fecha_limite) && strtotime($fecha_inicio) > strtotime($tarifa->fecha_limite)) {
			$fecha_limite = $tarifa->fecha_limite;
		} else if (!empty($tarifa->fecha_limite_dias)) {
			$fecha_limite = date('Y-m-d', strtotime($fecha_inicio . ' -' . ($tarifa->fecha_limite_dias + 1) . ' days'));
		} else {
			$fechaLimite = FechaLimite::model()->find('id_hotel=' . $id_hotel . ' and "' . $fecha_inicio . '" between fecha_inicio and fecha_final');
			if (!empty($fechaLimite)) {
				$fecha_limite = date('Y-m-d', strtotime($fecha_inicio . ' -' . ($fechaLimite->dias + 1) . ' days'));
			}
		}
		if ((!empty($fecha_limite) && strtotime($fecha_limite) < strtotime(date('Y-m-d'))) || empty($fecha_limite)) {

			$hoy = date("Y-m-d");

			$datetime_fecha_inicial = new DateTime($fecha_inicio);
			$datetime_hoy = new DateTime($hoy);

			$diferencia = $datetime_fecha_inicial->diff($datetime_hoy);

			$resultado_diferencia_dias = $diferencia->format('%a');

			if ($resultado_diferencia_dias <= 7) {
				$fecha_limite = date("Y-m-d", strtotime($hoy));
			} else if ($resultado_diferencia_dias > 7 && $resultado_diferencia_dias <= 15) {
				$fecha_limite = date("Y-m-d", strtotime($hoy . ' +1 days'));
			} else if ($resultado_diferencia_dias > 15 && $resultado_diferencia_dias <= 32) {
				$fecha_limite = date("Y-m-d", strtotime($hoy . ' +2 days'));
			} else if ($resultado_diferencia_dias > 32) {
				$fecha_limite = date("Y-m-d", strtotime($fecha_inicio . ' -31 days'));
			}

			if ($fecha_limite <= $hoy)
				$fecha_limite = $hoy;
		}
		return $fecha_limite;
	}

	public function actionAgregarcarrito()
	{
		$session = new CHttpSession;
		$session->open();
		if (isset($_POST['id_hotel'])) {
			if (isset($_SESSION['Datos'][0]['rateKey']))
				unset($_SESSION['Datos'], $_SESSION['Cotizacion'], $_SESSION['Menores'], $_SESSION['TotalCotiz']);
			$datos = array();
			$menores = array();
			$error = NULL;
			$Total = array();
			$hora = "and curtime() between hora_inicio and hora_final";
			$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
			$early_booking = "and (early_booking is null or DATEDIFF('" . $_POST['fecha_inicio'] . "',current_date) <= early_booking)";
			$release = "and (t.release is null or DATEDIFF('" . $_POST['fecha_inicio'] . "',current_date) >= t.release)";


			/*if($_SESSION["agenciaUsuario"] != 9){
				$tarifaAgencias = 'and not exists(select NULL from tbl_tarifa_agencia tarifaAgencias where tarifaAgencias.id_tarifa=t.id_tarifa and tarifaAgencias.id_agencia!='.$_SESSION["agenciaUsuario"].')';
				$agenciaUsuario = Agencias::model()->findByPk($_SESSION["agenciaUsuario"]);
				$tarifaEstados = 'and exists(select NULL from tbl_tarifa_estados tarifaEstados where tarifaEstados.id_tarifa=t.id_tarifa and tarifaEstados.id_estado='.$agenciaUsuario->id_estado_agencia.')';
			}*/


			$vip = TarifaAgencia::model()->find("id_agencia=" . $_SESSION["agenciaUsuario"]);

			if ($_SESSION["agenciaUsuario"] != 9 && !$vip) {

				$tarifaAgencias = 'and not exists(select NULL from tbl_tarifa_agencia tarifaAgencias where tarifaAgencias.id_tarifa=t.id_tarifa and tarifaAgencias.id_agencia!=' . $_SESSION["agenciaUsuario"] . ')';
				//$agenciaUsuario = Agencias::model()->findByPk($_SESSION["agenciaUsuario"]);
				$agenciaUsuario = $_SESSION["agencia"]; //$_SESSION["agenciaUsuario"];
				$tarifaEstados = 'and exists(select NULL from tbl_tarifa_estados tarifaEstados where tarifaEstados.id_tarifa=t.id_tarifa and tarifaEstados.id_estado=' . $agenciaUsuario->id_estado_agencia . ')';
			}



			$sup = Yii::app()->createController('reservacion');
			$sup = $sup[0];
			for ($dia = 0; $dia < $_POST['noches']; $dia++) {
				$fecha = date("Y-m-d", strtotime($_POST['fecha_inicio']) + $dia * 24 * 60 * 60);
				$fechadia = strtotime($_POST['fecha_inicio']) + $dia * 24 * 60 * 60;
				$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition' => 't.id_tarifa=' . $_POST['id_tarifa'] . ' and id_tipo_plan=' . $_POST['id_tipo_plan'] . ' ' . $fecha_promo . ' ' . $hora . ' ' . $early_booking . ' ' . $release . ' and dia=' . date("N", $fechadia) . ' and "' . $fecha . '" between t.fecha_inicial and t.fecha_final ' . $tarifaAgencias . ' ' . $tarifaEstados . '', 'limit' => 1));
				if (empty($tarifa)) {
					$tarifa = Tarifa::model()->with('tarifaDiasvalidos', 'tarifaDesgloses')->findAll(array('condition' => 't.id_hotel=' . $_POST['id_hotel'] . ' and id_tipo_plan=' . $_POST['id_tipo_plan'] . ' ' . $fecha_promo . ' ' . $hora . ' ' . $early_booking . ' ' . $release . ' and ( t.id_tarifa=' . $_POST['id_tarifa'] . ' || ( t.precio IN("PROMO","OUTLET","NORMAL","VIP") and (t.id_combina=' . $_POST['id_tarifa'] . ' || t.id_combina is null) and promocontigua=1 ) ) and t.estatus=1 and id_base_habitacion=2 and dia=' . date("N", $fechadia) . ' and "' . $fecha . '" between t.fecha_inicial and t.fecha_final ' . $tarifaAgencias . ' ' . $tarifaEstados . '', 'order' => 't.id_tipo_plan ASC, precio_normal ASC', 'limit' => 1));
					if (empty($tarifa)) {
						$error = "Actualmente este hotel no dispone de tarifas para la fecha " . $fecha . ". Le sugerimos modificar e intentar de nuevo, o le invitamos a contactar a nuestros ejecutivos vía telefónica o chat para la generación de una cotización.";
						break;
					}
				}
				$t = 0;
				foreach ($tarifa as $row) {
					$costoTotal = 0;
					$costoTotalTC = 0;
					for ($i = 1; $i <= $_POST['habitaciones']; $i++) {
						$num_ninios = $_SESSION['front_form']['habitacion_' . $i]['num_ninios'];
						$num_adultos = $_SESSION['front_form']['habitacion_' . $i]['adultos'];
						$habBloqueada = FechasBloqueadas::model()->find('id_tipo_habitacion=' . $_POST["id_tipo_habitacion"] . ' and "' . $fecha . '" between fecha_inicio and fecha_final and id_tarifa=' . $row->id_tarifa);
						if (empty($habBloqueada)) {
							$tarifaDesglose = TarifaDesglose::model()->find('id_tarifa=' . $row->id_tarifa . ' and id_tipo_habitacion=' . $_POST["id_tipo_habitacion"] . ' and id_base_habitacion=' . $_SESSION['front_form']['habitacion_' . $i]['adultos'] . ' and ' . $_SESSION['front_form']['habitacion_' . $i]['num_ninios'] . ' <= max_menores and estatus=1');
						}
						if (empty($tarifaDesglose)) {
							$error = "No se encontró una tarifa de " . $_SESSION['front_form']['habitacion_' . $i]['adultos'] . " adultos que acepte un máximo numero de menores de " . $_SESSION['front_form']['habitacion_' . $i]['num_ninios'] . " para la habitación " . $i . ". O la habitación está bloqueada para la fecha " . $fecha;
							break;
						}
						$nocheGratis = NochesGratis::model()->find('id_tarifa=' . $row->id_tarifa . ' and (id_tipo_habitacion is null or id_tipo_habitacion=' . $_POST["id_tipo_habitacion"] . ')');
						$suplemento = 0;
						if (!empty($nocheGratis) && (($dia + 1) % $nocheGratis->noche == 0)) {
							if (($dia + 1) > $nocheGratis->noche && $nocheGratis->acumulable != 1) {
								$nocheGratis = false;
							} else {
								$tarifaDesglose->precio_normal = 0;
								$nocheGratis = true;
							}
						}
						$suplemento = $sup->Sumarsuplemento($row->id_tarifa, $fecha, $tarifaDesglose->id_base_habitacion, 'A', NULL);
						$costoAdultos = $tarifaDesglose->precio_normal + $suplemento;
						$costoAdultosTC = $row->tipoCambio($tarifaDesglose->precio_normal) + $row->tipoCambio($suplemento);
						if ($suplemento > 0) {
							$datos[$dia][$t][$i]['adultos'] = number_format($row->tipoCambio($tarifaDesglose->precio_normal), '2') . " + " . number_format($row->tipoCambio($suplemento), '2') . " SUP.";
						} else {
							$datos[$dia][$t][$i]['adultos'] = number_format($costoAdultosTC, '2');
						}
						$precompraMenor = "fecha_inicio_precompra is null or current_date between fecha_inicio_precompra and fecha_final_precompra";
						$costoMenores = 0;
						$costoMenoresTC = 0;
						$menorgratis = 0;
						$niniopaga = 1;
						$suplemento = 0;
						$suplementoMenores = 0;
						$convertir = 0;
						for ($n = 1; $n <= $_SESSION['front_form']['habitacion_' . $i]['num_ninios']; $n++) { //Ordenar edades menores mayor a menor
							if ($_SESSION['front_form']['habitacion_' . $i]['edad_' . $n] < $_SESSION['front_form']['habitacion_' . $i]['edad_' . ($n + 1)]) {
								$aux = $_SESSION['front_form']['habitacion_' . $i]['edad_' . $n];
								$_SESSION['front_form']['habitacion_' . $i]['edad_' . $n] = $_SESSION['front_form']['habitacion_' . $i]['edad_' . ($n + 1)];
								$_SESSION['front_form']['habitacion_' . $i]['edad_' . ($n + 1)] = $aux;

								$_SESSION['info_search']['habitaciones'][$i]['menores'][$n] = $_SESSION['info_search']['habitaciones'][$i]['menores'][$n + 1];
								$_SESSION['info_search']['habitaciones'][$i]['menores'][$n + 1] = $aux;

								$n = 0;
							}
						}
						for ($n = 1; $n <= $_SESSION['front_form']['habitacion_' . $i]['num_ninios']; $n++) {
							$tarifaMenor = DesgloseMenores::model()->find("id_tarifa=" . $row->id_tarifa . " and id_tipo_habitacion=" . $_POST["id_tipo_habitacion"] . " and " . $_SESSION['front_form']['habitacion_' . $i]['edad_' . $n] . " <= edad_max_menor and num_evaluar=" . $niniopaga . " and es_junior=0 and(" . $precompraMenor . ") and(fecha_inicio is null or '" . $fecha . "' between fecha_inicio and fecha_final) ORDER BY precio ASC");
							if (empty($tarifaMenor)) {
								$tarifaMenor = DesgloseMenores::model()->find("id_tarifa=" . $row->id_tarifa . " and id_tipo_habitacion=" . $_POST["id_tipo_habitacion"] . " and " . $_SESSION['front_form']['habitacion_' . $i]['edad_' . $n] . " between edad_min_menor and edad_max_menor and es_junior=1 and(" . $precompraMenor . ") and(fecha_inicio is null or '" . $fecha . "' between fecha_inicio and fecha_final) ORDER BY precio ASC");
								if (empty($tarifaMenor)) {
									$convertir++;
									$aux_menor = $num_ninios - $convertir;
									$num_adultos += 1;
									$tarifaDesglose = TarifaDesglose::model()->find('id_tarifa=' . $row->id_tarifa . ' and id_tipo_habitacion=' . $_POST["id_tipo_habitacion"] . ' and id_base_habitacion=' . $num_adultos . ' and ' . $aux_menor . ' <= max_menores and estatus=1');
									if ($tarifaDesglose) {
										$_SESSION['front_form']['habitacion_' . $i]['num_ninios'] = $aux_menor;
										$_SESSION['front_form']['habitacion_' . $i]['adultos'] = $num_adultos;
										unset($_SESSION['front_form']['habitacion_' . $i]['edad_' . $convertir]);
									} else {
										$error = "El menor con edad " . $_SESSION['front_form']['habitacion_' . $i]['edad_' . $n] . " de la habitación " . $i . " no tiene una tarifa definida para la fecha " . $fecha;
									}
									$suplemento = $sup->Sumarsuplemento($row->id_tarifa, $fecha, $tarifaDesglose->id_base_habitacion, 'A', NULL);
									$costoAdultos = $tarifaDesglose->precio_normal + $suplemento;
									$costoAdultosTC = $row->tipoCambio($tarifaDesglose->precio_normal) + $row->tipoCambio($suplemento);
									if ($suplemento > 0) {
										$datos[$dia][$t][$i]['adultos'] = number_format($row->tipoCambio($tarifaDesglose->precio_normal), '2') . " + " . number_format($row->tipoCambio($suplemento), '2') . " SUP.";
									} else {
										$datos[$dia][$t][$i]['adultos'] = number_format($costoAdultosTC, '2');
									}
								}
							}
							if ($tarifaMenor->es_junior != 1) $niniopaga++;
							if ($_SESSION['front_form']['habitacion_' . $i]['edad_' . $n] < $tarifaMenor->edad_min_menor || $nocheGratis == true) $tarifaMenor->precio = 0;
							$suplemento = $sup->Sumarsuplemento($row->id_tarifa, $fecha, 0, 'N', $_SESSION['front_form']['habitacion_' . $i]['edad_' . $n]);
							$suplementoMenores += $suplemento;
							$precioMenor = $tarifaMenor->precio + $suplemento;
							$costoMenores += $precioMenor;
							$precioMenorTC = $row->tipoCambio($tarifaMenor->precio) + $row->tipoCambio($suplemento);
							$costoMenoresTC += $precioMenorTC;
							$menores[$dia][$t][$i] .= "Menor " . $n . ": $ " . number_format($precioMenorTC, '2') . " / ";
							if ($precioMenor == 0) $menorgratis++;
						}
						if ($suplementoMenores > 0) {
							$datos[$dia][$t][$i]['menores'] = number_format($row->tipoCambio($costoMenores - $suplementoMenores), 2) . " + " . number_format($row->tipoCambio($suplementoMenores), 2) . " SUP.";
						} else {
							$datos[$dia][$t][$i]['menores'] = number_format($costoMenoresTC, '2');
						}
						$costoHabitacion = $costoAdultos + $costoMenores;
						$costoTotal += $costoHabitacion;
						$costoHabitacionTC = $costoAdultosTC + $costoMenoresTC;
						$costoTotalTC += $costoHabitacionTC;
						$datos[$dia][$t][$i]['fecha'] = implode("-", array_reverse(explode("-", $fecha)));
						$datos[$dia][$t][$i]['total'] = number_format($costoHabitacionTC, '2', '.', ',');
						$minNoches = MinNoches::model()->find('id_tarifa=' . $row->id_tarifa . ' and id_tipo_habitacion=' . $tarifaDesglose->id_tipo_habitacion . ' and "' . $fecha . '" between fecha_inicio and fecha_final');
						if (!empty($minNoches) && $minNoches->minimo > $Total[$t]['min_noches']) {
							$Total[$t]['min_noches'] = $minNoches->minimo;
						} else if ($row->min_noches > $Total[$t]['min_noches']) {
							$Total[$t]['min_noches'] = $row->min_noches;
						}
						$habs++;
					}
					if (empty($Total[$t]['tarifa'])) $Total[$t]['tarifa'] = $row->id_tarifa;
					$Total[$t]['moneda'] = $row->mostrar_conversion == 0 ? $row->moneda : 'MXN';
					if ($row->restricciones != "" && "<p>" . $row->restricciones . "</p>" != $Total[$t]['restricciones'])
						$Total[$t]['restricciones'] .= "<p>" . $row->restricciones . "</p>";
					$Total[$t]['nombre'] = $row->precio . " " . $row->nombre_tarifa;
					$Total[$t]['total'] += $costoTotal;
					$Total[$t]['total_tc'] += $costoTotalTC;
					$t++;
				}
			}
			//se invierte donde se guardan los totales para no cambiar las variables en las vistas
			$Total[0]['total_neto'] = $Total[0]['total_tc'];
			$Total[0]['total_tc'] = $Total[0]['total'];
			$Total[0]['total'] = number_format($Total[0]['total_neto'], 2);
			if ($_POST['noches'] < $Total[0]['min_noches']) {
				$error = "La tarifa tiene un mínimo de " . $Total[0]['min_noches'] . " para poder reservar.";
			}
			if ($error == NULL && $_POST['agrega'] == "OK") {
				if (empty($_SESSION['Cotizacion'])) {
					$_SESSION['Datos'] = array();
					$_SESSION['Cotizacion'] = array();
					$_SESSION['Menores'] = array();
					$_SESSION['TotalCotiz'] = array();
					$_SESSION['time_out'] = array();
					$_SESSION['CountCotiz'] = 0;
				}
				$hotel = Hoteles::model()->findByPk($_POST['id_hotel']);
				$plan = Plan::model()->findByPk($_POST['id_tipo_plan']);
				$habitacion = TipoHabitaciones::model()->findByPk($_POST['id_tipo_habitacion']);
				array_push($_SESSION['time_out'], 1);
				array_push($_SESSION['Datos'], array(
					'id_hotel' => $hotel->id_hotel, 'hotel' => $hotel->nombre_hotel, 'tarifa' => $_POST['id_tarifa'], 'id_plan' => $plan->id_plan, 'plan' => $plan->nombre,
					'fecha_inicio' => date('d/m/Y', strtotime($_POST['fecha_inicio'])), 'fecha_final' => date('d/m/Y', strtotime($_POST['fecha_final'])),
					'noches' => $_POST['noches'], 'id_tipo_habitacion' => $habitacion->id_tipo_habitacion, 'tipo_habitacion' => $habitacion->tipo_habitacion,
					'front_form' => $_SESSION['front_form'], 'menorgratis' => $menorgratis, 'fecha_cotiza' => date('Y-m-d H:i:s')
				));
				array_push($_SESSION['Cotizacion'], $datos);
				array_push($_SESSION['Menores'], $menores);
				array_push($_SESSION['TotalCotiz'], $Total);
				$_SESSION['CountCotiz']++;
			}
			echo CJSON::encode(array(
				'error' => $error,
				'agrega' => $_POST['agrega'],
				'noches' => $_POST['noches'],
				'datos' => $_SESSION['Datos'],
				'cotizacion' => $datos,
				'menores' => $menores,
				'menorgratis' => $menorgratis,
				'total' => $_POST['agrega'] == "OK" ? $_SESSION['TotalCotiz'] : $Total,
				'cotizaciones' => $_POST['agrega'] == "OK" ? $_SESSION['CountCotiz'] : '',
			));
		}
	}

	public function actionAgregarcarritoBeds()
	{
		$session = new CHttpSession;
		$session->open();
		if (isset($_POST['id_hotel'])) {
			$datos = array();
			$menorgratis = 0;
			$error = NULL;
			$num_habitaciones = $_SESSION['front_form']['habs'];
			$markupPalace = Api::model()->findByPk(9);
			$Total = $_POST['total'];
			$_SESSION['Cotizacion'] = array();
			$_SESSION['Datos'] = array();
			$_SESSION['CountCotiz'] = 0;
			$_SESSION['Total_noche'] = array();
			$sup = Yii::app()->createController('reservacion');
			$sup = $sup[0];
			$hotel = Hoteles::model()->findByPk($_POST['id_hotel']);



			/*if ($_POST['rateKey']=="OB" && empty($_POST['id_tipo_plan']) ){
				$id_tipo_plan=2;
				$_POST['boardName']="Solo Habitación";
			}
			else*/
			$id_tipo_plan = $_POST['id_tipo_plan'];
			array_push(
				$_SESSION['Datos'],
				array(
					'rateKey' => $_POST['rateKey'],
					'desglose' => null, //$_POST['desglose'],
					'total' => null, //$_POST['total'],
					'id_hotel' => $hotel->id_hotel,
					'hotel' => $hotel->nombre_hotel,
					'tarifa' => $_POST['id_tarifa'],
					'id_plan' => $id_tipo_plan,
					'boardName' => $_POST['boardName'],
					'fecha_inicio' => date('d/m/Y', strtotime($_POST['fecha_inicio'])),
					'fecha_final' => date('d/m/Y', strtotime($_POST['fecha_final'])),
					'noches' => $_POST['noches'],
					'id_tipo_habitacion' => $_POST['id_tipo_habitacion'],
					'front_form' => $_SESSION['front_form'],
					'menorgratis' => $menorgratis,
					'fecha_cotiza' => date('Y-m-d H:i:s'),
					'roomRate' => $_POST['roomRate'],
					'ratePlan' => $_POST['ratePlan'],
					'roomType' => $_POST['roomType'],
					'totalRate' => $_POST['totalRate'],
					'promociones' => $_POST['promociones'],
					'currency' => $_POST['currency'],
					'rate_class' => $_POST['rate_class'],
					'politicas_cancelacion' => $_POST['politicas_cancelacion']
				)
			);
			if ($_POST['rateKey'] == "OB") {
				$ratePlanID = json_decode(base64_decode($_POST['ratePlan']));
				$roomID = json_decode(base64_decode($_POST['roomType']));
				$roomsRate = json_decode($_SESSION['front_form']['roomsRate'])->$_POST['id_hotel'];
				$rates = count($roomsRate);
				$markupHotel = Hoteles::model()->findByPk($_POST['id_hotel'])->comision;
				if ($markupHotel) {
					$markup = ((100 - $markupHotel) / 100);
				} else {

					$markup = Api::model()->findByPk(4)->markup;
				}
			}

			if ($hotel->proveedor == 3) ##TRAVEL SOLUTION
			{
				$travelSolution = Yii::app()->createController('travelSolution');
				$travelSolution = $travelSolution[0];

				$code = explode("/", $hotel->codigo);
				$hotelTS = $travelSolution->searchHotelTS($code[0]);
				$resultHotel = json_decode(json_encode($hotelTS));


				$ratePlan = json_decode(base64_decode($_POST['ratePlan']));
				$roomType = json_decode(base64_decode($_POST['roomType']));

				$modelTS = Api::model()->findByPk(6);
				$parametrosTS = json_decode($modelTS->params);

				$clave_afiliado = $parametrosTS->clave_afiliado;
				$ip = "MX";
				$currency = $resultHotel->Currency;
				$destino = $resultHotel->Destination->Id;
				$lenguage = "ESP";
				$fecha_ini = explode("/", $_SESSION['front_form']['fecha_ini']);
				$fecha_fin = explode("/", $_SESSION['front_form']['fecha_fin']);
				$star_date = $fecha_ini[2] . $fecha_ini[1] . $fecha_ini[0];
				$end_date = $fecha_fin[2] . $fecha_fin[1] . $fecha_fin[0];
				$codigo_hotel = $resultHotel->Id;
				$id_interfaceType = $resultHotel->InterfaceInfo->Id;
				$_SESSION['fecha_limite_h'] = substr($_POST['fecha_limite_h'], 0, 10);
			}

			if ($hotel->proveedor == 6) {
				$_SESSION['Datos'][0]['fecha_limite_h'] = $_POST['fecha_limite_h'];
			}

			$n = 0;
			$rph = 0;

			$tarifas_diaria = json_decode(base64_decode($_POST['desglose']));

			for ($i = 1; $i <= $num_habitaciones; $i++) {
				$adultos = $_SESSION['front_form']['habitacion_' . $i]['adultos'];
				$menores = $_SESSION['front_form']['habitacion_' . $i]['num_ninios'];
				if ($_POST['rateKey'] == "OB") {
					//foreach ($roomsRate as $roomRate)
					for ($r = 0; $r < $rates; $r++) {
						if ($rates > 1) {
							$rate = $roomsRate[$r];
						} else {
							$rate = $roomsRate;
						}
						if ($rate->RatePlanID == $ratePlanID->RatePlanID && $rate->RoomID == $roomID->RoomID && $rph == $rate->RoomStayCandidateRPH) {
							$_SESSION['Datos'][0]['roomRates'][$i] = json_encode($rate);
						}
					}
					$rph++;
				}

				if ($hotel->proveedor == 3) #TRAVELSOLUTION
				{

					$pax .= "r1a=" . $adultos . "&";
					$pax .= "r1k=" . $menores . "&";
					for ($j = 1; $j <= $menores; $j++) {
						$pax .= "r1k" . $j . "a=" . $_SESSION['front_form']["habitacion_" . $i]["edad_" . $j] . "&";
					}
					$pax = trim($pax, '&');

					$request = "a=" . $clave_afiliado . "&co=" . $ip . "&c=" . $currency . "&d=" . $destino . "&l=" . $lenguage . "&rk=" . $_SESSION['Datos'][0]['rateKey'] . "&sd=" . $star_date . "&ed=" . $end_date . "&h=" . $codigo_hotel . "&ci=" . $ratePlan->Contract . "&mi=" . $ratePlan->MarketId . "&it=" . $id_interfaceType . "&ri=" . $roomType->Id . "&mp=" . $ratePlan->Id . "&" . $pax;

					//echo $request;

					$responseDesgloseTarifa = json_decode($travelSolution->consultarDesgloseTarifa($request), true);
					//echo '<textarea rows="10" cols="50">'.json_encode($responseDesgloseTarifa).'</textarea>';
					$desgloseTarifa = $responseDesgloseTarifa["HotelRate"]["Rooms"]["Room"]["MealPlans"]["MealPlan"]["NightsDetail"]["NightlyRate"];

					if (!$desgloseTarifa[0]) {
						$responseDesgloseTarifa["HotelRate"]["Rooms"]["Room"]["MealPlans"]["MealPlan"]["NightsDetail"]["NightlyRate"] = array();
						$responseDesgloseTarifa["HotelRate"]["Rooms"]["Room"]["MealPlans"]["MealPlan"]["NightsDetail"]["NightlyRate"][0] = $desgloseTarifa;
					}

					$_SESSION['Datos'][0]['roomRates'][$i] = json_encode($responseDesgloseTarifa["HotelRate"]["Rooms"]["Room"]["MealPlans"]["MealPlan"]);


					$pax = "";
				}

				for ($d = 0; $d < $_POST['noches']; $d++) {
					$importeMenor = 0;
					if ($_POST['rateKey'] == "OB") {
						$ratesNight = json_decode($_SESSION['Datos'][0]['roomRates'][$i]);
						if (count($ratesNight->RatesType->Rates->Rate) == 1) {
							$precioxPxN = $ratesNight->RatesType->Rates->Rate;
						} else {
							$precioxPxN = $ratesNight->RatesType->Rates->Rate[$d];
						}

						if ($menores > 0) {
							/*$importeAdulto=json_decode($_SESSION['Datos'][0]['roomRates'][$i])->RatesType->Rates->Rate[$d]->Total->TPA_Extensions->Rates->Rate[0]->Total->AmountBeforeTax*$adultos;
							$importeMenor=json_decode($_SESSION['Datos'][0]['roomRates'][$i])->RatesType->Rates->Rate[$d]->Total->TPA_Extensions->Rates->Rate[1]->Total->AmountBeforeTax*$menores;*/
							$p = 0;
							foreach ($precioxPxN->Total->TPA_Extensions->Rates->Rate as $rate) {
								if ($rate->AgeQualifyingCode == 'Adult') {
									$importeAdulto = ($rate->Total->AmountBeforeTax * $rate->MinGuestApplicable) / $markup;
								} else {
									$_SESSION['Cotizacion'][$n][$d][0][$i][$p] = $rate->Total->AmountBeforeTax / $markup;
									$importeMenor += ($rate->Total->AmountBeforeTax * $rate->MinGuestApplicable) / $markup;
									$p++;
								}
							}
						} else {
							$importeAdulto = ($precioxPxN->Total->TPA_Extensions->Rates->Rate->Total->AmountBeforeTax * $adultos) / $markup;
							$importeMenor = 0;
						}

						$fH = explode(' ', $_POST['fecha_limite']);
						$fechaL = implode('-', array_reverse(explode("/", $fH[0])));
						$horaL = $fH[1];
						$_SESSION['fecha_limite'] = date('Y-m-d H:i:s', strtotime($fechaL . " " . $horaL));
					} elseif ($hotel->proveedor == 6) {
						$ratesxNight = json_decode(base64_decode($_SESSION['Datos'][0]['roomRate']));
						// echo json_encode($ratesxNight[$d][$i-1]);
						$importeAdulto = $ratesxNight[$i - 1][$d]->Rate / $markupPalace->markup;
						$importemenor = 0;
						// echo " - ".$importeAdulto." - ";
					} else {
						if ($hotel->proveedor == 1) {
							$desglose = explode(',', substr($tarifas_diaria[$i - 1], 0, -1));
							$importeAdulto = $desglose[$d];
							$importeMenor = 0;
							$_SESSION['fecha_limite'] = substr($_POST['fecha_limite'], 0, 10);
						} else {
							$importeAdulto = $responseDesgloseTarifa["HotelRate"]["Rooms"]["Room"]["MealPlans"]["MealPlan"]["NightsDetail"]["NightlyRate"][$d]["Total"] / $modelTS->markup;
							$importeMenor = 0;
							$_SESSION['fecha_limite'] = substr($_POST['fecha_limite'], 0, 10);
						}
					}
					$importeTotal = $importeAdulto + $importeMenor;
					$_SESSION['Cotizacion'][$n][$d][0][$i]['adultos'] = number_format($importeAdulto, '2', '.', ',');
					$_SESSION['Cotizacion'][$n][$d][0][$i]['menores'] = number_format($importeMenor, '2', '.', ',');
					$_SESSION['Cotizacion'][$n][$d][0][$i]['total'] = number_format($importeTotal, '2', '.', ',');
					$_SESSION['Cotizacion'][$n][$d][0][$i]['fecha'] = date('d-m-Y', strtotime($_POST['fecha_inicio'] . '+' . $d . ' day'));
					$_SESSION['politicas_cancelacion'] = $_POST['politicas_cancelacion'];
					$_SESSION['Datos'][0]['total'] += $importeTotal;
					//$_SESSION['Cotizacion'][$n][$d][0][$i]['total']
					if ($_POST['rateKey'] == "OB") {

						$_SESSION['Datos'][0]['total'] = $_POST["total"];
					}
				}
				$_SESSION['TotalCotiz'][$rph][0]['nombre'] = $_POST['boardName'];
				$_SESSION['TotalCotiz'][$rph][0]['moneda'] = $_POST['currency'];
				$_SESSION['TotalCotiz'][$rph][0]['restricciones'] = '';
			}
			echo CJSON::encode(array(
				'error' => $error,
				'agrega' => 'OK',
				'noches' => $_POST['noches'],
				'datos' => $_SESSION['Datos'],
				'cotizacion' => $datos,
				'menores' => $menores,
				'menorgratis' => $menorgratis,
				'total' => $_SESSION['TotalCotiz'],
				'cotizaciones' => $_POST['agrega'] == "OK" ? $_SESSION['CountCotiz'] : '',
			));
		}
	}

	public function actionVercarrito()
	{
		session_start();
		$nota = Politica::model()->findByPk(3);
		$this->render('carrito', array('nota' => $nota->descripcion));
	}

	public function actionChecacarrito($id)
	{
		session_start();
		$_SESSION['selected'] = $id;
		if ($_SESSION['CountCotiz'] > 0) {
			for ($i = 0; $n < $_SESSION['CountCotiz']; $i++) {
				if (empty($_SESSION['time_out'][$i])) continue;
				$_SESSION['time_out'][$i]++;
				if ($_SESSION['time_out'][$i] > 100) {
					unset($_SESSION['time_out'][$i], $_SESSION['Datos'][$i], $_SESSION['Cotizacion'][$i], $_SESSION['Menores'][$i], $_SESSION['TotalCotiz'][$i]);
					$_SESSION['CountCotiz']--;
				}
				$n++;
			}
		}
		$this->renderPartial('../layouts/carrito2mini');
	}

	public function actionEliminarcarrito($id)
	{
		session_start();
		unset($_SESSION['Datos'][$id], $_SESSION['Cotizacion'][$id], $_SESSION['Menores'][$id], $_SESSION['TotalCotiz'][$id]);
		$_SESSION['CountCotiz']--;
		$this->renderPartial('../layouts/carrito2mini');
	}

	public function actionVaciarcarrito()
	{
		session_start();
		unset($_SESSION['Datos'], $_SESSION['Cotizacion'], $_SESSION['Menores'], $_SESSION['TotalCotiz'], $_SESSION['CountCotiz']);
	}

	public function actionSetup()
	{
		$parser = new CMarkdownParser();
		Yii::app()->clientScript->registerCss('TextHighligther', file_get_contents($parser->getDefaultCssFile()));
		$this->render('setup', array(
			'parser' => $parser,
		));
	}

	public function actionMaintenance()
	{
		$this->layout = '/layouts/maintenance';
		$this->render('maintenance');
	}

	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionError()
	{
		$this->layout = "//layouts/homezV6";
		if ($error = Yii::app()->errorHandler->error) {
			if (Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}

	public function getTabularFormTabs($form, $model)
	{
		$tabs = array();
		$count = 0;
		foreach (array('en' => 'English', 'fi' => 'Finnish', 'sv' => 'Swedish') as $locale => $language) {
			$tabs[] = array(
				'active' => $count++ === 0,
				'label' => $language,
				'content' => $this->renderPartial('_tabular', array(
					'form' => $form,
					'model' => $model,
					'locale' => $locale,
					'language' => $language,
				), true),
			);
		}
		return $tabs;
	}

	public function actionImprimircotizacion()
	{
		session_start();
		$nota = Politica::model()->findByPk(3);
		$html = $this->renderPartial('cotizacion', array(
			'model' => $model, 'nota' => $nota->descripcion
		), true);
		$pdf = new MYPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Cotizacion');
		$pdf->SetSubject('Cotizacion');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 35, 15);
		$pdf->SetHeaderMargin(25);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 20);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Cotizacion_001.pdf", "I");
	}

	public function logWs($data, $ws)
	{
		$logWsControl = Yii::app()->createController('logWs');
		$logWsControl = $logWsControl[0];
		$logWsControl->Create($data, $ws);
		return true;
	}
}
// class MYPDF extends TCPDF
// {
// 	//Page header
// 	public function Header()
// 	{
// 		// get the current page break margin
// 		$bMargin = $this->getBreakMargin();
// 		// get current auto-page-break mode
// 		$auto_page_break = $this->AutoPageBreak;
// 		// disable auto-page-break
// 		$this->SetAutoPageBreak(false, 0);
// 		// set bacground image
// 		$img_file = $_SERVER['DOCUMENT_ROOT'] . '' . Yii::app()->baseUrl . '/images/pakal.jpg';
// 		$this->Image($img_file, 60, 50, 95, 135, '', '', '', false, 300, '', false, false, 0);
// 		// restore auto-page-break status
// 		$this->SetAutoPageBreak($auto_page_break, $bMargin);
// 		// set the starting point for the page content
// 		$this->setPageMark();
// 		// Logo
// 		$agencia = Agencias::model()->findByPk($_SESSION["agenciaUsuario"]);
// 		$estado = Estadosmex::model()->findByPk($agencia->id_estado_agencia);
// 		$pais = Pais::model()->findByPk($agencia->id_pais_agencia);
// 		$image_file = $_SERVER['DOCUMENT_ROOT'] . '/imagenes/' . $agencia->foto;
// 		if (!empty($agencia->foto) && is_readable($image_file)) {
// 			$this->Image($image_file, 20, 8, '', 15, '', '', 'T', false, 300, '', false, false, 0, false, false, false);
// 		}
// 		$this->Ln(4);
// 		$this->writeHTMLCell($w = 50, $h = 20, 120, 8, $agencia->nombre_agencia . '<br>
// 							Calle ' . $agencia->calle_agencia . ' No. ' . $agencia->num_exterior_agencia . ' Colonia ' . $agencia->id_colonia_agencia . '<br>
// 							' . $agencia->id_ciudad_agencia . ', ' . $estado->nombreestado . ' ' . $pais->nombre_pais . '<br>
// 							Tel. ' . $agencia->tel_agencia, $border = 0, $ln = 0, $fill = 0, $reseth = true, $align = '', $autopadding = true);
// 		// Set font
// 		$this->SetFont('helvetica', 'B', 12);
// 		// Title
// 		$this->Ln(22);
// 		$this->Cell(0, 15, 'Cotización Generada por Sistema de Reservaciones de RutaMayaTravel al ' . date('d/m/Y') . ' *', 0, false, 'C', 0, '', 0, false, 'M', 'M');
// 		$this->Line(15, 33, 195, 33);
// 	}
// }
