<?php
/*Yii::import('application.extensions.bootstrap.gii.*');
require_once('bootstrap/tcpdf/tcpdf.php');
require_once('bootstrap/tcpdf/config/lang/eng.php');
require_once('../../api/beds/HotelApi.php');
require_once('../../api/beds/ActivityApi.php');
require_once('../../api/omnibees/Token.php');
require_once('../../api/travelsolution/TravelSolution.php');
require_once('../../api/dingus/apiDingus.php');
*/
class ReservasController extends Controller
{
	/**
	 * Declares the behaviors.
	 * @return array the behaviors
	 */
	public function behaviors()
	{
		return array(
			'seo'=>'ext.seo.components.SeoControllerBehavior',
		);
	}
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	public function accessRules()
	{
		return array(
			array('allow',
				'actions'=>array('error'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index','Reservaciones','ReservacionesAll','ReservacionesAlljson', 'ReservacionesjsonBroked','ReservacionesBro','BookingInf','Reservacionesjson', 'CancelarBooking','PoliticasCancelacion', 'ActivityReservaciones', 'ActivityReservacionesJson','ActivityInf','ReservacionesTours','ReservacionesjsonTours','ReservacionesOmnibees', 'OmnibeesReservacionesjson', 'BookingInfOmniBees', 'Bloqueos', 'BloqueosJson','reservacionesTS','reservacionesJsonTS','reservacionesDingus','reservacionesJsonDingus','BookingInfoDingus','reservacionesRiu','reservacionesRiuJson','resultados','recibosAgencia'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('ConsultarTarifas'),
				'roles'=>array('verTarifa'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
	/**
	 * Declares class-based actions.
	 * @return array the actions
	 */
	public function actions()
	{
		return array(
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
			),
		);
	}
	public function actionReservaciones()
	{
		$this->layout = "//layouts/ansonika_site";
		
		$this->render('reservaciones');
		
	}
	public function actionBloqueos()
	{
		$this->render('bloqueos');
	}
	public function actionReservacionesAll()
	{
		$start="";
	    $end="";
		$status="";
		$filterType="";
		$enviar="";
		if ($_GET['enviar']) {
			$enviar=$_GET['enviar'];
			$start=$_GET['start'];
		    $end=$_GET['end'];
			$status=$_GET['status'];
			$filterType=$_GET['filterType'];
		}
			$this->render('reservacionesAll', array('start'=>$start, 'end'=>$end, 
				'status'=>$status, 'filterType'=>$filterType, 'enviar'=>$enviar));
	}
	public function actionRecibosAgencia(){
		$condAgencia = "";
		if($_SESSION["tipoUsuario"] == "Agencia")
		{
			$condAgencia = " where r.id_agencia=".$_SESSION["agenciaUsuario"]."";
		}
		$sql="select r.id_recibo, t.descripcion, r.referencia, r.tarjeta, IF(r.estado='C' OR r.id_tipo=11,0,r.importe) as importe, IF(MONTH (r.log) = MONTH (NOW()),1,0) as puede_facturar_fecha, date_format(r.log,'%Y-%m-%d %H:%i:%s') as log, a.id_agencia, a.nombre_agencia, u.nombre_usuario, r.comision, r.estado, r.revisado, r.id_cuenta
				from tbl_recibo r 
				inner join tbl_tipo_pago t on r.id_tipo=t.id_tipo 
				left join tbl_agencias a on r.id_agencia=a.id_agencia 
				inner join tbl_usuarios u on r.id_user=u.id_usuario where r.id_agencia=".$_POST["agenciaUsuario"]." ORDER BY r.log DESC;";

		$rows=Yii::app()->db->createCommand($sql)->queryAll();
		
		$hoy = date('Y-m-d H:i:s'); // fecha actual
		$numDiasMesActual = date("t", strtotime($hoy)); // numero de dias que tiene el mes actual
		$mesActual = date('m',strtotime($hoy)); // mes del año actual
		$añoActual = date('Y',strtotime($hoy)); // año actual

		$fechalimite_FinMes = date('Y-m-t 17:00:00'); // fecha del fin de mes actual e igual la fecha limite de facturar

		// si un mes tiene 31 dias se le resta uno para que todos los meses sean iguales
		if ($numDiasMesActual==31) {
			$restarFechaFinMes = strtotime('-1 day', strtotime( $fechalimite_FinMes ));
			$fechalimite_FinMes = date('Y-m-d 17:00:00', $restarFechaFinMes);
		}

		$diffFinMesActual = strtotime($fechalimite_FinMes); 

		$facturas = array();
		foreach ($rows as $key => $data) {

			$mesRecibo = date("m", strtotime($data['log'])); // mes que se hizo el recibo
			$añoRecibo = date("Y", strtotime($data['log'])); // año que se hizo el recibo
			$numDiasMesRecibo = date('t',strtotime($data['log'])); // dias que tiene el mes que se hizo el recibo

			$diffFinMesRecibo = strtotime($data['log']);

			$data['puede_facturar_fecha'] = 0;
			$data['fecha_limite_factura'] = null;


			// si la fecha de creacion del recibo es menor a la fecha limite de fin de mes
			// si el mes de la fecha de creacion es igual al mes actual
			// si el año de la fecha de creacion es igual al año actual
			if ($diffFinMesRecibo<$diffFinMesActual && $mesRecibo==$mesActual && $añoRecibo==$añoActual) {
				
				// suma de 5 dias a la fecha de creacion
				$fechalimite_cincodias = strtotime ( '+5 day' , strtotime($data['log']));
				$fechalimite_cincodias = date('Y-m-d 23:59:59',$fechalimite_cincodias); 

				// si el recibo despues de los 5 dias permitidos es el fin de mes 30,31,28 la fecha limite sera a la 5pm del ultimo dia del mes
				if (date('d',strtotime($fechalimite_cincodias)) == $numDiasMesActual) {
					$fechalimite_cincodias = $fechalimite_FinMes;
				}

				// si el recibo despues de los 5 dias permitidos es el siguiente mes la fecha limite sera a la 5pm del ultimo dia del mes
				if ($mesActual < date('m',strtotime($fechalimite_cincodias))) {
					$fechalimite_cincodias = $fechalimite_FinMes;
				}

				$diffCincoDias = strtotime($fechalimite_cincodias);

				// si la fecha y hora actual es menor a la fecha limite permitida procede a facturar
				if (strtotime($hoy)<$diffCincoDias) {
					$data['puede_facturar_fecha'] = 1;
					$data['fecha_limite_factura'] = date('m/d/Y H:i:s',strtotime($fechalimite_cincodias));
					// echo $data['id_recibo'].'/////'.$data['puede_facturar_fecha']."<br>";
				}
				
			}

			$facturas[] = $data;

		}
		echo '{"row":' .CJSON::encode($facturas). ', "__count": "'.count($facturas).'"}';
	}

	public function actionReservacionesTours()
	{
		$this->render('reservacionesTours');
	}

	public function sucursalAgente()
	{
		$sucursalAgente = SucursalesAgente::model()->find('id_user='.Yii::app()->user->id);
		return $sucursalAgente->id_sucursal;

	}

	public function actionReservacionesjson()
	{
		
		$sucAgente=$this->sucursalAgente();
		session_start();
		$condAgencia = "";
		$bloqueosValida =" AND r.id_bloqueo IS NULL ";
		if($_SESSION["tipoUsuario"] == "Agencia"){
			$condAgencia = " AND r.id_agencia=".$_SESSION["agenciaUsuario"]."";
		}else if($sucAgente)
		{
			$sucursalAgente =  " AND su.id_sucursal=".$sucAgente."";
			$sucursalrelacion = " INNER JOIN tbl_sucursales_agente AS su on su.id_user = r.id_agente ";
			
		}else{
			$sucAgente="";
			$sucursalrelacion="";
			}
	$sql = "SELECT r.*, DATE_FORMAT(r.log, '%Y-%m-%d') AS fecha_realizada, h.nombre_hotel, a.nombre_agencia, u.nombre_usuario, ag.nombre_usuario as nombre_agente, CONCAT(nombre_cliente,' ', apellido_cliente) as nombre_cliente
			FROM tbl_reservacion AS r 
			INNER JOIN tbl_usuarios as ag on ag.id_usuario=r.id_agente
			INNER JOIN tbl_hoteles AS h on h.id_hotel=r.id_hotel 
			INNER JOIN tbl_agencias AS a on r.id_agencia = a.id_agencia 
			INNER JOIN tbl_usuarios AS u on u.id_usuario = r.id_usuario".$sucursalrelacion."
			WHERE h.proveedor!=10 ".$sucursalAgente.$condAgencia.$bloqueosValida." ORDER BY r.id_reservacion DESC LIMIT 2000";
		$rows=Yii::app()->db->createCommand($sql)->queryAll();
		if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .CJSON::encode($rows). ', "__count": "'.count($rows).'"})';
	}

	public function actionBloqueosJson()
	{
		
		session_start();
		$condAgencia = "";
		if($_SESSION["tipoUsuario"] == "Agencia"){
			$condAgencia = " AND r.id_agencia=".$_SESSION["agenciaUsuario"]."";
		}
	$sql = "SELECT r.*, DATE_FORMAT(r.log, '%Y-%m-%d') AS fecha_realizada, h.nombre_hotel, a.nombre_agencia, u.nombre_usuario, ag.nombre_usuario as nombre_agente, CONCAT(nombre_cliente,' ', apellido_cliente) as nombre_cliente
			FROM tbl_reservacion AS r 
			INNER JOIN tbl_usuarios as ag on ag.id_usuario=r.id_agente
			INNER JOIN tbl_hoteles AS h on h.id_hotel=r.id_hotel 
			INNER JOIN tbl_agencias AS a on r.id_agencia = a.id_agencia 
			INNER JOIN tbl_usuarios AS u on u.id_usuario = r.id_usuario 
			


			WHERE r.id_bloqueo IS NOT NULL AND h.proveedor!=1 ".$condAgencia." ORDER BY r.id_reservacion DESC LIMIT 2000";
		$rows=Yii::app()->db->createCommand($sql)->queryAll();
		if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .CJSON::encode($rows). ', "__count": "'.count($rows).'"})';
	}



	public function actionReservacionesAlljson()
	{
		if (!empty($enviar)) {
			if($start && $end)
			{
				$inicial=implode('-', reverse(explode("/",$start)));
				$final=implode('-', reverse(explode("/",$end)));
				$fechas = " BETWEEN '".$inicial."' AND '".$final."' ";
				if($filterType=="CHECKIN")
					$rango = " AND r.fecha_inicial ".$fechas;
				else if($filterType=="CREATION")
					$rango = " AND r.log ".$fechas;
			}
			if(!empty($_POST['status']))
				$status = " AND r.estatus='".$status."'";
		}else{
			$rango="";
			$status="";
		}
			session_start();
		$condAgencia = "";
		if($_SESSION["tipoUsuario"] == "Agencia"){
			$condAgencia = " AND r.id_agencia='".$_SESSION["agenciaUsuario"]."'  ";
		}
		$sql = "SELECT r.*, DATE_FORMAT(r.log, '%Y-%m-%d') AS fecha_realizada, h.nombre_hotel, a.nombre_agencia, u.nombre_usuario, ag.nombre_usuario as nombre_agente, a.tel_agencia, a.celular, a.email_agencia, a.municipio_agencia, a.id_agencia
			FROM tbl_reservacion AS r 
			INNER JOIN tbl_usuarios as ag on ag.id_usuario=r.id_agente
			INNER JOIN tbl_hoteles AS h on h.id_hotel=r.id_hotel 
			INNER JOIN tbl_agencias AS a on r.id_agencia = a.id_agencia 
			INNER JOIN tbl_usuarios AS u on u.id_usuario = r.id_usuario 
				 ORDER BY r.id_reservacion DESC LIMIT 18000 ";
		$rows=Yii::app()->db->createCommand($sql)->queryAll();
		if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .CJSON::encode($rows). ', "__count": "'.count($rows).'"})';
	}

	public function actionReservacionesjsonTours()
	{
		session_start();
		$sucAgente=$this->sucursalAgente();
		$condAgencia = "";
		if($_SESSION["tipoUsuario"] == "Agencia"){
			$condAgencia = " WHERE r.id_agencia=".$_SESSION["agenciaUsuario"];
			$sucursalrelacion = "";
		}else if($sucAgente)
		{
			$sucursalrelacion = " INNER JOIN tbl_sucursales_agente AS su on su.id_user = r.id_agente ";
			$sucursalAgente =  " WHERE su.id_sucursal=".$sucAgente."";
			
		}
		$sql = "SELECT r.*, DATE_FORMAT(r.log, '%Y-%m-%d') AS fecha_realizada, t.nombre, a.nombre_agencia, u.nombre_usuario as nombre_agente, concat_ws(' ', cliente_nombre, cliente_apellido) as nombre_cliente,t.nombre as tour
			FROM tbl_tour_reservacion AS r 
			INNER JOIN tbl_tour AS t on r.id_tour=t.id_tour 
			INNER JOIN tbl_agencias AS a on r.id_agencia = a.id_agencia 
			INNER JOIN tbl_usuarios AS u on u.id_usuario = r.id_agente".$sucursalrelacion."
			

			".$sucursalAgente.$condAgencia." ORDER BY r.id_tourReservacion DESC LIMIT 2000";
		$rows=Yii::app()->db->createCommand($sql)->queryAll();
		if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .CJSON::encode($rows). ', "__count": "'.count($rows).'"})';
	}
 	public function consultarBookingList($params)
	{
	 	//booking list
	 	$hotelApi = new HotelApi();
		$estatus = $hotelApi->estatus();
		 //return $estatus;
		if($estatus=="OK")
		{
			$datos = $hotelApi->bookingList($params);
			return $datos;
		}
		else
		{
			return "No hubo conexión";
		}
	}
	public function actionReservacionesBro()
	{
		$_SESSION['booking']['start']=$_POST['start'];
		$_SESSION['booking']['end']=$_POST['end'];
		$_SESSION['booking']['status']=$_POST['status'];
		$_SESSION['booking']['filterType']=$_POST['filterType'];
		$this->render('reservacionesBro',array('in'=>$_SESSION['booking']['start'], 'fi'=>$_SESSION['booking']['end']));
	}
	public function ReservacionesBrojson()
	{
		$params= array();
	 	$params['start'] = implode("-", array_reverse(explode("/",$_SESSION['booking']['start'])));
	 	$params['end'] = implode("-", array_reverse(explode("/",$_SESSION['booking']['end'])));
	 	$params['filterType'] = $_SESSION['booking']['filterType'];
	 	$params['status'] = $_SESSION['booking']['status'];
	 	$params['from'] = 1;
	 	$params['to'] = 100;
	 	$e=$this->consultarBookingList(json_encode($params));
	 	return $e;
	}
	public function actionReservacionesjsonBroked()
	{
		$sucAgente=$this->sucursalAgente();
		$condAgencia = "";
		if($_SESSION["tipoUsuario"] == "Agencia"){
			$condAgencia = " AND r.id_agencia=".$_SESSION["agenciaUsuario"]."";
			$sucursalrelacion = "";
		}else if($sucAgente)
		{
			$sucursalrelacion = " INNER JOIN tbl_sucursales_agente AS su on su.id_user = r.id_agente ";
			$sucursalAgente =  " AND su.id_sucursal=".$sucAgente." ";
			
		}
		$datos= $this->ReservacionesBrojson($params);
		$data=json_decode($datos);
		foreach ($data->bookings->bookings as $row) 
		{
      		$code.="'BR".$row->reference."',";
  		}
  		$bookingList=trim($code, ",");
		$sql = "SELECT r.*, DATE_FORMAT(r.log, '%Y-%m-%d') AS fecha_realizada, h.nombre_hotel, a.nombre_agencia, u.nombre_usuario, ag.nombre_usuario as nombre_agente
			FROM tbl_reservacion AS r 
			INNER JOIN tbl_usuarios as ag on ag.id_usuario=r.id_agente
			INNER JOIN tbl_hoteles AS h on h.id_hotel=r.id_hotel 
			INNER JOIN tbl_agencias AS a on r.id_agencia = a.id_agencia 
			INNER JOIN tbl_usuarios AS u on u.id_usuario = r.id_usuario".$sucursalrelacion."
			WHERE r.code LIKE 'BR%'
			".$condAgencia.$sucursalAgente." ORDER BY r.id_reservacion DESC ";
		$rows=Yii::app()->db->createCommand($sql)->queryAll();
		if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .CJSON::encode($rows). ', "__count": "'.count($rows).'"})';
	}
/*.'({"row2":'.$row2.'})'.'({"soy":'.$codigo.'})'*/
	public function BookingInfo($param)
	{
			$hotelApi = new HotelApi();
			$estatus = $hotelApi->estatus();
			if($estatus=="OK")
			{
				$datos = $hotelApi->bookingInformation($param);
				return $datos;
			}
			else
			{
				return "No hubo conexión";
			}
	}
	public function actionBookingInf()
	{	
		if (isset($_POST['code'])) 
		{
			$codigo=$_POST['code'];
			$codes= explode(',', $codigo);
			$param=array();
			$i=1;
			$markup = Api::model()->findByPk(1)->markup;
			$resultado="";
			$error=0;

			foreach ($codes as $key ) 
			{
				$param['bookingId']=substr($key, 2);
				$inf= $this->BookingInfo(json_encode($param));
				$book= json_decode($inf);
				if($book->booking->reference)
				{
					switch ($book->booking->status) 
					{
						case 'CONFIRMED':
							$status="CONFIRMADO";
						break;
						case 'CANCELLED':
							$status="CANCELADO";
						break;
					}
					$fecha= implode("/", array_reverse(explode("-",$book->booking->hotel->checkIn)));
					$fechao= implode("/", array_reverse(explode("-",$book->booking->hotel->checkOut)));
					$fechac= implode("/", array_reverse(explode("-",$book->booking->creationDate)));
					if($i==1)
					{
						$resultado.='
						<table class="table table-striped table-condensed">
							<thead>
								<tr>
									<td colspan="4" rowspan="3"><h4><strong>Cliente: </strong>'.$book->booking->holder->name.' '.$book->booking->holder->surname.'</h4></td>
									<td ><strong>Creación: </strong></td><td>'.$fechac.'</td>
								<tr>
									<td><strong>Check in: </strong></td><td>'.$fecha.'</td>
								<tr>
									<td><strong>Check Out: </strong></td><td>'.$fechao.'</td>
								</tr>
								<tr>
									<th>Habitación</th>
									<th>Booking Id
									</th>
									<th>Estatus</th>
									<th>Plan</th>
									<th>Monto pendiente</th>
									<th>Total</th>
								</tr>
								</thead>
							<tbody>
								';
					}
					$resultado.='
							<tr>
								<th>'.$i.'</th>
								<td>'.$book->booking->reference.'</td>
								<td>'.$status.'</td>
								<td>'.$book->booking->hotel->rooms[0]->rates[0]->boardName.'</td>
								<td>$ '.number_format($book->booking->pendingAmount/$markup,2).' '.$book->booking->currency.'</td>
								<td>$ '.number_format($book->booking->totalNet/$markup,2).' '.$book->booking->currency.'</td>
							</tr>
							';
					$i++;
				}else
				{
					$error=1;
				}	
			}
			
				$resultado.='</tbody></table>';
		}

		if($error==1)
			$resultado="<br>Ocurrió un error, el código de información no se encontró registrado con el Socio On-Line<br>";
		echo $resultado;
	}
	public function cancelar($params)
	{
		$hotelApi = new HotelApi();
		$estatus = $hotelApi->estatus();
		if($estatus=="OK")
		{
			$datos = $hotelApi->bookingCancellation($params);
			return $datos;
		}
		else
		{
			return "No hubo conexión";
		}
	}
	public function actionCancelarBooking()
	{
		$cancelar=$_POST["cancelar"];
		$code=substr($_POST["code"],2);
		$params= array();
		$params['bookingId']=substr($code,0,-2);
		$params['cancellationFlag']=$cancelar;
		$cancel= $this->cancelar(json_encode($params));
		$booking=json_decode($cancel);
		$markup = Api::model()->findByPk(1)->markup;

		//$this->redirect('reservacion/view',array('id'=>$id_reservacion));
		//echo $cancel;


		if($cancelar=='SIMULATION')
		{
			if($booking->booking->reference==$params['bookingId'])
			{
				$fechaSC=implode("/", array_reverse(explode("-",  substr($booking->booking->hotel->rooms[0]->rates[0]->cancellationPolicies[0]->from,0,10)    )));
				?>
					<p>Cancelación <span class="text-success">SIN COSTO</span> hasta el <span class="text-success"><?php echo $fechaSC.' '.substr($booking->booking->hotel->rooms[0]->rates[0]->cancellationPolicies[0]->from,11,5);?></span></p>
					<p>Cancelación con costo durante las fechas:</p>
					<table class="table table-bordered table-striped table-condensed">
						<thead>
							<th>Fecha</th>
							<th>Costo</th>
						</thead>
						<tbody>
							<?php 
								foreach ($booking->booking->hotel->rooms[0]->rates[0]->cancellationPolicies as $fechas) 
								{
									?>
										<tr>
											<td><?php  echo implode("/", array_reverse(explode("-",substr($fechas->from,0,10))))?></td>
											<td align="right">$ <?php echo number_format($fechas->amount/$markup,2);?></td>										
										</tr>
									<?php					
								}
							?>
						</tbody>
					</table>
				<?php
			}else
			{
				echo "<br>Ocurrió un error, no se puede cancelar la reserva";
			}		
		}
		else 
		{
			if($booking->booking->reference==$params['bookingId'] && $booking->booking->status=="CANCELLED")
			{
				$habitacion = ReservacionDesglose::model()->findByPk($_POST["idDesglose"]);
				
				if($habitacion->id_desglose==$_POST["idDesglose"])
				{
					$habitacion->estatus=0; 
					if($habitacion->save())
						echo "<p>La habitación ha sido cancelada </p>";					
					
				}
			}else
			{
				echo "<br>Ocurrió un error al intentar cancelar la reserva.";
			}
		}
	}
	/*******************************************************************************************/
	public function actionActivityReservaciones()
	{
		$_SESSION['booking']['start']=$_POST['start'];
		$_SESSION['booking']['end']=$_POST['end'];
		$_SESSION['booking']['status']=$_POST['status'];
		$_SESSION['booking']['filterType']=$_POST['filterType'];
		$this->render('reservacionesActivity',array('in'=>$_SESSION['booking']['start'], 'fi'=>$_SESSION['booking']['end']));
	}
	public function actionActivityReservacionesJson()
	{
		$sucAgente=$this->sucursalAgente();
		$condAgencia = "";
		if($_SESSION["tipoUsuario"] == "Agencia"){
			$condAgencia = " AND r.id_agencia=".$_SESSION["agenciaUsuario"]."";
			$sucursalrelacion ="";
		}else if($sucAgente)
		{
			$sucursalrelacion = " INNER JOIN tbl_sucursales_agente AS su on su.id_user = r.id_agente ";
			$sucursalAgente =  " AND su.id_sucursal=".$sucAgente." ";
			
		}
		$datos= $this->ActivityReservacionesJson($params);
		$data=json_decode($datos);
		foreach ($data->bookings as $row) 
		{
      		$code.="'ACT01-".$row->reference."',";
  		}
  		$bookingList=trim($code, ",");
		$sql = "SELECT r.*, DATE_FORMAT(r.log, '%Y-%m-%d') AS fecha_realizada, a.nombre_agencia, u.nombre_usuario, ag.nombre_usuario as nombre_agente
			FROM tbl_activity_reservacion AS r 
			INNER JOIN tbl_usuarios as ag on ag.id_usuario=r.id_agente
			INNER JOIN tbl_agencias AS a on r.id_agencia = a.id_agencia 
			INNER JOIN tbl_usuarios AS u on u.id_usuario = r.id_usuario".$sucursalrelacion."
			WHERE r.code LIKE 'ACT01%'
			".$condAgencia.$sucursalAgente." ORDER BY r.id_reservacion DESC ";
		$rows=Yii::app()->db->createCommand($sql)->queryAll();
		if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .CJSON::encode($rows). ', "__count": "'.count($rows).'"})';
	}
	public function ActivityReservacionesJson()
	{
		$params= array();
	 	$params['start'] = implode("-", array_reverse(explode("/",$_SESSION['booking']['start'])));
	 	$params['end'] = implode("-", array_reverse(explode("/",$_SESSION['booking']['end'])));
	 	$params['filterType'] = $_SESSION['booking']['filterType'];
	 	$params['includeCancelled'] = $_SESSION['booking']['status'];
	 	$params['itemsPerPage'] = 10;
	 	$params['page'] = 1;
	 	$params['reference'] = "";
	 	$params['holder'] = "";
	 	$e=$this->consultarActivityList(json_encode($params));
	 	return $e;
	}
	public function consultarActivityList($params)
	{
	 	//booking list
	 	$activityApi = new ActivityApi();
		$datos = $activityApi->bookingList($params);
		return $datos;
	}
	public function actionActivityInf()
	{	
		if (isset($_POST['code'])) 
		{
			$codigo=$_POST['code'];
		}
		$param=array();
		$param['bookingReference']=substr($codigo, 6);
		$inf= $this->ActivityInfo(json_encode($param));
		$book= json_decode($inf);
		$markup = Api::model()->findByPk(2)->markup;

		if($book->booking->reference==$param['bookingReference'])
		{
			switch ($book->booking->status) 
			{
				case 'CONFIRMED':
					$status="CONFIRMADO";
				break;
				case 'CANCELLED':
					$status="CANCELADO";
				break;
			}

			$fechac= implode("/", array_reverse(explode("-",substr($book->booking->creationDate,0,10))));
			$fecha= implode("/", array_reverse(explode("-",$book->booking->activities[0]->dateFrom)));

			$resultado.='
			<table class="table table-striped table-condensed">
				<thead>
					<tr>
						<td colspan="3" rowspan="2"><h4><strong>Cliente: </strong>'.$book->booking->holder->name.' '.$book->booking->holder->surname.'</h4></td>
						<td ><strong>Fecha realizada: </strong></td><td>'.$fechac.'</td>
					<tr>
						<td><strong>Fecha de la actividad: </strong></td><td>'.$fecha.'</td>					
					<tr>
						<th>Booking ID</th>
						<th>Actividad</th>
						<th>Modalidad
						</th>
						<th>Estatus</th>
						<th>Total</th>
					</tr>
					</thead>
				<tbody>
					<tr>
						<td>'.$book->booking->reference.'</td>
						<td>'.$book->booking->activities[0]->name.'</th>
						<td>'.$book->booking->activities[0]->modality->name.'</td>
						<td>'.$status.'</td>
						
						<td>$ '.number_format($book->booking->total,2).' '.$book->booking->currency.'</td>
					</tr>
				</tbody>	
			</table>';

			//<td>$ '.number_format($book->booking->total/$markup,2).' '.$book->booking->currency.'</td>

			$questions=$book->booking->activities[0]->questions;
			if($questions)
			{
				$resultado.='<h4>Pregunta:</h4>';
				foreach ($questions as $question) 
				{
					if($question->question->required==true)
					{
						$resultado.='<h5><b>'.$question->question->text.'</b></h5>';
						$resultado.='<p>'.$question->answer.'</p>';
					}
				}
			}
		}else
		{
			$resultado.='<p>La reserva no se encuentra registrada con el Socio On-Line</p><hr>';
		}
		echo $resultado;
	}
	public function activityData($code)
	{	
		if (isset($code))
		{
			$param=array();
			$param['bookingReference']=substr($code, 6);
			$inf= $this->ActivityInfo(json_encode($param));			
			return $inf;
		}
	}
	public function ActivityInfo($param)
	{
		$activityApi = new ActivityApi();
		$datos = $activityApi->bookingDetail($param);
		return $datos;
	}



	public function actionReservacionesOmnibees(){
		$this->render('reservacionesOmnibees');
	}

	public function actionOmnibeesReservacionesjson()
	{
			/*$token= new Token;
			$tokens=$token->obtenToken(); 
			$url = "https://pull.omnibees.com/Pullservice.svc?wsdl"; //esta es la buena
	 		$UserName = "rutamayatravel";
	 		$Password ="jcilqiqhudejdngu";
			$data=array("GetBookings"=>array(
				"login"=>array("Password"=>$Password, "UserName"=>$UserName),
					  "ota_ReadRQ"=>array(
							   // "UniqueID"=>array(
							    //	"ID"=>"RES000573-4298",
							    //	"Type"=>"Reservation"
							    //	),
							   "ReadRequestsType"=>array(
							    	"HotelReadRequests"=>array(
							    		"HotelReadRequest"=>array(
							    			"HotelRef"=>array(
							    				"ChainCode"=>2513
							    				//"HotelCode"=>array(
							    				//)
							    			),
							    			"SelectionCriteria"=>array(
							    				"End"=>date("Y-m-d").'T'.date("H:i:s"),
							    				"Start"=>"2018-02-01T00:00:00+01:00"
							    			)
							    		)
							    	)
							    ),		
							    "EchoToken"=>$tokens,
							    "PrimaryLangID"=>"es",
							    "Target"=>"Test",
							    "TimeStamp"=>date("Y-m-d").'T'.date("H:i:s").'Z',
							 	"Version"=>2.5,
					    )
					)
			);
			$client = new SoapClient($url);
			try
				{
					$result = $client->__soapCall("GetBookings", $data, NULL, $header);
							$GetBookings=$result->GetBookingsResult->HotelReservationsType->HotelReservations->HotelReservation;
							//print_r($GetBookings);
							//echo json_encode($GetBookings);
							$booking[]="";
							$i=0;
						 foreach ($GetBookings as $Book) {
						 	//echo json_encode($result);
						 	//echo $Book->CreateDateTime."</br>";
						
						 	
						 	$reservacion=Reservacion::model()->find('code LIKE "%OB'.$Book->UniqueID->ID.'%"');
						 	$booking[$i]['reference']=$Book->UniqueID->ID;
						 	$booking[$i]['nombre_hotel']=$reservacion->idHotel->nombre_hotel;
						 	$booking[$i]['nombre']=$Book->ResGuestsType->ResGuests->ResGuest[0]->Profiles->ProfileInfos->ProfileInfo->Profile->Customer->PersonName->GivenName;
						 	$booking[$i]['fecha_creacion']=$Book->CreateDateTime;
						 	$booking[$i]['fecha_checkIn']=$Book->RoomStaysType->RoomStays->RoomStay->RoomRates->RoomRate->EffectiveDate;
						 	$booking[$i]['estatus']=$Book->ResStatus->PMS_ResStatusType;
						 	$booking[$i]['monto'] = $Book->ResGlobalInfo->Total->AmountBeforeTax;
						 	$booking[$i]['id_reservacion'] = $reservacion->id_reservacion;
						 	$booking[$i]['nombre_agente'] = $reservacion->idAgente->nombre_usuario;
						 	$booking[$i]['nombre_agencia'] = $reservacion->idAgencia->nombre_agencia;

						 	
						 	$i++;
						 }
						 //print_r($booking);
						
					  if(isset($_GET['$callback']))
							echo $_GET['$callback'].'({"row":' .CJSON::encode($booking). ', "__count": "'.count($result->GetBookingsResult->HotelReservationsType->HotelReservations->HotelReservation).'"})';
						
				}
			catch(SoapFault $exception)
				{
						echo "falló";
						echo "<hr>";
					    print_r($exception);
					    $ex=$exception;
					    
				}*/

				$markup = Api::model()->findByPk(4)->markup;

			$token= new Token;
			$tokens=$token->obtenToken(); 
			$url = "https://pull.omnibees.com/Pullservice.svc?wsdl"; //esta es la buena
	 		$UserName = "rutamayatravel";
	 		$Password ="jcilqiqhudejdngu";
			$data=array("GetBookings"=>array(
				"login"=>array("Password"=>$Password, "UserName"=>$UserName),
					  "ota_ReadRQ"=>array(
							   /* "UniqueID"=>array(
							    	"ID"=>"RES000573-4298",
							    	"Type"=>"Reservation"
							    	),*/
							   "ReadRequestsType"=>array(
							    	"HotelReadRequests"=>array(
							    		"HotelReadRequest"=>array(
							    			"HotelRef"=>array(
							    				"ChainCode"=>2513
							    				/*"HotelCode"=>array(
							    				)*/
							    			),
							    			"SelectionCriteria"=>array(
							    				"End"=>date("Y-m-d").'T'.date("H:i:s"),
							    				//"End"=>'2018-03-31T00:00:00+01:00',
							    				"Start"=>"2018-02-01T00:00:00+01:00"
							    			)
							    		)
							    	)
							    ),		
							    "EchoToken"=>$tokens,
							    "PrimaryLangID"=>"es",
							    "Target"=>"Test",
							    "TimeStamp"=>date("Y-m-d").'T'.date("H:i:s").'Z',
							 	"Version"=>2.5,
					    )
					)
			);
			$client = new SoapClient($url);
			try
				{
					$result = $client->__soapCall("GetBookings", $data, NULL, $header);
							$GetBookings=$result->GetBookingsResult->HotelReservationsType->HotelReservations->HotelReservation;
							//print_r($GetBookings);
							//echo json_encode($GetBookings);
							$booking[]="";
							$i=0;
						 foreach ($GetBookings as $Book) {
						 	//echo json_encode($result);
						 	//echo $Book->CreateDateTime."</br>";
						

							$roomStays=$Book->RoomStaysType->RoomStays->RoomStay;
						 	if(count($roomStays)==1)
						 		$roomStay=$roomStays;
						 	else
						 		$roomStay=$roomStays[0];

						 	$reservacion=Reservacion::model()->find('code LIKE "OB'.$Book->UniqueID->ID.'%"');
							$codigo_hotel=$roomStay->BasicPropertyInfo->HotelRef->HotelCode;
							if($reservacion->idHotel->nombre_hotel)
							{
								$nombre_hotel=$reservacion->idHotel->nombre_hotel;
							}
							else
							{
								$var=0;
								if($codigo_hotel==4275)
								{
									$pax=$roomStay->GuestCountsType->GuestCounts->GuestCount;
									for ($j=0; $j < count($pax); $j++) 
									{ 
										if(count($pax)==1)
										{
											$tipo_pax=$pax;
										}else
										{
											$tipo_pax=$pax[$j];
										}

										if($tipo_pax->AgeQualifyCode=="Child" && $var==0);
										{
											$var=1;
										}

									}
								}
						 		$nombre_hotel=Hoteles::model()->findAll('codigo LIKE "'.$codigo_hotel.'/%"')[$var]->nombre_hotel;
							}


						 	$booking[$i]['reference']=$Book->UniqueID->ID;
						 	$booking[$i]['nombre_hotel']=$nombre_hotel;
						 	$booking[$i]['nombre']=$Book->ResGuestsType->ResGuests->ResGuest[0]->Profiles->ProfileInfos->ProfileInfo->Profile->Customer->PersonName->GivenName;
						 	$booking[$i]['fecha_creacion']=$Book->CreateDateTime;
						 	$booking[$i]['fecha_checkIn']=$roomStay->RoomRates->RoomRate->EffectiveDate;
						 	$booking[$i]['estatus']=$Book->ResStatus->PMS_ResStatusType;
						 	$booking[$i]['monto'] = $Book->ResGlobalInfo->Total->AmountBeforeTax/$markup;
						 	$booking[$i]['id_reservacion'] = $reservacion->id_reservacion;
						 	$booking[$i]['nombre_agente'] = $reservacion->idAgente->nombre_usuario;
						 	$booking[$i]['nombre_agencia'] = $reservacion->idAgencia->nombre_agencia;
						 	$booking[$i]['booking']=$Book;

						 	
						 	$i++;
						 }
						 //print_r($booking);
						
					  if(isset($_GET['$callback']))
							echo $_GET['$callback'].'({"row":' .CJSON::encode($booking). ', "__count": "'.count($result->GetBookingsResult->HotelReservationsType->HotelReservations->HotelReservation).'"})';
						
				}
			catch(SoapFault $exception)
				{
						echo "falló";
						echo "<hr>";
					    print_r($exception);
					    $ex=$exception;
					    
				}
	}

	public function actionBookingInfOmniBees()
	{	
		$book=json_decode($_POST["booking"]);

		
		$markup = Api::model()->findByPk(4)->markup;

		if($book->UniqueID->ID)
		{
			$status=$book->ResStatus->PMS_ResStatusType;

			$fechac= implode("/", array_reverse(explode("-",substr($book->CreateDateTime,0,10))));

			$resultado.='
			<table class="table table-striped table-condensed">
				<thead>
					<tr>
						<td style="width: 65%;" colspan="3" rowspan="2"><h4><strong>Reference: </strong>'.$book->UniqueID->ID.'</h4></td>
						<td><strong>Estatus: </strong></td><td>'.$status.'</td>					
					<tr>
						<td ><strong>Fecha realizada: </strong></td><td>'.$fechac.'</td>
					<tr>
						<th>Habitación</th>
						<th>Plan</th>
						<th>Booking ID</th>
						<th>Estatus</th>
						<th>Total</th>
					</tr>
				</thead>
				<tbody>';
					$roomStay=$book->RoomStaysType->RoomStays->RoomStay;
					for ($i=0; $i < count($roomStay); $i++) 
					{ 
						if(count($roomStay)==1)
						{
							$room=$roomStay;
						}else
						{
							$room=$roomStay[$i];
						}

						$resultado.='
							<tr>
								<td>'.$room->RoomTypes->RoomType->RoomName.'</th>
								<td>'.$room->RatePlans->RatePlanType->RatePlanDescription->Description.'</td>
								<td>'.$room->IndexNumber.'</td>
								<td>'.$room->RoomStayStatus->PMS_ResStatusType.'</td>
								<td>$ '.number_format($room->Total->AmountBeforeTax/$markup,2).' '.$room->Total->CurrencyCode.'</td>
							</tr>';
					}
				


			$resultado.='</tbody></table>';

		}else
		{
			$resultado.='<p>La reserva no se encuentra registrada con el Socio On-Line</p><hr>';
		}

		echo $resultado;
	}
	/*******************************************************************************************/

		##FUNCIONESTRAVELSOLUTION############################################################################
	
	public function actionReservacionesTS()
	{
		if($_POST["start"] && $_POST["end"])
		{
			
			$_SESSION["booking"]["start"]=$_POST["start"];
			$_SESSION["booking"]["end"]=$_POST["end"];
		}else
		{
			$_SESSION["booking"]["start"]="01/01/".date("Y");
			$_SESSION["booking"]["end"]=date("d/m/Y");
		}

		$this->render("reservacionesTS",array("in"=>$_SESSION["booking"]["start"], "fi"=>$_SESSION["booking"]["end"]));
	}

	
	public function actionReservacionesJsonTS()
	{
		$condAgencia = "";
		if($_SESSION["tipoUsuario"] == "Agencia"){
			$condAgencia = " AND r.id_agencia=".$_SESSION["agenciaUsuario"]."";
		}



		##Datos WS
			$_SESSION["bookingsTravelSolution"]=$this->consultarReservacionesTS();
				
			//echo $datos;
			
			$data=json_decode($datos);
			foreach ($data->bookings->bookings as $row) 
			{
	      		$code.="'TS".$row->reference."',";
	  		}
	  		$bookingList=trim($code, ",");
  		##


		$sql = "SELECT r.*, DATE_FORMAT(r.log, '%Y-%m-%d') AS fecha_realizada, h.nombre_hotel, a.nombre_agencia, u.nombre_usuario, ag.nombre_usuario as nombre_agente
			FROM tbl_reservacion AS r 
			INNER JOIN tbl_usuarios as ag on ag.id_usuario=r.id_agente
			INNER JOIN tbl_hoteles AS h on h.id_hotel=r.id_hotel 
			INNER JOIN tbl_agencias AS a on r.id_agencia = a.id_agencia 
			INNER JOIN tbl_usuarios AS u on u.id_usuario = r.id_usuario 
			WHERE r.code LIKE 'TS%'
			".$condAgencia." ORDER BY r.id_reservacion DESC ";
		$rows=Yii::app()->db->createCommand($sql)->queryAll();
		if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .CJSON::encode($rows). ', "__count": "'.count($rows).'"})';
	}

	public function consultarReservacionesTS()
	{


		$travelSolution = new TravelSolution;		

		$travelSolutionController = Yii::app()->createController('travelSolution');
        $travelSolutionController = $travelSolutionController[0];
	 	
	 	$start=explode("/",$_SESSION["booking"]["start"]);
	 	$end=explode("/",$_SESSION["booking"]["end"]);

	 	$from=$start[2].$start[1].$start[0];
	 	$to=$end[2].$end[1].$end[0];

		$request = 'asoc='.$travelSolution->affiliateId.'&from='.$from.'&to='.$to.'&bookId=0&destId=0&lang=ESP&bychangedate=N&hash=';

	 	$e=$travelSolutionController->bookingList($request);

	 	return $e;
	}


	public function actionTravelSolutionJson()
	{
		$solution= new TravelSolution();
		$params = 'asoc=AF-TSXV&from=20180125&to=20180521&bookId=0&destId=0&lang=ESP&bychangedate=N&hash=';
		$travel = $solution->getBookinbyDate($params);
		$booking = json_decode($travel);
		foreach ($booking->Booking as $key => $book) 
		{
			   $id= explode('-', $book->BookingId);
			   $codeId= "TS".$id[0];
			   $reservacionid= Reservacion::model()->find('code="'.$codeId.'"');
			   echo $key." => ".$book->BookingId."<br>";

		/*	  switch ($book->PaymentState) {
			  	case 'NA':
			  		$payment= "pago no aplicado";
			  		break;
			  		case 'NP':
			  		$payment= "No Pagado";
			  		break;
			  		case 'PP':
			  		$payment= "Abonado";
			  		break;
			  		case 'PA':
			  		$payment= "Pagado";
			  		break;
			  		case 'OP':
			  		$payment= "Sobre Pagado";
			  		break;
	
			  }
			  switch ($book->BookingState) {
			  		case 'CO':
			  		$bookstate= "Confirmado";
			  		break;
			  		case 'NC':
			  		$bookstate= "No Confirmado";
			  		break;
			  		case 'CA':
			  		$bookstate= "Cancelado";
			  		break;
		
			  }*/



			   //$booking[$key]['BookingId'] = $codeId;
			   /*$booking[$key]['id_reservacion'] = $reservacionid->id_reservacion;
			   $booking[$key]['nombre_agente']= $reservacionid->idAgente->nombre_agente;
			   $booking[$key]['nombre_agencia']= $reservacionid->idAgencia->nombre_agencia;
			   $booking[$key]['nombre_cliente']= $reservacionid->nombre_cliente;
			   $booking[$key]['estatus']= $reservacionid->estatus;
			   $booking[$key]['total']= $reservacionid->total;
			   $booking[$key]['saldo']= $reservacionid->saldo;*/
			  /* $booking[$key]['PaymentState']= $payment;
			   $booking[$key]['BookingState']= $bookstate;*/


		}
		
		 echo "<textarea>".json_encode($booking)."</textarea>";
		 if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .json_encode($booking). ', "__count": "'.count($booking->Booking).'"})';
	}

	##############################################################################FUNCIONESTRAVELSOLUTION
	

	public function actionReservacionesDingus(){
		if($_POST["urlDingus"])
		{
			$_SESSION["booking"]["urlDingus"]=$_POST["urlDingus"];
			$_SESSION["booking"]["codigoDingus"] = $_POST["codigoDingus"];
			// $_SESSION["booking"]["startDate"]=$_POST["startDate"];
			// $_SESSION["booking"]["endDate"]=$_POST["endDate"];
			// $_SESSION["booking"]["startSale"]=$_POST["startSale"];
			// $_SESSION["booking"]["endSale"]=$_POST["endSale"];
		}else
		{
			$_SESSION["booking"]["urlDingus"]="RUTA%http://bahiaprincipe.dingus-services.com/services/Tazzy/CustomServices/dingus/service.asmx?WSDL";
			$_SESSION["booking"]["codigoDingus"] = NULL;
			// $_SESSION["booking"]["startDate"]="01/01/2018";
			// $_SESSION["booking"]["endDate"]="31/12/2019";
			// $_SESSION["booking"]["startSale"]="01/01/".date("Y");
			// $_SESSION["booking"]["endSale"]=date("d/m/Y");
		}

		$this->render("reservacionesDingus",array("urlDingus"=>$_SESSION["booking"]["urlDingus"], "starDate"=>$_SESSION["booking"]["startDate"], "endDate"=>$_SESSION["booking"]["endDate"], "startSale"=>$_SESSION["booking"]["startSale"], "endSale"=>$_SESSION["booking"]["endSale"], "codigoDingus"=>$_SESSION["booking"]["codigoDingus"]));
	}

	public function actionreservacionesJsonDingus(){
		$array_dingus = explode("%",$_SESSION["booking"]["urlDingus"]);

		if (is_null($_SESSION["booking"]["codigoDingus"])) {
			$codigo_dingus = NULL;
		}else{
			$codigo_dingus = explode("-",$_SESSION["booking"]["codigoDingus"]);
			$codigo_dingus = $codigo_dingus[1];
		}
		$dingusController = Yii::app()->createController('dingus');
		$dingusController = $dingusController[0];
		
		$bookingInfo = $dingusController->resInfo($array_dingus[0],$codigo_dingus,$hotel,$array_dingus[1]);
		$response=json_decode($bookingInfo,true);
		$i=0;
	 	if (count($response[0]['OTA_BookList']['ResList'])>1) {
	 		if ($response[0]['OTA_BookList']['ResList']['@attributes']['Version']=="0") {
	 
	 			$reslist = $response[0]['OTA_BookList']['ResList']['HotelReservations'];
	 			$reservacion=Reservacion::model()->find('code LIKE "%'.$reslist['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'].'%"');
				$comisionDingus = (100-$reservacion->hotel->comision)/100;
	 				foreach ($reslist['HotelReservation']['RoomStays']['RoomStay'] as $key => $monto){
		 			if (is_numeric($key)){
		 						$rooms = count($reslist['HotelReservation']['RoomStays']['RoomStay']);
		 						$row[$keys]+=$monto['RoomRates']['RoomRate']['Total']['@attributes']['AmountAfterTax']/$comisionDingus;
		 						$fechalimite=$reslist['HotelReservation']['RoomStays']['RoomStay']['CancelPolicies']['CancelPenalty']['@attributes']['Start'];
		 						$hotel_code = $monto['BasicPropertyInfo']['@attributes']['HotelCode'];
		 						$hotel_name = $monto['BasicPropertyInfo']['@attributes']['HotelName'];
		 						$checkIn = $monto['RoomRates']['RoomRate']['Rates']['Rate']['@attributes']['EffectiveDate'];
		 				}else{
		 					$rooms = 1;
		 					$row[$keys] = $reslist['HotelReservation']['RoomStays']['RoomStay']['RoomRates']['RoomRate']['Total']['@attributes']['AmountAfterTax']/$comisionDingus;
		 					$fechalimite=$reslist['HotelReservation']['RoomStays']['RoomStay']['CancelPolicies']['CancelPenalty']['@attributes']['Start'];
		 					$hotel_code = $reslist['HotelReservation']['RoomStays']['RoomStay']['BasicPropertyInfo']['@attributes']['HotelCode'];
		 					$hotel_name = $reslist['HotelReservation']['RoomStays']['RoomStay']['BasicPropertyInfo']['@attributes']['HotelName'];
		 					$checkIn = $reslist['HotelReservation']['RoomStays']['RoomStay']['RoomRates']['RoomRate']['Rates']['Rate']['@attributes']['EffectiveDate'];
		 				}
		 			}
		 		$bookingDingus[$i]['code'] = $reslist['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'];
		 		$bookingDingus[$i]['estatus']= $reslist['HotelReservation']['@attributes']['ResStatus'];
		 		$bookingDingus[$i]['fecha_creacion'] = $reslist['HotelReservation']['@attributes']['CreateDateTime'];
		 		$bookingDingus[$i]['referencia'] = $reslist['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'];
		 		$bookingDingus[$i]['codigo_hotel'] = $hotel_code;
		 		$bookingDingus[$i]['nombre_hotel'] = $hotel_name;
		 		$bookingDingus[$i]['cuartos'] = $rooms;
		 		$bookingDingus[$i]['monto'] = $row[$keys];
		 		$bookingDingus[$i]['fecha_limite'] = $fechalimite;
		 		$bookingDingus[$i]['id_reservacion'] = $reservacion->id_reservacion;
		 		$bookingDingus[$i]['nombre'] = $reslist['HotelReservation']['ResGuests']['ResGuest'][0]['Profiles']['ProfileInfo']['Profile']['Customer']['PersonName']['GivenName'];
				$bookingDingus[$i]['nombre_agente'] = $reservacion->idAgente->nombre_usuario;
				$bookingDingus[$i]['nombre_agencia'] = $reservacion->idAgencia->nombre_agencia;
				$bookingDingus[$i]['checkIn']=$checkIn;
				$bookingDingus[$i]['fechaInicio']=$reservacion->fecha_inicial;
				$bookingDingus[$i]["bookDingus"]=$reslist;
				$bookingDingus[$i]['RoomStayCount']=$rooms;

	 		}else{
	 		$reslist = $response[0]['OTA_BookList']['ResList'];
	 		$count=count($reslist);
	 		foreach ($response[0]['OTA_BookList']['ResList'] as $keys => $value) {
	 			$reservacion=Reservacion::model()->find('code LIKE "%'.$value['HotelReservations']['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'].'%"');
	 			$comisionDingus = (100-$reservacion->hotel->comision)/100;
	 			foreach ($value['HotelReservations']['HotelReservation']['RoomStays']['RoomStay'] as $key => $monto){
		 			if (is_numeric($key)){
		 						$rooms = count($value['HotelReservations']['HotelReservation']['RoomStays']['RoomStay']);
		 						$row[$keys]+=$monto['RoomRates']['RoomRate']['Total']['@attributes']['AmountAfterTax']/$comisionDingus;
		 						$fechalimite=$value['HotelReservations']['HotelReservation']['RoomStays']['RoomStay']['CancelPolicies']['CancelPenalty']['@attributes']['Start'];
		 						$hotel_code = $monto['BasicPropertyInfo']['@attributes']['HotelCode'];
		 						$hotel_name = $monto['BasicPropertyInfo']['@attributes']['HotelName'];
		 						$checkIn = $monto['RoomRates']['RoomRate']['Rates']['Rate']['@attributes']['EffectiveDate'];
		 				}else{
		 					$rooms = 1;
		 					$row[$keys] = $value['HotelReservations']['HotelReservation']['RoomStays']['RoomStay']['RoomRates']['RoomRate']['Total']['@attributes']['AmountAfterTax']/$comisionDingus;
		 					$fechalimite=$value['HotelReservations']['HotelReservation']['RoomStays']['RoomStay']['CancelPolicies']['CancelPenalty']['@attributes']['Start'];
		 					$hotel_code = $value['HotelReservations']['HotelReservation']['RoomStays']['RoomStay']['BasicPropertyInfo']['@attributes']['HotelCode'];
		 					$hotel_name = $value['HotelReservations']['HotelReservation']['RoomStays']['RoomStay']['BasicPropertyInfo']['@attributes']['HotelName'];
		 					$checkIn = $value['HotelReservations']['HotelReservation']['RoomStays']['RoomStay']['RoomRates']['RoomRate']['Rates']['Rate']['@attributes']['EffectiveDate'];
		 				}
		 			}
		 		$bookingDingus[$i]['code'] = $value['HotelReservations']['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'];
		 		$bookingDingus[$i]['estatus']= $value['HotelReservations']['HotelReservation']['@attributes']['ResStatus'];
		 		$bookingDingus[$i]['fecha_creacion'] = $value['HotelReservations']['HotelReservation']['@attributes']['CreateDateTime'];
		 		$bookingDingus[$i]['referencia'] = $value['HotelReservations']['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'];
		 		$bookingDingus[$i]['codigo_hotel'] = $hotel_code;
		 		$bookingDingus[$i]['nombre_hotel'] = $hotel_name;
		 		$bookingDingus[$i]['cuartos'] = $rooms;
		 		$bookingDingus[$i]['monto'] = $row[$keys];
		 		$bookingDingus[$i]['fecha_limite'] = $fechalimite;
		 		$bookingDingus[$i]['id_reservacion'] = $reservacion->id_reservacion;
		 		$bookingDingus[$i]['nombre'] = $value['HotelReservations']['HotelReservation']['ResGuests']['ResGuest'][0]['Profiles']['ProfileInfo']['Profile']['Customer']['PersonName']['GivenName'];
				$bookingDingus[$i]['nombre_agente'] = $reservacion->idAgente->nombre_usuario;
				$bookingDingus[$i]['nombre_agencia'] = $reservacion->idAgencia->nombre_agencia;
				$bookingDingus[$i]['checkIn']=$checkIn;
				$bookingDingus[$i]['fechaInicio']=$reservacion->fecha_inicial;
				$bookingDingus[$i]["bookDingus"]=$value['HotelReservations'];
				$bookingDingus[$i]['RoomStayCount']=$rooms;
		 		$i++;
	 			}
	 		}
	 	}
	 	if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .CJSON::encode($bookingDingus). ', "__count": "'.$count.'"})';

	}

	public function actionBookingInfoDingus(){
		$book=json_decode($_POST["bookDingus"],true);

		if(isset($_POST["bookDingus"]))
		{
			// echo $book['HotelReservation']['@attributes']['ResStatus'];
			switch ($book['HotelReservation']['@attributes']['ResStatus']) 
			{
				case 'Commit':
					$status="Liberado";
				break;
				case 'Cancel':
					$status="Cancelado";
				break;
				default:
					$status="Reservado";
				break;
			}

			$fechacreacion= implode("/", array_reverse(explode("-",substr($book["HotelReservation"]["@attributes"]["CreateDateTime"],0,10))));

			$resultado.='
			<table class="table table-striped table-condensed">
				<thead>
					<tr>
						<td style="width: 65%;" colspan="3" rowspan="2"><h4><strong>Referencia: </strong>DI-'.$book['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'].'</h4></td>
						<td><strong>Estatus: </strong></td><td>'.$status.'</td>					
					<tr>
						<td ><strong>Fecha realizada: </strong></td><td>'.$fechacreacion.'</td>
					<tr>
						<th>Habitación</th>
						<th>Plan</th>
						<th>Booking ID</th>
						<th>Check in</th>
						<th>Total Sin Markup</th>
					</tr>
				</thead>
				<tbody>';
						if ($_POST['countRoom']>1) {
							$i=1;
							foreach ($book['HotelReservation']['RoomStays']['RoomStay'] as $key => $monto){
									$row[$keys]+=$monto['RoomRates']['RoomRate']['Total']['@attributes']['AmountAfterTax'];
									$currency = $monto['RoomRates']['RoomRate']['Total']['@attributes']['CurrencyCode'];
									$resultado.='<tr>';
			 						$resultado.='<td>Habitación '.$i.': '.$monto['RoomTypes']['RoomType']['RoomDescription']['@attributes']['Name'].'</td>';
			 						$resultado.='<td>'.$monto['RoomRates']['RoomRate']['@attributes']['MealPlanDescription'].' - '.$monto['RoomRates']['RoomRate']['@attributes']['RatePlanCode'].'</td>';
			 						$resultado.='<td>'.$book['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'].'</td>';
			 						$resultado.='<td>'.implode("/", array_reverse(explode("-",substr($monto['RoomRates']['RoomRate']['Rates']['Rate']['@attributes']['EffectiveDate'],0,10)))).'</td>';
			 						$resultado.='<td>$ '.number_format($monto['RoomRates']['RoomRate']['Total']['@attributes']['AmountAfterTax'],2).' '.$currency.'</td>';
			 						$resultado.='</tr>';
			 						$i++;
			 				}
			 				$resultado.='<tr>';
			 				$resultado.='<td colspan="3"></td><td>Total: </td><td>$ '.number_format($row[$keys],2).' '.$currency.'</td>';
			 				$resultado.='</tr>';
						}elseif ($_POST['countRoom']==1) {
							$resultado.='<tr>';
							$resultado.='<td>'.$book['HotelReservation']['RoomStays']['RoomStay']['RoomTypes']['RoomType']['RoomDescription']['@attributes']['Name'].'</td>';
							$resultado.='<td>'.$book['HotelReservation']['RoomStays']['RoomStay']['RoomRates']['RoomRate']['@attributes']['MealPlanDescription'].' - '.$book['HotelReservation']['RoomStays']['RoomStay']['RoomRates']['RoomRate']['@attributes']['RatePlanCode'].'</td>';
							$resultado.='<td>'.$book['HotelReservation']['ResGlobalInfo']['HotelReservationIDs']['HotelReservationID']['@attributes']['ResID_Value'].'</td>';
							$resultado.='<td>'.implode("/", array_reverse(explode("-",substr($book['HotelReservation']['RoomStays']['RoomStay']['RoomRates']['RoomRate']['Rates']['Rate']['@attributes']['EffectiveDate'],0,10)))).'</td>';
							$resultado.='<td>$ '.number_format($book['HotelReservation']['RoomStays']['RoomStay']['RoomRates']['RoomRate']['Total']['@attributes']['AmountAfterTax'],2).' '.$book['HotelReservation']['RoomStays']['RoomStay']['RoomRates']['RoomRate']['Total']['@attributes']['CurrencyCode'].'</td>';
							$resultado.='</tr>';
						}

			$resultado.='</tbody></table>';

		}else
		{
			$resultado='<p>No se encontró la reserva</p><hr>';
		}

		echo $resultado;
	}

	public function actionReservacionesRiu()
	{
		$this->render('reservacionesRiu');
	}

	public function actionReservacionesRiuJson()
	{
		if (!empty($enviar)) {
			if($start && $end)
			{
				$inicial=implode('-', reverse(explode("/",$start)));
				$final=implode('-', reverse(explode("/",$end)));
				$fechas = " BETWEEN '".$inicial."' AND '".$final."' ";
				if($filterType=="CHECKIN")
					$rango = " AND r.fecha_inicial ".$fechas;
				else if($filterType=="CREATION")
					$rango = " AND r.log ".$fechas;
			}
			if(!empty($_POST['status']))
				$status = " AND r.estatus='".$status."'";
		}else{
			$rango="";
			$status="";
		}
		session_start();
		$condAgencia = "";
		if($_SESSION["tipoUsuario"] == "Agencia"){
			$condAgencia = " AND r.id_agencia='".$_SESSION["agenciaUsuario"]."'  ";
		}
		$sql = "SELECT r.*, DATE_FORMAT(r.log, '%Y-%m-%d') AS fecha_realizada, h.nombre_hotel, a.nombre_agencia, u.nombre_usuario, ag.nombre_usuario as nombre_agente
			FROM tbl_reservacion AS r 
			INNER JOIN tbl_usuarios as ag on ag.id_usuario=r.id_agente
			INNER JOIN tbl_hoteles AS h on h.id_hotel=r.id_hotel 
			INNER JOIN tbl_agencias AS a on r.id_agencia = a.id_agencia 
			INNER JOIN tbl_usuarios AS u on u.id_usuario = r.id_usuario 
			WHERE h.proveedor=4 ORDER BY r.id_reservacion DESC LIMIT 12000 ";
		$rows=Yii::app()->db->createCommand($sql)->queryAll();
		if(isset($_GET['$callback']))
			echo $_GET['$callback'].'({"row":' .CJSON::encode($rows). ', "__count": "'.count($rows).'"})';

	}
	public function xml_to_json($response)
	{
		if ($response) {
			$response = (string) preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $response);
       		$xml = new SimpleXMLElement($response);
        	$body = $xml->xpath('//soapBody');
       		$array = json_encode((array)$body);
		}else{
			$array = $response;
		}
		

        return $array; 
	}


	public function actionResultados(){
		$this->layout="//layouts/ansonika";

		$this->render("itemList");

	}


}