<?php

Yii::import('application.extensions.phpmailer.JPhpMailer');

class ReservacionTrasladoController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/homezV6';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','create','Cancelar'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('update','GeneratePdf','GenerateExcel'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
			
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */

	// public function actionConfirmarReserva()
	// {
	// 	// $response = $this->Tarifas();
	// 	// $response = $this->filtrarDatos($response);
	// 	$this->render('confirmarreserva');
	// }
	public function actionConfirmarReserva()
    {
        // $response = $this->Tarifas();
        // $response = $this->filtrarDatos($response);
        $this->render('confirmarreserva');
    }

	public function actionCancelar()
	{
		
			// $bookingReference = $_POST['bookings']['reference'];
			$modelreserva = ReservacionTraslado::model()->findByPk($_POST['idreserva']);
			$requestData = json_encode(['bookingReference' => $modelreserva->referencia]);
			// echo CJSON::encode($requestData);
			// exit;
			// require "../api/beds/prueba.php"; 
			// $trasladoApi = new ActivityApi(); 

			// $responseData = $trasladoApi->bookingCancel($requestData);
			// echo CJSON::encode($responseData);
			// exit;
			// if (isset($responseData['success']) && $responseData['success']) {
			// 	Yii::app()->user->setFlash('success', 'La reserva ha sido cancelada con exito.');
			// } else {
			// 	Yii::app()->user->setFlash('error', 'Error al cancelar la reserva: ' . ($responseData['message'] ?? 'Error desconocido.'));
			// }
 			$modelreserva->status='cancelado';
			$modelreserva->save();
			$this->redirect(array('view','id'=>$modelreserva->id_reservacion_traslado));		
		echo CJSON::encode($requestData);

	
		$response = [
			'success' => Yii::app()->user->hasFlash('success'),
			'message' => Yii::app()->user->getFlash('success') ?: Yii::app()->user->getFlash('error')
		];
	
		echo CJSON::encode($response);
	}
	//ConfirmarReserva
	public function actionCreate()
	{
		$model=new ReservacionTraslado;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['ReservacionTraslado']))
		{
			$model->attributes=$_POST['ReservacionTraslado'];
			$model->codigo_vuelo_ida = $_POST['codigo_vuelo_ida'];
			// $model->hora_vuelo_ida = $_POST['hora_vuelo_ida'];
			$model->hora_vuelo_ida = date("Y-m-d") . " " . $_POST['hora_vuelo_ida'];
			$model->codigo_vuelo_regreso = $_POST['codigo_vuelo_regreso'];
			$model->hora_vuelo_regreso = date("Y-m-d") . " " . $_POST['hora_vuelo_regreso'];
			// die(var_dump($model));
			$reservaProveedor = $this->reservastransfer($_POST);

			$model->referencia=$reservaProveedor['bookings']['reference'];
			$model->moneda=$reservaProveedor['bookings']['currency'];
			$model->tipo_traslado=$reservaProveedor['bookings']['transfers'][0]['transferType'];
			// $model->fecha_hora_recogida=$reservaProveedor['bookings']
			// $model->fecha_hora_llegada=$reservaProveedor['bookings']
			$model->tipo_vehiculo=$reservaProveedor['bookings']['transfers'][0]['vehicle']['name'];
			$model->numero_de_pasajeros=$reservaProveedor ? count($reservaProveedor['bookings']['transfers'][0]['paxes']) : 0;
			$model->aeropuerto=$reservaProveedor['bookings']['transfers'][0]['pickupInformation']['from']['description'];
			$model->hotel=$reservaProveedor['bookings']['transfers'][0]['pickupInformation']['to']['description'];	
			$model->precio_total=$reservaProveedor['bookings']['totalAmount'];	
			$model->total_neto=$reservaProveedor['bookings']['totalNetAmount'];
			// $model->codigo_vuelo_ida=$reservaProveedor['bookings']
			// $model->hora_vuelo_ida=$reservaProveedor['bookings']
			// $model->fecha_vuelo_ida=$reservaProveedor['bookings']
			// $model->codigo_vuelo_regreso=$reservaProveedor['bookings']
			// $model->hora_vuelo_regreso=$reservaProveedor['bookings']
			// $model->fecha_vuelo_regreso=$reservaProveedor['bookings']

			
			$arrayboking=[
				'imagen' =>$reservaProveedor['bookings']['transfers'][0]['content']['images'][0]['url'],
				'nombrevehiculo' =>$reservaProveedor['bookings']['transfers'][0]['vehicle']['name'],
				'categoriavehiculo' =>$reservaProveedor['bookings']['transfers'][0]['category']['name'],
				'tipotraslado' =>$reservaProveedor['bookings']['transfers'][0]['transferType'],
				'aeropuerto' =>$reservaProveedor['bookings']['transfers'][0]['pickupInformation']['from']['description'],
				'hotel' =>$reservaProveedor['bookings']['transfers'][0]['pickupInformation']['to']['description'],
				'cantidadpersonas' => count($reservaProveedor['bookings']['transfers'][0]['paxes']),
				'maletaspermitidas' =>$reservaProveedor['bookings']['transfers'][0]['content']['transferDetailInfo'][3]['description'],
				'codigovuelo' =>$reservaProveedor['bookings']['transfers'][0]['arrivalFlightNumber'],
				'precioviaje' =>$reservaProveedor['bookings']['totalAmount'],
				'tipomoneda' =>$reservaProveedor['bookings']['currency']



			];
			$model->booking=json_encode($arrayboking);
			// $model->image=$reservaProveedor['bookings']['reference']['content'][0]['url'];
			
			//Estos die imprimen la respuesta
			// die(var_dump($reservaProveedor));
			// die(json_encode($reservaProveedor));
			// die(var_dump($reservaProveedor['bookings']['reference']));
			// echo CJSON::encode($model);
			// exit;
			if($model->save()){
				$this->emailCliente($model);
				$_SESSION['traslado_exitoso'] = true;
				$this->redirect(array('view','id'=>$model->id_reservacion_traslado));
			}else{
				echo CJSON::encode($model->getErrors());
			}
		}

		// $this->render('confirmarreserva', array('model' => $model));

	}

	public function reservastransfer($datos)
	{
		require "../api/beds/prueba.php";
			
		$rateKey = isset($datos['rateKey']);
		$holderName = isset($datos['ReservacionTraslado']['name']);
		$holderSurname = isset($datos['ReservacionTraslado']['lastname']);
		$holderEmail = isset($datos['ReservacionTraslado']['email']);
		$holderPhone = isset($datos['ReservacionTraslado']['phone']);
		// $clientReference = isset($datos['ReservacionTraslado']['clientReference']);
		// $welcomeMessage = isset($datos['ReservacionTraslado']['welcomeMessage']);
		// $remark = isset($datos['ReservacionTraslado']['remark']);
		
		if ($rateKey && $holderName && $holderSurname && $holderEmail && $holderPhone) {
			$requestData = [
				"language" => "es",
				"holder" => [
					"name" => $holderName,
					"surname" => $holderSurname,
					"email" => $holderEmail,
					"phone" => $holderPhone
				],
				"transfers" => [

					[

						"rateKey" => $rateKey,
						"transferDetails" => [
							[
								"type" => "standard", 
								"direction" => "pickup", 
								"code" => "ABC", 
								"companyName" => "NombreEmpresa" 									
							]
						]
					]
				],

				"clientReference" => "BOSTON#12-203#456754", // $clientReference, 
				"welcomeMessage" => "Welcome Mr. John Doe", // $welcomeMessage,
				"remark" => "Booking remarks go here.", // $remark

			];
			$trasladoApi = new ActivityApi();
			// $response = $trasladoApi->modifyBookingAddTransfer(json_encode($requestData));
			// return $response;

			//PROCESO ESTATICO POR ERROR DE API DE HOTELBEDS
			$responsejemplo = [
				"bookings" => 
					[
						"reference" => "102-14536491",
						"bookingFileId" => null,
						"creationDate" => "2023-11-24T11:32:41",
						"status" => "CONFIRMED",
						"modificationsPolicies" => [
							"cancellation" => true,
							"modification" => true
						],
						"holder" => [
							"name" => "John",
							"surname" => "Doe",
							"email" => "john.doe@hotelbeds.com",
							"phone" => "+16543245812"
						],
						"transfers" => [
							[
								"id" => 1,
								"rateKey" => "ARRIVAL|IATA|BCN|ATLAS|398692|2024-01-11|15:25|2024-01-11|15:25|2~0~0||99|||||102|SHRD||SH|STND|20.01||||39|398692|SIMPLE|173a9268801b66cdac4a1bbe6430b137|1269799|T|1b3814dfc98b4495220e3ecb1ff1ee6f",
								"status" => "CONFIRMED",
								"transferType" => "SHARED",
								"vehicle" => [
									"code" => "SH",
									"name" => "Shuttle"
								],
								"category" => [
									"code" => "STND",
									"name" => "Standard"
								],
								"pickupInformation" => [
									"from" => [
										"code" => "BCN",
										"description" => "Barcelona Airport",
										"type" => "IATA"
									],
									"to" => [
										"code" => "398692",
										"description" => "Lugaris Rambla",
										"type" => "ATLAS"
									],
									"date" => "2024-01-11",
									"time" => "15:25:00",
									"pickup" => [
										"address" => null,
										"number" => null,
										"town" => null,
										"zip" => null,
										"description" => "Aquí va la nota importante...",
										"altitude" => null,
										"latitude" => 41.3989153,
										"longitude" => 2.20509,
										"checkPickup" => [
											"mustCheckPickupTime" => true,
											"url" => "www.checkpickup.com",
											"hoursBeforeConsulting" => null
										],
										"pickupId" => null,
										"stopName" => null,
										"image" => null
									]
								],
								"paxes" => [
									["type" => "ADULT", "age" => 30],
									["type" => "ADULT", "age" => 30]
								],
								"content" => [
									"vehicle" => ["code" => "SH", "name" => "Shuttle"],
									"category" => ["code" => "STND", "name" => "Standard"],
									"images" => [
										["url" => "https://assets.htxstaging.com/imgs/default/vehicle_set/shuttle1min3.jpg", "type" => "EXTRALARGE"],
										["url" => "https://assets.htxstaging.com/imgs/default/vehicle_set/shuttle1min3.jpg", "type" => "LARGE"],
										["url" => "https://assets.htxstaging.com/imgs/default/vehicle_set/shuttle1min3.jpg", "type" => "MEDIUM"],
										["url" => "https://assets.htxstaging.com/imgs/default/vehicle_set/shuttle1min3.jpg", "type" => "SMALL"]
									],
									"transferDetailInfo" => [
										["id" => "0", "name" => "transfertime", "description" => "50 min. Estimated journey time", "type" => "GENERAL_INFO"],
										["id" => "1", "name" => "minpax", "description" => "1 passenger(s) minimum", "type" => "GENERAL_INFO"],
										["id" => "2", "name" => "maxpax", "description" => "99 passenger(s) maximum", "type" => "GENERAL_INFO"],
										["id" => "3", "name" => "luggage", "description" => "12 suitcases permitted", "type" => "GENERAL_INFO"]
									],
									"transferRemarks" => [
										[
											"type" => "CONTRACT",
											"description" => "Aquí va la nota importante de nuevo...",
											"mandatory" => true
										]
									]
								],
								"price" => [
									"totalAmount" => 20.01,
									"netAmount" => 0.00,
									"currencyId" => "EUR"
								],
								"cancellationPolicies" => [
									[
										"amount" => 20.99,
										"from" => "2024-01-10T00:00:00",
										"currencyId" => "USD",
										"isForceMajeure" => false
									]
								],
								"arrivalFlightNumber" => "XR1234",
								"transferDetails" => [
									[
										"type" => "FLIGHT",
										"direction" => "ARRIVAL",
										"code" => "XR1234"
									]
								],
								"sourceMarketEmergencyNumber" => "34871180153",
								"links" => [
									["rel" => "transferCancel", "href" => "/booking/en/reference/102-14536491", "method" => "DELETE"]
								]
							]
						],
						"clientReference" => "BOSTON#12-203#456754",
						"remark" => "",
						"invoiceCompany" => ["code" => "E14"],
						"supplier" => [
							"name" => "HOTELBEDS SPAIN, S.L.U",
							"vatNumber" => "ESB28916765"
						],
						"totalAmount" => 20.99,
						"totalNetAmount" => 20.99,
						"pendingAmount" => 20.99,
						"currency" => "USD",
						"links" => [
							["rel" => "self", "href" => "/booking/en/reference/102-14536491", "method" => "GET"],
							["rel" => "bookingDetail", "href" => "/booking/en/reference/102-14536491", "method" => "GET"],
							["rel" => "bookingCancel", "href" => "/booking/en/reference/102-14536491", "method" => "DELETE"]
						],
						"paymentDataRequired" => false
					]
				
			];

			return $responsejemplo;
		} 
	}

	public function emailCliente($model)
	{


		$mail = new JPhpMailer();
        $mail->IsSMTP();
        $mail->Host = 'reservaenlinea1.uvaconline.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'prueba@reservaenlinea1.uvaconline.com';
        $mail->Port = '26';
        $mail->Password = 'uvaconline2024+';
        $mail->SMTPKeepAlive = true;
        $mail->Mailer = "SMTP";
        $mail->SMTPAuth   = true;
        $mail->CharSet = 'utf-8';
		$mail->SetFrom('prueba@reservaenlinea1.uvaconline.com', 'Sistema UVAC ONLINE');
        $mail->SMTPDebug  = false;
		// $message = '<h4>Atentamente el equipo de UVAC ONLINE</h4>';
        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true));

		$mail->Subject = "Felicidades, su reservación ha sido creada con éxito";
		$mail->MsgHTML($this->renderPartial('email', array("model" => $model),true));
		$mail->AddAddress($model->email, $model->name . ' ' . $model->lastname);


				
	
		if ($mail->Send()) {
			// echo "enviado";
			$this->redirect(array('view','id'=>$model->id_reservacion_traslado));
		} else {
			echo 'Message could not be sent.';
			echo 'Mailer Error: <textarea>' . $mail->ErrorInfo . "";
		}exit;
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['ReservacionTraslado']))
		{
			$model->attributes=$_POST['ReservacionTraslado'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_reservacion_traslado));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new ReservacionTraslado('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['ReservacionTraslado']))
		{
                        $model->attributes=$_GET['ReservacionTraslado'];
			
			
                   	
                       if (!empty($model->id_reservacion_traslado)) $criteria->addCondition("id_reservacion_traslado = '".$model->id_reservacion_traslado."'");
                     
                    	
                       if (!empty($model->folio)) $criteria->addCondition("folio = '".$model->folio."'");
                     
                    	
                       if (!empty($model->name)) $criteria->addCondition("name = '".$model->name."'");
                     
                    	
                       if (!empty($model->lastname)) $criteria->addCondition("lastname = '".$model->lastname."'");
                     
                    	
                       if (!empty($model->email)) $criteria->addCondition("email = '".$model->email."'");
                     
                    	
                       if (!empty($model->phone)) $criteria->addCondition("phone = '".$model->phone."'");
                     
                    	
                       if (!empty($model->currency)) $criteria->addCondition("currency = '".$model->currency."'");
                     
                    	
                       if (!empty($model->transfer_type)) $criteria->addCondition("transfer_type = '".$model->transfer_type."'");
                     
                    	
                       if (!empty($model->pickup_time)) $criteria->addCondition("pickup_time = '".$model->pickup_time."'");
                     
                    	
                       if (!empty($model->dropoff_time)) $criteria->addCondition("dropoff_time = '".$model->dropoff_time."'");
                     
                    	
                       if (!empty($model->vehicle_type)) $criteria->addCondition("vehicle_type = '".$model->vehicle_type."'");
                     
                    	
                       if (!empty($model->passenger_count)) $criteria->addCondition("passenger_count = '".$model->passenger_count."'");
                     
                    	
                       if (!empty($model->status)) $criteria->addCondition("status = '".$model->status."'");
                     
                    	
                       if (!empty($model->pickup_location)) $criteria->addCondition("pickup_location = '".$model->pickup_location."'");
                     
                    	
                       if (!empty($model->dropoff_location)) $criteria->addCondition("dropoff_location = '".$model->dropoff_location."'");
                     
                    	
                       if (!empty($model->total_price)) $criteria->addCondition("total_price = '".$model->total_price."'");
                     
                    	
                       if (!empty($model->total_neto)) $criteria->addCondition("total_neto = '".$model->total_neto."'");
                     
                    	
                       if (!empty($model->fecha_creacion)) $criteria->addCondition("fecha_creacion = '".$model->fecha_creacion."'");
                     
                    	
                       if (!empty($model->flight_code_outgoing)) $criteria->addCondition("flight_code_outgoing = '".$model->flight_code_outgoing."'");
                     
                    	
                       if (!empty($model->flight_time_outgoing)) $criteria->addCondition("flight_time_outgoing = '".$model->flight_time_outgoing."'");
                     
                    	
                       if (!empty($model->flight_date_outgoing)) $criteria->addCondition("flight_date_outgoing = '".$model->flight_date_outgoing."'");
                     
                    	
                       if (!empty($model->flight_code_return)) $criteria->addCondition("flight_code_return = '".$model->flight_code_return."'");
                     
                    	
                       if (!empty($model->flight_time_return)) $criteria->addCondition("flight_time_return = '".$model->flight_time_return."'");
                     
                    	
                       if (!empty($model->flight_date_return)) $criteria->addCondition("flight_date_return = '".$model->flight_date_return."'");
                     
                    	
                       if (!empty($model->vendedor_referenciado)) $criteria->addCondition("vendedor_referenciado = '".$model->vendedor_referenciado."'");
                     
                    			
                    $session['ReservacionTraslado_records']=ReservacionTraslado::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new ReservacionTraslado('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['ReservacionTraslado']))
			$model->attributes=$_GET['ReservacionTraslado'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=ReservacionTraslado::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='reservacion-traslado-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['ReservacionTraslado_records']))
               {
                $model=$session['ReservacionTraslado_records'];
               }
               else
                 $model = ReservacionTraslado::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['ReservacionTraslado_records']))
               {
                $model=$session['ReservacionTraslado_records'];
               }
               else
                 $model = ReservacionTraslado::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('ReservacionTraslado Report');
		$pdf->SetSubject('ReservacionTraslado Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("ReservacionTraslado_002.pdf", "I");
	}
}
