<?php

Yii::import('application.extensions.phpmailer.JPhpMailer');

class OutletController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel','reservaciones','procesoReservacion','agregarParticipantes','deleteParticipante','reporteAgencias','enviarCupones','Comisiones', 'AjaxExample'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Outlet;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Outlet']))
		{
			$model->attributes=$_POST['Outlet'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_outlet));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Outlet']))
		{
			$model->attributes=$_POST['Outlet'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_outlet));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionComisiones($id)
	{
		$this->layout='//layouts/altair';
			
		$this->render('gestionComision', array('id'=>$id));	
	}

		public function pagoTotal($id)
	{	
		$ageciasParticipantes=OutletAgencia::model()->findAll('id_evento='.$id);
		$agencias=array();
		foreach ($ageciasParticipantes as $key=>$ag) {
			$agencias[$key]=$ag->id_agencia;
		}
		$criteria=$this->consultaRes($id,$agencias);

		$reservaciones=Reservacion::model()->findAll($criteria);
		$comisionReserva=array();
		
		$totalPago=0;
		$totalSaldo=0;
		$idAgencia=0;
		$outlet=Outlet::model()->findByPk($id);
		$agencias=array();
		//$fecha_final=date('Y-m-d',strtotime($outlet->fecha_final." +1 days"));
		foreach ($reservaciones as $key => $reserv) {
		$criteria->condition="id_agencia=".$reserv->id_agencia." and log BETWEEN '".$outlet->fecha_inicio."' AND '2019-05-05'";
		
		$reservas=Reservacion::model()->count($criteria);
	
			$comisionReserva['data'][$reserv->id_agencia]['id']=$reserv->id_agencia;
			$comisionReserva['data'][$reserv->id_agencia]['agencia']=$reserv->idAgencia->nombre_agencia;
			$comisionReserva['data'][$reserv->id_agencia]['reservaciones']=$reservas;
			$comisionReserva['data'][$reserv->id_agencia]['total']+=$reserv->total;
			$comisionReserva['data'][$reserv->id_agencia]['saldo']+=$reserv->total-($reserv->total*($reserv->comision/100));
			
			
			$total="";
			$imptotal="";
			$detalle=ReciboDetalles::model()->findAll('id_reservacion='.$reserv->id_reservacion);
			
				
				foreach ($detalle as $res => $detalle) {
						$model=Recibo::model()->findAll('id_recibo='.$detalle->id_recibo);
				
						foreach ($model as $com => $recibo) {
							$subtotal="";
							switch ($recibo->id_tipo) {
								case 8 || 9 || 11 || 13 || 14 || 2:
										$subtotal=$detalle->importe*0.10;
									break;
								
								case 1 || 6 || 7:
										$subtotal=$detalle->importe*0.12;
										
									break;
							
							}
						 
						 	$total+=$subtotal;
						}
				}
						
						
				
		
				$comisionReserva['data'][$reserv->id_agencia]['pago_agencia']+=$total;
				$idAgencia=$reserv->id_agencia;
				
		}
			$comision['data']=array_values($comisionReserva['data']);
		
		
		return $comision;
	}
	

	public function consultaRes($id,$agencias){
		$outlet=Outlet::model()->findByPk($id);
		$criteria= new CDbCriteria;
		//$criteria->with="idTarifa";
		//$criteria->condition="idTarifa.precio='OUTLET'";
		//$criteria->limit=10;
		$criteria->condition="id_agencia IN(".implode(',', $agencias).") AND estatus!='C'";
		$fecha_final=date('Y-m-d',strtotime($outlet->fecha_final." +1 days"));
		$criteria->addBetweenCondition('log',$outlet->fecha_inicio,$fecha_final,'AND');
		return $criteria;
	}

	public function reservacionxRecibo($id)
	{

		$ageciasParticipantes=OutletAgencia::model()->findAll('id_evento='.$id);

		foreach ($ageciasParticipantes as $key=>$ag) {
			$agencias[$key]=$ag->id_agencia;
		}
		$criteria=$this->consultaRes($id,$agencias);
			$tipoPago10=array(8,11,12,13,14);
			$tipoPago12=array(1,2,6,7,9);

		$reservaciones=Reservacion::model()->findAll($criteria);
		$comisionReserva=array();
		foreach ($reservaciones as $key => $reserv) {
			$comisionReserva['data'][$key]['id_reservacion']=$reserv->id_reservacion;
			$comisionReserva['data'][$key]['agencia']=$reserv->idAgencia->nombre_agencia;
			$comisionReserva['data'][$key]['hotel']=$reserv->idHotel->nombre_hotel;
			$comisionReserva['data'][$key]['total']='$'.number_format($reserv->total,2);
			$comisionReserva['data'][$key]['saldo']='$'.number_format($reserv->total-($reserv->total*($reserv->comision/100)),2);
			$comisionReserva['data'][$key]['comision']=number_format($reserv->comision)."%";
			$comisionReserva['data'][$key]['log']=date('d/m/y',strtotime($reserv->log));
			
			$total="";
			$imptotal="";
			$detalle=ReciboDetalles::model()->findAll('id_reservacion='.$reserv->id_reservacion);
			
				$tablaComision=" <tr><th class='uk-width-1-10 uk-text-center small_col'>Recibo</th><th class='uk-width-2-10 uk-text-center small_col'>Pago</th><th class='uk-width-1-10 uk-text-center small_col' >Comision</th><th class='uk-width-1-10 uk-text-center small_col'>Importe</th><th class='uk-width-1-10 uk-text-center small_col'>Subtotal</th></tr>";
				foreach ($detalle as $res => $detalle) {
						$model=Recibo::model()->findAll('id_recibo='.$detalle->id_recibo);
				
						foreach ($model as $com => $recibo) {
							$subtotal="";
							switch (true) {
								case in_array($recibo->id_tipo, $tipoPago10):
										$subtotal=$detalle->importe*0.10;
										$comision="10%";
									break;
								// 
								case in_array($recibo->id_tipo, $tipoPago12):
										$subtotal=$detalle->importe*0.12;
										$comision="12%";
									break;
									// 
							}
						 	$tablaComision.='<tr><td class="uk-text-center uk-width-1-10 small_col">'.$recibo->id_recibo.'</td><td class="uk-text-center uk-width-2-10 small_col">'.$recibo->idTipo->descripcion.'</td><td class="uk-width-1-10 uk-text-center small_col">'.$comision.'</td><td class="uk-text-right uk-width-1-10 small_col">$'.number_format($detalle->importe,2).'</td><td class="uk-text-right uk-width-1-10 small_col">$'.number_format($subtotal,2).'</td></tr>';	
						 	$total+=$subtotal;
						}
				}
						
						$tablaComision.='<tr><td colspan=4 class="uk-text-right"><b>Total:</b></td><td class="uk-text-right">$'.number_format($total,2).'</td></tr>';
				
		
				$comisionReserva['data'][$key]['recibo']=trim($tablaComision,"\t\n\r");
				$comisionReserva['data'][$key]['pago_agencia']=number_format($total,2);


			//

			/*foreach ($model as $key => $recibo) {
				$comisionReserva['']$recibo->
			}*/
			
		}
		return $comisionReserva;

	}
	public function actionAjaxExample($id, $com)
	{
		 header('Content-Type: text/html; charset=utf-8');
		 if ($com=="comision") {
		 	$res= $this->reservacionxRecibo($id);
		 	
		 }else{
		 	$res=$this->pagoTotal($id);
		 }
		 	echo CJSON::encode($res); 
		
		//echo '{"data":[{"id_reservacion":"1","agencia":"Tiger Nixon","hotel":"System Architect","comision":"14%","total":"$320,800","recibo":"15505</td><td>TARJETA CREDITO</td><td>12%</td><td>10376.73</td><td>1245.2076</td></tr><tr><td colspan=\"4\ class=\"uk-text-right\">Total</td><td>1245.2076</td></tr>"}]}';
			
	}
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new Outlet('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['Outlet']))
		{
                        $model->attributes=$_GET['Outlet'];
			
			
                   	
                       if (!empty($model->id_outlet)) $criteria->addCondition("id_outlet = '".$model->id_outlet."'");
                     
                    	
                       if (!empty($model->comision_agencia)) $criteria->addCondition("comision_agencia = '".$model->comision_agencia."'");
                     
                    	
                       if (!empty($model->fecha_inicio)) $criteria->addCondition("fecha_inicio = '".$model->fecha_inicio."'");
                     
                    	
                       if (!empty($model->fecha_final)) $criteria->addCondition("fecha_final = '".$model->fecha_final."'");
                     
                    	
                       if (!empty($model->mensaje_comision_agencia)) $criteria->addCondition("mensaje_comision_agencia = '".$model->mensaje_comision_agencia."'");
                     
                    			
                    $session['Outlet_records']=Outlet::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Outlet('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Outlet']))
			$model->attributes=$_GET['Outlet'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Outlet::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='outlet-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
       
    public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['Outlet_records']))
               {
                $model=$session['Outlet_records'];
               }
               else
                 $model = Outlet::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}

	public function actionReservaciones($id)
	{
		

		if($_POST['start'] && $_POST['end'])
		{
			$start=$_POST['start'];
			$end=$_POST['end'];
			/*$in=$_POST['start'];
			$fi=$_POST['end'];*/
		}else
		{
			$outlet=Outlet::model()->findByPk($id);
			/*$start = $outlet->fecha_inicio;
			$end = $outlet->fecha_final;*/
			$start=date("d/m/Y",strtotime($outlet->fecha_inicio));
			$end=date("d/m/Y",strtotime($outlet->fecha_final));
		}
		


		$fecha_inicio = implode("-", array_reverse(explode("/", $start)));
		$fecha_final = implode("-", array_reverse(explode("/", $end)));

		//echo $fecha_inicio."<br>".$fecha_final;

		
		$fechas = 'and (date(t.log) between "'.$fecha_inicio.'" and "'.date('Y-m-d',strtotime($fecha_final."+1 days")).'")';

		$tipo_precio = 'and idTarifa.precio="OUTLET"';

		$model = Reservacion::model()->with('idHotel','idTarifa')->findAll(array('condition'=>'t.estatus!="C" '.$tipo_precio.' '.$fechas,'order'=>'t.id_hotel DESC, t.log'));
	
		$this->render('reservaciones',array('model'=>$model,'id_evento'=>$id,'start'=>$start,'end'=>$end));
		
	}

	public function actionEnviarCupones()
	{
		if($_POST['confirmar']=="OK")
		{
			
			$mail=array();
			$ulHead="<ul>";
			$ulFoot="</ul>";
			foreach (json_decode(json_encode($_POST['data'])) as $key => $row) 
			{
				if($row->name=="folio")
				{
					$reservacion=Reservacion::model()->findByPk($row->value);
					if($reservacion->enviado_h==0)
					{
						$email=json_decode($this->creaEmail($reservacion));
						$mail["hotels"][$reservacion->id_hotel]['messagesHotel'][$reservacion->id_reservacion]=$email->messageHotel;
						$mail["hotels"][$reservacion->id_hotel]['nombreHotel']=$reservacion->idHotel->nombre_hotel;
						$mail["hotels"][$reservacion->id_hotel]['email_hotel']=$reservacion->idHotel->email_reservas_1;
						$mail["hotels"][$reservacion->id_hotel]['contacto_reservas']=$reservacion->idHotel->contacto_reservas_1;

						$reservacion->enviado_h=1;
						$reservacion->save();

					}else
					{
						echo $ulHead."<li>El folio ".$row->value." ya sido enviado anteriormente</li>".$ulFoot;		
					}
				}
			}
			
			if($mail["hotels"])
			{
				$mail['subject']="RESERVAS OUTLET VERANO RUTA MAYA TRAVEL";
				$mail['img_rmt']='<img src="http://'.$_SERVER['SERVER_NAME'].''.Yii::app()->baseUrl.'/images/logo_rutamaya.jpg" style="width:30px">';

				$mail["usuario_agente"]="FERNANDO EUAN";
				$mail["email_agente"]="reservaciones@rutamayatravel.com";
				$mail["messageFooter"] = "Enviado por: <strong>".$mail["usuario_agente"]."</strong><br>
						Responder a: <strong>".$mail["email_agente"]."</strong><br>
						<span style='color:#001e7b'>Av. Cupules #236 x 20 y 22 Col. García Ginerés.<br>Mérida, Yucatán, México.<br>Tels. 925-56-18 y 286-49-90<br><u>www.rutamayatravel.com</u></span></div>";

				$mail_json=json_encode($mail);
				$mail_decode=json_decode($mail_json);

				//echo "<textarea>".$mail_json."</textarea>";
				
				foreach ($mail_decode->hotels as $id_hotel => $reserva) 
				{
					$foliosEnviados="";
					$messageHotel="";
					foreach ($reserva->messagesHotel as $folio => $descrip_hotel) 
					{
						$messageHotel.=$descrip_hotel;
						$foliosEnviados.="<li>El folio ".$folio." ha sido enviado</li>";		

					}

					$messageHotel="<h3>".$mail_decode->subject."</h3>".$mail_decode->img_rmt.$messageHotel."<hr>".$mail_decode->messageFooter;				

					//echo $messageHotel;

					$messageSend=$this->enviaEmail($mail_decode->subject,$messageHotel,$reserva->email_hotel,$reserva->contacto_reservas,$mail_decode->usuario_agente,$mail_decode->email_agente);

					//echo $mail_decode->subject."<br>".$reserva->email_hotel."<br>".$reserva->contacto_reservas."<br>".$mail_decode->usuario_agente."<br>".$mail_decode->email_agente;
					
					if($messageSend==true)
					{
						echo "<h4>".$reserva->nombreHotel."</h4>";
						echo $ulHead.$foliosEnviados.$ulFoot;
					}else
					{
						$foliosEnviados="";
						echo "Ocurrió un error al intentar enviar los folios seleccionados";
						foreach ($reserva->messagesHotel as $folio => $descrip_hotel) 
						{
							$reservacion=Reservacion::model()->findByPk($folio);
							if($reservacion->enviado_h==1)
							{
								$reservacion->enviado_h=0;
								if($reservacion->save())
									$foliosEnviados.="<li>El folio ".$folio." no pudo ser enviado</li>";									
								
							}


						}
						echo $ulHead.$foliosEnviados.$ulFoot;
					
					}									
					
				}
			}else
			{
				echo "No hay folios por enviar";
			}
			

		}else
		{
			echo "No se enviaron cupones";
			//echo count($_POST['folios']);
		}
	}

	public function creaEmail($model)
	{
		//Formato de correo para el hotel
		$desglose = ReservacionDesglose::model()->findAll('id_reservacion='.$model->id_reservacion);
		$num_adultos = 0;
		$num_menores = 0;
		$i = 1;
		$messageHotel = '<div style="font-family:Helvetica">
					<table border="1" bordercolor="#000000">
						<tbody>
							<tr>
								<td align="center" colspan="4" style="background:#CCC; font-size:22px">SOLICITUD DE RESERVACION</td>    
							</tr>
							<tr>
								<td>MERIDA, YUC.</td>
								<td>FECHA:</td>
								<td colspan="2">'.date('d/m/Y').'</td>
							</tr>
							<tr>
								<td colspan="3">DEPARTAMENTO DE RESERVACIONES:</td>
								<td align="center">'.strtoupper($model->idHotel->contacto_reservas_1).'</td>
							</tr>
							<tr>
								<td style="font-size:16px">HOTEL:</td>
								<td colspan="3" style="font-size:16px"><strong>'.strtoupper($model->idHotel->nombre_hotel).'</strong></td>
							</tr>
							<tr>
								<td style="font-size:16px">CLIENTE:</td>
								<td colspan="3" style="font-size:16px"><strong>'.strtoupper($model->nombre_cliente).' '.strtoupper($model->apellido_cliente).'</strong></td>
							</tr>
							<tr>
								<td>FAVOR DE:</td>
								<td align="center" colspan="3" style="font-size:16px"><strong>CONFIRMAR</strong></td>
							</tr>
							<tr>
								<td>CUPÓN RMT:</td>
								<td colspan="3">'.$model->id_reservacion.'</td>
							</tr>';
		foreach($desglose as $hab)
		{	
			$pax = ReservacionDesglosePersona::model()->find('id_desglose='.$hab->id_desglose.' and id_reservacion='.$hab->id_reservacion);
			$menores = ReservacionDesglosePersona::model()->findAll('id_desglose='.$hab->id_desglose.' and id_reservacion='.$hab->id_reservacion.' and tipo="N"');
			$num_adultos += $hab->num_adultos;
			$num_menores += $hab->num_ninios;
			$messageHotel .= '<tr>
							<td><strong>PAX '.$i.'</strong></td>
							<td colspan="3"><strong>'.$pax->nombre.' UNA HAB '.$hab->idbasehabitacion->base_habitacion;
				if(!empty($menores))
				{
					$messageHotel .= ' + '.$hab->num_ninios.' MNRS / ';
					foreach($menores as $mnr){
						$messageHotel .= $mnr->edad.',';
					}
					$messageHotel = substr($messageHotel, 0, -1);						
					$messageHotel .= ' AÑOS</strong></td>
								</tr>
								<tr>
									<td colspan="4">&nbsp;</td>
								</tr>';
				}
				else{
					$messageHotel .= '</strong></td></tr>
								<tr>
									<td colspan="4">&nbsp;</td>
								</tr>';
				}
			$i++;
		}
		$messageHotel .= '<tr>
						<td>IN:</td>
						<td colspan="3" style="background:#CCC;"><strong>'.date('d/m/Y',strtotime($model->fecha_inicial)).'</strong></td>
					</tr>
					<tr>
						<td>OUT:</td>
						<td colspan="3" style="background:#CCC;"><strong>'.date('d/m/Y',strtotime($model->fecha_final)).'</strong></td>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
					<tr>
						<td>NUM. NOCHES:</td>
						<td colspan="3"><strong>'.$model->num_noches.' NOCHES</strong></td>
					</tr>
					<tr>
						<td>No. HAB:</td>
						<td colspan="3"><strong>'.$model->num_habitaciones.'</strong></td>
					</tr>
					<tr>
						<td>TIPO:</td>
						<td colspan="3"><strong>'.$desglose[0]->idtipohabitacion->tipo_habitacion.'</strong></td>
					</tr>
					<tr>
						<td>No. ADTS</td>
						<td align="center">'.$num_adultos.'</td>
						<td>No. MNRS</td>
						<td align="center">'.$num_menores.'</td>
					</tr>
					<tr>
						<td>PLAN</td>
						<td colspan="3"><strong>'.$model->idTipoPlan->nombre.'</strong></td>
					</tr>
					<tr>
						<td>COD. TARIFA</td>
						<td colspan="3"><strong>'.$model->idTarifa->nombre_tarifa.' ('.$model->idTarifa->codigo.')</strong></td>
					</tr>
					<tr>
						<td align="center" colspan="4"><strong>OBSERVACIONES:</strong></td>
					</tr>
					<tr>
						<td colspan="4" rowspan="4" style="background:#CCC;"><strong>'.$model->observaciones.'</strong></td>
					</tr>';
		$messageHotel .= '</tbody></table><br>';
		return json_encode(array('messageHotel'=>$messageHotel));
	}


	public function enviaEmail($subject,$messageHotel,$email_hotel,$contacto_reservas,$usuario_agente,$email_agente)
	{
		$mail = new JPhpMailer;
		$mail->IsSMTP();
		$mail->Host = 'rutamayatravel.com'; 
		$mail->SMTPAuth = true;
		$mail->Username = 'no-reply@rutamayatravel.com'; 
		$mail->Port = '26'; 
		$mail->Password = 'Intelred76'; 
		$mail->SMTPKeepAlive = true;  
		$mail->Mailer = "smtp"; 
		$mail->IsSMTP();  
		$mail->SMTPAuth = true;  
		$mail->CharSet = 'utf-8';  
		$mail->SMTPDebug  = 0;
		$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel'); 
		$mail->Subject = $subject; 
		$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; 
		$mail->MsgHTML($messageHotel);
		//El correo se envia con copia al agente_reservasRMT, contacto_reservasHotel
		$mail->AddAddress($email_hotel, $contacto_reservas);
		$mail->AddAddress($email_agente, $usuario_agente);
		if($mail->Send())
		{
			$messageSend=true;
		}else
		{
			$messageSend=false;
		}

		return $messageSend;

	}

	public function actionProcesoReservacion()
	{
		$true='<i class="fa text-success fa-check"></i>';
		$false='<i class="fa text-danger fa-circle"></i>';
		$estatusEnviado=$true;
		$estatusCobrado=$true;
		$estatusPagado=$true;
		$id_reservacion=$_POST["folio"];
		
		$reservacion=Reservacion::model()->findByPk($id_reservacion);

			/*$pagos = ReciboDetalles::model()->findAll('id_reservacion='.$id_reservacion);
			$totalrecibos = 0;
			foreach ($pagos as $row)
			{
			    $recibo = Recibo::model()->findByPk($row->id_recibo);
			    if($recibo->estado != 'C')
			    {
				    $totalrecibos += $row->importe; 
			    } 
			}
			$totalrecibos;*/


		if($reservacion->enviado_h!=1)
			$estatusEnviado=$false;

		if($reservacion->saldo>0)
			$estatusCobrado=$false;

		if($reservacion->saldo_h>0)
			$estatusPagado=$false;


		$this->renderPartial('procesoReservacion',array('folio'=>$id_reservacion,'estatusReservado'=>$true,'estatusCobrado'=>$estatusCobrado,'estatusPagado'=>$estatusPagado,'estatusEnviado'=>$estatusEnviado));
	}

	public function actionAgregarParticipantes()
	{
		$participante=$_POST["id_participante"];
		$id_evento=$_POST["id"];


		if($_POST["tipo"]=="a")
		{
			$existe=OutletAgencia::model()->find('id_agencia='.$participante." AND id_evento=".$id_evento);
			if(empty($existe))
			{
				$outletAgencia=new OutletAgencia;
				$outletAgencia->id_agencia=$participante;
				$outletAgencia->id_evento=$id_evento;
				if($outletAgencia->save())
				{
					echo '<div class="alert alert-success"><p>La agencia '.$outletAgencia->idAgencia->nombre_agencia.' ha sido agregada a la lista</p>';
				}else
				{
					echo '<div class="alert alert-danger"><p><strong>¡Error!</strong> La agencia '.$outletAgencia->idAgencia->nombre_agencia.' no pudo agregarse a la lista</p>';
				}

			}else
			{
				echo '<div class="alert alert-warning"><p>La agencia '.$outletAgencia->idAgencia->nombre_agencia.' ya existe en la lista</p>';
			}
		}else if($_POST["tipo"]=="h")
		{
			$existe=OutletHotel::model()->find('id_hotel='.$participante." AND id_evento=".$id_evento);
			if(count($existe)==0)
			{
				$outletHotel=new OutletHotel;
				$outletHotel->id_hotel=$participante;
				$outletHotel->id_evento=$id_evento;
				if($outletHotel->save())
				{
					echo '<div class="alert alert-success"><p>El hotel '.$outletHotel->idHotel->nombre_hotel.' ha sido agregado a la lista</p>';
				}else
				{
					echo '<div class="alert alert-danger"><p><strong>¡Error!</strong> El hotel '.$outletHotel->idHotel->nombre_hotel.' no pudo agregarse a la lista</p>';
				}

			}else
			{
				echo '<div class="alert alert-warning"><p>El hotel '.$outletHotel->idHotel->nombre_hotel.' ya existe en la lista</p>';
			}
		}

	}

	public function actionDeleteParticipante()
	{
		$id=$_POST["id"];

		if($_POST["tipo"]=="a")
		{
			$participante=OutletAgencia::model()->findByPk($id);
			if(!empty($participante)){
				$participante->delete();
				echo '<div class="alert alert-success"><p>La agencia '.$participante->idAgencia->nombre_agencia.' ha sido eliminada de la lista</p>';
			}else
			{
				echo '<div class="alert alert-danger"><p><strong>¡Error!</strong> La agencia '.$outletAgencia->idAgencia->nombre_agencia.' no pudo ser eliminada de la lista</p>';
			}

		}else if($_POST["tipo"]=="h")
		{


			$participante=OutletHotel::model()->findByPk($id);
			if(!empty($participante)){
				$participante->delete();
				echo '<div class="alert alert-success"><p>El hotel '.$participante->idHotel->nombre_hotel.' ha sido eliminado de la lista</p>';
			}else
			{
				echo '<div class="alert alert-danger"><p><strong>¡Error!</strong> El hotel '.$outletAgencia->idHotel->nombre_hotel.' no pudo ser eliminado de la lista</p>';

			}
		}
	}

	public function actionReporteAgencias($id)
	{

		$outlet=Outlet::model()->findByPk($id);

		$fecha_inicio = implode("-", array_reverse(explode("/", $outlet->fecha_inicio)));
		$fecha_final = implode("-", array_reverse(explode("/", $outlet->fecha_final)));
		
		$fechas = 'and (date(log) between "'.$fecha_inicio.'" and "'.$fecha_final.'")';


		$agenciasOutlet = OutletAgencia::model()->findAll('id_evento='.$id);

		$agency=array();
		$num_reservaciones=0;
		$total=0;
		foreach ($agenciasOutlet as $key) 
		{
			$agency[$key->id_agencia]['id_agencia']=$key->id_agencia;
			$agency[$key->id_agencia]['nombre_agencia']=$key->idAgencia->nombre_agencia;
			$agency[$key->id_agencia]['foto']=$key->idAgencia->foto;
			$reservaciones = Reservacion::model()->with('idTarifa')->findAll('idTarifa.precio="outlet" AND t.estatus!="C" and id_agencia='.$key->id_agencia);
			foreach ($reservaciones as $reservacion) 
			{
			
				$agency[$key->id_agencia]['num_reservaciones']++;//$key->num_reservaciones;
				if($reservacion->saldo==0.00){
					$agency[$key->id_agencia]['num_pagadas']++;//$key->num_reservaciones;
				}else{
					$agency[$key->id_agencia]['num_abonadas']++;//$key->num_reservaciones;
				}
				$agency[$key->id_agencia]['total']+=$reservacion->total;
			
			}

			$num_reservaciones+=$agency[$key->id_agencia]['num_reservaciones'];
			$total+=$agency[$key->id_agencia]['total'];

			$agency[$key->id_agencia]['idCard']="c_".$key->id_agencia;
			
		}
			

		$dataProvider= new CArrayDataProvider($agency, array(
			   	'id'=>'agencias',
			    'sort'=>array(
			        'attributes'=>array(
                			'total','num_reservaciones'
            			),
			        'defaultOrder'=>'total'
			    ),
			    'pagination'=>array(
			        'pageSize'=>12
			    ),
			));


	
		$this->render('reporteAgencias', array('dataProvider'=>$dataProvider,'total'=>$total,'num_reservaciones'=>$num_reservaciones));
	}

	

	public function validacionTarifas($outlet)
	{

		if ($outlet->tipo=="GRUPOS") {
			return false;
		}

		if ($outlet->tipo=="SEMANA ESPECIAL") {
			if (!empty($outlet) && date("Y-m-d") >= $outlet->fecha_inicio && date("Y-m-d") <= $outlet->fecha_final) {
				return true;
			}
			return false;
		}

		$tarifaOutlet=false;
		$resEdo=array(31,4,23);
		if ( !empty($outlet) && date("Y-m-d")>=$outlet->fecha_inicio && date("Y-m-d")<=$outlet->fecha_final) {
			if($_SESSION["tipoUsuario"] == "Agencia")
			{
				$outletAgencia=OutletAgencia::model()->find('id_agencia='.$_SESSION["agenciaUsuario"].' AND id_evento='.$outlet->id_outlet);
				if((in_array($_SESSION['estadoUsuario'],$resEdo)===false || !empty($outletAgencia)) && $outlet->solo_agencias==1 )
				{

					$tarifaOutlet=true;	                    	
				}else if($outlet->solo_agencias!=1) {
					$tarifaOutlet=true;

				}
			}else{

				$tarifaOutlet=true;	                    	
			}
		}
		return $tarifaOutlet;
	}

	public function tarifaOutletVirtual($tarifa,$tarifaNeta,$comision,$descuento){
		$neta= (empty($tarifaNeta) || $tarifaNeta==0) ? $tarifa-($tarifa*($comision/100)) : $tarifaNeta;
		$netaOutlet=$neta-($neta*($descuento/100));
		$tarifaOutlet=$netaOutlet/((100-$comision)/100);
		return $tarifaOutlet;
	}

	public function politicasCancelacion()
	{
		$politicas="Pago inmediato<br>No transferible, no reembolsable, no se aceptan modificaciones, cancelaciones, ni devoluciones.";
		return $politicas;
	}
	public function fechasLimite($fecha_limite, $proveedor, $checkin)
	{
		$fecha=strtotime($fecha_limite);
		
			if ($fecha >= strtotime('2019-06-05')) {
				$fecha_limite=strtotime('2019-06-05');
			}else {
					switch ($proveedor) {
					case 0:
							if ($fecha_limite=="") {
								$fecha_limite=strtotime($checkin.' -2 days');
								
							}
						break;
					
					default:
						$fecha_limite=$fecha;
					break;
				}
			}
		return $fecha_limite;
	}
    public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['Outlet_records']))
               {
                $model=$session['Outlet_records'];
               }
               else
                 $model = Outlet::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Outlet Report');
		$pdf->SetSubject('Outlet Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Outlet_002.pdf", "I");
	}
}
