<?php

class AgenciasRestController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new AgenciasRest;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['AgenciasRest']))
		{
			$model->attributes=$_POST['AgenciasRest'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_agencia));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['AgenciasRest']))
		{
			$model->attributes=$_POST['AgenciasRest'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_agencia));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new AgenciasRest('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['AgenciasRest']))
		{
                        $model->attributes=$_GET['AgenciasRest'];
			
			
                   	
                       if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '".$model->id_agencia."'");
                     
                    	
                       if (!empty($model->nombre_agencia)) $criteria->addCondition("nombre_agencia = '".$model->nombre_agencia."'");
                     
                    	
                       if (!empty($model->webslug)) $criteria->addCondition("webslug = '".$model->webslug."'");
                     
                    	
                       if (!empty($model->fecha_alta)) $criteria->addCondition("fecha_alta = '".$model->fecha_alta."'");
                     
                    	
                       if (!empty($model->tel_agencia)) $criteria->addCondition("tel_agencia = '".$model->tel_agencia."'");
                     
                    	
                       if (!empty($model->email_agencia)) $criteria->addCondition("email_agencia = '".$model->email_agencia."'");
                     
                    	
                       if (!empty($model->celular)) $criteria->addCondition("celular = '".$model->celular."'");
                     
                    	
                       if (!empty($model->contacto)) $criteria->addCondition("contacto = '".$model->contacto."'");
                     
                    	
                       if (!empty($model->skype_agencia)) $criteria->addCondition("skype_agencia = '".$model->skype_agencia."'");
                     
                    	
                       if (!empty($model->puesto)) $criteria->addCondition("puesto = '".$model->puesto."'");
                     
                    	
                       if (!empty($model->porcentaje_comision)) $criteria->addCondition("porcentaje_comision = '".$model->porcentaje_comision."'");
                     
                    	
                       if (!empty($model->observaciones)) $criteria->addCondition("observaciones = '".$model->observaciones."'");
                     
                    	
                       if (!empty($model->id_pais_agencia)) $criteria->addCondition("id_pais_agencia = '".$model->id_pais_agencia."'");
                     
                    	
                       if (!empty($model->id_estado_agencia)) $criteria->addCondition("id_estado_agencia = '".$model->id_estado_agencia."'");
                     
                    	
                       if (!empty($model->id_ciudad_agencia)) $criteria->addCondition("id_ciudad_agencia = '".$model->id_ciudad_agencia."'");
                     
                    	
                       if (!empty($model->id_colonia_agencia)) $criteria->addCondition("id_colonia_agencia = '".$model->id_colonia_agencia."'");
                     
                    	
                       if (!empty($model->calle_agencia)) $criteria->addCondition("calle_agencia = '".$model->calle_agencia."'");
                     
                    	
                       if (!empty($model->cruzamientos_agencia)) $criteria->addCondition("cruzamientos_agencia = '".$model->cruzamientos_agencia."'");
                     
                    	
                       if (!empty($model->num_interior_agencia)) $criteria->addCondition("num_interior_agencia = '".$model->num_interior_agencia."'");
                     
                    	
                       if (!empty($model->num_exterior_agencia)) $criteria->addCondition("num_exterior_agencia = '".$model->num_exterior_agencia."'");
                     
                    	
                       if (!empty($model->cp_agencia)) $criteria->addCondition("cp_agencia = '".$model->cp_agencia."'");
                     
                    	
                       if (!empty($model->rfc)) $criteria->addCondition("rfc = '".$model->rfc."'");
                     
                    	
                       if (!empty($model->razon_social)) $criteria->addCondition("razon_social = '".$model->razon_social."'");
                     
                    	
                       if (!empty($model->id_estado_fiscal)) $criteria->addCondition("id_estado_fiscal = '".$model->id_estado_fiscal."'");
                     
                    	
                       if (!empty($model->id_ciudad_fiscal)) $criteria->addCondition("id_ciudad_fiscal = '".$model->id_ciudad_fiscal."'");
                     
                    	
                       if (!empty($model->id_colonia_fiscal)) $criteria->addCondition("id_colonia_fiscal = '".$model->id_colonia_fiscal."'");
                     
                    	
                       if (!empty($model->calle_fiscal)) $criteria->addCondition("calle_fiscal = '".$model->calle_fiscal."'");
                     
                    	
                       if (!empty($model->cruzamientos_fiscal)) $criteria->addCondition("cruzamientos_fiscal = '".$model->cruzamientos_fiscal."'");
                     
                    	
                       if (!empty($model->num_exterior_fiscal)) $criteria->addCondition("num_exterior_fiscal = '".$model->num_exterior_fiscal."'");
                     
                    	
                       if (!empty($model->num_interior_fiscal)) $criteria->addCondition("num_interior_fiscal = '".$model->num_interior_fiscal."'");
                     
                    	
                       if (!empty($model->cp_fiscal)) $criteria->addCondition("cp_fiscal = '".$model->cp_fiscal."'");
                     
                    	
                       if (!empty($model->id_pais_fiscal)) $criteria->addCondition("id_pais_fiscal = '".$model->id_pais_fiscal."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    	
                       if (!empty($model->municipio_agencia)) $criteria->addCondition("municipio_agencia = '".$model->municipio_agencia."'");
                     
                    	
                       if (!empty($model->municipio_fiscal)) $criteria->addCondition("municipio_fiscal = '".$model->municipio_fiscal."'");
                     
                    	
                       if (!empty($model->mismadir)) $criteria->addCondition("mismadir = '".$model->mismadir."'");
                     
                    	
                       if (!empty($model->logotipo)) $criteria->addCondition("logotipo = '".$model->logotipo."'");
                     
                    	
                       if (!empty($model->foto)) $criteria->addCondition("foto = '".$model->foto."'");
                     
                    	
                       if (!empty($model->url_agencia)) $criteria->addCondition("url_agencia = '".$model->url_agencia."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    	
                       if (!empty($model->activacion)) $criteria->addCondition("activacion = '".$model->activacion."'");
                     
                    	
                       if (!empty($model->verificada)) $criteria->addCondition("verificada = '".$model->verificada."'");
                     
                    	
                       if (!empty($model->accesows)) $criteria->addCondition("accesows = '".$model->accesows."'");
                     
                    	
                       if (!empty($model->ubicacion)) $criteria->addCondition("ubicacion = '".$model->ubicacion."'");
                     
                    	
                       if (!empty($model->pie_flyer)) $criteria->addCondition("pie_flyer = '".$model->pie_flyer."'");
                     
                    			
                    $session['AgenciasRest_records']=AgenciasRest::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new AgenciasRest('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['AgenciasRest']))
			$model->attributes=$_GET['AgenciasRest'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=AgenciasRest::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='agencias-rest-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['AgenciasRest_records']))
               {
                $model=$session['AgenciasRest_records'];
               }
               else
                 $model = AgenciasRest::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['AgenciasRest_records']))
               {
                $model=$session['AgenciasRest_records'];
               }
               else
                 $model = AgenciasRest::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('AgenciasRest Report');
		$pdf->SetSubject('AgenciasRest Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("AgenciasRest_002.pdf", "I");
	}
}
