<?php

class AgenciasMarkupController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('markup'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	public function actionMarkup($agenciaUsuario = NULL){
		header("Access-Control-Allow-Origin: *");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header('Content-Type: application/json; charset=utf-8');

		if ($_SESSION['agenciaUsuario']) {
			$id = $_SESSION['agenciaUsuario'];
			if (!empty($agenciaUsuario)) {
				$id = $agenciaUsuario;
			}
			$markup = $this->markup($id);
			echo CJSON::encode($markup); exit;
		}

		if ($agenciaUsuario) {
			$id = $agenciaUsuario;
			if (!empty($agenciaUsuario)) {
				$id = $agenciaUsuario;
			}
			$markup = $this->markup($id);
			echo CJSON::encode($markup); exit;
		}
	}

	public function markup($id){
		$markup = AgenciasMarkup::model()->find('id_agencia='.$id.' ORDER BY id DESC');
		$markupRmt = AgenciasMarkupRmt::model()->find('id_agencia='.$id.' ORDER BY id DESC');
		return array('markup'=>$markup->markup, 'markupRmt'=>$markupRmt->markup,'tarifa'=>$markupRmt->tarifa);
	}

	public function aplicaMarkup($agencia,$monto,$all = true){
		$total = $monto; $mod = false;
		if (!empty($agencia)) {
			$model = AgenciasMarkup::model()->find('id_agencia='.$agencia.' ORDER BY id DESC');
			$modelRmt = AgenciasMarkupRmt::model()->find('id_agencia='.$agencia.' ORDER BY id DESC');
			
			if (!empty($modelRmt) && $modelRmt->markup != 0) {
				$mod = true;
				$ganancia = (100-$modelRmt->markup)/100;
				// $ganancia = $monto*($modelRmt->markup / 100);
				$total = (float) $monto/$ganancia;
			}
			
			if ($all) {
				if (!empty($model) && $model->markup != 0) {
					$ganancia = (100-$model->markup)/100;
					// $ganancia = $total*($model->markup / 100);
					$total = (float) $total/$ganancia;
					$mod = true;
				}
			}

		}

		return array('total' => $total, 'mod' => $mod);
	}

	public function aplicaMarkupAsignados($monto,$markup = NULL,$markupRmt = NULL,$tipo = "all"){
		$total = $monto;
		if ($markupRmt != NULL && $markupRmt != 0 && ($tipo == "all" || $tipo == "rmt")) {
			$ganancia = (100-$markupRmt)/100;
			$total = (float) $total/$ganancia;
		}

		if ($markup != NULL && $markup != 0 && ($tipo == "all" || $tipo == "agencia")) {
			$ganancia = (100-$markup)/100;
			$total = (float) $total/$ganancia;
		}

		return $total;
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new AgenciasMarkup;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['AgenciasMarkup']))
		{
			$model->attributes=$_POST['AgenciasMarkup'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['AgenciasMarkup']))
		{
			$model->attributes=$_POST['AgenciasMarkup'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new AgenciasMarkup('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['AgenciasMarkup']))
		{
                        $model->attributes=$_GET['AgenciasMarkup'];
			
			
                   	
                       if (!empty($model->id)) $criteria->addCondition("id = '".$model->id."'");
                     
                    	
                       if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '".$model->id_agencia."'");
                     
                    	
                       if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '".$model->id_usuario."'");
                     
                    	
                       if (!empty($model->markup)) $criteria->addCondition("markup = '".$model->markup."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    			
                    $session['AgenciasMarkup_records']=AgenciasMarkup::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new AgenciasMarkup('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['AgenciasMarkup']))
			$model->attributes=$_GET['AgenciasMarkup'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=AgenciasMarkup::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='agencias-markup-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['AgenciasMarkup_records']))
               {
                $model=$session['AgenciasMarkup_records'];
               }
               else
                 $model = AgenciasMarkup::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['AgenciasMarkup_records']))
               {
                $model=$session['AgenciasMarkup_records'];
               }
               else
                 $model = AgenciasMarkup::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('AgenciasMarkup Report');
		$pdf->SetSubject('AgenciasMarkup Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("AgenciasMarkup_002.pdf", "I");
	}
}
