var tbl_gastos;
var app = new Vue({
    el: '#page_content_inner',
    data: {
        id_actividad: id_actividad,
        id_usuario: id_usuario,
        rmt_url: rmt_url,
        api_url: rmt_url + '/api/',

        info_actividad: [],
        array_gastos: [],
        array_conceptos: [],

        loading: true,
        show_description: false,

        model_id_gasto: 0,
        model_concepto: 0,
        model_descripcion: null,
        model_fecha: '',
        model_forma_pago: '',
        model_importe: 0,
        model_comprobante: null,
        file_comprobante: '',

        //models modal actualizar info actividad
        model_id_actividad: 0,
        model_nombre: '',
        model_aportacion_efectivo: null,
        model_aportacion_tarjeta: null,
        model_fecha_inicio: '',
        model_fecha_final: null,
        model_id_evento: null,
        model_id_usuario: id_usuario,
        array_events: [],
    },
    created: function() {
        this.loadInfoActividad();
        this.loadGastos();
        this.loadEvents();
    },
    methods: {
        loadInfoActividad: function() {
            this.$http.get(this.api_url + 'viaticosActividades/' + this.id_actividad).then(function(response) {
                var response_var = response.body.data;
                this.info_actividad = response_var.viaticosActividades;
                this.model_id_actividad = this.info_actividad.id_actividad;
            }, function(ex) {
                console.log(ex);
            });
        },
        save: function() {
            var that = this;
            var modal = UIkit.modal("#modal_cu");
            var post_data = { nombre: this.model_nombre, aportacion_efectivo: this.model_aportacion_efectivo, aportacion_tarjeta: this.model_aportacion_tarjeta, fecha_inicio: ((this.model_fecha_inicio.split("/")).reverse()).join("-"), fecha_final: ((this.model_fecha_final.split("/")).reverse()).join("-"), id_evento: this.model_id_evento };
            this.$http.put(this.api_url + 'viaticosActividades/' + this.id_actividad, JSON.stringify(post_data)).then(function(response) {
                var response_var = response.body;
                modal.hide();
                if(response_var.success) {
                    that.info_actividad = response_var.data.viaticosActividades;
                    Swal.fire({
                        type: 'success',
                        title: "Correcto",
                        text: "Se ha modificado la actividad.",
                    });
                } else {
                    Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                    });
                }
            }, function(ex) {
                modal.hide();
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                });
                console.log(ex);
            });
        },
        loadGastos: function() {
            var url = this.api_url + 'viaticosGastos?filter=[{"property":"id_actividad","value":' + this.id_actividad +',"operator":=}]';
            this.$http.get(encodeURI(url)).then(function(response) {
                var response_var = response.body.data;
                this.array_gastos = response_var.viaticosGastos;
                this.loading = false;
                this.loadTable();
                this.loadConceptos();
            }, function(ex) {
                console.log(ex);
            });
        },
        loadConceptos: function() {
            this.$http.get(this.api_url + 'viaticosConceptos/').then(function(response) {
                var response_var = response.body.data;
                this.array_conceptos = response_var.viaticosConceptos;
            }, function(ex) {
                console.log(ex);
            });
        },
        loadTable: function() {
            var that = this;
            tbl_gastos = $('#tbl_gastos').DataTable({
                destroy:true,
                paging: true,
                lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
                sDom:"<'dt_colVis_buttons'B><'dt-uikit-header'<'uk-grid'<'uk-width-medium-2-3'l><'uk-width-medium-1-3'f>>>tipr",
                buttons: [
                    {
                        extend: 'excel',
                        text:'<i class="uk-icon-file-excel-o" style="color: #FFFFFF"></i> Exportar a Excel',
                        className: 'md-btn md-btn-success md-btn-wave-light'
                    },
                ],
                columns: [
                    null,
                    null,
                    null,
                    { render: $.fn.dataTable.render.number(',', '.', 2, '$') },
                    { "orderable": false },
                    { "orderable": false },
                ],
                footerCallback: function ( tfoot, data, start, end, display ) {
                    intVal = function ( i ) {
                        return typeof i === 'string' ?
                            i.replace(/[\$,]/g, '')*1 :
                            typeof i === 'number' ?
                            i : 0;
                    };

                    var api = this.api(), data;
                    total_gastos = api
                        .column(3)
                        .data()
                        .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                    }, 0 );

                     $(tfoot).find('th').eq(1).html("$" + total_gastos.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,'));                
                }
            });
            tbl_gastos.clear();

            this.array_gastos.forEach(function(element) {
                var concepto = element.idConcepto.nombre, fecha = that.parseDate(element.fecha, "DD/MM/YYYY"), forma_pago = element.forma_pago, importe = element.importe, comprobante;
                if(element.idConcepto.id_viaticos_conceptos == 99) {
                    concepto = element.descripcion_concepto;
                }
                if(element.comprobante == null || element.comprobante == "") {
                    comprobante = "No hay comprobante registrado";
                } else {
                	comprobante = "<a class=\"img_comprobante\" data-id_gasto="+ element.id_viaticos_gastos +" data-uk-modal=\"{target:'#modal_comprobante'}\">Ver comprobante</a>";
                }
                tbl_gastos.row.add([
                    concepto,
                    fecha,
                    forma_pago,
                    importe,
                    comprobante,
					"<a class='btn_info' data-id_gasto="+ element.id_viaticos_gastos +"><i class='material-icons md-24'>edit</i></a><a class='btn_delete' data-id_gasto="+ element.id_viaticos_gastos +"><i class='material-icons md-24'>delete</i></a>"
                ]).draw(false);
            });
        },
        checkConcept: function() {
            if(this.model_concepto == 99) {
                this.show_description = true;
            } else {
                this.show_description = false;
            }
        },
        save_actividad: function() {
        	if(this.model_id_gasto > 0) {
        		this.updateGasto();
        	} else {
        		this.createGasto();
        	}
        },
        createGasto: function() {
        	var fecha_gasto = ((this.model_fecha.split("/")).reverse()).join("-");
            var post_data = { id_concepto: this.model_concepto, descripcion_concepto: this.model_descripcion, fecha: fecha_gasto, forma_pago: this.model_forma_pago, importe: this.model_importe, id_actividad: this.id_actividad, comprobante: this.model_comprobante };
            var url = this.api_url + 'viaticosGastos/';
            this.$http.post(this.api_url + 'viaticosGastos/', JSON.stringify(post_data)).then(function(response) {
                var response_var = response.body;
                if(response_var.success) {
                	Swal.fire({
                        type: 'success',
                        title: "Correcto",
                        text: "Se ha agregado el gasto.",
                    });
                    if(this.file_comprobante != '') {
                    	this.uploadComprobante();
                    }
                    this.loadGastos();
                	this.clearForm();
                } else {
                	Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                    });
                }
            }, function(ex) {
            	Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                });
                console.log(ex);
            });
        },
        updateGasto: function() {
        	var fecha_gasto = ((this.model_fecha.split("/")).reverse()).join("-");
            var post_data = { id_concepto: this.model_concepto, descripcion_concepto: this.model_descripcion, fecha: fecha_gasto, forma_pago: this.model_forma_pago, importe: this.model_importe, id_actividad: this.id_actividad, comprobante: this.model_comprobante };
            var url = this.api_url + 'viaticosGastos/';
            this.$http.put(this.api_url + 'viaticosGastos/' + this.model_id_gasto, JSON.stringify(post_data)).then(function(response) {
                var response_var = response.body;
                if(response_var.success) {
                	Swal.fire({
                        type: 'success',
                        title: "Correcto",
                        text: "Se ha actualizado el gasto.",
                    });
                    if(this.file_comprobante != '') {
                    	this.uploadComprobante();
                    }
                    this.loadGastos();
                	this.clearForm();
                } else {
                	Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                    });
                }
            }, function(ex) {
            	Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                });
                console.log(ex);
            });
        },
        deleteGasto: function() {
            this.$http.delete(this.api_url + 'viaticosGastos/' + this.model_id_gasto).then(function(response) {
                var response_var = response.body;
                if(response_var.success) {
                	Swal.fire({
                        type: 'success',
                        title: "Correcto",
                        text: "Se eliminado el gasto.",
                    });

                    this.loadGastos();
                	this.clearForm();
                } else {
                	Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                    });
                }
            }, function(ex) {
            	Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                });
                console.log(ex);
            });
        },
        uploadComprobante: function() {
			var data = new FormData();
	        data.append("img", this.file_comprobante);
	        data.append("id_actividad", this.id_actividad);
			this.$http.post(rmt_url + '/viaticosGastos/uploadImage', data).then(function(response) {
				console.log(response.body);
	        }, function(ex) {
	        	Swal.fire({
					type: 'error',
					title: "¡Ops!",
					html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
				});
	            console.log(ex);
	        });
		},
		loadedComprobante: function(event) {
			this.file_comprobante = event.target.files[0];
			this.model_comprobante = this.id_actividad + "-" + this.id_usuario + "-" + this.file_comprobante.name.replace(/\s+/g, '-');
		},
        loadEvents: function() {
            this.$http.get(this.api_url + 'events/').then(function(response) {
                var response_var = response.body.data;
                this.array_events = response_var.events;
            }, function(ex) {
                console.log(ex);
            });
        },
        updateInfoActividad: function() {
            var modal = UIkit.modal("#modal_cu");
            var post_data = { nombre: this.model_nombre, aportacion_efectivo: this.model_aportacion_efectivo, aportacion_tarjeta: this.model_aportacion_tarjeta, fecha_inicio: ((this.model_fecha_inicio.split("/")).reverse()).join("-"), fecha_final: ((this.model_fecha_final.split("/")).reverse()).join("-"), id_evento: this.model_id_evento, id_usuario: this.model_id_usuario };
            this.$http.put(this.api_url + 'viaticosActividades/' + this.model_id_actividad, JSON.stringify(post_data)).then(function(response) {
                var response_var = response.body;
                if(response_var.success) {
                    modal.hide();
                    Swal.fire({
                        type: 'success',
                        title: 'Correcto',
                        text: 'Se ha actualizado la actividad.'
                    });
                    this.loadInfoActividad();
                    this.clearModelActividad();
                } else {
                    modal.hide();
                    Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                    });
                }
            }, function(ex) {
                modal.hide();
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                });
                console.log(ex);
            });
        },
        setInfoActividad: function() {
            this.model_id_actividad = this.info_actividad.id_actividad;
            this.model_nombre = this.info_actividad.nombre;
            this.model_aportacion_efectivo = this.info_actividad.aportacion_efectivo;
            this.model_aportacion_tarjeta = this.info_actividad.aportacion_tarjeta;
            this.model_fecha_inicio = this.parseDate(this.info_actividad.fecha_inicio, "DD/MM/YYYY");
            this.model_fecha_final = this.parseDate(this.info_actividad.fecha_final, "DD/MM/YYYY");
            this.model_id_evento = this.info_actividad.idEvento.id_event;
        },
        clearModelActividad: function() {
            this.model_id_actividad = 0;
            this.model_nombre = '';
            this.model_aportacion_efectivo = null;
            this.model_aportacion_tarjeta = null;
            this.model_fecha_inicio = '';
            this.model_fecha_final = null;
            this.model_id_evento = null;
        },
        clearForm: function() {
			this.model_id_gasto = 0;
        	this.model_concepto = 0;
            this.model_descripcion = null;
            this.show_description = false;
	        this.model_fecha = '';
	        this.model_forma_pago = '';
	        this.model_importe = 0;
	        this.model_comprobante = null;
	        this.file_comprobante = '';
        },
        getTotalAportacion: function() {
            var total = this.info_actividad.aportacion_efectivo + this.info_actividad.aportacion_tarjeta;
            return this.round(parseFloat(total), 2);
        },
        printTotalConcepto: function(concepto) {
            var filterConcepto = this.array_gastos.filter(function(i) {
                return i.idConcepto.id_viaticos_conceptos === concepto.id_viaticos_conceptos;
            });
            var total = 0;
            filterConcepto.forEach(function(element) {
                total += parseFloat(element.importe);
            });
            return this.round(total, 2);
        },
        getTotalConceptos: function() {
            var total = 0;
            this.array_gastos.forEach(function(element) {
                total += parseFloat(element.importe);
            });
            return this.round(total, 2);
        },
        getSaldoViaticos: function() {
            var aport_tarj = 0;
            if(this.info_actividad.aportacion_tarjeta != null) {
                aport_tarj = parseFloat(this.info_actividad.aportacion_tarjeta)
            }
            var total_aport = parseFloat(this.info_actividad.aportacion_efectivo) + aport_tarj;
            if(parseFloat(total_aport) > 0) {
                var total = 0;
                this.array_gastos.forEach(function(element) {
                    total += parseFloat(element.importe);
                });
                var saldo = parseFloat(total_aport) - total;
                return this.round(saldo, 2);
            } else {
                console.log("else");
                return this.getTotalConceptos();
            }
        },
        printIntervalDate: function() {
            return this.parseDate(this.info_actividad.fecha_inicio, "DD/MM/YYYY") + " - " + this.parseDate(this.info_actividad.fecha_final, "DD/MM/YYYY");
        },
        parseDate: function(date,format) {
            return moment(date).format(format);
        },
        round: function(value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
    }
});

$('body').on('change', '#dp_fecha_gasto', function() {
	app.model_fecha = $(this).val();
});

$('body').on('click', '.btn_info', function() {
	var id_gasto = $(this).attr("data-id_gasto");
	var filterGasto = app.array_gastos.filter(function(i) {
		return i.id_viaticos_gastos === id_gasto;
	});
	app.model_id_gasto = filterGasto[0].id_viaticos_gastos;
    app.model_concepto = filterGasto[0].id_concepto;
    app.checkConcept();
	app.model_descripcion = filterGasto[0].descripcion_concepto;
    app.model_fecha = app.parseDate(filterGasto[0].fecha, "DD/MM/YYYY");
    app.model_forma_pago = filterGasto[0].forma_pago;
    app.model_importe = filterGasto[0].importe;
});

$('body').on('click', '.btn_delete', function() {
	var id_gasto = $(this).attr("data-id_gasto");
	var filterGasto = app.array_gastos.filter(function(i) {
		return i.id_viaticos_gastos === id_gasto;
	});
	app.model_id_gasto = filterGasto[0].id_viaticos_gastos;

	Swal.fire({
  		title: '¿Desea eliminar este gasto?',
  		text: "Esta acción no se puede revertir.",
  		type: 'warning',
  		showCancelButton: true,
  		confirmButtonColor: '#3085d6',
  		cancelButtonColor: '#d33',
  		confirmButtonText: 'Aceptar',
  		cancelButtonText: 'Cancelar',
	}).then((result) => {
  		if (result.value) {
    		app.deleteGasto();
  		}
	})
});

$('body').on('click', '.img_comprobante', function() {
	var id_gasto = $(this).attr("data-id_gasto");
	var filterGasto = app.array_gastos.filter(function(i) {
		return i.id_viaticos_gastos === id_gasto;
	});
	app.model_comprobante = filterGasto[0].comprobante;
});

$("#modal_comprobante").on({
    'hide.uk.modal': function(){
		app.model_comprobante = null;
    }
});

var $dp_start = $('#dp_fecha_inicio'), $dp_end = $('#dp_fecha_fin');

var start_date = UIkit.datepicker($dp_start, {
    format:'DD/MM/YYYY',
    i18n: { 
        months:['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'], 
        weekdays:['DOM','LUN','MAR','MIE','JUE','VIE','SAB'] 
    },
});

var end_date = UIkit.datepicker($dp_end, {
    format:'DD/MM/YYYY',
    i18n: { 
        months:['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'], 
        weekdays:['DOM','LUN','MAR','MIE','JUE','VIE','SAB'] 
    },
});

$dp_start.on('change',function() {
    end_date.options.minDate = $dp_start.val();
    setTimeout(function() {
        $dp_end.focus();
    },300);
});

$('body').on('change', '#dp_fecha_inicio', function() {
    app.model_fecha_inicio = $(this).val();
});

$('body').on('change', '#dp_fecha_fin', function() {
    app.model_fecha_final = $(this).val();
});