$('body .destinos').select2({
      language: "es",
      minimumInputLength: 3,
      ajax: {
        url: baseUrl+'/busqueda/buscarDestinos.html',
        dataType: 'json',
        type:'POST',

        // Additional AJAX parameters go here; see the end of this chapter for the full code of this example
        data: function (params) {
          var query = {
            search: params.term,
            type: 'public',
            pais:$("#consultarPais").val()
          }

          // Query parameters will be ?search=[term]&type=public
          return query;
        },
        processResults: function (data) {

            list = [
                   {text: 'Destinos', children: []},
                   {text: 'Zonas', children: []},
                   {text: 'Hoteles', children: []},
                  ];

            var d1=$.map(data.destinos, function(item, i) {
                  list[0]['children'][i] = {
                      text: item.name,
                      id: 'd_'+item.code
                  }
              });

               
            $.map(data.zonas, function (item, i) {
                  list[1]['children'][i] = {
                      text: item.name,
                      id: 'z_'+item.idZona+'_'+item.destinationsCode+'/'+item.zoneCode
                  }
              });
                

               
            $.map(data.hoteles, function (item, i) {
                  list[2]['children'][i] = {
                      text: item.nombre_hotel,
                      id: 'h_'+item.id_hotel
                  }
              });
                               

          return {
             results: list,
          };
        }

        
      }
    });