//Date Range Picker
var fecha_start;
var fecha_end;

$(document).ready(function() {
	
    $('#reportrange').daterangepicker({
            startDate: moment().subtract(29, 'days'),
            endDate: moment(),
            minDate: '01/01/2012',
            maxDate: '12/31/2020',
            dateLimit: {
                days: 365
            },
            showDropdowns: true,
            showWeekNumbers: true,
            timePicker: false,
            timePickerIncrement: 1,
            timePicker12Hour: true,
            ranges: {
                'Hoy': [moment(), moment()],
                'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Ultimos 7 dias': [moment().subtract(6, 'days'), moment()],
                'Ultimos 30 dias': [moment().subtract(29, 'days'), moment()],
                'Este mes': [moment().startOf('month'), moment().endOf('month')],
                'Mes anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
            opens: 'left',
            buttonClasses: ['btn btn-default'],
            applyClass: 'btn-small btn-primary',
            cancelClass: 'btn-small',
            locale: {
				format: 'DD/MM/YYYY',
            	separator: ' a ',
                applyLabel: 'Aceptar',
				cancelLabel: 'Cancelar',
                fromLabel: 'De',
                toLabel: 'A',
                customRangeLabel: 'Periodo',
                daysOfWeek: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sa'],
                monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Deciembre'],
                firstDay: 1
            }
        },
        function(start, end) {
			
			var rango=start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD');
			fecha_start=start.format('YYYY-MM-DD');
			fecha_end=end.format('YYYY-MM-DD');			

            console.log("Callback has been called!");
            $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        }
    );
    //Set the initial state of the picker label
	moment.locale('ES'); 
	fecha_start=moment().subtract(29, 'days').format('YYYY-MM-DD');
	fecha_end=moment().format('YYYY-MM-DD');
    $('#reportrange span').html(moment().subtract(29, 'days').format('MMMM D, YYYY') + ' - ' + moment().format('MMMM D, YYYY'));
});

//To-Do List jQuery - Adds a strikethrough on checked items
$('.checklist input:checkbox').change(function() {
    if ($(this).is(':checked'))
        $(this).parent().addClass('selected');
    else
        $(this).parent().removeClass('selected')
});

function rangoFechas(){
	alert(fecha_start+" / "+fecha_end);
	
}