$(document).ready(function () {
  var msiOpenPay = false;
  var numMSIOpenPay = 0;
  OpenPay.setId(merchantId);
  OpenPay.setApiKey(publicKey);
  OpenPay.setSandboxMode(false);
  deviceSessionId = OpenPay.deviceData.setup(
    "payment-form-openpay",
    "deviceIdHiddenFieldName"
  );
  $("#pay-button").on("click", function (event) {
    if (!validarFormulariosReservacion()) return false;
    if ($("#condiciones").is(":not(:checked)")) {
      Swal.fire({
        title: 'Advertencia',
        text: "Debe aceptar los términos y condiciones",
        icon: 'warning',
        showCancelButton: false,
      })
    } else {
      btnPayOpenpay(true);
      event.preventDefault();
      OpenPay.token.create({
        card_number: $("#card_number").val(),
        holder_name: $("#holder_name").val(),
        expiration_year: $("#expiration_year").val(),
        expiration_month: $("#expiration_month").val(),
        cvv2: $("#cvv2").val(),
      },
        success_callbak,
        error_callbak
      );
    }

    if (msiOpenPay) {
      numMSIOpenPay = $("#selectMSIOpenpay").val();
    }else{
      numMSIOpenPay = 0;
    }
  });
  var success_callbak = async function (response) {
    var token_id = response.data.id;
    $("#token_id").val(token_id);
    try {
      let req = await fetch(urlBase + "/reservacion/openPay", {
        method: "POST",
        headers: {
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          token: token_id,
          agencia: agencia,
          deviceSessionId: deviceSessionId,
          name: $("#holder_name").val(),
          phone: $("#Reservacion_tel_cliente").val(),
          email: $("#Reservacion_email").val(),
          msi: numMSIOpenPay,
        }),
      }),
        res = await req.json();
      if (res.success) {
        localStorage.setItem("contformulario", JSON.stringify($("#reservacion-form").serializeArray()));
        let timerInterval
        Swal.fire({
          title: 'En un momento se redireccionará al proceso de autentificación de su banco.',
          html: '',
          timer: 5000,
          timerProgressBar: true,
          didOpen: () => {
            Swal.showLoading()
          },
        }).then((result) => {
          /* Read more about handling dismissals below */
          if (result.dismiss === Swal.DismissReason.timer) {
            console.log('I was closed by the timer')
          }
        })
        // Swal.fire('En un momento se redireccionará al proceso de autentificación de su banco', '', 'success');
        setTimeout(function () {
          window.location.href = res.url_autentificacion
        }, 5000);
        // crearreservacion();
        btnPayOpenpay(false);
        return true;
      } else {
        sweetError(res, res.message, false);
        btnPayOpenpay(false);
      }
    } catch (error) {
      console.error(error);
    }
  };
  var error_callbak = function (response) {
    var desc =
      response.data.description != undefined ?
        response.data.description :
        response.message;
    alert("ERROR [" + response.status + "] " + desc);
    btnPayOpenpay(false);
  };
  var btnPayOpenpay = function (status) {
    const btn = document.querySelector("#pay-button");
    if (status) {
      btn.disabled = true;
      btn.textContent = "Pagando...";
    } else {
      btn.disabled = false;
      btn.textContent = "Pagar";
    }
  };

  function validarFormulariosReservacion() {
    var mensaje = "";
    var response = true;
    // console.log('aqui')
    var reg = /(\.|\-)/g;

    var num_hab = $("#Reservacion_num_habitaciones").val();
    for (var hab = 1; hab <= num_hab; hab++) {
      var num_adultos = $("#num_adultos_" + hab).val();
      for (var i = 1; i <= num_adultos; i++) {
        if (
          $("#nombre_" + i + "_" + hab).val() == "" ||
          $("#apellido_" + i + "_" + hab).val() == ""
        ) {
          mensaje +=
            "El nombre y apellido de pasajero #" +
            i +
            " son requeridos en habitación:" +
            hab;
          response = false;
        }
        if (
          reg.test($("#nombre_" + i + "_" + hab).val()) == true ||
          reg.test($("#apellido_" + i + "_" + hab).val()) == true
        ) {
          mensaje +=
            "El nombre y/o apellido de pasajero #" +
            i +
            " contiene caracteres no permitidos. habitación:" +
            hab;
          response = false;
        }
      }
    }

    if (
      $("#s2_agencias").val() == "" ||
      $("#s2_agentes").val() == "" ||
      $("#nombre_cliente").val() == "" ||
      $("#apellido_cliente").val() == ""
    ) {
      console.log($("#s2_agencias").val());
      console.log($("#s2_agentes").val());
      console.log($("#s2_agentes").val());
      console.log($("#nombre_cliente").val());
      console.log($("#apellido_cliente").val());
      mensaje += "Por favor, complete los campos requeridos.";
      response = false;
    }

    if (
      reg.test($("#nombre_cliente").val()) == true ||
      reg.test($("#apellido_cliente").val()) == true
    ) {
      mensaje += "El nombre y/o apellido contiene caracteres no permitidos.";
      response = false;
    }

    if ($("#tel_cliente").val() == "" && $("#ok_elige_transporte").val() == 1) {
      mensaje += "Datos Adicionales para su transportación son requeridos.";
      response = false;
    }
    var xhr = {
      responseText: "Formulario Incompleto",
      status: "Advertencia",
      statusIcon: "warning",
    };
    if (response === false) {
      sweetError(xhr, mensaje, false);
    }
    return response;
  }


  $("#tarjetacredito").change(function (e) {
    e.preventDefault();
    msiOpenPay = this.checked;
    if (msiOpenPay) {
      $("#msiOpenpay").removeClass('d-none');
    } else {
      $("#msiOpenpay").addClass('d-none');
    }
  });
});