

function createPaymentClip() {
    // let datos_clip = {
    //     id_agencia_2b: id_agencia_2b_clip,
    //     nombre_cliente: "Rodrigo"
    // }
    // $.ajax({
    //     type: 'POST',
    //     url: baseUrl + "/reservacion/clip", // Archivo PHP que procesará los datos
    //     data: datos_clip,
    //     contentType: 'application/json',
    //     success: function (response) {
    //         // Manejar la respuesta del servidor
    //         console.log(response);
    //     },
    //     error: function (xhr, status, error) {
    //         // Manejar los errores de la petición
    //         console.error(error);
    //     }
    // });

    appClip.sendDataClip();
}
Vue.http.options.emulateJSON = true;
var appClip = new Vue({
    el: '#transaccionClip',
    data: {
        id_agencia_2b: id_agencia_2b_clip,
        array_clip: [],
        baseUrl: baseUrl
    },
    methods: {
        sendDataClip: function () {
            if (!this.validarFormulariosReservacion()) return false;
            if ($("#condiciones").is(":not(:checked)")) {
                Swal.fire({
                    title: 'Advertencia',
                    text: "Debe aceptar los términos y condiciones",
                    icon: 'warning',
                    showCancelButton: false,
                })
            } else {
                let btn_Clip = document.getElementById('btnClip');
                btn_Clip.disabled = true;
                btn_Clip.style.cursor = "not-allowed";
                btn_Clip.style.opacity = "50%";
                let rq = {
                    id_agencia_2b: this.id_agencia_2b,
                    nombre_cliente: $("#Reservacion_nombre_cliente").val(),
                    apellido_cliente: $("#Reservacion_apellido_cliente").val(),
                    correo_cliente: $('#Reservacion_email').val(),
                    telefono_cliente: $('#Reservacion_tel_cliente').val(),
                }
                this.$http.post(this.baseUrl + "/reservacion/clip", rq).then(function (response) {
                    this.array_clip = response.data;
                    if (this.array_clip.payment_request_url) {
                        Swal.fire({
                            title: 'En unos momentos será redireccionado a la página de pago de Clip.',
                            html: '',
                            timer: 5000,
                            timerProgressBar: true,
                            didOpen: () => {
                                Swal.showLoading()
                            },
                        }).then((result) => {
                            /* Read more about handling dismissals below */
                            if (result.dismiss === Swal.DismissReason.timer) {
                                console.log('I was closed by the timer')
                            }
                        })
                        localStorage.setItem("contformulario", JSON.stringify($("#reservacion-form").serializeArray()));
                        // Swal.fire('En un momento se redireccionará al proceso de autentificación de su banco', '', 'success');
                        setTimeout(function () {
                            window.location.href = appClip.array_clip.payment_request_url
                        }, 5000);
                    }else{
                        Swal.fire({
                            title: 'error',
                            text: "Ha ocurrido un error, intente recargar la página, si el error persiste contáctenos.",
                            icon: 'error',
                            showCancelButton: false,
                        })
                    }
                }).catch(function (error) {
                    console.error(error);
                });

            }
        },

        validarFormulariosReservacion: function () {
            var mensaje = '';
            var response = true;
            // console.log('aqui')
            var reg = /(\.|\-)/g;

            if ($('#Reservacion_nombre_cliente').val() == '' || $('#Reservacion_apellido_cliente').val() == '') {
                mensaje += 'El Nombre y Apellido del cliente son requeridos. ';
                response = false;
            }
            if ($('#Reservacion_tel_cliente').val() == '') {
                mensaje += 'El Teléfono del cliente es requerido. ';
                response = false;
            }
            if ($('#Reservacion_email').val() == '') {
                mensaje += 'El E-mail del cliente es requerido. ';
                response = false;
            }

            var num_hab = $('#Reservacion_num_habitaciones').val();
            for (var hab = 1; hab <= num_hab; hab++) {
                var num_adultos = $('#num_adultos_' + hab).val();
                for (var i = 1; i <= num_adultos; i++) {
                    if ($('#nombre_' + i + '_' + hab).val() == '' || $('#apellido_' + i + '_' + hab).val() == '') {
                        mensaje += 'El nombre y apellido de pasajero #' + i + ' son requeridos en habitación:' + hab;
                        response = false;
                    }
                    if (reg.test($('#nombre_' + i + '_' + hab).val()) == true || reg.test($('#apellido_' + i + '_' + hab).val()) == true) {
                        mensaje += 'El nombre y/o apellido de pasajero #' + i + ' contiene caracteres no permitidos. habitación:' + hab;
                        response = false;
                    }
                }
            }

            if ($('#s2_agencias').val() == '' || $('#s2_agentes').val() == '' || $('#nombre_cliente').val() == '' || $('#apellido_cliente').val() == '') {
                response = false;
            }

            if (reg.test($('#nombre_cliente').val()) == true || reg.test($('#apellido_cliente').val()) == true) {
                mensaje += 'El nombre y/o apellido contiene caracteres no permitidos.';
                response = false;
            }

            if ($('#tel_cliente').val() == '' && $('#ok_elige_transporte').val() == 1) {
                mensaje += 'Datos Adicionales para su transportación son requeridos.';
                response = false;
            }
            var xhr = {
                responseText: 'Formulario Incompleto',
                status: 'Advertencia',
                statusIcon: 'warning'
            }

            if (response === false) {

                this.sweetError(xhr, mensaje, false);
            }
            return response;
        },

        sweetError: function (xhr, text, reload) {

            var estatusText = xhr.responseText;
            if (!estatusText) {
                estatusText = xhr.statusText;
            }
            var icon = 'error';
            if (xhr.statusIcon) {
                icon = xhr.statusIcon;
            }
            Swal.fire({
                icon: icon,
                title: xhr.status,
                text: text,
                footer: estatusText
            }).then((result) => {
                if (reload === true) {
                    location.reload();
                } else if (reload == 'replace') {
                    window.location.replace('/sur4agenciasvdemo/site/index');
                }
            })
        }
    },
});