<?php
require __DIR__ . '/vendor/autoload.php';

class PriceTravel
{
	private $token;
	private $clientId;
	private $clientSecret;
	private $card;
	public $url;
	public $urlToken;
	public $app;
	private $urlLog = 'https://webhook.site/c22876fa-c83a-4b19-9687-23ebefbb149c';

	public function __construct($credencial = 'MXN')
	{
		$production = true;
		if ($credencial == 'MXN') {
			$this->app          = 'uvaconline';
			// $this->clientId     = ($production) ? '1c5bda424ad5492599fcdfab69ffbd07'     : 'db7f4bc549844ae0bda8a87b739df630';
			$this->clientId     = ($production) ? '1c5bda424ad5492599fcdfab69ffbd07'     : '1c5bda424ad5492599fcdfab69ffbd07';
			// $this->clientSecret = ($production) ? '8396c52b-f57d-9364-bdc9-a8305960a41b' : 'e30a8ac5-fbf1-aa37-ce58-3ec9d782c5b5';
			$this->clientSecret = ($production) ? '8396c52b-f57d-9364-bdc9-a8305960a41b' : '8396c52b-f57d-9364-bdc9-a8305960a41b';
			$this->card         = [
				'type'            => '',
				'holderName'      => '',
				'number'          => '',
				'expirationMonth' => '',
				'expirationYear'  => '',
				'cvc'             => ''
			];
		}
		$this->url          = ($production) ? 'http://ptapi.pricetravel.com/1.0'      : 'https://ptapi-int.pricetravel.com/1.0';
		$this->urlToken     = ($production) ? 'http://ptapi.pricetravel.com'       : 'https://ptapi-int.pricetravel.com/1.0';
		if (!isset($_SESSION['token'])) {
			$this->login();
		} else if (time() >= $_SESSION['tokenExpire']) {
			$this->login();
		} else {
			$this->token = $_SESSION['token'];
		}
	}

	private function login()
	{
		session_start();
		$request = [
			'clientId'                => $this->clientId,
			'clientSecret'            => $this->clientSecret,
			'redirectUri'             => 'https://my.example.com/your-redirect-url/',
			'urlAuthorize'            => 'https://service.example.com/authorize',
			'urlAccessToken'          => $this->urlToken . '/connect/token',
			'urlResourceOwnerDetails' => 'https://service.example.com/resource'
		];
		$provider = new \League\OAuth2\Client\Provider\GenericProvider($request);
		try {
			$accessToken             = $provider->getAccessToken('client_credentials');
			$_SESSION['token']       = $accessToken->getToken();
			$_SESSION['tokenExpire'] = $accessToken->getExpires();
			$this->token             = $_SESSION['token'];
			$json                    = json_encode(['request' => $request, 'response' => $_SESSION['token']]);
			$this->sendLog($json,'getToken');
		} catch (\League\OAuth2\Client\Provider\Exception\IdentityProviderException $e) {
			exit($e->getMessage());
		}
	}

	public function getRates($paxes, $hotels, $residence, $nacionalidad = 'MX')
	{
		try {
			$client   = new GuzzleHttp\Client();
			$request  = [
				'checkIn'         => $residence['fecha_ini'],
				'checkOut'        => $residence['fecha_fin'],
				'roomCriteria'    => $paxes,
				'hotelIds'        => $hotels,
				'hotelRateFilter' => array(
					'nonRefundable' => true
				),
				'market'          => $nacionalidad
			];
			$result   = $client->post($this->url . '/hotels/rates/?language=es-mx', [
				'headers' => [
					'Authorization'   => 'Bearer ' . $this->token,
					'Content-Type'    => 'application/json',
					'Accept-Encoding' => 'gzip, deflate, br',
					'accept'          => '	*/*'
				],
				'json'    => $request
			]);
			$response = json_decode($result->getBody()->getContents(), true);
			$json     = json_encode(['request' => $request, 'response' => $response, 'app' => $this->app]);
			$this->sendLog($json, 'rates');
			return $json;
		} catch (\Throwable $th) {
			$json = json_encode(['request' => $request, 'response' => $th->getMessage(), 'app' => $this->app]);
			$this->sendLog($json, 'Rates:Error');
			return json_encode(['success' => false, 'message' => $th->getMessage()]);
		}
	}

	public function checkRates($rateKey)
	{
		try {
			$client  = new GuzzleHttp\Client();
			$request = [
				'rateKey' => $rateKey,
			];
			$result = $client->post($this->url . '/hotels/checkrates/?language=es-mx', [
				'headers' => [
					'Authorization'   => 'Bearer ' . $this->token,
					'Content-Type'    => 'application/json',
					'Accept-Encoding' => 'gzip, deflate, br',
					'accept'          => '	*/*'
				],
				'json'    => $request
			]);
			$response = json_decode($result->getBody()->getContents(), true);
			$json     = json_encode(['request' => $request, 'response' => $response, 'app' => $this->app]);
			$this->sendLog($json,'checkRates');
			return $json;
		} catch (\Throwable $th) {
			$json = json_encode(['request' => $request, 'response' => $th->getMessage(), 'app' => $this->app]);
			$this->sendLog($json,'checkRates:Error');
			return json_encode(['success' => false, 'message' => $th->getMessage(), 'app' => $this->app]);
		}
	}

	public function bookingHold($rateKey)
	{
		try {
			$client   = new GuzzleHttp\Client();
			$request  = [
				'rateKey' => $rateKey,
			];
			$result   = $client->post($this->url . '/bookings/hold/?language=es-mx', [
				'headers' => [
					'Authorization'   => 'Bearer ' . $this->token,
					'Content-Type'    => 'application/json',
					'Accept-Encoding' => 'gzip, deflate, br',
					'accept'          => '	*/*'
				],
				'json'    => $request
			]);
			$response = json_decode($result->getBody()->getContents(), true);
			$json     = json_encode(['request' => $request, 'response' => $response, 'app' => $this->app]);
			$this->sendLog($json,'bookingHold');
			return $json;
		} catch (\Throwable $th) {
			$json = json_encode(['request' => $request, 'response' => $th->getMessage(), 'app' => $this->app]);
			$this->sendLog($json,'bookingHold:Error');
			return json_encode(['success' => false, 'message' => $th->getMessage(), 'app' => $this->app]);
		}
	}

	public function booking($bookingKey, $paxes, $comments = null)
	{
		if (is_null($comments)) $comments = '';
		try {
			$client   = new GuzzleHttp\Client();
			$request  = [
				'bookingKey'       => $bookingKey,
				'clientReference'  => 'UVAC',
				'roomCriteria'     => $paxes,
				'client'           => [
					'name'    => $paxes['paxes'][0]['name'],
					'surname' => $paxes['paxes'][0]['surname'],
					'contactData' => [
						[
							'email' => 'programador@2businesstravel.com',
							'phone' => [
								'countryCode' => '+52',
								'number'      => '5512312322'
							]
						]
					]
				],
				'commentsForHotel' => $comments
			];
			// return $request;
			$result   = $client->post($this->url . '/bookings/?language=es-mx', [
				'headers' => [
					'Authorization'   => 'Bearer ' . $this->token,
					'Content-Type'    => 'application/json',
					'Accept-Encoding' => 'gzip, deflate, br',
					'accept'          => '	*/*'
				],
				'json'  => $request
			]);
			$response = json_decode($result->getBody()->getContents(), true);
			$json     = json_encode(['request' => $request, 'response' => $response, 'success' => true, 'app' => $this->app]);
			$this->sendLog($json,'booking');
			return $json;
		} catch (\Throwable $th) {
			$response = json_decode($th->getMessage());
			$json     = json_encode(['request' => $request, 'response' => $response, 'app' => $this->app]);
			$this->sendLog($json,'booking:Error');
			return json_encode(['success' => false, 'message' => $response, 'app' => $this->app]);
		}
	}

	public function getBooking($bookingId)
	{
	    
		try {
			$client  = new GuzzleHttp\Client();
			
			$request = $this->url . '/bookings/22770426/?language=es-mx';
			return $request;
			$result  = $client->get($request, [
				'headers' => [
					'Authorization'   => 'Bearer ' . $this->token,
					'Content-Type'    => 'application/json',
					'Accept-Encoding' => 'gzip, deflate, br',
					'accept'          => '	*/*'
				]
			]);
			
			$response = json_decode($result->getBody()->getContents(), true);
			$json     = json_encode(['request' => $request, 'response' => $response]);
			$this->sendLog($json,'getBooking');
			return $json;
		} catch (\Throwable $th) {
			$json = json_encode(['request' => $request, 'response' => $th->getMessage(), 'app' => $this->app]);
			$this->sendLog($json,'getBooking:Error');
			return json_encode(['success' => false, 'message' => $th->getMessage(), 'app' => $this->app]);
		}
	}

	public function cancelBooking($bookingId)
	{
		try {
			$client   = new GuzzleHttp\Client();
			$request  = $this->url . '/bookings/' . $bookingId . '/?language=es-mx';
			$result   = $client->delete($request, [
				'headers' => [
					'Authorization'   => 'Bearer ' . $this->token,
					'Content-Type'    => 'application/json',
					'Accept-Encoding' => 'gzip, deflate, br',
					'accept'          => '	*/*'
				]
			]);
			$response = json_decode($result->getBody()->getContents(), true);
			$json     = json_encode(['request' => $request, 'response' => $response, 'app' => $this->app]);
			$this->sendLog($json,'cancelBooking');
			return $json;
		} catch (\Throwable $th) {
		    $this->sendLog($th->getMessage(),'cancelBooking');
			return json_encode(['success' => false, 'message' => $th->getMessage(), 'app' => $this->app]);
		}
	}

	public function getHotelInfo($hotelId)
	{
		try {
			$client  = new GuzzleHttp\Client();
			$request = $this->url . '/hotels/' . $hotelId . '/?language=es-mx';
			$result  = $client->get($request, [
				'headers' => [
					'Authorization'   => 'Bearer ' . $this->token,
					'Content-Type'    => 'application/json',
					'Accept-Encoding' => 'gzip, deflate, br',
					'accept'          => '	*/*'
				]
			]);
			$response = json_decode($result->getBody()->getContents(), true);
			$json     = json_encode(['request' => $request, 'response' => $response]);
			// $this->sendLog($json,'getBooking');
			return $json;
		} catch (\Throwable $th) {
			$json = json_encode(['request' => $request, 'response' => $th->getMessage(), 'app' => $this->app]);
			$this->sendLog($json, 'getHotelInfo:Error');
			return json_encode(['success' => false, 'message' => $th->getMessage(), 'app' => $this->app]);
		}
	}

	private function sendLog($data, $type)
	{
		$data         = json_decode($data, true);
		$data['type'] = $type;
		$data         = json_encode($data);
		$curl         = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL            => $this->urlLog,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING       => '',
			CURLOPT_MAXREDIRS      => 10,
			CURLOPT_TIMEOUT        => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST  => 'POST',
			CURLOPT_POSTFIELDS     => $data,
			CURLOPT_HTTPHEADER     => array(
				'Cookie: PHPSESSID=50e947c50a7b3530de8e71908ac4812c',
				'Content-Type: application/json'
			),
		));
		curl_exec($curl);
		curl_close($curl);
	}
}
