<?php 

class Commons
{

	public function changeFormatDate($dateStr){
		$date = str_replace('/', '-', $dateStr);
		return date('Y-m-d', strtotime($date));
	}

	public function callApi($pApiKey, $pSecret, $pEndpoint, $pMethod = 'GET', $pParams = ''){

	    $signature = hash("sha256", $pApiKey.$pSecret.time());
		
        $body = new http\Message\Body;
        $body->append($pParams);

		$request = new http\Client\Request;
        $request->setRequestUrl($pEndpoint);
        $request->setRequestMethod($pMethod);
        $request->setBody($body);
        $request->setHeaders(array(
            'Api-Key'      => $pApiKey,
	      	'X-Signature'  => $signature,
	      	'Content-Type' => 'application/json;charset=UTF-8',
	      	'Accept'       => 'application/json',
        ));




        
		try
		{
		    $client = new http\Client;
		    $client->enqueue($request)->send();
		    $response = $client->getResponse();

		    if ($response->getResponseCode() != 200) {  
		      /* return printf("%s returned '%s' (%d) '%s'\n",
		           $response->getTransferInfo("effective_url"),
		           $response->getInfo(),
		           $response->getResponseCode(),
		           $pParams

		       );*/

		       $error=$response->getTransferInfo("effective_url")." returned "
		           .$response->getInfo()."("
		           .$response->getResponseCode().") "
		           .$pParams;
		       return $error;

		    } else {
		       return $response->getBody();
      		}
		} catch (Exception $ex) {
		    return "Error while sending request, reason: ".$ex->getMessage();
		
		}
	}
}

?>